package com.particles.prebidadapter

import android.content.Context
import com.particles.msp.BidListener
import com.particles.msp.BidLoader
import com.particles.msp.MSPManager
import com.particles.msp.adapter.AdNetwork
import com.particles.msp.adapter.AdNetworkAdapter
import com.particles.msp.api.AdListener
import com.particles.msp.api.AdRequest
import com.particles.msp.auction.AuctionBidListener
import com.particles.msp.auction.BidderInfo
import com.particles.msp.util.Logger
import org.prebid.mobile.rendering.bidding.data.bid.BidResponse

class PrebidAdLoader {
    private var bidLoader: BidLoader? = null
    var adNetworkAdapter: AdNetworkAdapter? = null

    fun loadAd(bidderPlacementId: String, auctionBidListener: AuctionBidListener, context: Context, adRequest: AdRequest, adListener: AdListener, bidderInfo: BidderInfo) {
        class BidListenerImp : BidListener {
            override fun onBidResponse(bidResponse: BidResponse, adNetwork: AdNetwork) {
                Logger.info("[Bidder: Prebid] Loading creative from adNetwork: $adNetwork ...")
                adNetworkAdapter = MSPManager.adNetworkAdapterProvider?.getAdNetworkAdapter(adNetwork)
                adNetworkAdapter?.loadAdCreative(bidResponse, auctionBidListener, context, adRequest, adListener, bidderPlacementId, bidderInfo) ?: run {
                    auctionBidListener.onError("[Bidder: Prebid] adNetwork Adapter is null for network: $adNetwork")
                    Logger.info("[Bidder: Prebid] adNetwork Adapter is null for network: $adNetwork")
                }
            }

            override fun onError(msg: String) {
                auctionBidListener.onError("[Bidder: Prebid] Prebid bid request error: $msg")
                Logger.info("[Bidder: Prebid] Prebid bid request error: $msg")
            }
        }
        bidLoader = MSPManager.bidLoaderProvider?.getBidLoader()
        Logger.verbose("[Bidder: Prebid] sending bid request for bidderPlacementId: $bidderPlacementId")
        bidLoader?.loadBid(bidderPlacementId, mapOf(), BidListenerImp(), adRequest)
    }
}