/*
 * Decompiled with CFR 0.152.
 */
package com.particles.prebidadapter;

import android.content.Context;
import android.content.res.Configuration;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.particles.msp.BidListener;
import com.particles.msp.BidLoader;
import com.particles.msp.adapter.AdNetwork;
import com.particles.msp.adapter.FacebookBidTokenListener;
import com.particles.msp.adapter.FacebookBidTokenProvider;
import com.particles.msp.adapter.GoogleQueryInfoFetcher;
import com.particles.msp.adapter.GoogleQueryInfoListener;
import com.particles.msp.api.AdFormat;
import com.particles.msp.api.AdRequest;
import com.particles.msp.api.AdSize;
import com.particles.msp.util.Logger;
import com.particles.msp.util.UserId;
import com.particles.prebidadapter.PrebidBidLoader;
import com.particles.prebidadapter.UtilsKt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.prebid.mobile.BannerParameters;
import org.prebid.mobile.NativeAdUnit;
import org.prebid.mobile.NativeDataAsset;
import org.prebid.mobile.NativeEventTracker;
import org.prebid.mobile.NativeImageAsset;
import org.prebid.mobile.NativeParameters;
import org.prebid.mobile.NativeTitleAsset;
import org.prebid.mobile.TargetingParams;
import org.prebid.mobile.api.data.BidInfo;
import org.prebid.mobile.api.original.PrebidAdUnit;
import org.prebid.mobile.api.original.PrebidRequest;
import org.prebid.mobile.rendering.bidding.data.bid.BidResponse;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J4\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/particles/prebidadapter/PrebidBidLoader;", "Lcom/particles/msp/BidLoader;", "context", "Landroid/content/Context;", "googleQueryInfoFetcher", "Lcom/particles/msp/adapter/GoogleQueryInfoFetcher;", "facebookBidTokenProvider", "Lcom/particles/msp/adapter/FacebookBidTokenProvider;", "(Landroid/content/Context;Lcom/particles/msp/adapter/GoogleQueryInfoFetcher;Lcom/particles/msp/adapter/FacebookBidTokenProvider;)V", "getContext", "()Landroid/content/Context;", "createBannerParameters", "Lorg/prebid/mobile/BannerParameters;", "adRequest", "Lcom/particles/msp/api/AdRequest;", "createNativeParameters", "Lorg/prebid/mobile/NativeParameters;", "getAdNetwork", "Lcom/particles/msp/adapter/AdNetwork;", "bidResponse", "Lorg/prebid/mobile/rendering/bidding/data/bid/BidResponse;", "loadBid", "", "placementId", "", "adParams", "", "", "bidListener", "Lcom/particles/msp/BidListener;", "Companion", "prebid-adapter_mavenRelease"})
public final class PrebidBidLoader
extends BidLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Context context;

    public PrebidBidLoader(@Nullable Context context, @Nullable GoogleQueryInfoFetcher googleQueryInfoFetcher, @NotNull FacebookBidTokenProvider facebookBidTokenProvider) {
        Intrinsics.checkNotNullParameter((Object)facebookBidTokenProvider, (String)"facebookBidTokenProvider");
        GoogleQueryInfoFetcher googleQueryInfoFetcher2 = googleQueryInfoFetcher;
        Intrinsics.checkNotNull((Object)googleQueryInfoFetcher2);
        super(googleQueryInfoFetcher2, facebookBidTokenProvider);
        this.context = context;
    }

    @Nullable
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final BannerParameters createBannerParameters(@NotNull AdRequest adRequest) {
        Intrinsics.checkNotNullParameter((Object)adRequest, (String)"adRequest");
        org.prebid.mobile.AdSize adSize = null;
        org.prebid.mobile.AdSize adSize2 = adSize = adRequest.getAdFormat() == AdFormat.BANNER ? new org.prebid.mobile.AdSize(320, 50) : new org.prebid.mobile.AdSize(300, 250);
        if (adRequest.getAdFormat() == AdFormat.INTERSTITIAL) {
            Context context = this.context;
            Intrinsics.checkNotNull((Object)context);
            Configuration configuration = context.getResources().getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getConfiguration(...)");
            Configuration deviceConfiguration = configuration;
            adSize = new org.prebid.mobile.AdSize(deviceConfiguration.screenWidthDp, deviceConfiguration.screenHeightDp);
        }
        AdSize adSize3 = adRequest.getAdSize();
        if (adSize3 != null) {
            AdSize it = adSize3;
            boolean bl = false;
            adSize = new org.prebid.mobile.AdSize(it.getWidth(), it.getHeight());
        }
        BannerParameters parameters = new BannerParameters();
        Set adSizes = new HashSet();
        adSizes.add(adSize);
        parameters.setAdSizes(adSizes);
        return parameters;
    }

    @NotNull
    public final NativeParameters createNativeParameters() {
        List assets = new ArrayList();
        NativeTitleAsset title = new NativeTitleAsset();
        title.setLength(90);
        title.setRequired(true);
        assets.add(title);
        NativeImageAsset icon = new NativeImageAsset(50, 50, 50, 50);
        icon.setImageType(NativeImageAsset.IMAGE_TYPE.ICON);
        icon.setRequired(true);
        assets.add(icon);
        NativeImageAsset image = new NativeImageAsset(382, 200, 382, 200);
        image.setImageType(NativeImageAsset.IMAGE_TYPE.MAIN);
        image.setRequired(true);
        assets.add(image);
        NativeDataAsset data = new NativeDataAsset();
        data.setDataType(NativeDataAsset.DATA_TYPE.SPONSORED);
        data.setRequired(true);
        assets.add(data);
        NativeDataAsset body = new NativeDataAsset();
        body.setRequired(true);
        body.setDataType(NativeDataAsset.DATA_TYPE.DESC);
        assets.add(body);
        NativeDataAsset cta = new NativeDataAsset();
        cta.setRequired(true);
        cta.setDataType(NativeDataAsset.DATA_TYPE.CTATEXT);
        assets.add(cta);
        NativeParameters nativeParameters = new NativeParameters(assets);
        ArrayList<NativeEventTracker.EVENT_TRACKING_METHOD> methods = new ArrayList<NativeEventTracker.EVENT_TRACKING_METHOD>();
        methods.add(NativeEventTracker.EVENT_TRACKING_METHOD.IMAGE);
        methods.add(NativeEventTracker.EVENT_TRACKING_METHOD.JS);
        try {
            NativeEventTracker tracker = new NativeEventTracker(NativeEventTracker.EVENT_TYPE.IMPRESSION, methods);
            nativeParameters.addEventTracker(tracker);
        }
        catch (Exception exception) {
            // empty catch block
        }
        nativeParameters.setContextType(NativeAdUnit.CONTEXT_TYPE.CONTENT_CENTRIC);
        nativeParameters.setPlacementType(NativeAdUnit.PLACEMENTTYPE.CONTENT_FEED);
        return nativeParameters;
    }

    public void loadBid(@NotNull String placementId, @NotNull Map<String, ? extends Object> adParams, @NotNull BidListener bidListener, @NotNull AdRequest adRequest) {
        Intrinsics.checkNotNullParameter((Object)placementId, (String)"placementId");
        Intrinsics.checkNotNullParameter(adParams, (String)"adParams");
        Intrinsics.checkNotNullParameter((Object)bidListener, (String)"bidListener");
        Intrinsics.checkNotNullParameter((Object)adRequest, (String)"adRequest");
        this.getGoogleQueryInfoFetcher().fetch(new GoogleQueryInfoListener(this, adRequest, placementId, bidListener){
            final /* synthetic */ PrebidBidLoader this$0;
            final /* synthetic */ AdRequest $adRequest;
            final /* synthetic */ String $placementId;
            final /* synthetic */ BidListener $bidListener;
            {
                this.this$0 = $receiver;
                this.$adRequest = $adRequest;
                this.$placementId = $placementId;
                this.$bidListener = $bidListener;
            }

            public void onComplete(@NotNull String queryInfo) {
                Intrinsics.checkNotNullParameter((Object)queryInfo, (String)"queryInfo");
                Logger.INSTANCE.verbose("PrebidBidLoader. google queryInfo received: " + queryInfo);
                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$adRequest, this.$placementId, queryInfo, this.$bidListener, null){
                    int label;
                    final /* synthetic */ PrebidBidLoader this$0;
                    final /* synthetic */ AdRequest $adRequest;
                    final /* synthetic */ String $placementId;
                    final /* synthetic */ String $queryInfo;
                    final /* synthetic */ BidListener $bidListener;
                    {
                        this.this$0 = $receiver;
                        this.$adRequest = $adRequest;
                        this.$placementId = $placementId;
                        this.$queryInfo = $queryInfo;
                        this.$bidListener = $bidListener;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                FacebookBidTokenProvider facebookBidTokenProvider = this.this$0.getFacebookBidTokenProvider();
                                FacebookBidTokenListener facebookBidTokenListener = new FacebookBidTokenListener(this.$placementId, this.this$0, this.$adRequest, this.$queryInfo, this.$bidListener){
                                    final /* synthetic */ String $placementId;
                                    final /* synthetic */ PrebidBidLoader this$0;
                                    final /* synthetic */ AdRequest $adRequest;
                                    final /* synthetic */ String $queryInfo;
                                    final /* synthetic */ BidListener $bidListener;
                                    {
                                        this.$placementId = $placementId;
                                        this.this$0 = $receiver;
                                        this.$adRequest = $adRequest;
                                        this.$queryInfo = $queryInfo;
                                        this.$bidListener = $bidListener;
                                    }

                                    public void onComplete(@NotNull String bidToken) {
                                        Object object;
                                        Map map;
                                        Intrinsics.checkNotNullParameter((Object)bidToken, (String)"bidToken");
                                        TargetingParams.setBuyerId((String)bidToken);
                                        PrebidAdUnit prebidAdUnit = new PrebidAdUnit(this.$placementId);
                                        PrebidRequest prebidRequest = new PrebidRequest();
                                        prebidRequest.setBannerParameters(this.this$0.createBannerParameters(this.$adRequest));
                                        if (this.$adRequest.getAdFormat() == AdFormat.MULTI_FORMAT || this.$adRequest.getAdFormat() == AdFormat.NATIVE) {
                                            prebidRequest.setNativeParameters(this.this$0.createNativeParameters());
                                        }
                                        if (this.$adRequest.getAdFormat() == AdFormat.INTERSTITIAL) {
                                            prebidRequest.setInterstitial(true);
                                        }
                                        Map customParams = MapsKt.toMutableMap((Map)this.$adRequest.getCustomParams());
                                        if (!TextUtils.isEmpty((CharSequence)this.$queryInfo)) {
                                            customParams.put("query_info", this.$queryInfo);
                                        }
                                        if (!customParams.containsKey("user_id")) {
                                            Long l = UserId.INSTANCE.getCachedUserId();
                                            if (l != null) {
                                                long it = ((Number)l).longValue();
                                                boolean bl = false;
                                                Long l2 = it;
                                                customParams.put("user_id", l2);
                                            }
                                        }
                                        Gson gson = new Gson();
                                        if (loadBid.onComplete.1.onComplete$isDebugBuild(this.this$0)) {
                                            map = customParams;
                                            String string = "test";
                                            String string2 = gson.toJson((Object)this.$adRequest.getTestParams());
                                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toJson(...)");
                                            object = string2;
                                            map.put(string, object);
                                        }
                                        map = customParams;
                                        String string = "app_install_timestamp";
                                        object = this.$adRequest.getContext();
                                        object = UtilsKt.getAppInstallTime((Context)(object instanceof Context ? object : null));
                                        map.put(string, object);
                                        PrebidBidLoader.Companion.addCustomTargeting(prebidRequest, customParams);
                                        Logger.INSTANCE.verbose("PrebidBidLoader. send bid request " + prebidRequest + " with custom params: " + customParams);
                                        prebidAdUnit.fetchDemand(prebidRequest, (arg_0, arg_1) -> loadBid.onComplete.1.onComplete$lambda$3(this, this.$bidListener, this.this$0, arg_0, arg_1));
                                    }

                                    private static final boolean onComplete$isDebugBuild(PrebidBidLoader this$0) {
                                        boolean bl;
                                        try {
                                            Context context = this$0.getContext();
                                            Intrinsics.checkNotNull((Object)context);
                                            String appPackageName = context.getApplicationContext().getPackageName();
                                            Class<?> appBuildConfig = Class.forName(appPackageName + ".BuildConfig");
                                            Field debugField = appBuildConfig.getField("DEBUG");
                                            bl = debugField.getBoolean(null);
                                        }
                                        catch (Exception e) {
                                            bl = false;
                                        }
                                        return bl;
                                    }

                                    private static final void onComplete$lambda$3(loadBid.onComplete.1 this$0, BidListener $bidListener, PrebidBidLoader this$1, BidInfo bidInfo, String message) {
                                        block2: {
                                            Unit unit;
                                            BidResponse bidResponse;
                                            BidResponse bidResponse2;
                                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                            Intrinsics.checkNotNullParameter((Object)$bidListener, (String)"$bidListener");
                                            Intrinsics.checkNotNullParameter((Object)((Object)this$1), (String)"this$1");
                                            Intrinsics.checkNotNullParameter((Object)bidInfo, (String)"bidInfo");
                                            Logger.INSTANCE.verbose("PrebidBidLoader. Bid response received. price: " + ((bidResponse2 = bidInfo.getBidResponse()) != null && (bidResponse2 = bidResponse2.getWinningBid()) != null ? Double.valueOf(bidResponse2.getPrice()) : null));
                                            BidResponse bidResponse3 = bidResponse = bidInfo.getBidResponse();
                                            if (bidResponse3 != null) {
                                                BidResponse it = bidResponse3;
                                                boolean bl = false;
                                                $bidListener.onBidResponse(it, this$1.getAdNetwork(it));
                                                unit = Unit.INSTANCE;
                                            } else {
                                                unit = null;
                                            }
                                            if (unit != null) break block2;
                                            loadBid.onComplete.1 $this$onComplete_u24lambda_u243_u24lambda_u242 = this$0;
                                            boolean bl = false;
                                            $bidListener.onError(bidInfo.getResultCode() + ". " + message);
                                        }
                                    }
                                };
                                Context context = this.$adRequest.getContext();
                                Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type android.content.Context");
                                facebookBidTokenProvider.fetch(facebookBidTokenListener, (Object)context);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }, adRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final AdNetwork getAdNetwork(@NotNull BidResponse bidResponse) {
        AdNetwork adNetwork;
        String string;
        Intrinsics.checkNotNullParameter((Object)bidResponse, (String)"bidResponse");
        Object object = bidResponse.getWinningBid();
        String string2 = object != null && (object = object.getPrebid()) != null && (object = object.getTargeting()) != null ? (String)((HashMap)object).get("hb_bidder") : (string = null);
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 1745486990: {
                    if (!string.equals("msp_google")) break;
                    n = 1;
                    break;
                }
                case 1924955018: {
                    if (!string.equals("audienceNetwork")) break;
                    n = 2;
                    break;
                }
                case -1025906751: {
                    if (!string.equals("msp_nova")) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    adNetwork = AdNetwork.Google;
                    return adNetwork;
                }
                case 2: {
                    adNetwork = AdNetwork.Facebook;
                    return adNetwork;
                }
                case 3: {
                    adNetwork = AdNetwork.Nova;
                    return adNetwork;
                }
            }
        }
        adNetwork = AdNetwork.Prebid;
        return adNetwork;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b\u00a8\u0006\n"}, d2={"Lcom/particles/prebidadapter/PrebidBidLoader$Companion;", "", "()V", "addCustomTargeting", "", "prebidRequest", "Lorg/prebid/mobile/api/original/PrebidRequest;", "params", "", "", "prebid-adapter_mavenRelease"})
    @SourceDebugExtension(value={"SMAP\nPrebidBidLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrebidBidLoader.kt\ncom/particles/prebidadapter/PrebidBidLoader$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,209:1\n1549#2:210\n1620#2,3:211\n*S KotlinDebug\n*F\n+ 1 PrebidBidLoader.kt\ncom/particles/prebidadapter/PrebidBidLoader$Companion\n*L\n199#1:210\n199#1:211,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void addCustomTargeting(@NotNull PrebidRequest prebidRequest, @NotNull Map<String, ? extends Object> params) {
            Intrinsics.checkNotNullParameter((Object)prebidRequest, (String)"prebidRequest");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            Object[] objectArray = new String[]{"google_multi_format_enabled", "google_ads_multi_content_urls", "google_ad_content_url"};
            Set parametersToSkip = SetsKt.setOf((Object[])objectArray);
            Map contextData = new HashMap();
            for (Map.Entry<String, ? extends Object> entry : params.entrySet()) {
                Object it;
                String key = entry.getKey();
                Object value = entry.getValue();
                if (parametersToSkip.contains(key)) continue;
                if (value instanceof List) {
                    void $this$mapTo$iv$iv;
                    if (!(!((Collection)value).isEmpty())) continue;
                    Map map = contextData;
                    HashSet $this$map$iv = (HashSet)value;
                    boolean $i$f$map = false;
                    HashSet hashSet = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void it2;
                        Object item$iv$iv;
                        Object t = item$iv$iv = iterator.next();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(String.valueOf(it2));
                    }
                    Collection collection = (List)destination$iv$iv;
                    $this$map$iv = new HashSet(collection);
                    map.put(key, $this$map$iv);
                    continue;
                }
                if (value == null) continue;
                boolean bl = false;
                contextData.put(key, new HashSet(SetsKt.setOf((Object)it.toString())));
            }
            prebidRequest.setExtData(contextData);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

