package com.particles.prebidadapter

import com.particles.msp.AdNetworkAdapterProvider
import com.particles.msp.adapter.AdNetwork
import com.particles.msp.adapter.AdNetworkAdapter

class AdNetworkAdapterProviderImp: AdNetworkAdapterProvider {
    private val GOOGLE_ADAPTER_CLASS_NAME = "com.particles.googleadapter.GoogleAdapter"
    private val PREBID_ADAPTER_CLASS_NAME = "com.particles.prebidadapter.PrebidAdapter"
    private val FACEBOOK_ADAPTER_CLASS_NAME = "com.particles.facebookadapter.FacebookAdapter"
    private val NOVA_ADAPTER_CLASS_NAME = "com.particles.novaadapter.NovaAdapter"
    private val UNITY_ADAPTER_CLASS_NAME = "com.particles.unityadapter.UnityAdapter"
    private val INMOBI_ADAPTER_CLASS_NAME = "com.particles.inmobiadapter.InMobiAdapter"
    private val MOBILEFUSE_ADAPTER_CLASS_NAME = "com.particles.mobilefuseadapter.MobileFuseAdapter"
    private val MINTEGRAL_ADAPTER_CLASS_NAME = "com.particles.mintegraladapter.MintegralAdapter"
    private val PUBMATIC_ADAPTER_CLASS_NAME = "com.particles.pubmaticadapter.PubMaticAdapter"

    override fun getAdNetworkAdapter(adNetwork: AdNetwork): AdNetworkAdapter? {
        val classStr = when (adNetwork) {
            AdNetwork.Google -> GOOGLE_ADAPTER_CLASS_NAME
            AdNetwork.Prebid -> PREBID_ADAPTER_CLASS_NAME
            AdNetwork.Facebook -> FACEBOOK_ADAPTER_CLASS_NAME
            AdNetwork.Nova -> NOVA_ADAPTER_CLASS_NAME
            AdNetwork.Unity -> UNITY_ADAPTER_CLASS_NAME
            AdNetwork.InMobi -> INMOBI_ADAPTER_CLASS_NAME
            AdNetwork.MobileFuse -> MOBILEFUSE_ADAPTER_CLASS_NAME
            AdNetwork.Mintegral -> MINTEGRAL_ADAPTER_CLASS_NAME
            AdNetwork.PubMatic -> PUBMATIC_ADAPTER_CLASS_NAME
            else -> return null
        }
        return createInstance(classStr) as? AdNetworkAdapter
    }
}
