package com.particles.prebidadapter

import android.content.Context
import com.particles.msp.BidLoader
import com.particles.msp.BidLoaderProvider
import com.particles.msp.adapter.FacebookBidTokenProvider
import com.particles.msp.adapter.GoogleQueryInfoFetcher

class BidLoaderProviderImp(private val context: Context): BidLoaderProvider {
    override fun getBidLoader(): BidLoader {
        return PrebidBidLoader(context,
            createInstance("com.particles.googleadapter.GoogleQueryInfoFetcherImp") as GoogleQueryInfoFetcher,
            createInstance("com.particles.facebookadapter.FacebookBidTokenProviderImp") as? FacebookBidTokenProvider)
    }
}