package com.particles.prebidadapter

import android.content.Context
import com.particles.msp.adapter.AdNetwork
import com.particles.msp.adapter.AdNetworkAdapter
import com.particles.msp.adapter.AdapterInitListener
import com.particles.msp.adapter.AdapterInitStatus
import com.particles.msp.adapter.InitializationParameters
import com.particles.msp.api.AdListener
import com.particles.msp.api.AdRequest
import com.particles.msp.api.BannerAdView
import com.particles.msp.api.NativeAd
import com.particles.msp.auction.AuctionBidListener
import com.particles.msp.auction.BidderInfo
import com.particles.msp.util.Logger
import org.prebid.mobile.AdSize
import org.prebid.mobile.Host
import org.prebid.mobile.PrebidMobile
import org.prebid.mobile.api.exceptions.AdException
import org.prebid.mobile.api.exceptions.InitError
import org.prebid.mobile.api.rendering.BannerView
import org.prebid.mobile.api.rendering.listeners.BannerViewListener
import org.prebid.mobile.rendering.bidding.data.bid.BidResponse
import org.prebid.mobile.rendering.listeners.SdkInitializationListener

class PrebidAdapter : AdNetworkAdapter() {
    private var bannerView: BannerView? = null
    private val tagPrefix = "[Adapter: Prebid]"

    override fun loadAdCreative(bidResponse: BidResponse?, auctionBidListener: AuctionBidListener, context: Context, adRequest: AdRequest,
                                adListener: AdListener, bidderPlacementId: String, bidderInfo: BidderInfo) {
        super.loadAdCreative(bidResponse, auctionBidListener, context, adRequest, adListener, bidderPlacementId, bidderInfo)

        // Assuming all other bidders are banner format.
        // may need to add prebid native format support later.
        var adSize = AdSize(320, 50)
        adRequest.adSize?.let {
            adSize = AdSize(it.width, it.height)
        }
        val bannerView = BannerView(context, adRequest.placementId, adSize)
        this.bannerView = bannerView
        bannerView.bidResponse = bidResponse
        bannerView.setBannerListener(object : BannerViewListener {
            override fun onBidResponse(bannerView: BannerView?) {}

            override fun onAdLoaded(bannerView: BannerView?) {
                val bannerAdView = BannerAdView(bannerView!!, this@PrebidAdapter)
                Logger.info("$tagPrefix Prebid banner ad loaded successfully.")
                handleAdLoaded(bannerAdView, auctionBidListener, bidderPlacementId, bidderPlacementId, bidResponse?.winningBid?.price?: 0.0)
            }

            override fun onAdDisplayed(bannerView: BannerView?) {
                handleAdImpression(adListener, adRequest)
            }

            override fun onAdFailed(bannerView: BannerView?, exception: AdException?) {}

            override fun onAdClicked(bannerView: BannerView?) {
                handleAdClicked(adListener, adRequest)
            }

            override fun onAdClosed(bannerView: BannerView?) {}
        })
        bannerView.requestAd()
    }

    override fun prepareViewForInteraction(nativeAd: NativeAd, nativeAdView: Any) {
    }

    override fun destroyAd() {
        bannerView?.setBannerListener(null)
        bannerView?.destroy()
    }

    override fun initialize(
        initParams: InitializationParameters,
        adapterInitListener: AdapterInitListener,
        context: Context
    ) {
        super.initialize(initParams, adapterInitListener, context)
        // Prebid SDk must be initialized in UI main thread.
        PrebidMobile.setPrebidServerAccountId(initParams.getPrebidAPIKey())
        Host.CUSTOM.hostUrl = initParams.getPrebidHostUrl()
        PrebidMobile.setPrebidServerHost(Host.CUSTOM)
        PrebidMobile.setShareGeoLocation(true)
        PrebidMobile.setTimeoutMillis(10000)
        PrebidMobile.initializeSdk(context, object : SdkInitializationListener {
            override fun onSdkInit() {
                adapterInitListener.onComplete(AdNetwork.Prebid, AdapterInitStatus.SUCCESS, AdapterInitStatus.SUCCESS.message)
            }

            override fun onSdkFailedToInit(error: InitError?) {}
        })
    }
}
