package com.particles.prebidadapter

import android.content.Context
import android.content.pm.PackageManager
import kotlin.reflect.KClass

fun createInstance(className: String): Any? {
    return try {
        val clazz = Class.forName(className)
        clazz.newInstance()
    } catch (e: ClassNotFoundException) {
        null
    } catch (e: InstantiationException) {
        null
    } catch (e: IllegalAccessException) {
        null
    }
}

fun <T : Any> createInstanceWithParameters(kClass: KClass<T>, vararg args: Any?): T? {
    val constructor = kClass.constructors.firstOrNull { it.parameters.size == args.size }
        ?: return null

    return constructor.call(*args)
}

fun getAppInstallTime(context: Context?): Long {
    val nonNullContext: Context = context ?: return 0

    return try {
        nonNullContext.packageManager.getPackageInfo(context.packageName, 0).firstInstallTime
    } catch (e: PackageManager.NameNotFoundException) {
        0
    }
}