package com.particles.prebidadapter

import com.particles.msp.auction.Bidder
import com.particles.msp.auction.BidderProvider
import com.particles.msp.auction.BidderInfo
import com.particles.msp.auction.DefaultBidder

class BidderProviderImp : BidderProvider {
    companion object {
        private const val PREBID_BIDDER_CLASS_NAME = "com.particles.prebidadapter.PrebidBidder"
    }
    override fun getBidder(bidderInfo: BidderInfo): Bidder? {
        if (bidderInfo.name == "msp") {
            return runCatching {
                val clazz = Class.forName(PREBID_BIDDER_CLASS_NAME).kotlin
                createInstanceWithParameters(clazz, bidderInfo) as? Bidder
            }.getOrNull()
        }

        return DefaultBidder(bidderInfo)
    }
}
