/*
 * Decompiled with CFR 0.152.
 */
package com.particles.prebidadapter;

import android.content.Context;
import com.particles.msp.adapter.AdNetwork;
import com.particles.msp.adapter.AdNetworkAdapter;
import com.particles.msp.adapter.AdapterInitListener;
import com.particles.msp.adapter.AdapterInitStatus;
import com.particles.msp.adapter.InitializationParameters;
import com.particles.msp.api.AdFormat;
import com.particles.msp.api.AdListener;
import com.particles.msp.api.AdRequest;
import com.particles.msp.api.AdSize;
import com.particles.msp.api.BannerAdView;
import com.particles.msp.api.MSPAd;
import com.particles.msp.api.NativeAd;
import com.particles.msp.auction.AuctionBidListener;
import com.particles.msp.auction.BidderInfo;
import com.particles.msp.util.Logger;
import com.particles.msp.util.UtilsKt;
import com.particles.prebidadapter.PrebidInterstitialAd;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.prebid.mobile.Host;
import org.prebid.mobile.PrebidMobile;
import org.prebid.mobile.api.data.AdUnitFormat;
import org.prebid.mobile.api.exceptions.AdException;
import org.prebid.mobile.api.exceptions.InitError;
import org.prebid.mobile.api.rendering.BannerView;
import org.prebid.mobile.api.rendering.listeners.BannerViewListener;
import org.prebid.mobile.configuration.AdUnitConfiguration;
import org.prebid.mobile.rendering.bidding.data.bid.Bid;
import org.prebid.mobile.rendering.bidding.data.bid.BidResponse;
import org.prebid.mobile.rendering.bidding.display.InterstitialController;
import org.prebid.mobile.rendering.bidding.interfaces.InterstitialControllerListener;
import org.prebid.mobile.rendering.listeners.SdkInitializationListener;
import org.prebid.mobile.rendering.models.AdPosition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016JB\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 H\u0016J@\u0010!\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J@\u0010%\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J@\u0010&\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0018\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/particles/prebidadapter/PrebidAdapter;", "Lcom/particles/msp/adapter/AdNetworkAdapter;", "()V", "adNetworkName", "", "getAdNetworkName", "()Ljava/lang/String;", "bannerView", "Lorg/prebid/mobile/api/rendering/BannerView;", "interstitialController", "Lorg/prebid/mobile/rendering/bidding/display/InterstitialController;", "tagPrefix", "destroyAd", "", "initialize", "initParams", "Lcom/particles/msp/adapter/InitializationParameters;", "adapterInitListener", "Lcom/particles/msp/adapter/AdapterInitListener;", "context", "Landroid/content/Context;", "loadAdCreative", "bidResponse", "Lorg/prebid/mobile/rendering/bidding/data/bid/BidResponse;", "auctionBidListener", "Lcom/particles/msp/auction/AuctionBidListener;", "adRequest", "Lcom/particles/msp/api/AdRequest;", "adListener", "Lcom/particles/msp/api/AdListener;", "bidderPlacementId", "bidderInfo", "Lcom/particles/msp/auction/BidderInfo;", "loadBannerAd", "adUnitId", "winnerBid", "Lorg/prebid/mobile/rendering/bidding/data/bid/Bid;", "loadInterstitialAd", "loadNativeAd", "prepareViewForInteraction", "nativeAd", "Lcom/particles/msp/api/NativeAd;", "nativeAdView", "", "prebid-adapter_mavenRelease"})
public final class PrebidAdapter
extends AdNetworkAdapter {
    @Nullable
    private BannerView bannerView;
    @Nullable
    private InterstitialController interstitialController;
    @NotNull
    private final String tagPrefix;

    public PrebidAdapter() {
        this.tagPrefix = "[Adapter: Prebid]";
    }

    @NotNull
    public String getAdNetworkName() {
        Object object;
        block3: {
            block2: {
                object = this.getBidResponse();
                if (object == null || (object = object.getWinningBid()) == null || (object = object.getJsonString()) == null) break block2;
                Object it = object;
                boolean bl = false;
                String string = UtilsKt.getBidder((String)it);
                object = string;
                if (string != null) break block3;
            }
            object = "unknown";
        }
        return object;
    }

    public void loadAdCreative(@Nullable BidResponse bidResponse, @NotNull AuctionBidListener auctionBidListener, @NotNull Context context, @NotNull AdRequest adRequest, @NotNull AdListener adListener, @NotNull String bidderPlacementId, @NotNull BidderInfo bidderInfo) {
        Bid winnerBid;
        Intrinsics.checkNotNullParameter((Object)auctionBidListener, (String)"auctionBidListener");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)adRequest, (String)"adRequest");
        Intrinsics.checkNotNullParameter((Object)adListener, (String)"adListener");
        Intrinsics.checkNotNullParameter((Object)bidderPlacementId, (String)"bidderPlacementId");
        Intrinsics.checkNotNullParameter((Object)bidderInfo, (String)"bidderInfo");
        super.loadAdCreative(bidResponse, auctionBidListener, context, adRequest, adListener, bidderPlacementId, bidderInfo);
        String adUnitId = adRequest.getPlacementId();
        BidResponse bidResponse2 = bidResponse;
        Object object = winnerBid = bidResponse2 != null ? bidResponse2.getWinningBid() : null;
        if (winnerBid == null) {
            this.handleAdLoadError(auctionBidListener, bidderPlacementId, "Failed to load prebid Ad: No Winning bid returned");
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[adRequest.getAdFormat().ordinal()]) {
            case 1: {
                this.loadBannerAd(context, adUnitId, winnerBid, adRequest, adListener, auctionBidListener, bidderPlacementId);
                break;
            }
            case 2: {
                this.loadNativeAd(context, adUnitId, winnerBid, adRequest, adListener, auctionBidListener, bidderPlacementId);
                break;
            }
            case 3: {
                this.loadInterstitialAd(context, adUnitId, winnerBid, adRequest, adListener, auctionBidListener, bidderPlacementId);
                break;
            }
            case 4: {
                String type = winnerBid.getPrebid().getType();
                if (Intrinsics.areEqual((Object)type, (Object)"banner")) {
                    this.loadBannerAd(context, adUnitId, winnerBid, adRequest, adListener, auctionBidListener, bidderPlacementId);
                    break;
                }
                if (Intrinsics.areEqual((Object)type, (Object)"native")) {
                    this.loadNativeAd(context, adUnitId, winnerBid, adRequest, adListener, auctionBidListener, bidderPlacementId);
                    break;
                }
                this.handleAdLoadError(auctionBidListener, bidderPlacementId, "Failed to load prebid Ad: Unsupported Ad type: " + type);
                break;
            }
            default: {
                this.handleAdLoadError(auctionBidListener, bidderPlacementId, "Failed to load prebid Ad: Unsupported Ad Format: " + adRequest.getAdFormat());
            }
        }
    }

    private final void loadBannerAd(Context context, String adUnitId, Bid winnerBid, AdRequest adRequest, AdListener adListener, AuctionBidListener auctionBidListener, String bidderPlacementId) {
        BannerView bannerView;
        org.prebid.mobile.AdSize adSize = null;
        adSize = new org.prebid.mobile.AdSize(320, 50);
        AdSize adSize2 = adRequest.getAdSize();
        if (adSize2 != null) {
            AdSize it = adSize2;
            boolean bl = false;
            adSize = new org.prebid.mobile.AdSize(it.getWidth(), it.getHeight());
        }
        this.bannerView = bannerView = new BannerView(context, adRequest.getPlacementId(), adSize);
        bannerView.setBidResponse(this.getBidResponse());
        bannerView.setBannerListener(new BannerViewListener(this, auctionBidListener, bidderPlacementId, adListener, adRequest){
            final /* synthetic */ PrebidAdapter this$0;
            final /* synthetic */ AuctionBidListener $auctionBidListener;
            final /* synthetic */ String $bidderPlacementId;
            final /* synthetic */ AdListener $adListener;
            final /* synthetic */ AdRequest $adRequest;
            {
                this.this$0 = $receiver;
                this.$auctionBidListener = $auctionBidListener;
                this.$bidderPlacementId = $bidderPlacementId;
                this.$adListener = $adListener;
                this.$adRequest = $adRequest;
            }

            public void onBidResponse(@Nullable BannerView bannerView) {
            }

            public void onAdLoaded(@Nullable BannerView bannerView) {
                BannerView bannerView2 = bannerView;
                Intrinsics.checkNotNull((Object)bannerView2);
                BannerAdView bannerAdView = new BannerAdView((Object)bannerView2, (AdNetworkAdapter)this.this$0);
                Logger.INSTANCE.info(PrebidAdapter.access$getTagPrefix$p(this.this$0) + " Prebid banner ad loaded successfully.");
                BidResponse bidResponse = PrebidAdapter.access$getBidResponse(this.this$0);
                this.this$0.handleAdLoaded((MSPAd)bannerAdView, this.$auctionBidListener, this.$bidderPlacementId, this.$bidderPlacementId, bidResponse != null && (bidResponse = bidResponse.getWinningBid()) != null ? bidResponse.getPrice() : 0.0);
            }

            public void onAdDisplayed(@Nullable BannerView bannerView) {
                this.this$0.handleAdImpression(this.$adListener, this.$adRequest);
            }

            public void onAdFailed(@Nullable BannerView bannerView, @Nullable AdException exception) {
            }

            public void onAdClicked(@Nullable BannerView bannerView) {
                this.this$0.handleAdClicked(this.$adListener, this.$adRequest);
            }

            public void onAdClosed(@Nullable BannerView bannerView) {
            }
        });
        bannerView.requestAd();
    }

    private final void loadNativeAd(Context context, String adUnitId, Bid winnerBid, AdRequest adRequest, AdListener adListener, AuctionBidListener auctionBidListener, String bidderPlacementId) {
        Logger.INSTANCE.info(this.tagPrefix + " Failed to load Prebid native Ad: not supported");
        this.handleAdLoadError(auctionBidListener, bidderPlacementId, "Failed to load Prebid native Ad: not supported");
    }

    private final void loadInterstitialAd(Context context, String adUnitId, Bid winnerBid, AdRequest adRequest, AdListener adListener, AuctionBidListener auctionBidListener, String bidderPlacementId) {
        AdUnitConfiguration adUnitConfiguration;
        Logger.INSTANCE.info(this.tagPrefix + " start to load prebid interstitial ads: " + bidderPlacementId);
        AdUnitConfiguration $this$loadInterstitialAd_u24lambda_u242 = adUnitConfiguration = new AdUnitConfiguration();
        boolean bl = false;
        $this$loadInterstitialAd_u24lambda_u242.setConfigId(adUnitId);
        $this$loadInterstitialAd_u24lambda_u242.setAdUnitFormats(EnumSet.of((Enum)AdUnitFormat.BANNER, (Enum)AdUnitFormat.VIDEO));
        $this$loadInterstitialAd_u24lambda_u242.setAdPosition(AdPosition.FULLSCREEN);
        AdUnitConfiguration adUnitConfig = adUnitConfiguration;
        try {
            InterstitialController interstitialController = this.interstitialController = new InterstitialController(context, new InterstitialControllerListener(this, auctionBidListener, bidderPlacementId, adUnitId, winnerBid, adListener, adRequest){
                final /* synthetic */ PrebidAdapter this$0;
                final /* synthetic */ AuctionBidListener $auctionBidListener;
                final /* synthetic */ String $bidderPlacementId;
                final /* synthetic */ String $adUnitId;
                final /* synthetic */ Bid $winnerBid;
                final /* synthetic */ AdListener $adListener;
                final /* synthetic */ AdRequest $adRequest;
                {
                    this.this$0 = $receiver;
                    this.$auctionBidListener = $auctionBidListener;
                    this.$bidderPlacementId = $bidderPlacementId;
                    this.$adUnitId = $adUnitId;
                    this.$winnerBid = $winnerBid;
                    this.$adListener = $adListener;
                    this.$adRequest = $adRequest;
                }

                public void onInterstitialReadyForDisplay() {
                    Logger.INSTANCE.info(PrebidAdapter.access$getTagPrefix$p(this.this$0) + " successfully loaded Prebid interstitial ad");
                    InterstitialController interstitialController = PrebidAdapter.access$getInterstitialController$p(this.this$0);
                    if (interstitialController == null) {
                        return;
                    }
                    InterstitialController interstitialController2 = interstitialController;
                    PrebidInterstitialAd mspInterstitialAd = new PrebidInterstitialAd(this.this$0, interstitialController2);
                    this.this$0.handleAdLoaded((MSPAd)mspInterstitialAd, this.$auctionBidListener, this.$bidderPlacementId, this.$adUnitId, this.$winnerBid.getPrice());
                }

                public void onInterstitialClicked() {
                    this.this$0.handleAdClicked(this.$adListener, this.$adRequest);
                }

                public void onInterstitialFailedToLoad(@Nullable AdException e) {
                    AdException adException = e;
                    Logger.INSTANCE.info(PrebidAdapter.access$getTagPrefix$p(this.this$0) + " Failed to load Prebid interstitial Ad: " + (adException != null ? adException.getMessage() : null));
                    AdException adException2 = e;
                    this.this$0.handleAdLoadError(this.$auctionBidListener, this.$bidderPlacementId, "Failed to load Prebid interstitial Ad: " + (adException2 != null ? adException2.getMessage() : null));
                }

                public void onInterstitialDisplayed() {
                    this.this$0.handleAdImpression(this.$adListener, this.$adRequest);
                }

                public void onInterstitialClosed() {
                    this.this$0.handleAdDismissed(this.$adListener, this.$adRequest);
                }
            });
            if (interstitialController != null) {
                interstitialController.loadAd(adUnitConfig, this.getBidResponse());
            }
        }
        catch (AdException e) {
            Logger.INSTANCE.info(this.tagPrefix + " Failed to load Prebid interstitial Ad: " + e.getMessage());
            this.handleAdLoadError(auctionBidListener, bidderPlacementId, "Failed to load Prebid interstitial Ad: " + e.getMessage());
        }
    }

    public void prepareViewForInteraction(@NotNull NativeAd nativeAd, @NotNull Object nativeAdView) {
        Intrinsics.checkNotNullParameter((Object)nativeAd, (String)"nativeAd");
        Intrinsics.checkNotNullParameter((Object)nativeAdView, (String)"nativeAdView");
    }

    public void destroyAd() {
        BannerView bannerView = this.bannerView;
        if (bannerView != null) {
            bannerView.setBannerListener(null);
        }
        BannerView bannerView2 = this.bannerView;
        if (bannerView2 != null) {
            bannerView2.destroy();
        }
        InterstitialController interstitialController = this.interstitialController;
        if (interstitialController != null) {
            interstitialController.destroy();
        }
        this.interstitialController = null;
    }

    public void initialize(@NotNull InitializationParameters initParams, @NotNull AdapterInitListener adapterInitListener, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)initParams, (String)"initParams");
        Intrinsics.checkNotNullParameter((Object)adapterInitListener, (String)"adapterInitListener");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.initialize(initParams, adapterInitListener, context);
        PrebidMobile.setPrebidServerAccountId((String)initParams.getPrebidAPIKey());
        Host.CUSTOM.setHostUrl(initParams.getPrebidHostUrl());
        PrebidMobile.setPrebidServerHost((Host)Host.CUSTOM);
        PrebidMobile.setShareGeoLocation((boolean)true);
        PrebidMobile.setTimeoutMillis((int)10000);
        PrebidMobile.initializeSdk((Context)context, (SdkInitializationListener)new SdkInitializationListener(adapterInitListener){
            final /* synthetic */ AdapterInitListener $adapterInitListener;
            {
                this.$adapterInitListener = $adapterInitListener;
            }

            public void onSdkInit() {
                this.$adapterInitListener.onComplete(AdNetwork.Prebid, AdapterInitStatus.SUCCESS, AdapterInitStatus.SUCCESS.getMessage());
            }

            public void onSdkFailedToInit(@Nullable InitError error) {
            }
        });
    }

    public static final /* synthetic */ String access$getTagPrefix$p(PrebidAdapter $this) {
        return $this.tagPrefix;
    }

    public static final /* synthetic */ BidResponse access$getBidResponse(PrebidAdapter $this) {
        return $this.getBidResponse();
    }

    public static final /* synthetic */ InterstitialController access$getInterstitialController$p(PrebidAdapter $this) {
        return $this.interstitialController;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AdFormat.values().length];
            try {
                nArray[AdFormat.BANNER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdFormat.NATIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdFormat.INTERSTITIAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdFormat.MULTI_FORMAT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

