/*
 * Decompiled with CFR 0.152.
 */
package com.particles.prebidadapter;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.hardware.display.DisplayManager;
import android.net.ConnectivityManager;
import android.os.BatteryManager;
import android.os.Build;
import android.os.PowerManager;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.RequiresPermission;
import androidx.core.app.ActivityCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.particles.msp.util.Logger;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a=\u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0016\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\t\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\n\u001a\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u001a\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u001a&\u0010\u0010\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0013H\u0000\u001a\u0012\u0010\u0014\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u001a\b\u0010\u0015\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0016\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0001\u001a\u0012\u0010\u0017\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u001a\u0012\u0010\u0018\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u00a8\u0006\u0019"}, d2={"createInstance", "", "className", "", "createInstanceWithParameters", "T", "kClass", "Lkotlin/reflect/KClass;", "args", "", "(Lkotlin/reflect/KClass;[Ljava/lang/Object;)Ljava/lang/Object;", "getAppInstallTime", "", "context", "Landroid/content/Context;", "getAvailableMemory", "getBatteryStatus", "", "customParams", "", "getFontSize", "getIsInForeground", "getIsLowDataMode", "getIsLowPowerMode", "getOrientation", "prebid-adapter_mavenRelease"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/particles/prebidadapter/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n288#2,2:204\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/particles/prebidadapter/UtilsKt\n*L\n38#1:204,2\n*E\n"})
public final class UtilsKt {
    @Nullable
    public static final Object createInstance(@NotNull String className) {
        Object var1_1;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        try {
            Class<?> clazz = Class.forName(className);
            var1_1 = clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            var1_1 = null;
        }
        catch (InstantiationException e) {
            var1_1 = null;
        }
        catch (IllegalAccessException e) {
            var1_1 = null;
        }
        return var1_1;
    }

    @Nullable
    public static final <T> T createInstanceWithParameters(@NotNull KClass<T> kClass, Object ... args) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Iterable $this$firstOrNull$iv = kClass.getConstructors();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KFunction it = (KFunction)element$iv;
                boolean bl = false;
                if (!(it.getParameters().size() == args.length)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        KFunction kFunction = v0;
        if (kFunction == null) {
            return null;
        }
        KFunction constructor = kFunction;
        return (T)constructor.call(Arrays.copyOf(args, args.length));
    }

    public static final long getAppInstallTime(@Nullable Context context) {
        long l;
        Context context2 = context;
        if (context2 == null) {
            return 0L;
        }
        Context nonNullContext = context2;
        try {
            l = nonNullContext.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).firstInstallTime;
        }
        catch (PackageManager.NameNotFoundException e) {
            l = 0L;
        }
        return l;
    }

    public static final long getAvailableMemory(@Nullable Context context) {
        ActivityManager.MemoryInfo memInfo;
        block1: {
            ActivityManager activityManager;
            Context context2 = context;
            Object object = context2 != null ? context2.getSystemService("activity") : null;
            ActivityManager activityManager2 = activityManager = object instanceof ActivityManager ? (ActivityManager)object : null;
            if (activityManager == null) {
                Logger.INSTANCE.info("getAvailableMemory: context is null or get ActivityManager failed.");
            }
            memInfo = new ActivityManager.MemoryInfo();
            ActivityManager activityManager3 = activityManager;
            if (activityManager3 == null) break block1;
            activityManager3.getMemoryInfo(memInfo);
        }
        return memInfo.availMem;
    }

    @NotNull
    public static final String getFontSize(@Nullable Context context) {
        String string;
        Context context2 = context;
        if (context2 != null) {
            Context it = context2;
            boolean bl = false;
            float fontScale = it.getResources().getConfiguration().fontScale;
            string = fontScale == 1.0f ? "m" : (fontScale < 1.0f ? "s" : (fontScale > 1.0f ? "l" : "unknown"));
        } else {
            string = "unknown";
        }
        return string;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @NotNull
    public static final String getIsLowDataMode(@Nullable Context context) {
        if (context == null) {
            Logger.INSTANCE.info("getIsLowDataMode: context is null");
            return "unknown";
        }
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE") == 0) {
            ConnectivityManager connectivityManager;
            Object object = context.getSystemService("connectivity");
            ConnectivityManager connectivityManager2 = connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
            if (connectivityManager == null) {
                Logger.INSTANCE.info("getIsLowDataMode: get ConnectivityManager failed");
                return "unknown";
            }
            return connectivityManager.isActiveNetworkMetered() ? "true" : "false";
        }
        Logger.INSTANCE.info("getIsLowDataMode: no permission of ACCESS_NETWORK_STATE");
        return "unknown";
    }

    @NotNull
    public static final String getIsLowPowerMode(@Nullable Context context) {
        PowerManager powerManager;
        if (context == null) {
            Logger.INSTANCE.info("getIsLowPowerMode: context is null");
            return "unknown";
        }
        Object object = context.getSystemService("power");
        PowerManager powerManager2 = powerManager = object instanceof PowerManager ? (PowerManager)object : null;
        if (powerManager == null) {
            Logger.INSTANCE.info("getIsLowPowerMode: get PowerManager failed");
            return "unknown";
        }
        return powerManager.isPowerSaveMode() ? "true" : "false";
    }

    public static final void getBatteryStatus(@Nullable Context context, @NotNull Map<String, Object> customParams) {
        Intrinsics.checkNotNullParameter(customParams, (String)"customParams");
        if (context == null) {
            Logger.INSTANCE.info("getBatteryStatus: context is null");
            customParams.put("battery_level", "unknown");
            customParams.put("battery_status", "unknown");
        } else {
            BatteryManager batteryManager;
            Object object = context.getSystemService("batterymanager");
            BatteryManager batteryManager2 = batteryManager = object instanceof BatteryManager ? (BatteryManager)object : null;
            if (batteryManager == null) {
                Logger.INSTANCE.info("getBatteryStatus: get BatteryManager failed");
                customParams.put("battery_level", "unknown");
                customParams.put("battery_status", "unknown");
            } else {
                int batteryCapacity = batteryManager.getIntProperty(4);
                Map<String, Object> map = customParams;
                Object object2 = "battery_level";
                String string = "%.2f";
                Object object3 = new Object[]{Float.valueOf((float)batteryCapacity / 100.0f)};
                String string2 = String.format(string, Arrays.copyOf(object3, ((Object[])object3).length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                string = string2;
                map.put((String)object2, string);
                if (Build.VERSION.SDK_INT >= 26) {
                    String string3;
                    int batteryStatus = batteryManager.getIntProperty(6);
                    object2 = customParams;
                    string = "battery_status";
                    switch (batteryStatus) {
                        case 2: {
                            string3 = "charging";
                            break;
                        }
                        case 3: {
                            string3 = "unplugged";
                            break;
                        }
                        case 5: {
                            string3 = "full";
                            break;
                        }
                        case 4: {
                            string3 = "unknown";
                            break;
                        }
                        case 1: {
                            string3 = "unknown";
                            break;
                        }
                        default: {
                            string3 = "unknown";
                        }
                    }
                    object3 = string3;
                    object2.put(string, object3);
                } else {
                    customParams.put("battery_status", "unknown");
                }
            }
        }
    }

    @NotNull
    public static final String getOrientation(@Nullable Context context) {
        String string;
        Display display;
        Object object;
        if (context == null) {
            Logger.INSTANCE.info("getOrientation: context is null");
            return "unknown";
        }
        if (Build.VERSION.SDK_INT >= 30) {
            DisplayManager displayManager;
            object = context.getSystemService("display");
            DisplayManager displayManager2 = displayManager = object instanceof DisplayManager ? (DisplayManager)object : null;
            if (displayManager == null) {
                Logger.INSTANCE.info("getOrientation: get DisplayManager failed");
                return "unknown";
            }
            display = displayManager.getDisplay(0);
        } else {
            WindowManager windowManager;
            object = context.getSystemService("window");
            WindowManager windowManager2 = windowManager = object instanceof WindowManager ? (WindowManager)object : null;
            if (windowManager == null) {
                Logger.INSTANCE.info("getOrientation: get WindowManager failed");
                return "unknown";
            }
            display = windowManager.getDefaultDisplay();
        }
        Display display2 = display;
        int rotation = display2.getRotation();
        int orientation = context.getResources().getConfiguration().orientation;
        switch (rotation) {
            case 0: {
                if (orientation == 1) {
                    string = "portrait";
                    break;
                }
                string = "landscapeLeft";
                break;
            }
            case 1: {
                if (orientation == 2) {
                    string = "landscapeLeft";
                    break;
                }
                string = "portraitUpsideDown";
                break;
            }
            case 2: {
                if (orientation == 1) {
                    string = "portraitUpsideDown";
                    break;
                }
                string = "landscapeRight";
                break;
            }
            case 3: {
                if (orientation == 2) {
                    string = "landscapeRight";
                    break;
                }
                string = "portrait";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    @NotNull
    public static final String getIsInForeground() {
        boolean isForeground = ProcessLifecycleOwner.Companion.get().getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED);
        Logger.INSTANCE.info("getIsInForeground: " + isForeground);
        return isForeground ? "true" : "false";
    }
}

