package com.particles.prebidadapter

import ai.themsp.mspcore.R
import android.content.Context
import com.particles.msp.MSPManager
import com.particles.msp.api.MSPAd
import com.particles.msp.api.MSPInitListener
import com.particles.msp.api.MSPInitializationParameters
import com.particles.msp.auction.AdConfig
import com.particles.msp.auction.Auction
import com.particles.msp.auction.AuctionBid
import com.particles.msp.auction.AuctionBidListener
import com.particles.msp.util.Logger
import com.particles.msp.util.loadJSONFromRaw

object MSP {
    fun init(context: Context,
             initParams: MSPInitializationParameters,
             sdkInitListener: MSPInitListener,
             skipInit: Boolean = true) {
        MSPManager.bidLoaderProvider = BidLoaderProviderImp(context)
        MSPManager.adNetworkAdapterProvider = AdNetworkAdapterProviderImp()
        MSPManager.bidderProvider = BidderProviderImp()
        if (!skipInit) {
            MSPManager.init(initParams, sdkInitListener, context)
        }
    }

    fun showMediationDebugger(
        context: Context,
    ) {
        MSPManager.showMediationDebugger(context)
    }

}