package com.particles.prebidadapter

import android.content.Context
import com.particles.msp.MSPManager
import com.particles.msp.api.MSPInitListener
import com.particles.msp.api.MSPInitializationParameters

object MSP {
    const val version: String = MSPManager.version
    fun init(context: Context,
             initParams: MSPInitializationParameters,
             sdkInitListener: MSPInitListener,
             skipInit: Boolean = true) {
        val initStartTime = System.currentTimeMillis()
        MSPManager.bidLoaderProvider = BidLoaderProviderImp(context)
        MSPManager.adNetworkAdapterProvider = AdNetworkAdapterProviderImp()
        MSPManager.bidderProvider = BidderProviderImp()
        if (!skipInit) {
            MSPManager.init(initParams, sdkInitListener, context, initStartTime)
        }
    }

    fun showMediationDebugger(
        context: Context,
    ) {
        MSPManager.showMediationDebugger(context)
    }

}