package com.particles.unityadapter

import androidx.annotation.Keep
import com.particles.msp.MSPManager
import com.particles.msp.adapter.AdNetwork
import com.particles.msp.api.AdFormat
import com.particles.msp.api.AdListener
import com.particles.msp.api.AdRequest
import com.particles.msp.auction.AuctionBidListener
import com.particles.msp.auction.Bidder
import com.particles.msp.auction.BidderInfo
import com.particles.msp.util.Logger

@Keep
class UnityBidder(private val bidderInfo: BidderInfo) : Bidder(bidderInfo) {
    override fun requestBid(adRequest: AdRequest, bidListener: AuctionBidListener, adListener: AdListener) {
        val adapter = MSPManager.adNetworkAdapterProvider?.getAdNetworkAdapter(AdNetwork.Unity)
        if (adapter == null) {
            Logger.info("adNetwork Adapter is null for network: ${AdNetwork.Unity}")
            bidListener.onError("adNetwork Adapter is null for network: ${AdNetwork.Unity}")
            return
        }

        val newAdRequest = if (adRequest.adFormat == AdFormat.MULTI_FORMAT) {
            when (bidderInfo.bidderFormat?.lowercase()) {
                "banner" -> adRequest.copy(adFormat = AdFormat.BANNER)
                "native" -> adRequest.copy(adFormat = AdFormat.NATIVE)
                else -> adRequest
            }
        } else adRequest

        adapter.loadAdCreative(Unit, bidListener, adRequest.context, newAdRequest, adListener, bidderPlacementId)
    }
}
