/*
 * Thirdwatch API
 * The first version of the Thirdwatch API is an exciting step forward towards making it easier for developers to pass data to Thirdwatch.  Once you've [registered your website/app](https://thirdwatch.ai) it's easy to start sending data to Thirdwatch.  All endpoints are only accessible via https and are located at `api.thirdwatch.ai`. For instance: you can send event at the moment by ```HTTP POST``` Request to the following URL with your API key in ```Header``` and ```JSON``` data in request body. ```   https://api.thirdwatch.ai/event/v1 ``` Every API request must contain ```API Key``` in header value ```X-THIRDWATCH-API-KEY```  Every event must contain your ```_userId``` (if this is not available, you can alternatively provide a ```_sessionId``` value also in ```_userId```).  JavaScript Fingerprinting module for capturing unique devices and tracking user interaction.  This script will identify unique devices with respect to the browser. For e.g., if chrome is opened in normal mode a unique device id is generated and this will be same if chrome is opened in incognito mode or reinstalled.  Paste the below script onto your webpage, just after the opening `<body>` tag. This script should be added to the page which is accessed externally by the user of your website. For e.g., If you want to track three different webpages then paste the below script onto each webpage, just after the opening `<body>` tag. This script should not be added onto internal tools or admin panels. ```   &lt;script id=\"thirdwatch\"     data-session-cookie-name=\"&lt;cookie_name&gt;\"     data-session-id-value=\"&lt;session_id&gt;\"     data-user-id=\"&lt;user_id&gt;\"     data-app-secret=\"&lt;app_secret&gt;\"     data-is-track-pageview=\"true\"&gt; (function() {         var loadDeviceJs = function() {         var element = document.createElement(\"script\");         element.async = 1;         element.src = \"https://cdn.thirdwatch.ai/tw.min.js\";         document.body.appendChild(element);         };         if (window.addEventListener) {              window.addEventListener(\"load\", loadDeviceJs, false);         } else if (window.attachEvent) {         window.attachEvent(\"onload\", loadDeviceJs);         }     })();   &lt;/script&gt; ``` * `data-session-cookie-name` -- The cookie name where you are saving the unique session id. We will pick the session id by reading its value from the cookie name. (Optional) * `data-session-id-value` -- In case you are not passing `data-session-cookie-name` than you can put session id directly in this parameter. In absence of both `data-session-cookie-name` and `data-session-id-value`, our system will generate a session Id. (Optional) * `data-user-id` -- Unique user id at your end. This can be email id or primary key in the database. In case of guest user, you can insert session Id here. * `data-app-secret` -- Unique App secret generated for you by Thirdwatch. * `data-is-track-pageview` -- If this is set to true, then the url on which this script is running will be sent to Thirdwatch, else the url will not be captured.   The Score API is use to get an up to date cutomer trust score after you have sent transaction event and order successful. This API will provide the riskiness score of the order with reasons. Some examples of when you may want to check the score are before:    - Before Shippement of a package   - Finalizing a money transfer   - Giving access to a prearranged vacation rental   - Sending voucher on mail  ```   https://api.thirdwatch.ai/neo/v1/score?api_key=<your api key>&order_id=<Order id> ```  According to Score you can decide to take action Approve or Reject. Orders with score more than 70 will consider as Riskey orders. We'll provide some reasons also in rules section.   ``` {   \"order_id\": \"OCT45671\",   \"user_id\": \"ajay_245\",   \"order_timestamp\": \"2017-05-09T09:40:45.717Z\",   \"score\": 82,   \"flag\": \"red\",     -\"reasons\": [     {         \"name\": \"_numOfFailedTransactions\",         \"display_name\": \"Number of failed transactions\",         \"flag\": \"green\",         \"value\": \"0\",         \"is_display\": true       },       {         \"name\": \"_accountAge\",         \"display_name\": \"Account age\",         \"flag\": \"red\",         \"value\": \"0\",         \"is_display\": true       },       {         \"name\": \"_numOfOrderSameIp\",         \"display_name\": \"Number of orders from same IP\",         \"flag\": \"red\",         \"value\": \"11\",         \"is_display\": true       }     ] } ``` 
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package ai.thirdwatch.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * The Promotion field type generically models different kinds of promotions such as referrals, coupons, free trials, etc. The value must be a nested JSON object which you populate with the appropriate information to describe the promotion. Not all sub-fields will likely apply to a given promotion. Populate only those that apply.  A promotion can be added when creating or updating an account, creating or updating an order, or on its own using the add_promotion event. The promotion object supports both monetary (e.g. 500 coupon on first order) and non-monetary (e.g. \&quot;100 in points to refer a friend\&quot;). 
 */
@ApiModel(description = "The Promotion field type generically models different kinds of promotions such as referrals, coupons, free trials, etc. The value must be a nested JSON object which you populate with the appropriate information to describe the promotion. Not all sub-fields will likely apply to a given promotion. Populate only those that apply.  A promotion can be added when creating or updating an account, creating or updating an order, or on its own using the add_promotion event. The promotion object supports both monetary (e.g. 500 coupon on first order) and non-monetary (e.g. \"100 in points to refer a friend\"). ")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-11-02T14:14:25.959+05:30")
public class Promotion {
  @SerializedName("_promotionId")
  private String promotionId = null;

  @SerializedName("_status")
  private String status = null;

  @SerializedName("_description")
  private String description = null;

  @SerializedName("_amount")
  private String amount = null;

  @SerializedName("_minPurchaseAmount")
  private String minPurchaseAmount = null;

  @SerializedName("_referrerUserId")
  private String referrerUserId = null;

  @SerializedName("_failureReason")
  private String failureReason = null;

  @SerializedName("_percentageOff")
  private String percentageOff = null;

  @SerializedName("_currencyCode")
  private String currencyCode = null;

  @SerializedName("_type")
  private String type = null;

  public Promotion promotionId(String promotionId) {
    this.promotionId = promotionId;
    return this;
  }

   /**
   * The ID/Coupon Code within your system that you use to represent this promotion. This ID is ideally unique to the promotion across users (e.g. \&quot;Welcome\&quot;).
   * @return promotionId
  **/
  @ApiModelProperty(value = "The ID/Coupon Code within your system that you use to represent this promotion. This ID is ideally unique to the promotion across users (e.g. \"Welcome\").")
  public String getPromotionId() {
    return promotionId;
  }

  public void setPromotionId(String promotionId) {
    this.promotionId = promotionId;
  }

  public Promotion status(String status) {
    this.status = status;
    return this;
  }

   /**
   * The status of the addition of promotion to an account. Best used with the add_promotion event. This way you can pass to Thirdwatch both successful and failed attempts when using a promotion. May be useful in spotting potential abuse. e.g. _success, _Failed
   * @return status
  **/
  @ApiModelProperty(value = "The status of the addition of promotion to an account. Best used with the add_promotion event. This way you can pass to Thirdwatch both successful and failed attempts when using a promotion. May be useful in spotting potential abuse. e.g. _success, _Failed")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public Promotion description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Describe promotion here.
   * @return description
  **/
  @ApiModelProperty(value = "Describe promotion here.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Promotion amount(String amount) {
    this.amount = amount;
    return this;
  }

   /**
   * The amount or credits the promotion is worth.
   * @return amount
  **/
  @ApiModelProperty(value = "The amount or credits the promotion is worth.")
  public String getAmount() {
    return amount;
  }

  public void setAmount(String amount) {
    this.amount = amount;
  }

  public Promotion minPurchaseAmount(String minPurchaseAmount) {
    this.minPurchaseAmount = minPurchaseAmount;
    return this;
  }

   /**
   * The minimum amount someone must spend in order for the promotion to be applied.
   * @return minPurchaseAmount
  **/
  @ApiModelProperty(value = "The minimum amount someone must spend in order for the promotion to be applied.")
  public String getMinPurchaseAmount() {
    return minPurchaseAmount;
  }

  public void setMinPurchaseAmount(String minPurchaseAmount) {
    this.minPurchaseAmount = minPurchaseAmount;
  }

  public Promotion referrerUserId(String referrerUserId) {
    this.referrerUserId = referrerUserId;
    return this;
  }

   /**
   * The unique user ID of the user who referred the user to this promotion.
   * @return referrerUserId
  **/
  @ApiModelProperty(value = "The unique user ID of the user who referred the user to this promotion.")
  public String getReferrerUserId() {
    return referrerUserId;
  }

  public void setReferrerUserId(String referrerUserId) {
    this.referrerUserId = referrerUserId;
  }

  public Promotion failureReason(String failureReason) {
    this.failureReason = failureReason;
    return this;
  }

   /**
   * When adding a promotion fails, use this to describe why it failed.e.g. _alreadyUsed, _invalidCode, _notApplicable, _expired
   * @return failureReason
  **/
  @ApiModelProperty(value = "When adding a promotion fails, use this to describe why it failed.e.g. _alreadyUsed, _invalidCode, _notApplicable, _expired")
  public String getFailureReason() {
    return failureReason;
  }

  public void setFailureReason(String failureReason) {
    this.failureReason = failureReason;
  }

  public Promotion percentageOff(String percentageOff) {
    this.percentageOff = percentageOff;
    return this;
  }

   /**
   * The percentage discount. If the discount is 10% off, you would send \&quot;10\&quot;.
   * @return percentageOff
  **/
  @ApiModelProperty(value = "The percentage discount. If the discount is 10% off, you would send \"10\".")
  public String getPercentageOff() {
    return percentageOff;
  }

  public void setPercentageOff(String percentageOff) {
    this.percentageOff = percentageOff;
  }

  public Promotion currencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * The [ISO-4217](http://en.wikipedia.org/wiki/ISO_4217) currency code for the amount. e.g., USD, INR alternative currencies, like bitcoin or points systems.
   * @return currencyCode
  **/
  @ApiModelProperty(value = "The [ISO-4217](http://en.wikipedia.org/wiki/ISO_4217) currency code for the amount. e.g., USD, INR alternative currencies, like bitcoin or points systems.")
  public String getCurrencyCode() {
    return currencyCode;
  }

  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }

  public Promotion type(String type) {
    this.type = type;
    return this;
  }

   /**
   * Type of the promotion e.g., First Time, Refer, Diwali
   * @return type
  **/
  @ApiModelProperty(value = "Type of the promotion e.g., First Time, Refer, Diwali")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Promotion promotion = (Promotion) o;
    return Objects.equals(this.promotionId, promotion.promotionId) &&
        Objects.equals(this.status, promotion.status) &&
        Objects.equals(this.description, promotion.description) &&
        Objects.equals(this.amount, promotion.amount) &&
        Objects.equals(this.minPurchaseAmount, promotion.minPurchaseAmount) &&
        Objects.equals(this.referrerUserId, promotion.referrerUserId) &&
        Objects.equals(this.failureReason, promotion.failureReason) &&
        Objects.equals(this.percentageOff, promotion.percentageOff) &&
        Objects.equals(this.currencyCode, promotion.currencyCode) &&
        Objects.equals(this.type, promotion.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(promotionId, status, description, amount, minPurchaseAmount, referrerUserId, failureReason, percentageOff, currencyCode, type);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Promotion {\n");
    
    sb.append("    promotionId: ").append(toIndentedString(promotionId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    minPurchaseAmount: ").append(toIndentedString(minPurchaseAmount)).append("\n");
    sb.append("    referrerUserId: ").append(toIndentedString(referrerUserId)).append("\n");
    sb.append("    failureReason: ").append(toIndentedString(failureReason)).append("\n");
    sb.append("    percentageOff: ").append(toIndentedString(percentageOff)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

