/*
 * Thirdwatch API
 * The first version of the Thirdwatch API is an exciting step forward towards making it easier for developers to pass data to Thirdwatch.  Once you've [registered your website/app](https://thirdwatch.ai) it's easy to start sending data to Thirdwatch.  All endpoints are only accessible via https and are located at `api.thirdwatch.ai`. For instance: you can send event at the moment by ```HTTP POST``` Request to the following URL with your API key in ```Header``` and ```JSON``` data in request body. ```   https://api.thirdwatch.ai/event/v1 ``` Every API request must contain ```API Key``` in header value ```X-THIRDWATCH-API-KEY```  Every event must contain your ```_userId``` (if this is not available, you can alternatively provide a ```_sessionId``` value also in ```_userId```).  JavaScript Fingerprinting module for capturing unique devices and tracking user interaction.  This script will identify unique devices with respect to the browser. For e.g., if chrome is opened in normal mode a unique device id is generated and this will be same if chrome is opened in incognito mode or reinstalled.  Paste the below script onto your webpage, just after the opening `<body>` tag. This script should be added to the page which is accessed externally by the user of your website. For e.g., If you want to track three different webpages then paste the below script onto each webpage, just after the opening `<body>` tag. This script should not be added onto internal tools or admin panels. ```   &lt;script id=\"thirdwatch\"     data-session-cookie-name=\"&lt;cookie_name&gt;\"     data-session-id-value=\"&lt;session_id&gt;\"     data-user-id=\"&lt;user_id&gt;\"     data-app-secret=\"&lt;app_secret&gt;\"     data-is-track-pageview=\"true\"&gt; (function() {         var loadDeviceJs = function() {         var element = document.createElement(\"script\");         element.async = 1;         element.src = \"https://cdn.thirdwatch.ai/tw.min.js\";         document.body.appendChild(element);         };         if (window.addEventListener) {              window.addEventListener(\"load\", loadDeviceJs, false);         } else if (window.attachEvent) {         window.attachEvent(\"onload\", loadDeviceJs);         }     })();   &lt;/script&gt; ``` * `data-session-cookie-name` -- The cookie name where you are saving the unique session id. We will pick the session id by reading its value from the cookie name. (Optional) * `data-session-id-value` -- In case you are not passing `data-session-cookie-name` than you can put session id directly in this parameter. In absence of both `data-session-cookie-name` and `data-session-id-value`, our system will generate a session Id. (Optional) * `data-user-id` -- Unique user id at your end. This can be email id or primary key in the database. In case of guest user, you can insert session Id here. * `data-app-secret` -- Unique App secret generated for you by Thirdwatch. * `data-is-track-pageview` -- If this is set to true, then the url on which this script is running will be sent to Thirdwatch, else the url will not be captured.   The Score API is use to get an up to date cutomer trust score after you have sent transaction event and order successful. This API will provide the riskiness score of the order with reasons. Some examples of when you may want to check the score are before:    - Before Shippement of a package   - Finalizing a money transfer   - Giving access to a prearranged vacation rental   - Sending voucher on mail  ```   https://api.thirdwatch.ai/neo/v1/score?api_key=<your api key>&order_id=<Order id> ```  According to Score you can decide to take action Approve or Reject. Orders with score more than 70 will consider as Riskey orders. We'll provide some reasons also in rules section.   ``` {   \"order_id\": \"OCT45671\",   \"user_id\": \"ajay_245\",   \"order_timestamp\": \"2017-05-09T09:40:45.717Z\",   \"score\": 82,   \"flag\": \"red\",     -\"reasons\": [     {         \"name\": \"_numOfFailedTransactions\",         \"display_name\": \"Number of failed transactions\",         \"flag\": \"green\",         \"value\": \"0\",         \"is_display\": true       },       {         \"name\": \"_accountAge\",         \"display_name\": \"Account age\",         \"flag\": \"red\",         \"value\": \"0\",         \"is_display\": true       },       {         \"name\": \"_numOfOrderSameIp\",         \"display_name\": \"Number of orders from same IP\",         \"flag\": \"red\",         \"value\": \"11\",         \"is_display\": true       }     ] } ``` 
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package ai.thirdwatch.model;

import java.util.Objects;
import ai.thirdwatch.model.BillingAddress;
import ai.thirdwatch.model.CustomInfo;
import ai.thirdwatch.model.PaymentMethod;
import ai.thirdwatch.model.Promotion;
import ai.thirdwatch.model.ShippingAddress;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * UpdateAccount
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-11-02T14:14:25.959+05:30")
public class UpdateAccount {
  @SerializedName("_userId")
  private String userId = null;

  @SerializedName("_sessionId")
  private String sessionId = null;

  @SerializedName("_deviceIp")
  private String deviceIp = null;

  @SerializedName("_originTimestamp")
  private String originTimestamp = null;

  @SerializedName("_userEmail")
  private String userEmail = null;

  @SerializedName("_firstName")
  private String firstName = null;

  @SerializedName("_lastName")
  private String lastName = null;

  @SerializedName("_phone")
  private String phone = null;

  @SerializedName("_age")
  private String age = null;

  @SerializedName("_gender")
  private String gender = null;

  @SerializedName("_referralCode")
  private String referralCode = null;

  @SerializedName("_referrerUserId")
  private String referrerUserId = null;

  @SerializedName("_billingAddress")
  private BillingAddress billingAddress = null;

  @SerializedName("_shippingAddress")
  private ShippingAddress shippingAddress = null;

  @SerializedName("_paymentMethods")
  private List<PaymentMethod> paymentMethods = null;

  @SerializedName("_promotions")
  private List<Promotion> promotions = null;

  @SerializedName("_socialSignOnType")
  private String socialSignOnType = null;

  @SerializedName("_emailConfirmedStatus")
  private String emailConfirmedStatus = null;

  @SerializedName("_phoneConfirmedStatus")
  private String phoneConfirmedStatus = null;

  @SerializedName("_isNewsletterSubscribed")
  private Boolean isNewsletterSubscribed = null;

  @SerializedName("_accountStatus")
  private String accountStatus = null;

  @SerializedName("_facebookId")
  private String facebookId = null;

  @SerializedName("_googleId")
  private String googleId = null;

  @SerializedName("_twitterId")
  private String twitterId = null;

  @SerializedName("_customInfo")
  private CustomInfo customInfo = null;

  public UpdateAccount userId(String userId) {
    this.userId = userId;
    return this;
  }

   /**
   * The user&#39;s account ID according to your systems. Note that user IDs are case sensitive.
   * @return userId
  **/
  @ApiModelProperty(value = "The user's account ID according to your systems. Note that user IDs are case sensitive.")
  public String getUserId() {
    return userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  public UpdateAccount sessionId(String sessionId) {
    this.sessionId = sessionId;
    return this;
  }

   /**
   * The user&#39;s current session ID, used to tie a user&#39;s action before and after login or account creation. Required if no user_id values is provided.
   * @return sessionId
  **/
  @ApiModelProperty(value = "The user's current session ID, used to tie a user's action before and after login or account creation. Required if no user_id values is provided.")
  public String getSessionId() {
    return sessionId;
  }

  public void setSessionId(String sessionId) {
    this.sessionId = sessionId;
  }

  public UpdateAccount deviceIp(String deviceIp) {
    this.deviceIp = deviceIp;
    return this;
  }

   /**
   * IP address of the request made by the user. Recommended for historical backfills and customers with mobile apps.
   * @return deviceIp
  **/
  @ApiModelProperty(value = "IP address of the request made by the user. Recommended for historical backfills and customers with mobile apps.")
  public String getDeviceIp() {
    return deviceIp;
  }

  public void setDeviceIp(String deviceIp) {
    this.deviceIp = deviceIp;
  }

  public UpdateAccount originTimestamp(String originTimestamp) {
    this.originTimestamp = originTimestamp;
    return this;
  }

   /**
   * Represents the time the event occured in your system. Send as a UNIX timestamp in milliseconds in string.
   * @return originTimestamp
  **/
  @ApiModelProperty(value = "Represents the time the event occured in your system. Send as a UNIX timestamp in milliseconds in string.")
  public String getOriginTimestamp() {
    return originTimestamp;
  }

  public void setOriginTimestamp(String originTimestamp) {
    this.originTimestamp = originTimestamp;
  }

  public UpdateAccount userEmail(String userEmail) {
    this.userEmail = userEmail;
    return this;
  }

   /**
   * Email of the user creating this order. Note - If the user&#39;s email is also their account ID in your system, set both the userId and userEmail fields to their email address.
   * @return userEmail
  **/
  @ApiModelProperty(value = "Email of the user creating this order. Note - If the user's email is also their account ID in your system, set both the userId and userEmail fields to their email address.")
  public String getUserEmail() {
    return userEmail;
  }

  public void setUserEmail(String userEmail) {
    this.userEmail = userEmail;
  }

  public UpdateAccount firstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

   /**
   * Provide the first name associated with the user here.
   * @return firstName
  **/
  @ApiModelProperty(value = "Provide the first name associated with the user here.")
  public String getFirstName() {
    return firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  public UpdateAccount lastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

   /**
   * Provide the last name associated with the user here.
   * @return lastName
  **/
  @ApiModelProperty(value = "Provide the last name associated with the user here.")
  public String getLastName() {
    return lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  public UpdateAccount phone(String phone) {
    this.phone = phone;
    return this;
  }

   /**
   * The primary phone number of the user associated with this account. Provide the phone number as a string.
   * @return phone
  **/
  @ApiModelProperty(value = "The primary phone number of the user associated with this account. Provide the phone number as a string.")
  public String getPhone() {
    return phone;
  }

  public void setPhone(String phone) {
    this.phone = phone;
  }

  public UpdateAccount age(String age) {
    this.age = age;
    return this;
  }

   /**
   * Age of the user e.g. \&quot;25\&quot;
   * @return age
  **/
  @ApiModelProperty(value = "Age of the user e.g. \"25\"")
  public String getAge() {
    return age;
  }

  public void setAge(String age) {
    this.age = age;
  }

  public UpdateAccount gender(String gender) {
    this.gender = gender;
    return this;
  }

   /**
   * Gender of the user e.g. \&quot;_male\&quot;, \&quot;_female\&quot; or \&quot;_trans\&quot;
   * @return gender
  **/
  @ApiModelProperty(value = "Gender of the user e.g. \"_male\", \"_female\" or \"_trans\"")
  public String getGender() {
    return gender;
  }

  public void setGender(String gender) {
    this.gender = gender;
  }

  public UpdateAccount referralCode(String referralCode) {
    this.referralCode = referralCode;
    return this;
  }

   /**
   * Code or promotion used by the user while creating account.
   * @return referralCode
  **/
  @ApiModelProperty(value = "Code or promotion used by the user while creating account.")
  public String getReferralCode() {
    return referralCode;
  }

  public void setReferralCode(String referralCode) {
    this.referralCode = referralCode;
  }

  public UpdateAccount referrerUserId(String referrerUserId) {
    this.referrerUserId = referrerUserId;
    return this;
  }

   /**
   * The ID of the user that referred the current user to your business. This field is required for detecting referral fraud.
   * @return referrerUserId
  **/
  @ApiModelProperty(value = "The ID of the user that referred the current user to your business. This field is required for detecting referral fraud.")
  public String getReferrerUserId() {
    return referrerUserId;
  }

  public void setReferrerUserId(String referrerUserId) {
    this.referrerUserId = referrerUserId;
  }

  public UpdateAccount billingAddress(BillingAddress billingAddress) {
    this.billingAddress = billingAddress;
    return this;
  }

   /**
   * Get billingAddress
   * @return billingAddress
  **/
  @ApiModelProperty(value = "")
  public BillingAddress getBillingAddress() {
    return billingAddress;
  }

  public void setBillingAddress(BillingAddress billingAddress) {
    this.billingAddress = billingAddress;
  }

  public UpdateAccount shippingAddress(ShippingAddress shippingAddress) {
    this.shippingAddress = shippingAddress;
    return this;
  }

   /**
   * Get shippingAddress
   * @return shippingAddress
  **/
  @ApiModelProperty(value = "")
  public ShippingAddress getShippingAddress() {
    return shippingAddress;
  }

  public void setShippingAddress(ShippingAddress shippingAddress) {
    this.shippingAddress = shippingAddress;
  }

  public UpdateAccount paymentMethods(List<PaymentMethod> paymentMethods) {
    this.paymentMethods = paymentMethods;
    return this;
  }

  public UpdateAccount addPaymentMethodsItem(PaymentMethod paymentMethodsItem) {
    if (this.paymentMethods == null) {
      this.paymentMethods = new ArrayList<PaymentMethod>();
    }
    this.paymentMethods.add(paymentMethodsItem);
    return this;
  }

   /**
   * The payment information associated with this account. Represented as an array of nested payment_method objects containing payment type, payment gateway, credit card bin, etc.
   * @return paymentMethods
  **/
  @ApiModelProperty(value = "The payment information associated with this account. Represented as an array of nested payment_method objects containing payment type, payment gateway, credit card bin, etc.")
  public List<PaymentMethod> getPaymentMethods() {
    return paymentMethods;
  }

  public void setPaymentMethods(List<PaymentMethod> paymentMethods) {
    this.paymentMethods = paymentMethods;
  }

  public UpdateAccount promotions(List<Promotion> promotions) {
    this.promotions = promotions;
    return this;
  }

  public UpdateAccount addPromotionsItem(Promotion promotionsItem) {
    if (this.promotions == null) {
      this.promotions = new ArrayList<Promotion>();
    }
    this.promotions.add(promotionsItem);
    return this;
  }

   /**
   * The list of promotions that apply to this account. You can add one or more promotions when creating or updating an order. Represented as a JSON array of promotion objects. You can also separately add promotions to the account via the addPromotion event.
   * @return promotions
  **/
  @ApiModelProperty(value = "The list of promotions that apply to this account. You can add one or more promotions when creating or updating an order. Represented as a JSON array of promotion objects. You can also separately add promotions to the account via the addPromotion event.")
  public List<Promotion> getPromotions() {
    return promotions;
  }

  public void setPromotions(List<Promotion> promotions) {
    this.promotions = promotions;
  }

  public UpdateAccount socialSignOnType(String socialSignOnType) {
    this.socialSignOnType = socialSignOnType;
    return this;
  }

   /**
   * If the user logged in with a social identify provider, give the name here. e.g. _google, _facebook, _twitter, _linkedin, _other
   * @return socialSignOnType
  **/
  @ApiModelProperty(value = "If the user logged in with a social identify provider, give the name here. e.g. _google, _facebook, _twitter, _linkedin, _other")
  public String getSocialSignOnType() {
    return socialSignOnType;
  }

  public void setSocialSignOnType(String socialSignOnType) {
    this.socialSignOnType = socialSignOnType;
  }

  public UpdateAccount emailConfirmedStatus(String emailConfirmedStatus) {
    this.emailConfirmedStatus = emailConfirmedStatus;
    return this;
  }

   /**
   * Status of email verification. e.g. _success, _failure, _pending
   * @return emailConfirmedStatus
  **/
  @ApiModelProperty(value = "Status of email verification. e.g. _success, _failure, _pending")
  public String getEmailConfirmedStatus() {
    return emailConfirmedStatus;
  }

  public void setEmailConfirmedStatus(String emailConfirmedStatus) {
    this.emailConfirmedStatus = emailConfirmedStatus;
  }

  public UpdateAccount phoneConfirmedStatus(String phoneConfirmedStatus) {
    this.phoneConfirmedStatus = phoneConfirmedStatus;
    return this;
  }

   /**
   * Status of phone verification. e.g. _success, _failure, _pending
   * @return phoneConfirmedStatus
  **/
  @ApiModelProperty(value = "Status of phone verification. e.g. _success, _failure, _pending")
  public String getPhoneConfirmedStatus() {
    return phoneConfirmedStatus;
  }

  public void setPhoneConfirmedStatus(String phoneConfirmedStatus) {
    this.phoneConfirmedStatus = phoneConfirmedStatus;
  }

  public UpdateAccount isNewsletterSubscribed(Boolean isNewsletterSubscribed) {
    this.isNewsletterSubscribed = isNewsletterSubscribed;
    return this;
  }

   /**
   * Is user subscribed for newsletter. e.g. true, false
   * @return isNewsletterSubscribed
  **/
  @ApiModelProperty(value = "Is user subscribed for newsletter. e.g. true, false")
  public Boolean getIsNewsletterSubscribed() {
    return isNewsletterSubscribed;
  }

  public void setIsNewsletterSubscribed(Boolean isNewsletterSubscribed) {
    this.isNewsletterSubscribed = isNewsletterSubscribed;
  }

  public UpdateAccount accountStatus(String accountStatus) {
    this.accountStatus = accountStatus;
    return this;
  }

   /**
   * Current status of account, e.g. _active, _inactive
   * @return accountStatus
  **/
  @ApiModelProperty(value = "Current status of account, e.g. _active, _inactive")
  public String getAccountStatus() {
    return accountStatus;
  }

  public void setAccountStatus(String accountStatus) {
    this.accountStatus = accountStatus;
  }

  public UpdateAccount facebookId(String facebookId) {
    this.facebookId = facebookId;
    return this;
  }

   /**
   * Facebook user id or token of the user. This can help to varify his social identity.
   * @return facebookId
  **/
  @ApiModelProperty(value = "Facebook user id or token of the user. This can help to varify his social identity.")
  public String getFacebookId() {
    return facebookId;
  }

  public void setFacebookId(String facebookId) {
    this.facebookId = facebookId;
  }

  public UpdateAccount googleId(String googleId) {
    this.googleId = googleId;
    return this;
  }

   /**
   * Google user id or token of the user. This can help to varify his social identity.
   * @return googleId
  **/
  @ApiModelProperty(value = "Google user id or token of the user. This can help to varify his social identity.")
  public String getGoogleId() {
    return googleId;
  }

  public void setGoogleId(String googleId) {
    this.googleId = googleId;
  }

  public UpdateAccount twitterId(String twitterId) {
    this.twitterId = twitterId;
    return this;
  }

   /**
   * Twitter handle or token of the user. This can help to varify his social identity.
   * @return twitterId
  **/
  @ApiModelProperty(value = "Twitter handle or token of the user. This can help to varify his social identity.")
  public String getTwitterId() {
    return twitterId;
  }

  public void setTwitterId(String twitterId) {
    this.twitterId = twitterId;
  }

  public UpdateAccount customInfo(CustomInfo customInfo) {
    this.customInfo = customInfo;
    return this;
  }

   /**
   * Get customInfo
   * @return customInfo
  **/
  @ApiModelProperty(value = "")
  public CustomInfo getCustomInfo() {
    return customInfo;
  }

  public void setCustomInfo(CustomInfo customInfo) {
    this.customInfo = customInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateAccount updateAccount = (UpdateAccount) o;
    return Objects.equals(this.userId, updateAccount.userId) &&
        Objects.equals(this.sessionId, updateAccount.sessionId) &&
        Objects.equals(this.deviceIp, updateAccount.deviceIp) &&
        Objects.equals(this.originTimestamp, updateAccount.originTimestamp) &&
        Objects.equals(this.userEmail, updateAccount.userEmail) &&
        Objects.equals(this.firstName, updateAccount.firstName) &&
        Objects.equals(this.lastName, updateAccount.lastName) &&
        Objects.equals(this.phone, updateAccount.phone) &&
        Objects.equals(this.age, updateAccount.age) &&
        Objects.equals(this.gender, updateAccount.gender) &&
        Objects.equals(this.referralCode, updateAccount.referralCode) &&
        Objects.equals(this.referrerUserId, updateAccount.referrerUserId) &&
        Objects.equals(this.billingAddress, updateAccount.billingAddress) &&
        Objects.equals(this.shippingAddress, updateAccount.shippingAddress) &&
        Objects.equals(this.paymentMethods, updateAccount.paymentMethods) &&
        Objects.equals(this.promotions, updateAccount.promotions) &&
        Objects.equals(this.socialSignOnType, updateAccount.socialSignOnType) &&
        Objects.equals(this.emailConfirmedStatus, updateAccount.emailConfirmedStatus) &&
        Objects.equals(this.phoneConfirmedStatus, updateAccount.phoneConfirmedStatus) &&
        Objects.equals(this.isNewsletterSubscribed, updateAccount.isNewsletterSubscribed) &&
        Objects.equals(this.accountStatus, updateAccount.accountStatus) &&
        Objects.equals(this.facebookId, updateAccount.facebookId) &&
        Objects.equals(this.googleId, updateAccount.googleId) &&
        Objects.equals(this.twitterId, updateAccount.twitterId) &&
        Objects.equals(this.customInfo, updateAccount.customInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, sessionId, deviceIp, originTimestamp, userEmail, firstName, lastName, phone, age, gender, referralCode, referrerUserId, billingAddress, shippingAddress, paymentMethods, promotions, socialSignOnType, emailConfirmedStatus, phoneConfirmedStatus, isNewsletterSubscribed, accountStatus, facebookId, googleId, twitterId, customInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateAccount {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    sessionId: ").append(toIndentedString(sessionId)).append("\n");
    sb.append("    deviceIp: ").append(toIndentedString(deviceIp)).append("\n");
    sb.append("    originTimestamp: ").append(toIndentedString(originTimestamp)).append("\n");
    sb.append("    userEmail: ").append(toIndentedString(userEmail)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    age: ").append(toIndentedString(age)).append("\n");
    sb.append("    gender: ").append(toIndentedString(gender)).append("\n");
    sb.append("    referralCode: ").append(toIndentedString(referralCode)).append("\n");
    sb.append("    referrerUserId: ").append(toIndentedString(referrerUserId)).append("\n");
    sb.append("    billingAddress: ").append(toIndentedString(billingAddress)).append("\n");
    sb.append("    shippingAddress: ").append(toIndentedString(shippingAddress)).append("\n");
    sb.append("    paymentMethods: ").append(toIndentedString(paymentMethods)).append("\n");
    sb.append("    promotions: ").append(toIndentedString(promotions)).append("\n");
    sb.append("    socialSignOnType: ").append(toIndentedString(socialSignOnType)).append("\n");
    sb.append("    emailConfirmedStatus: ").append(toIndentedString(emailConfirmedStatus)).append("\n");
    sb.append("    phoneConfirmedStatus: ").append(toIndentedString(phoneConfirmedStatus)).append("\n");
    sb.append("    isNewsletterSubscribed: ").append(toIndentedString(isNewsletterSubscribed)).append("\n");
    sb.append("    accountStatus: ").append(toIndentedString(accountStatus)).append("\n");
    sb.append("    facebookId: ").append(toIndentedString(facebookId)).append("\n");
    sb.append("    googleId: ").append(toIndentedString(googleId)).append("\n");
    sb.append("    twitterId: ").append(toIndentedString(twitterId)).append("\n");
    sb.append("    customInfo: ").append(toIndentedString(customInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

