/*
 * Thirdwatch API
 * The first version of the Thirdwatch API is an exciting step forward towards making it easier for developers to pass data to Thirdwatch.  Once you've [registered your website/app](https://thirdwatch.ai) it's easy to start sending data to Thirdwatch.  All endpoints are only accessible via https and are located at `api.thirdwatch.ai`. For instance: you can send event at the moment by ```HTTP POST``` Request to the following URL with your API key in ```Header``` and ```JSON``` data in request body. ```   https://api.thirdwatch.ai/event/v1 ``` Every API request must contain ```API Key``` in header value ```X-THIRDWATCH-API-KEY```  Every event must contain your ```_userId``` (if this is not available, you can alternatively provide a ```_sessionId``` value also in ```_userId```).  JavaScript Fingerprinting module for capturing unique devices and tracking user interaction.  This script will identify unique devices with respect to the browser. For e.g., if chrome is opened in normal mode a unique device id is generated and this will be same if chrome is opened in incognito mode or reinstalled.  Paste the below script onto your webpage, just after the opening `<body>` tag. This script should be added to the page which is accessed externally by the user of your website. For e.g., If you want to track three different webpages then paste the below script onto each webpage, just after the opening `<body>` tag. This script should not be added onto internal tools or admin panels. ```   &lt;script id=\"thirdwatch\"     data-session-cookie-name=\"&lt;cookie_name&gt;\"     data-session-id-value=\"&lt;session_id&gt;\"     data-user-id=\"&lt;user_id&gt;\"     data-app-secret=\"&lt;app_secret&gt;\"     data-is-track-pageview=\"true\"&gt; (function() {         var loadDeviceJs = function() {         var element = document.createElement(\"script\");         element.async = 1;         element.src = \"https://cdn.thirdwatch.ai/tw.min.js\";         document.body.appendChild(element);         };         if (window.addEventListener) {              window.addEventListener(\"load\", loadDeviceJs, false);         } else if (window.attachEvent) {         window.attachEvent(\"onload\", loadDeviceJs);         }     })();   &lt;/script&gt; ``` * `data-session-cookie-name` -- The cookie name where you are saving the unique session id. We will pick the session id by reading its value from the cookie name. (Optional) * `data-session-id-value` -- In case you are not passing `data-session-cookie-name` than you can put session id directly in this parameter. In absence of both `data-session-cookie-name` and `data-session-id-value`, our system will generate a session Id. (Optional) * `data-user-id` -- Unique user id at your end. This can be email id or primary key in the database. In case of guest user, you can insert session Id here. * `data-app-secret` -- Unique App secret generated for you by Thirdwatch. * `data-is-track-pageview` -- If this is set to true, then the url on which this script is running will be sent to Thirdwatch, else the url will not be captured.   The Score API is use to get an up to date cutomer trust score after you have sent transaction event and order successful. This API will provide the riskiness score of the order with reasons. Some examples of when you may want to check the score are before:    - Before Shippement of a package   - Finalizing a money transfer   - Giving access to a prearranged vacation rental   - Sending voucher on mail  ```   https://api.thirdwatch.ai/neo/v1/score?api_key=<your api key>&order_id=<Order id> ```  According to Score you can decide to take action Approve or Reject. Orders with score more than 70 will consider as Riskey orders. We'll provide some reasons also in rules section.   ``` {   \"order_id\": \"OCT45671\",   \"user_id\": \"ajay_245\",   \"order_timestamp\": \"2017-05-09T09:40:45.717Z\",   \"score\": 82,   \"flag\": \"red\",     -\"reasons\": [     {         \"name\": \"_numOfFailedTransactions\",         \"display_name\": \"Number of failed transactions\",         \"flag\": \"green\",         \"value\": \"0\",         \"is_display\": true       },       {         \"name\": \"_accountAge\",         \"display_name\": \"Account age\",         \"flag\": \"red\",         \"value\": \"0\",         \"is_display\": true       },       {         \"name\": \"_numOfOrderSameIp\",         \"display_name\": \"Number of orders from same IP\",         \"flag\": \"red\",         \"value\": \"11\",         \"is_display\": true       }     ] } ``` 
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package ai.thirdwatch.model;

import java.util.Objects;
import ai.thirdwatch.model.Seller;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * The Item field type represents a product or service for sale in your business. The value must be a nested object with the appropriate item subfields. Generally used in the add_to_cart and remove_from_cart events. 
 */
@ApiModel(description = "The Item field type represents a product or service for sale in your business. The value must be a nested object with the appropriate item subfields. Generally used in the add_to_cart and remove_from_cart events. ")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-11-21T16:23:00.366+05:30")
public class Item {
  @SerializedName("_itemId")
  private String itemId = null;

  @SerializedName("_productTitle")
  private String productTitle = null;

  @SerializedName("_price")
  private String price = null;

  @SerializedName("_currencyCode")
  private String currencyCode = null;

  @SerializedName("_upc")
  private String upc = null;

  @SerializedName("_sku")
  private String sku = null;

  @SerializedName("_isbn")
  private String isbn = null;

  @SerializedName("_brand")
  private String brand = null;

  @SerializedName("_manufacturer")
  private String manufacturer = null;

  @SerializedName("_category")
  private String category = null;

  @SerializedName("_tags")
  private String tags = null;

  @SerializedName("_color")
  private String color = null;

  @SerializedName("_quantity")
  private Long quantity = null;

  @SerializedName("_isOnSale")
  private Boolean isOnSale = null;

  @SerializedName("_maxQuantity")
  private Long maxQuantity = null;

  @SerializedName("_discountPrice")
  private String discountPrice = null;

  @SerializedName("_productWeight")
  private String productWeight = null;

  @SerializedName("_country")
  private String country = null;

  @SerializedName("_descriptionShort")
  private String descriptionShort = null;

  @SerializedName("_description")
  private String description = null;

  @SerializedName("_seller")
  private Seller seller = null;

  public Item itemId(String itemId) {
    this.itemId = itemId;
    return this;
  }

   /**
   * The item&#39;s unique identifier according to your systems. Use the same ID that you would use to look up items on your website&#39;s database.
   * @return itemId
  **/
  @ApiModelProperty(value = "The item's unique identifier according to your systems. Use the same ID that you would use to look up items on your website's database.")
  public String getItemId() {
    return itemId;
  }

  public void setItemId(String itemId) {
    this.itemId = itemId;
  }

  public Item productTitle(String productTitle) {
    this.productTitle = productTitle;
    return this;
  }

   /**
   * The item&#39;s name, e.g., \&quot;WD 2 TB External Hard Drive\&quot;.
   * @return productTitle
  **/
  @ApiModelProperty(value = "The item's name, e.g., \"WD 2 TB External Hard Drive\".")
  public String getProductTitle() {
    return productTitle;
  }

  public void setProductTitle(String productTitle) {
    this.productTitle = productTitle;
  }

  public Item price(String price) {
    this.price = price;
    return this;
  }

   /**
   * The item unit price in numbers, in the base unit of the currency_code.e.g. \&quot;2500\&quot;
   * @return price
  **/
  @ApiModelProperty(value = "The item unit price in numbers, in the base unit of the currency_code.e.g. \"2500\"")
  public String getPrice() {
    return price;
  }

  public void setPrice(String price) {
    this.price = price;
  }

  public Item currencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * The [ISO-4217](http://en.wikipedia.org/wiki/ISO_4217) currency code for the amount. e.g., USD, INR alternative currencies, like bitcoin or points systems.
   * @return currencyCode
  **/
  @ApiModelProperty(value = "The [ISO-4217](http://en.wikipedia.org/wiki/ISO_4217) currency code for the amount. e.g., USD, INR alternative currencies, like bitcoin or points systems.")
  public String getCurrencyCode() {
    return currencyCode;
  }

  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }

  public Item upc(String upc) {
    this.upc = upc;
    return this;
  }

   /**
   * If the item has a Universal Product Code (UPC), provide it here.
   * @return upc
  **/
  @ApiModelProperty(value = "If the item has a Universal Product Code (UPC), provide it here.")
  public String getUpc() {
    return upc;
  }

  public void setUpc(String upc) {
    this.upc = upc;
  }

  public Item sku(String sku) {
    this.sku = sku;
    return this;
  }

   /**
   * If the item has a Stock-keeping Unit ID (SKU), provide it here.
   * @return sku
  **/
  @ApiModelProperty(value = "If the item has a Stock-keeping Unit ID (SKU), provide it here.")
  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public Item isbn(String isbn) {
    this.isbn = isbn;
    return this;
  }

   /**
   * If the item is a book with an International Standard Book Number (ISBN), provide it here.
   * @return isbn
  **/
  @ApiModelProperty(value = "If the item is a book with an International Standard Book Number (ISBN), provide it here.")
  public String getIsbn() {
    return isbn;
  }

  public void setIsbn(String isbn) {
    this.isbn = isbn;
  }

  public Item brand(String brand) {
    this.brand = brand;
    return this;
  }

   /**
   * The brand name of the item.
   * @return brand
  **/
  @ApiModelProperty(value = "The brand name of the item.")
  public String getBrand() {
    return brand;
  }

  public void setBrand(String brand) {
    this.brand = brand;
  }

  public Item manufacturer(String manufacturer) {
    this.manufacturer = manufacturer;
    return this;
  }

   /**
   * Name of the item&#39;s manufacturer.
   * @return manufacturer
  **/
  @ApiModelProperty(value = "Name of the item's manufacturer.")
  public String getManufacturer() {
    return manufacturer;
  }

  public void setManufacturer(String manufacturer) {
    this.manufacturer = manufacturer;
  }

  public Item category(String category) {
    this.category = category;
    return this;
  }

   /**
   * The category this item is listed under in your business. e.g., \&quot;travel\&quot;, \&quot;man &gt; bags\&quot;.
   * @return category
  **/
  @ApiModelProperty(value = "The category this item is listed under in your business. e.g., \"travel\", \"man > bags\".")
  public String getCategory() {
    return category;
  }

  public void setCategory(String category) {
    this.category = category;
  }

  public Item tags(String tags) {
    this.tags = tags;
    return this;
  }

   /**
   * The tags used to describe this item in your business. e.g., \&quot;man\&quot;, \&quot;summer\&quot;.
   * @return tags
  **/
  @ApiModelProperty(value = "The tags used to describe this item in your business. e.g., \"man\", \"summer\".")
  public String getTags() {
    return tags;
  }

  public void setTags(String tags) {
    this.tags = tags;
  }

  public Item color(String color) {
    this.color = color;
    return this;
  }

   /**
   * The color of the item.
   * @return color
  **/
  @ApiModelProperty(value = "The color of the item.")
  public String getColor() {
    return color;
  }

  public void setColor(String color) {
    this.color = color;
  }

  public Item quantity(Long quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * The quantity of the item.
   * @return quantity
  **/
  @ApiModelProperty(value = "The quantity of the item.")
  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public Item isOnSale(Boolean isOnSale) {
    this.isOnSale = isOnSale;
    return this;
  }

   /**
   * Is item on sale or running offers on this item .
   * @return isOnSale
  **/
  @ApiModelProperty(value = "Is item on sale or running offers on this item .")
  public Boolean getIsOnSale() {
    return isOnSale;
  }

  public void setIsOnSale(Boolean isOnSale) {
    this.isOnSale = isOnSale;
  }

  public Item maxQuantity(Long maxQuantity) {
    this.maxQuantity = maxQuantity;
    return this;
  }

   /**
   * The max quantity per user for this item.
   * @return maxQuantity
  **/
  @ApiModelProperty(value = "The max quantity per user for this item.")
  public Long getMaxQuantity() {
    return maxQuantity;
  }

  public void setMaxQuantity(Long maxQuantity) {
    this.maxQuantity = maxQuantity;
  }

  public Item discountPrice(String discountPrice) {
    this.discountPrice = discountPrice;
    return this;
  }

   /**
   * Price of the product after discount.
   * @return discountPrice
  **/
  @ApiModelProperty(value = "Price of the product after discount.")
  public String getDiscountPrice() {
    return discountPrice;
  }

  public void setDiscountPrice(String discountPrice) {
    this.discountPrice = discountPrice;
  }

  public Item productWeight(String productWeight) {
    this.productWeight = productWeight;
    return this;
  }

   /**
   * Weight of the product in Kilo Gram, e.g. \&quot;3\&quot; , \&quot;0.5\&quot;
   * @return productWeight
  **/
  @ApiModelProperty(value = "Weight of the product in Kilo Gram, e.g. \"3\" , \"0.5\"")
  public String getProductWeight() {
    return productWeight;
  }

  public void setProductWeight(String productWeight) {
    this.productWeight = productWeight;
  }

  public Item country(String country) {
    this.country = country;
    return this;
  }

   /**
   * The [ISO-3166](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the item, e.g., \&quot;IN\&quot; in case of India.
   * @return country
  **/
  @ApiModelProperty(value = "The [ISO-3166](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the item, e.g., \"IN\" in case of India.")
  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public Item descriptionShort(String descriptionShort) {
    this.descriptionShort = descriptionShort;
    return this;
  }

   /**
   * Short description of the item.
   * @return descriptionShort
  **/
  @ApiModelProperty(value = "Short description of the item.")
  public String getDescriptionShort() {
    return descriptionShort;
  }

  public void setDescriptionShort(String descriptionShort) {
    this.descriptionShort = descriptionShort;
  }

  public Item description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Detail description of the item.
   * @return description
  **/
  @ApiModelProperty(value = "Detail description of the item.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Item seller(Seller seller) {
    this.seller = seller;
    return this;
  }

   /**
   * Get seller
   * @return seller
  **/
  @ApiModelProperty(value = "")
  public Seller getSeller() {
    return seller;
  }

  public void setSeller(Seller seller) {
    this.seller = seller;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Item item = (Item) o;
    return Objects.equals(this.itemId, item.itemId) &&
        Objects.equals(this.productTitle, item.productTitle) &&
        Objects.equals(this.price, item.price) &&
        Objects.equals(this.currencyCode, item.currencyCode) &&
        Objects.equals(this.upc, item.upc) &&
        Objects.equals(this.sku, item.sku) &&
        Objects.equals(this.isbn, item.isbn) &&
        Objects.equals(this.brand, item.brand) &&
        Objects.equals(this.manufacturer, item.manufacturer) &&
        Objects.equals(this.category, item.category) &&
        Objects.equals(this.tags, item.tags) &&
        Objects.equals(this.color, item.color) &&
        Objects.equals(this.quantity, item.quantity) &&
        Objects.equals(this.isOnSale, item.isOnSale) &&
        Objects.equals(this.maxQuantity, item.maxQuantity) &&
        Objects.equals(this.discountPrice, item.discountPrice) &&
        Objects.equals(this.productWeight, item.productWeight) &&
        Objects.equals(this.country, item.country) &&
        Objects.equals(this.descriptionShort, item.descriptionShort) &&
        Objects.equals(this.description, item.description) &&
        Objects.equals(this.seller, item.seller);
  }

  @Override
  public int hashCode() {
    return Objects.hash(itemId, productTitle, price, currencyCode, upc, sku, isbn, brand, manufacturer, category, tags, color, quantity, isOnSale, maxQuantity, discountPrice, productWeight, country, descriptionShort, description, seller);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Item {\n");
    
    sb.append("    itemId: ").append(toIndentedString(itemId)).append("\n");
    sb.append("    productTitle: ").append(toIndentedString(productTitle)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    upc: ").append(toIndentedString(upc)).append("\n");
    sb.append("    sku: ").append(toIndentedString(sku)).append("\n");
    sb.append("    isbn: ").append(toIndentedString(isbn)).append("\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    manufacturer: ").append(toIndentedString(manufacturer)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    isOnSale: ").append(toIndentedString(isOnSale)).append("\n");
    sb.append("    maxQuantity: ").append(toIndentedString(maxQuantity)).append("\n");
    sb.append("    discountPrice: ").append(toIndentedString(discountPrice)).append("\n");
    sb.append("    productWeight: ").append(toIndentedString(productWeight)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    descriptionShort: ").append(toIndentedString(descriptionShort)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    seller: ").append(toIndentedString(seller)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

