/*
 * Thirdwatch API
 * The first version of the Thirdwatch API is an exciting step forward towards making it easier for developers to pass data to Thirdwatch.  Once you've [registered your website/app](https://thirdwatch.ai) it's easy to start sending data to Thirdwatch.  All endpoints are only accessible via https and are located at `api.thirdwatch.ai`. For instance: you can send event at the moment by ```HTTP POST``` Request to the following URL with your API key in ```Header``` and ```JSON``` data in request body. ```   https://api.thirdwatch.ai/event/v1 ``` Every API request must contain ```API Key``` in header value ```X-THIRDWATCH-API-KEY```  Every event must contain your ```_userId``` (if this is not available, you can alternatively provide a ```_sessionId``` value also in ```_userId```).  JavaScript Fingerprinting module for capturing unique devices and tracking user interaction.  This script will identify unique devices with respect to the browser. For e.g., if chrome is opened in normal mode a unique device id is generated and this will be same if chrome is opened in incognito mode or reinstalled.  Paste the below script onto your webpage, just after the opening `<body>` tag. This script should be added to the page which is accessed externally by the user of your website. For e.g., If you want to track three different webpages then paste the below script onto each webpage, just after the opening `<body>` tag. This script should not be added onto internal tools or admin panels. ```   &lt;script id=\"thirdwatch\"     data-session-cookie-name=\"&lt;cookie_name&gt;\"     data-session-id-value=\"&lt;session_id&gt;\"     data-user-id=\"&lt;user_id&gt;\"     data-app-secret=\"&lt;app_secret&gt;\"     data-is-track-pageview=\"true\"&gt; (function() {         var loadDeviceJs = function() {         var element = document.createElement(\"script\");         element.async = 1;         element.src = \"https://cdn.thirdwatch.ai/tw.min.js\";         document.body.appendChild(element);         };         if (window.addEventListener) {              window.addEventListener(\"load\", loadDeviceJs, false);         } else if (window.attachEvent) {         window.attachEvent(\"onload\", loadDeviceJs);         }     })();   &lt;/script&gt; ``` * `data-session-cookie-name` -- The cookie name where you are saving the unique session id. We will pick the session id by reading its value from the cookie name. (Optional) * `data-session-id-value` -- In case you are not passing `data-session-cookie-name` than you can put session id directly in this parameter. In absence of both `data-session-cookie-name` and `data-session-id-value`, our system will generate a session Id. (Optional) * `data-user-id` -- Unique user id at your end. This can be email id or primary key in the database. In case of guest user, you can insert session Id here. * `data-app-secret` -- Unique App secret generated for you by Thirdwatch. * `data-is-track-pageview` -- If this is set to true, then the url on which this script is running will be sent to Thirdwatch, else the url will not be captured.   The Score API is use to get an up to date cutomer trust score after you have sent transaction event and order successful. This API will provide the riskiness score of the order with reasons. Some examples of when you may want to check the score are before:    - Before Shippement of a package   - Finalizing a money transfer   - Giving access to a prearranged vacation rental   - Sending voucher on mail  ```   https://api.thirdwatch.ai/neo/v1/score?api_key=<your api key>&order_id=<Order id> ```  According to Score you can decide to take action Approve or Reject. Orders with score more than 70 will consider as Riskey orders. We'll provide some reasons also in rules section.   ``` {   \"order_id\": \"OCT45671\",   \"user_id\": \"ajay_245\",   \"order_timestamp\": \"2017-05-09T09:40:45.717Z\",   \"score\": 82,   \"flag\": \"red\",     -\"reasons\": [     {         \"name\": \"_numOfFailedTransactions\",         \"display_name\": \"Number of failed transactions\",         \"flag\": \"green\",         \"value\": \"0\",         \"is_display\": true       },       {         \"name\": \"_accountAge\",         \"display_name\": \"Account age\",         \"flag\": \"red\",         \"value\": \"0\",         \"is_display\": true       },       {         \"name\": \"_numOfOrderSameIp\",         \"display_name\": \"Number of orders from same IP\",         \"flag\": \"red\",         \"value\": \"11\",         \"is_display\": true       }     ] } ``` 
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package ai.thirdwatch.model;

import java.util.Objects;
import ai.thirdwatch.model.CustomInfo;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * OrderStatus
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-11-21T16:23:00.366+05:30")
public class OrderStatus {
  @SerializedName("_userId")
  private String userId = null;

  @SerializedName("_sessionId")
  private String sessionId = null;

  @SerializedName("_orderId")
  private String orderId = null;

  @SerializedName("_orderStatus")
  private String orderStatus = null;

  @SerializedName("_reason")
  private String reason = null;

  @SerializedName("_shippingCost")
  private String shippingCost = null;

  @SerializedName("_trackingNumber")
  private String trackingNumber = null;

  @SerializedName("_trackingMethod")
  private String trackingMethod = null;

  @SerializedName("_source")
  private String source = null;

  @SerializedName("_analyst")
  private String analyst = null;

  @SerializedName("_description")
  private String description = null;

  @SerializedName("_customInfo")
  private CustomInfo customInfo = null;

  public OrderStatus userId(String userId) {
    this.userId = userId;
    return this;
  }

   /**
   * The user&#39;s account ID according to your systems. Note that user IDs are case sensitive.
   * @return userId
  **/
  @ApiModelProperty(value = "The user's account ID according to your systems. Note that user IDs are case sensitive.")
  public String getUserId() {
    return userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  public OrderStatus sessionId(String sessionId) {
    this.sessionId = sessionId;
    return this;
  }

   /**
   * The user&#39;s current session ID, used to tie a user&#39;s action before and after login or account creation. Required if no user_id values is provided.
   * @return sessionId
  **/
  @ApiModelProperty(value = "The user's current session ID, used to tie a user's action before and after login or account creation. Required if no user_id values is provided.")
  public String getSessionId() {
    return sessionId;
  }

  public void setSessionId(String sessionId) {
    this.sessionId = sessionId;
  }

  public OrderStatus orderId(String orderId) {
    this.orderId = orderId;
    return this;
  }

   /**
   * The ID for the order that this chargeback is filed against. This field is not required if this chargeback was filed against a transaction with no _orderId.
   * @return orderId
  **/
  @ApiModelProperty(value = "The ID for the order that this chargeback is filed against. This field is not required if this chargeback was filed against a transaction with no _orderId.")
  public String getOrderId() {
    return orderId;
  }

  public void setOrderId(String orderId) {
    this.orderId = orderId;
  }

  public OrderStatus orderStatus(String orderStatus) {
    this.orderStatus = orderStatus;
    return this;
  }

   /**
   * Indicates the high-level state of the order. e.g. _approved, _canceled, _held, _fulfilled, _returned, _rto
   * @return orderStatus
  **/
  @ApiModelProperty(value = "Indicates the high-level state of the order. e.g. _approved, _canceled, _held, _fulfilled, _returned, _rto")
  public String getOrderStatus() {
    return orderStatus;
  }

  public void setOrderStatus(String orderStatus) {
    this.orderStatus = orderStatus;
  }

  public OrderStatus reason(String reason) {
    this.reason = reason;
    return this;
  }

   /**
   * The reason for a cancellation. e.g. _paymentRisk, _abuse, _policy, _other
   * @return reason
  **/
  @ApiModelProperty(value = "The reason for a cancellation. e.g. _paymentRisk, _abuse, _policy, _other")
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  public OrderStatus shippingCost(String shippingCost) {
    this.shippingCost = shippingCost;
    return this;
  }

   /**
   * if _approved or _fulfilled than pass the shipping cost. e.g. \&quot;50\&quot;
   * @return shippingCost
  **/
  @ApiModelProperty(value = "if _approved or _fulfilled than pass the shipping cost. e.g. \"50\"")
  public String getShippingCost() {
    return shippingCost;
  }

  public void setShippingCost(String shippingCost) {
    this.shippingCost = shippingCost;
  }

  public OrderStatus trackingNumber(String trackingNumber) {
    this.trackingNumber = trackingNumber;
    return this;
  }

   /**
   * if _approved or _fulfilled than pass the tracking number. e.g. \&quot;55327470\&quot;
   * @return trackingNumber
  **/
  @ApiModelProperty(value = "if _approved or _fulfilled than pass the tracking number. e.g. \"55327470\"")
  public String getTrackingNumber() {
    return trackingNumber;
  }

  public void setTrackingNumber(String trackingNumber) {
    this.trackingNumber = trackingNumber;
  }

  public OrderStatus trackingMethod(String trackingMethod) {
    this.trackingMethod = trackingMethod;
    return this;
  }

   /**
   * if _approved or _fulfilled than pass the tracking url. e.g. \&quot;http://fedex.com/track?q&#x3D;abc123\&quot;
   * @return trackingMethod
  **/
  @ApiModelProperty(value = "if _approved or _fulfilled than pass the tracking url. e.g. \"http://fedex.com/track?q=abc123\"")
  public String getTrackingMethod() {
    return trackingMethod;
  }

  public void setTrackingMethod(String trackingMethod) {
    this.trackingMethod = trackingMethod;
  }

  public OrderStatus source(String source) {
    this.source = source;
    return this;
  }

   /**
   * The source of a decision. e.g. _automated, _manualReview\&quot;
   * @return source
  **/
  @ApiModelProperty(value = "The source of a decision. e.g. _automated, _manualReview\"")
  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  public OrderStatus analyst(String analyst) {
    this.analyst = analyst;
    return this;
  }

   /**
   * The analyst who made the decision, if manual.
   * @return analyst
  **/
  @ApiModelProperty(value = "The analyst who made the decision, if manual.")
  public String getAnalyst() {
    return analyst;
  }

  public void setAnalyst(String analyst) {
    this.analyst = analyst;
  }

  public OrderStatus description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Any additional information about this order status change.
   * @return description
  **/
  @ApiModelProperty(value = "Any additional information about this order status change.")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public OrderStatus customInfo(CustomInfo customInfo) {
    this.customInfo = customInfo;
    return this;
  }

   /**
   * Get customInfo
   * @return customInfo
  **/
  @ApiModelProperty(value = "")
  public CustomInfo getCustomInfo() {
    return customInfo;
  }

  public void setCustomInfo(CustomInfo customInfo) {
    this.customInfo = customInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OrderStatus orderStatus = (OrderStatus) o;
    return Objects.equals(this.userId, orderStatus.userId) &&
        Objects.equals(this.sessionId, orderStatus.sessionId) &&
        Objects.equals(this.orderId, orderStatus.orderId) &&
        Objects.equals(this.orderStatus, orderStatus.orderStatus) &&
        Objects.equals(this.reason, orderStatus.reason) &&
        Objects.equals(this.shippingCost, orderStatus.shippingCost) &&
        Objects.equals(this.trackingNumber, orderStatus.trackingNumber) &&
        Objects.equals(this.trackingMethod, orderStatus.trackingMethod) &&
        Objects.equals(this.source, orderStatus.source) &&
        Objects.equals(this.analyst, orderStatus.analyst) &&
        Objects.equals(this.description, orderStatus.description) &&
        Objects.equals(this.customInfo, orderStatus.customInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, sessionId, orderId, orderStatus, reason, shippingCost, trackingNumber, trackingMethod, source, analyst, description, customInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OrderStatus {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    sessionId: ").append(toIndentedString(sessionId)).append("\n");
    sb.append("    orderId: ").append(toIndentedString(orderId)).append("\n");
    sb.append("    orderStatus: ").append(toIndentedString(orderStatus)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    shippingCost: ").append(toIndentedString(shippingCost)).append("\n");
    sb.append("    trackingNumber: ").append(toIndentedString(trackingNumber)).append("\n");
    sb.append("    trackingMethod: ").append(toIndentedString(trackingMethod)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    analyst: ").append(toIndentedString(analyst)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    customInfo: ").append(toIndentedString(customInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

