/*
 * Thirdwatch API
 * The first version of the Thirdwatch API is an exciting step forward towards making it easier for developers to pass data to Thirdwatch.  Once you've [registered your website/app](https://thirdwatch.ai) it's easy to start sending data to Thirdwatch.  All endpoints are only accessible via https and are located at `api.thirdwatch.ai`. For instance: you can send event at the moment by ```HTTP POST``` Request to the following URL with your API key in ```Header``` and ```JSON``` data in request body. ```   https://api.thirdwatch.ai/event/v1 ``` Every API request must contain ```API Key``` in header value ```X-THIRDWATCH-API-KEY```  Every event must contain your ```_userId``` (if this is not available, you can alternatively provide a ```_sessionId``` value also in ```_userId```).  JavaScript Fingerprinting module for capturing unique devices and tracking user interaction.  This script will identify unique devices with respect to the browser. For e.g., if chrome is opened in normal mode a unique device id is generated and this will be same if chrome is opened in incognito mode or reinstalled.  Paste the below script onto your webpage, just after the opening `<body>` tag. This script should be added to the page which is accessed externally by the user of your website. For e.g., If you want to track three different webpages then paste the below script onto each webpage, just after the opening `<body>` tag. This script should not be added onto internal tools or admin panels. ```   &lt;script id=\"thirdwatch\"     data-session-cookie-name=\"&lt;cookie_name&gt;\"     data-session-id-value=\"&lt;session_id&gt;\"     data-user-id=\"&lt;user_id&gt;\"     data-app-secret=\"&lt;app_secret&gt;\"     data-is-track-pageview=\"true\"&gt; (function() {         var loadDeviceJs = function() {         var element = document.createElement(\"script\");         element.async = 1;         element.src = \"https://cdn.thirdwatch.ai/tw.min.js\";         document.body.appendChild(element);         };         if (window.addEventListener) {              window.addEventListener(\"load\", loadDeviceJs, false);         } else if (window.attachEvent) {         window.attachEvent(\"onload\", loadDeviceJs);         }     })();   &lt;/script&gt; ``` * `data-session-cookie-name` -- The cookie name where you are saving the unique session id. We will pick the session id by reading its value from the cookie name. (Optional) * `data-session-id-value` -- In case you are not passing `data-session-cookie-name` than you can put session id directly in this parameter. In absence of both `data-session-cookie-name` and `data-session-id-value`, our system will generate a session Id. (Optional) * `data-user-id` -- Unique user id at your end. This can be email id or primary key in the database. In case of guest user, you can insert session Id here. * `data-app-secret` -- Unique App secret generated for you by Thirdwatch. * `data-is-track-pageview` -- If this is set to true, then the url on which this script is running will be sent to Thirdwatch, else the url will not be captured.   The Score API is use to get an up to date cutomer trust score after you have sent transaction event and order successful. This API will provide the riskiness score of the order with reasons. Some examples of when you may want to check the score are before:    - Before Shippement of a package   - Finalizing a money transfer   - Giving access to a prearranged vacation rental   - Sending voucher on mail  ```   https://api.thirdwatch.ai/neo/v1/score?api_key=<your api key>&order_id=<Order id> ```  According to Score you can decide to take action Approve or Reject. Orders with score more than 70 will consider as Riskey orders. We'll provide some reasons also in rules section.   ``` {   \"order_id\": \"OCT45671\",   \"user_id\": \"ajay_245\",   \"order_timestamp\": \"2017-05-09T09:40:45.717Z\",   \"score\": 82,   \"flag\": \"red\",     -\"reasons\": [     {         \"name\": \"_numOfFailedTransactions\",         \"display_name\": \"Number of failed transactions\",         \"flag\": \"green\",         \"value\": \"0\",         \"is_display\": true       },       {         \"name\": \"_accountAge\",         \"display_name\": \"Account age\",         \"flag\": \"red\",         \"value\": \"0\",         \"is_display\": true       },       {         \"name\": \"_numOfOrderSameIp\",         \"display_name\": \"Number of orders from same IP\",         \"flag\": \"red\",         \"value\": \"11\",         \"is_display\": true       }     ] } ``` 
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package ai.thirdwatch.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * The payment_method field type represents information about the payment methods provided by the user. The value must be a nested object with the appropriate item subfields for the given payment method. Generally usedwith the create_order or transaction events. 
 */
@ApiModel(description = "The payment_method field type represents information about the payment methods provided by the user. The value must be a nested object with the appropriate item subfields for the given payment method. Generally usedwith the create_order or transaction events. ")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-11-21T16:23:00.366+05:30")
public class PaymentMethod {
  @SerializedName("_paymentType")
  private String paymentType = null;

  @SerializedName("_amount")
  private String amount = null;

  @SerializedName("_currencyCode")
  private String currencyCode = null;

  @SerializedName("_paymentGateway")
  private String paymentGateway = null;

  @SerializedName("_accountName")
  private String accountName = null;

  @SerializedName("_cardBin")
  private String cardBin = null;

  @SerializedName("_avsResponseCode")
  private String avsResponseCode = null;

  @SerializedName("_cvvResponseCode")
  private String cvvResponseCode = null;

  @SerializedName("_cardLast4")
  private String cardLast4 = null;

  @SerializedName("_cardExpiryMonth")
  private String cardExpiryMonth = null;

  @SerializedName("_cardExpiryYear")
  private String cardExpiryYear = null;

  public PaymentMethod paymentType(String paymentType) {
    this.paymentType = paymentType;
    return this;
  }

   /**
   * Values like - _cash, _check, _creditCard, _debitCard, _netBanking, _wallet, _cryptoCurrency, _electronicFundTransfer, _financing, _giftCard, _interac, _invoice, _moneyOrder, _masterPass, _points, _storeCredit, _thirdPartyProcessor, _voucher
   * @return paymentType
  **/
  @ApiModelProperty(value = "Values like - _cash, _check, _creditCard, _debitCard, _netBanking, _wallet, _cryptoCurrency, _electronicFundTransfer, _financing, _giftCard, _interac, _invoice, _moneyOrder, _masterPass, _points, _storeCredit, _thirdPartyProcessor, _voucher")
  public String getPaymentType() {
    return paymentType;
  }

  public void setPaymentType(String paymentType) {
    this.paymentType = paymentType;
  }

  public PaymentMethod amount(String amount) {
    this.amount = amount;
    return this;
  }

   /**
   * The item unit price in numbers, in the base unit of the currency_code.e.g. \&quot;2500\&quot;. In case of multiple payment methods in order it&#39;s useful.
   * @return amount
  **/
  @ApiModelProperty(value = "The item unit price in numbers, in the base unit of the currency_code.e.g. \"2500\". In case of multiple payment methods in order it's useful.")
  public String getAmount() {
    return amount;
  }

  public void setAmount(String amount) {
    this.amount = amount;
  }

  public PaymentMethod currencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * The [ISO-4217](http://en.wikipedia.org/wiki/ISO_4217) currency code for the amount. e.g., USD, INR alternative currencies, like bitcoin or points systems. In case of multiple payment methods in order it&#39;s useful.
   * @return currencyCode
  **/
  @ApiModelProperty(value = "The [ISO-4217](http://en.wikipedia.org/wiki/ISO_4217) currency code for the amount. e.g., USD, INR alternative currencies, like bitcoin or points systems. In case of multiple payment methods in order it's useful.")
  public String getCurrencyCode() {
    return currencyCode;
  }

  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }

  public PaymentMethod paymentGateway(String paymentGateway) {
    this.paymentGateway = paymentGateway;
    return this;
  }

   /**
   * fill value like bank name, gateway name, wallet name etc, e.g. payu, paypal, icici, paytm
   * @return paymentGateway
  **/
  @ApiModelProperty(value = "fill value like bank name, gateway name, wallet name etc, e.g. payu, paypal, icici, paytm")
  public String getPaymentGateway() {
    return paymentGateway;
  }

  public void setPaymentGateway(String paymentGateway) {
    this.paymentGateway = paymentGateway;
  }

  public PaymentMethod accountName(String accountName) {
    this.accountName = accountName;
    return this;
  }

   /**
   * Account name oif the user for that payment method
   * @return accountName
  **/
  @ApiModelProperty(value = "Account name oif the user for that payment method")
  public String getAccountName() {
    return accountName;
  }

  public void setAccountName(String accountName) {
    this.accountName = accountName;
  }

  public PaymentMethod cardBin(String cardBin) {
    this.cardBin = cardBin;
    return this;
  }

   /**
   * The first six digits of the credit card number. These numbers contain information about the card issuer, the geography and other card details.
   * @return cardBin
  **/
  @ApiModelProperty(value = "The first six digits of the credit card number. These numbers contain information about the card issuer, the geography and other card details.")
  public String getCardBin() {
    return cardBin;
  }

  public void setCardBin(String cardBin) {
    this.cardBin = cardBin;
  }

  public PaymentMethod avsResponseCode(String avsResponseCode) {
    this.avsResponseCode = avsResponseCode;
    return this;
  }

   /**
   * Response code from the AVS address verification system. Used in payments involving credit cards.
   * @return avsResponseCode
  **/
  @ApiModelProperty(value = "Response code from the AVS address verification system. Used in payments involving credit cards.")
  public String getAvsResponseCode() {
    return avsResponseCode;
  }

  public void setAvsResponseCode(String avsResponseCode) {
    this.avsResponseCode = avsResponseCode;
  }

  public PaymentMethod cvvResponseCode(String cvvResponseCode) {
    this.cvvResponseCode = cvvResponseCode;
    return this;
  }

   /**
   * Response code from the credit card company indicating if the CVV number entered matches the number on record. Used in payments involving credit cards.
   * @return cvvResponseCode
  **/
  @ApiModelProperty(value = "Response code from the credit card company indicating if the CVV number entered matches the number on record. Used in payments involving credit cards.")
  public String getCvvResponseCode() {
    return cvvResponseCode;
  }

  public void setCvvResponseCode(String cvvResponseCode) {
    this.cvvResponseCode = cvvResponseCode;
  }

  public PaymentMethod cardLast4(String cardLast4) {
    this.cardLast4 = cardLast4;
    return this;
  }

   /**
   * The last four digits of the credit card number.
   * @return cardLast4
  **/
  @ApiModelProperty(value = "The last four digits of the credit card number.")
  public String getCardLast4() {
    return cardLast4;
  }

  public void setCardLast4(String cardLast4) {
    this.cardLast4 = cardLast4;
  }

  public PaymentMethod cardExpiryMonth(String cardExpiryMonth) {
    this.cardExpiryMonth = cardExpiryMonth;
    return this;
  }

   /**
   * Expiry month of the card.
   * @return cardExpiryMonth
  **/
  @ApiModelProperty(value = "Expiry month of the card.")
  public String getCardExpiryMonth() {
    return cardExpiryMonth;
  }

  public void setCardExpiryMonth(String cardExpiryMonth) {
    this.cardExpiryMonth = cardExpiryMonth;
  }

  public PaymentMethod cardExpiryYear(String cardExpiryYear) {
    this.cardExpiryYear = cardExpiryYear;
    return this;
  }

   /**
   * Expiry year of the card.
   * @return cardExpiryYear
  **/
  @ApiModelProperty(value = "Expiry year of the card.")
  public String getCardExpiryYear() {
    return cardExpiryYear;
  }

  public void setCardExpiryYear(String cardExpiryYear) {
    this.cardExpiryYear = cardExpiryYear;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentMethod paymentMethod = (PaymentMethod) o;
    return Objects.equals(this.paymentType, paymentMethod.paymentType) &&
        Objects.equals(this.amount, paymentMethod.amount) &&
        Objects.equals(this.currencyCode, paymentMethod.currencyCode) &&
        Objects.equals(this.paymentGateway, paymentMethod.paymentGateway) &&
        Objects.equals(this.accountName, paymentMethod.accountName) &&
        Objects.equals(this.cardBin, paymentMethod.cardBin) &&
        Objects.equals(this.avsResponseCode, paymentMethod.avsResponseCode) &&
        Objects.equals(this.cvvResponseCode, paymentMethod.cvvResponseCode) &&
        Objects.equals(this.cardLast4, paymentMethod.cardLast4) &&
        Objects.equals(this.cardExpiryMonth, paymentMethod.cardExpiryMonth) &&
        Objects.equals(this.cardExpiryYear, paymentMethod.cardExpiryYear);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentType, amount, currencyCode, paymentGateway, accountName, cardBin, avsResponseCode, cvvResponseCode, cardLast4, cardExpiryMonth, cardExpiryYear);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentMethod {\n");
    
    sb.append("    paymentType: ").append(toIndentedString(paymentType)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    paymentGateway: ").append(toIndentedString(paymentGateway)).append("\n");
    sb.append("    accountName: ").append(toIndentedString(accountName)).append("\n");
    sb.append("    cardBin: ").append(toIndentedString(cardBin)).append("\n");
    sb.append("    avsResponseCode: ").append(toIndentedString(avsResponseCode)).append("\n");
    sb.append("    cvvResponseCode: ").append(toIndentedString(cvvResponseCode)).append("\n");
    sb.append("    cardLast4: ").append(toIndentedString(cardLast4)).append("\n");
    sb.append("    cardExpiryMonth: ").append(toIndentedString(cardExpiryMonth)).append("\n");
    sb.append("    cardExpiryYear: ").append(toIndentedString(cardExpiryYear)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

