/*
 * Decompiled with CFR 0.152.
 */
package ai.thirdwatch.api;

import ai.thirdwatch.ApiCallback;
import ai.thirdwatch.ApiClient;
import ai.thirdwatch.ApiException;
import ai.thirdwatch.ApiResponse;
import ai.thirdwatch.Configuration;
import ai.thirdwatch.Pair;
import ai.thirdwatch.ProgressRequestBody;
import ai.thirdwatch.ProgressResponseBody;
import ai.thirdwatch.model.CreateOrder;
import ai.thirdwatch.model.EventResponse;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateOrderApi {
    private ApiClient apiClient;

    public CreateOrderApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CreateOrderApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createOrderCall(CreateOrder body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateOrder localVarPostBody = body;
        String localVarPath = "/v1/createOrder";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createOrderValidateBeforeCall(CreateOrder body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createOrder(Async)");
        }
        Call call = this.createOrderCall(body, progressListener, progressRequestListener);
        return call;
    }

    public EventResponse createOrder(CreateOrder body) throws ApiException {
        ApiResponse<EventResponse> resp = this.createOrderWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<EventResponse> createOrderWithHttpInfo(CreateOrder body) throws ApiException {
        Call call = this.createOrderValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<EventResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createOrderAsync(CreateOrder body, final ApiCallback<EventResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createOrderValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<EventResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

