/*
 * Decompiled with CFR 0.152.
 */
package ai.thirdwatch.api;

import ai.thirdwatch.ApiCallback;
import ai.thirdwatch.ApiClient;
import ai.thirdwatch.ApiException;
import ai.thirdwatch.ApiResponse;
import ai.thirdwatch.Configuration;
import ai.thirdwatch.Pair;
import ai.thirdwatch.ProgressRequestBody;
import ai.thirdwatch.ProgressResponseBody;
import ai.thirdwatch.model.EventResponse;
import ai.thirdwatch.model.ItemStatus;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemStatusApi {
    private ApiClient apiClient;

    public ItemStatusApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ItemStatusApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call itemStatusCall(ItemStatus JSON2, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ItemStatus localVarPostBody = JSON2;
        String localVarPath = "/v1/item_status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call itemStatusValidateBeforeCall(ItemStatus JSON2, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (JSON2 == null) {
            throw new ApiException("Missing the required parameter 'JSON' when calling itemStatus(Async)");
        }
        Call call = this.itemStatusCall(JSON2, progressListener, progressRequestListener);
        return call;
    }

    public EventResponse itemStatus(ItemStatus JSON2) throws ApiException {
        ApiResponse<EventResponse> resp = this.itemStatusWithHttpInfo(JSON2);
        return resp.getData();
    }

    public ApiResponse<EventResponse> itemStatusWithHttpInfo(ItemStatus JSON2) throws ApiException {
        Call call = this.itemStatusValidateBeforeCall(JSON2, null, null);
        Type localVarReturnType = new TypeToken<EventResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call itemStatusAsync(ItemStatus JSON2, final ApiCallback<EventResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.itemStatusValidateBeforeCall(JSON2, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<EventResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

