/*
 * Decompiled with CFR 0.152.
 */
package ai.thirdwatch.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The Address field type represents a physical address. The value must be a nested object with the appropriate address subfields. We extract many geolocation features from these values. An address is represented as a nested JSON object. ")
public class BillingAddress {
    @SerializedName(value="_name")
    private String name = null;
    @SerializedName(value="_phone")
    private String phone = null;
    @SerializedName(value="_address1")
    private String address1 = null;
    @SerializedName(value="_address2")
    private String address2 = null;
    @SerializedName(value="_city")
    private String city = null;
    @SerializedName(value="_region")
    private String region = null;
    @SerializedName(value="_country")
    private String country = null;
    @SerializedName(value="_zipcode")
    private String zipcode = null;
    @SerializedName(value="_isOfficeAddress")
    private Boolean isOfficeAddress = null;
    @SerializedName(value="_isHomeAddress")
    private Boolean isHomeAddress = null;

    public BillingAddress name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Provide the full name associated with the address here. Concatenate first name and last name together if you collect them separately in your system.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BillingAddress phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(value="The phone number associated with this address. Provide the phone number as a string starting with the country code. Use E.164 format or send in the standard national format of number's origin.")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public BillingAddress address1(String address1) {
        this.address1 = address1;
        return this;
    }

    @ApiModelProperty(value="Address first line, e.g., \"C802 Nirvana Courtyard\".")
    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public BillingAddress address2(String address2) {
        this.address2 = address2;
        return this;
    }

    @ApiModelProperty(value="Address second line, e.g., \"Nirvana Country, Sector 50\".")
    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public BillingAddress city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="The city or town name, e.g., \"Gurgaon\" .")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public BillingAddress region(String region) {
        this.region = region;
        return this;
    }

    @ApiModelProperty(value="The region portion of the address. In the India, this corresponds to the state.")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public BillingAddress country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="The [ISO-3166](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code for the billing address, e.g., \"IN\" in case of India.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public BillingAddress zipcode(String zipcode) {
        this.zipcode = zipcode;
        return this;
    }

    @ApiModelProperty(value="The postal code associated with the address, e.g., \"122002\".")
    public String getZipcode() {
        return this.zipcode;
    }

    public void setZipcode(String zipcode) {
        this.zipcode = zipcode;
    }

    public BillingAddress isOfficeAddress(Boolean isOfficeAddress) {
        this.isOfficeAddress = isOfficeAddress;
        return this;
    }

    @ApiModelProperty(value="Is user chosen this address as office address.")
    public Boolean getIsOfficeAddress() {
        return this.isOfficeAddress;
    }

    public void setIsOfficeAddress(Boolean isOfficeAddress) {
        this.isOfficeAddress = isOfficeAddress;
    }

    public BillingAddress isHomeAddress(Boolean isHomeAddress) {
        this.isHomeAddress = isHomeAddress;
        return this;
    }

    @ApiModelProperty(value="Is user chosen this address as home address.")
    public Boolean getIsHomeAddress() {
        return this.isHomeAddress;
    }

    public void setIsHomeAddress(Boolean isHomeAddress) {
        this.isHomeAddress = isHomeAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingAddress billingAddress = (BillingAddress)o;
        return Objects.equals(this.name, billingAddress.name) && Objects.equals(this.phone, billingAddress.phone) && Objects.equals(this.address1, billingAddress.address1) && Objects.equals(this.address2, billingAddress.address2) && Objects.equals(this.city, billingAddress.city) && Objects.equals(this.region, billingAddress.region) && Objects.equals(this.country, billingAddress.country) && Objects.equals(this.zipcode, billingAddress.zipcode) && Objects.equals(this.isOfficeAddress, billingAddress.isOfficeAddress) && Objects.equals(this.isHomeAddress, billingAddress.isHomeAddress);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.phone, this.address1, this.address2, this.city, this.region, this.country, this.zipcode, this.isOfficeAddress, this.isHomeAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingAddress {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    address1: ").append(this.toIndentedString(this.address1)).append("\n");
        sb.append("    address2: ").append(this.toIndentedString(this.address2)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    zipcode: ").append(this.toIndentedString(this.zipcode)).append("\n");
        sb.append("    isOfficeAddress: ").append(this.toIndentedString(this.isOfficeAddress)).append("\n");
        sb.append("    isHomeAddress: ").append(this.toIndentedString(this.isHomeAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

