/*
 * Decompiled with CFR 0.152.
 */
package ai.thirdwatch.model;

import ai.thirdwatch.model.CustomInfo;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class Chargeback {
    @SerializedName(value="_userId")
    private String userId = null;
    @SerializedName(value="_sessionId")
    private String sessionId = null;
    @SerializedName(value="_orderId")
    private String orderId = null;
    @SerializedName(value="_transactionId")
    private String transactionId = null;
    @SerializedName(value="_chargebackState")
    private String chargebackState = null;
    @SerializedName(value="_chargebackReason")
    private String chargebackReason = null;
    @SerializedName(value="_customInfo")
    private CustomInfo customInfo = null;

    public Chargeback userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(value="The user's account ID according to your systems. Note that user IDs are case sensitive.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Chargeback sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(value="The user's current session ID, used to tie a user's action before and after login or account creation. Required if no user_id values is provided.")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Chargeback orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @ApiModelProperty(value="The ID for the order that this chargeback is filed against. This field is not required if this chargeback was filed against a transaction with no _orderId.")
    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Chargeback transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(value="The ID for the transaction that this chargeback is filed against.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public Chargeback chargebackState(String chargebackState) {
        this.chargebackState = chargebackState;
        return this;
    }

    @ApiModelProperty(value="The current state of the chargeback. e.g. _received, _accepted, _disputed, _won, _lost")
    public String getChargebackState() {
        return this.chargebackState;
    }

    public void setChargebackState(String chargebackState) {
        this.chargebackState = chargebackState;
    }

    public Chargeback chargebackReason(String chargebackReason) {
        this.chargebackReason = chargebackReason;
        return this;
    }

    @ApiModelProperty(value="This field can be used to capture the reason given. e.g. _fraud, _duplicate, _product_not_received, _product_unacceptable, _other\"")
    public String getChargebackReason() {
        return this.chargebackReason;
    }

    public void setChargebackReason(String chargebackReason) {
        this.chargebackReason = chargebackReason;
    }

    public Chargeback customInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public CustomInfo getCustomInfo() {
        return this.customInfo;
    }

    public void setCustomInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chargeback chargeback = (Chargeback)o;
        return Objects.equals(this.userId, chargeback.userId) && Objects.equals(this.sessionId, chargeback.sessionId) && Objects.equals(this.orderId, chargeback.orderId) && Objects.equals(this.transactionId, chargeback.transactionId) && Objects.equals(this.chargebackState, chargeback.chargebackState) && Objects.equals(this.chargebackReason, chargeback.chargebackReason) && Objects.equals(this.customInfo, chargeback.customInfo);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.sessionId, this.orderId, this.transactionId, this.chargebackState, this.chargebackReason, this.customInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Chargeback {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    chargebackState: ").append(this.toIndentedString(this.chargebackState)).append("\n");
        sb.append("    chargebackReason: ").append(this.toIndentedString(this.chargebackReason)).append("\n");
        sb.append("    customInfo: ").append(this.toIndentedString(this.customInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

