/*
 * Decompiled with CFR 0.152.
 */
package ai.thirdwatch.model;

import ai.thirdwatch.model.BillingAddress;
import ai.thirdwatch.model.CustomInfo;
import ai.thirdwatch.model.Item;
import ai.thirdwatch.model.PaymentMethod;
import ai.thirdwatch.model.Promotion;
import ai.thirdwatch.model.ShippingAddress;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateOrder {
    @SerializedName(value="_userId")
    private String userId = null;
    @SerializedName(value="_sessionId")
    private String sessionId = null;
    @SerializedName(value="_orderId")
    private String orderId = null;
    @SerializedName(value="_deviceIp")
    private String deviceIp = null;
    @SerializedName(value="_originTimestamp")
    private String originTimestamp = null;
    @SerializedName(value="_userEmail")
    private String userEmail = null;
    @SerializedName(value="_amount")
    private String amount = null;
    @SerializedName(value="_currencyCode")
    private String currencyCode = null;
    @SerializedName(value="_hasExpeditedShipping")
    private Boolean hasExpeditedShipping = null;
    @SerializedName(value="_shippingMethod")
    private String shippingMethod = null;
    @SerializedName(value="_orderReferrer")
    private String orderReferrer = null;
    @SerializedName(value="_isPrePaid")
    private Boolean isPrePaid = null;
    @SerializedName(value="_isGift")
    private Boolean isGift = null;
    @SerializedName(value="_isReturn")
    private Boolean isReturn = null;
    @SerializedName(value="_isFirstTimeBuyer")
    private Boolean isFirstTimeBuyer = null;
    @SerializedName(value="_billingAddress")
    private BillingAddress billingAddress = null;
    @SerializedName(value="_shippingAddress")
    private ShippingAddress shippingAddress = null;
    @SerializedName(value="_paymentMethods")
    private List<PaymentMethod> paymentMethods = null;
    @SerializedName(value="_promotions")
    private List<Promotion> promotions = null;
    @SerializedName(value="_items")
    private List<Item> items = null;
    @SerializedName(value="_customInfo")
    private CustomInfo customInfo = null;

    public CreateOrder userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(value="The user's account ID according to your systems. Note that user IDs are case sensitive.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public CreateOrder sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(value="The user's current session ID, used to tie a user's action before and after login or account creation. Required if no user_id values is provided.")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public CreateOrder orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID for tracking this order in your system.")
    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public CreateOrder deviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
        return this;
    }

    @ApiModelProperty(value="IP address of the request made by the user. Recommended for historical backfills and customers with mobile apps.")
    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public CreateOrder originTimestamp(String originTimestamp) {
        this.originTimestamp = originTimestamp;
        return this;
    }

    @ApiModelProperty(value="Represents the time the event occured in your system. Send as a UNIX timestamp in milliseconds in string.")
    public String getOriginTimestamp() {
        return this.originTimestamp;
    }

    public void setOriginTimestamp(String originTimestamp) {
        this.originTimestamp = originTimestamp;
    }

    public CreateOrder userEmail(String userEmail) {
        this.userEmail = userEmail;
        return this;
    }

    @ApiModelProperty(value="Email of the user creating this order. Note - If the user's email is also their account ID in your system, set both the userId and userEmail fields to their email address.")
    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public CreateOrder amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="The item unit price in numbers, in the base unit of the currency_code.e.g. \"2500\"")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public CreateOrder currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="The [ISO-4217](http://en.wikipedia.org/wiki/ISO_4217) currency code for the amount. e.g., USD, INR alternative currencies, like bitcoin or points systems.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public CreateOrder hasExpeditedShipping(Boolean hasExpeditedShipping) {
        this.hasExpeditedShipping = hasExpeditedShipping;
        return this;
    }

    @ApiModelProperty(value="Whether the user requested priority/expedited shipping on their order.")
    public Boolean getHasExpeditedShipping() {
        return this.hasExpeditedShipping;
    }

    public void setHasExpeditedShipping(Boolean hasExpeditedShipping) {
        this.hasExpeditedShipping = hasExpeditedShipping;
    }

    public CreateOrder shippingMethod(String shippingMethod) {
        this.shippingMethod = shippingMethod;
        return this;
    }

    @ApiModelProperty(value="Indicates the method of delivery to the user. e.g. _electronic, _physical")
    public String getShippingMethod() {
        return this.shippingMethod;
    }

    public void setShippingMethod(String shippingMethod) {
        this.shippingMethod = shippingMethod;
    }

    public CreateOrder orderReferrer(String orderReferrer) {
        this.orderReferrer = orderReferrer;
        return this;
    }

    @ApiModelProperty(value="Referer website or user name.")
    public String getOrderReferrer() {
        return this.orderReferrer;
    }

    public void setOrderReferrer(String orderReferrer) {
        this.orderReferrer = orderReferrer;
    }

    public CreateOrder isPrePaid(Boolean isPrePaid) {
        this.isPrePaid = isPrePaid;
        return this;
    }

    @ApiModelProperty(value="is order is prepaid.")
    public Boolean getIsPrePaid() {
        return this.isPrePaid;
    }

    public void setIsPrePaid(Boolean isPrePaid) {
        this.isPrePaid = isPrePaid;
    }

    public CreateOrder isGift(Boolean isGift) {
        this.isGift = isGift;
        return this;
    }

    @ApiModelProperty(value="Is user chosen gift pack.")
    public Boolean getIsGift() {
        return this.isGift;
    }

    public void setIsGift(Boolean isGift) {
        this.isGift = isGift;
    }

    public CreateOrder isReturn(Boolean isReturn) {
        this.isReturn = isReturn;
        return this;
    }

    @ApiModelProperty(value="Is this return order.")
    public Boolean getIsReturn() {
        return this.isReturn;
    }

    public void setIsReturn(Boolean isReturn) {
        this.isReturn = isReturn;
    }

    public CreateOrder isFirstTimeBuyer(Boolean isFirstTimeBuyer) {
        this.isFirstTimeBuyer = isFirstTimeBuyer;
        return this;
    }

    @ApiModelProperty(value="Is user first time buyer.")
    public Boolean getIsFirstTimeBuyer() {
        return this.isFirstTimeBuyer;
    }

    public void setIsFirstTimeBuyer(Boolean isFirstTimeBuyer) {
        this.isFirstTimeBuyer = isFirstTimeBuyer;
    }

    public CreateOrder billingAddress(BillingAddress billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public BillingAddress getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(BillingAddress billingAddress) {
        this.billingAddress = billingAddress;
    }

    public CreateOrder shippingAddress(ShippingAddress shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public ShippingAddress getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(ShippingAddress shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public CreateOrder paymentMethods(List<PaymentMethod> paymentMethods) {
        this.paymentMethods = paymentMethods;
        return this;
    }

    public CreateOrder addPaymentMethodsItem(PaymentMethod paymentMethodsItem) {
        if (this.paymentMethods == null) {
            this.paymentMethods = new ArrayList<PaymentMethod>();
        }
        this.paymentMethods.add(paymentMethodsItem);
        return this;
    }

    @ApiModelProperty(value="The payment information associated with this order. Represented as an array of nested payment_method objects containing payment type, payment gateway, credit card bin, etc.")
    public List<PaymentMethod> getPaymentMethods() {
        return this.paymentMethods;
    }

    public void setPaymentMethods(List<PaymentMethod> paymentMethods) {
        this.paymentMethods = paymentMethods;
    }

    public CreateOrder promotions(List<Promotion> promotions) {
        this.promotions = promotions;
        return this;
    }

    public CreateOrder addPromotionsItem(Promotion promotionsItem) {
        if (this.promotions == null) {
            this.promotions = new ArrayList<Promotion>();
        }
        this.promotions.add(promotionsItem);
        return this;
    }

    @ApiModelProperty(value="The list of promotions that apply to this order. You can add one or more promotions when creating or updating an order. Represented as a JSON array of promotion objects. You can also separately add promotions to the account via the addPromotion event.")
    public List<Promotion> getPromotions() {
        return this.promotions;
    }

    public void setPromotions(List<Promotion> promotions) {
        this.promotions = promotions;
    }

    public CreateOrder items(List<Item> items) {
        this.items = items;
        return this;
    }

    public CreateOrder addItemsItem(Item itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<Item>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="The list of items ordered. Represented as a JSON array of item")
    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public CreateOrder customInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public CustomInfo getCustomInfo() {
        return this.customInfo;
    }

    public void setCustomInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrder createOrder = (CreateOrder)o;
        return Objects.equals(this.userId, createOrder.userId) && Objects.equals(this.sessionId, createOrder.sessionId) && Objects.equals(this.orderId, createOrder.orderId) && Objects.equals(this.deviceIp, createOrder.deviceIp) && Objects.equals(this.originTimestamp, createOrder.originTimestamp) && Objects.equals(this.userEmail, createOrder.userEmail) && Objects.equals(this.amount, createOrder.amount) && Objects.equals(this.currencyCode, createOrder.currencyCode) && Objects.equals(this.hasExpeditedShipping, createOrder.hasExpeditedShipping) && Objects.equals(this.shippingMethod, createOrder.shippingMethod) && Objects.equals(this.orderReferrer, createOrder.orderReferrer) && Objects.equals(this.isPrePaid, createOrder.isPrePaid) && Objects.equals(this.isGift, createOrder.isGift) && Objects.equals(this.isReturn, createOrder.isReturn) && Objects.equals(this.isFirstTimeBuyer, createOrder.isFirstTimeBuyer) && Objects.equals(this.billingAddress, createOrder.billingAddress) && Objects.equals(this.shippingAddress, createOrder.shippingAddress) && Objects.equals(this.paymentMethods, createOrder.paymentMethods) && Objects.equals(this.promotions, createOrder.promotions) && Objects.equals(this.items, createOrder.items) && Objects.equals(this.customInfo, createOrder.customInfo);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.sessionId, this.orderId, this.deviceIp, this.originTimestamp, this.userEmail, this.amount, this.currencyCode, this.hasExpeditedShipping, this.shippingMethod, this.orderReferrer, this.isPrePaid, this.isGift, this.isReturn, this.isFirstTimeBuyer, this.billingAddress, this.shippingAddress, this.paymentMethods, this.promotions, this.items, this.customInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateOrder {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    deviceIp: ").append(this.toIndentedString(this.deviceIp)).append("\n");
        sb.append("    originTimestamp: ").append(this.toIndentedString(this.originTimestamp)).append("\n");
        sb.append("    userEmail: ").append(this.toIndentedString(this.userEmail)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    hasExpeditedShipping: ").append(this.toIndentedString(this.hasExpeditedShipping)).append("\n");
        sb.append("    shippingMethod: ").append(this.toIndentedString(this.shippingMethod)).append("\n");
        sb.append("    orderReferrer: ").append(this.toIndentedString(this.orderReferrer)).append("\n");
        sb.append("    isPrePaid: ").append(this.toIndentedString(this.isPrePaid)).append("\n");
        sb.append("    isGift: ").append(this.toIndentedString(this.isGift)).append("\n");
        sb.append("    isReturn: ").append(this.toIndentedString(this.isReturn)).append("\n");
        sb.append("    isFirstTimeBuyer: ").append(this.toIndentedString(this.isFirstTimeBuyer)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    shippingAddress: ").append(this.toIndentedString(this.shippingAddress)).append("\n");
        sb.append("    paymentMethods: ").append(this.toIndentedString(this.paymentMethods)).append("\n");
        sb.append("    promotions: ").append(this.toIndentedString(this.promotions)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    customInfo: ").append(this.toIndentedString(this.customInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

