/*
 * Decompiled with CFR 0.152.
 */
package ai.thirdwatch.model;

import ai.thirdwatch.model.Seller;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The Item field type represents a product or service for sale in your business. The value must be a nested object with the appropriate item subfields. Generally used in the add_to_cart and remove_from_cart events. ")
public class Item {
    @SerializedName(value="_itemId")
    private String itemId = null;
    @SerializedName(value="_productTitle")
    private String productTitle = null;
    @SerializedName(value="_price")
    private String price = null;
    @SerializedName(value="_currencyCode")
    private String currencyCode = null;
    @SerializedName(value="_upc")
    private String upc = null;
    @SerializedName(value="_sku")
    private String sku = null;
    @SerializedName(value="_isbn")
    private String isbn = null;
    @SerializedName(value="_brand")
    private String brand = null;
    @SerializedName(value="_manufacturer")
    private String manufacturer = null;
    @SerializedName(value="_category")
    private String category = null;
    @SerializedName(value="_tags")
    private String tags = null;
    @SerializedName(value="_color")
    private String color = null;
    @SerializedName(value="_quantity")
    private Long quantity = null;
    @SerializedName(value="_isOnSale")
    private Boolean isOnSale = null;
    @SerializedName(value="_maxQuantity")
    private Long maxQuantity = null;
    @SerializedName(value="_discountPrice")
    private String discountPrice = null;
    @SerializedName(value="_productWeight")
    private String productWeight = null;
    @SerializedName(value="_country")
    private String country = null;
    @SerializedName(value="_descriptionShort")
    private String descriptionShort = null;
    @SerializedName(value="_description")
    private String description = null;
    @SerializedName(value="_seller")
    private Seller seller = null;

    public Item itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(value="The item's unique identifier according to your systems. Use the same ID that you would use to look up items on your website's database.")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public Item productTitle(String productTitle) {
        this.productTitle = productTitle;
        return this;
    }

    @ApiModelProperty(value="The item's name, e.g., \"WD 2 TB External Hard Drive\".")
    public String getProductTitle() {
        return this.productTitle;
    }

    public void setProductTitle(String productTitle) {
        this.productTitle = productTitle;
    }

    public Item price(String price) {
        this.price = price;
        return this;
    }

    @ApiModelProperty(value="The item unit price in numbers, in the base unit of the currency_code.e.g. \"2500\"")
    public String getPrice() {
        return this.price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public Item currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="The [ISO-4217](http://en.wikipedia.org/wiki/ISO_4217) currency code for the amount. e.g., USD, INR alternative currencies, like bitcoin or points systems.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Item upc(String upc) {
        this.upc = upc;
        return this;
    }

    @ApiModelProperty(value="If the item has a Universal Product Code (UPC), provide it here.")
    public String getUpc() {
        return this.upc;
    }

    public void setUpc(String upc) {
        this.upc = upc;
    }

    public Item sku(String sku) {
        this.sku = sku;
        return this;
    }

    @ApiModelProperty(value="If the item has a Stock-keeping Unit ID (SKU), provide it here.")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public Item isbn(String isbn) {
        this.isbn = isbn;
        return this;
    }

    @ApiModelProperty(value="If the item is a book with an International Standard Book Number (ISBN), provide it here.")
    public String getIsbn() {
        return this.isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    public Item brand(String brand) {
        this.brand = brand;
        return this;
    }

    @ApiModelProperty(value="The brand name of the item.")
    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Item manufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
        return this;
    }

    @ApiModelProperty(value="Name of the item's manufacturer.")
    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public Item category(String category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(value="The category this item is listed under in your business. e.g., \"travel\", \"man > bags\".")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Item tags(String tags) {
        this.tags = tags;
        return this;
    }

    @ApiModelProperty(value="The tags used to describe this item in your business. e.g., \"man\", \"summer\".")
    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public Item color(String color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(value="The color of the item.")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Item quantity(Long quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(value="The quantity of the item.")
    public Long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    public Item isOnSale(Boolean isOnSale) {
        this.isOnSale = isOnSale;
        return this;
    }

    @ApiModelProperty(value="Is item on sale or running offers on this item .")
    public Boolean getIsOnSale() {
        return this.isOnSale;
    }

    public void setIsOnSale(Boolean isOnSale) {
        this.isOnSale = isOnSale;
    }

    public Item maxQuantity(Long maxQuantity) {
        this.maxQuantity = maxQuantity;
        return this;
    }

    @ApiModelProperty(value="The max quantity per user for this item.")
    public Long getMaxQuantity() {
        return this.maxQuantity;
    }

    public void setMaxQuantity(Long maxQuantity) {
        this.maxQuantity = maxQuantity;
    }

    public Item discountPrice(String discountPrice) {
        this.discountPrice = discountPrice;
        return this;
    }

    @ApiModelProperty(value="Price of the product after discount.")
    public String getDiscountPrice() {
        return this.discountPrice;
    }

    public void setDiscountPrice(String discountPrice) {
        this.discountPrice = discountPrice;
    }

    public Item productWeight(String productWeight) {
        this.productWeight = productWeight;
        return this;
    }

    @ApiModelProperty(value="Weight of the product in Kilo Gram, e.g. \"3\" , \"0.5\"")
    public String getProductWeight() {
        return this.productWeight;
    }

    public void setProductWeight(String productWeight) {
        this.productWeight = productWeight;
    }

    public Item country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="The [ISO-3166](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the item, e.g., \"IN\" in case of India.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Item descriptionShort(String descriptionShort) {
        this.descriptionShort = descriptionShort;
        return this;
    }

    @ApiModelProperty(value="Short description of the item.")
    public String getDescriptionShort() {
        return this.descriptionShort;
    }

    public void setDescriptionShort(String descriptionShort) {
        this.descriptionShort = descriptionShort;
    }

    public Item description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Detail description of the item.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Item seller(Seller seller) {
        this.seller = seller;
        return this;
    }

    @ApiModelProperty(value="")
    public Seller getSeller() {
        return this.seller;
    }

    public void setSeller(Seller seller) {
        this.seller = seller;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.itemId, item.itemId) && Objects.equals(this.productTitle, item.productTitle) && Objects.equals(this.price, item.price) && Objects.equals(this.currencyCode, item.currencyCode) && Objects.equals(this.upc, item.upc) && Objects.equals(this.sku, item.sku) && Objects.equals(this.isbn, item.isbn) && Objects.equals(this.brand, item.brand) && Objects.equals(this.manufacturer, item.manufacturer) && Objects.equals(this.category, item.category) && Objects.equals(this.tags, item.tags) && Objects.equals(this.color, item.color) && Objects.equals(this.quantity, item.quantity) && Objects.equals(this.isOnSale, item.isOnSale) && Objects.equals(this.maxQuantity, item.maxQuantity) && Objects.equals(this.discountPrice, item.discountPrice) && Objects.equals(this.productWeight, item.productWeight) && Objects.equals(this.country, item.country) && Objects.equals(this.descriptionShort, item.descriptionShort) && Objects.equals(this.description, item.description) && Objects.equals(this.seller, item.seller);
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.productTitle, this.price, this.currencyCode, this.upc, this.sku, this.isbn, this.brand, this.manufacturer, this.category, this.tags, this.color, this.quantity, this.isOnSale, this.maxQuantity, this.discountPrice, this.productWeight, this.country, this.descriptionShort, this.description, this.seller);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Item {\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    productTitle: ").append(this.toIndentedString(this.productTitle)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    upc: ").append(this.toIndentedString(this.upc)).append("\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    isbn: ").append(this.toIndentedString(this.isbn)).append("\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    manufacturer: ").append(this.toIndentedString(this.manufacturer)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    isOnSale: ").append(this.toIndentedString(this.isOnSale)).append("\n");
        sb.append("    maxQuantity: ").append(this.toIndentedString(this.maxQuantity)).append("\n");
        sb.append("    discountPrice: ").append(this.toIndentedString(this.discountPrice)).append("\n");
        sb.append("    productWeight: ").append(this.toIndentedString(this.productWeight)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    descriptionShort: ").append(this.toIndentedString(this.descriptionShort)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    seller: ").append(this.toIndentedString(this.seller)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

