/*
 * Decompiled with CFR 0.152.
 */
package ai.thirdwatch.model;

import ai.thirdwatch.model.CustomInfo;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class Login {
    @SerializedName(value="_userId")
    private String userId = null;
    @SerializedName(value="_sessionId")
    private String sessionId = null;
    @SerializedName(value="_deviceIp")
    private String deviceIp = null;
    @SerializedName(value="_originTimestamp")
    private String originTimestamp = null;
    @SerializedName(value="_loginStatus")
    private String loginStatus = null;
    @SerializedName(value="_customInfo")
    private CustomInfo customInfo = null;

    public Login userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(value="The user's account ID according to your systems. Note that user IDs are case sensitive.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Login sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(value="The user's current session ID, used to tie a user's action before and after login or account creation. Required if no user_id values is provided.")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Login deviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
        return this;
    }

    @ApiModelProperty(value="IP address of the request made by the user. Recommended for historical backfills and customers with mobile apps.")
    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public Login originTimestamp(String originTimestamp) {
        this.originTimestamp = originTimestamp;
        return this;
    }

    @ApiModelProperty(value="Represents the time the event occured in your system. Send as a UNIX timestamp in milliseconds in string.")
    public String getOriginTimestamp() {
        return this.originTimestamp;
    }

    public void setOriginTimestamp(String originTimestamp) {
        this.originTimestamp = originTimestamp;
    }

    public Login loginStatus(String loginStatus) {
        this.loginStatus = loginStatus;
        return this;
    }

    @ApiModelProperty(value="Use _loginStatus to represent the success or failure of the login attempt. e.g. _success, _failure")
    public String getLoginStatus() {
        return this.loginStatus;
    }

    public void setLoginStatus(String loginStatus) {
        this.loginStatus = loginStatus;
    }

    public Login customInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public CustomInfo getCustomInfo() {
        return this.customInfo;
    }

    public void setCustomInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Login login = (Login)o;
        return Objects.equals(this.userId, login.userId) && Objects.equals(this.sessionId, login.sessionId) && Objects.equals(this.deviceIp, login.deviceIp) && Objects.equals(this.originTimestamp, login.originTimestamp) && Objects.equals(this.loginStatus, login.loginStatus) && Objects.equals(this.customInfo, login.customInfo);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.sessionId, this.deviceIp, this.originTimestamp, this.loginStatus, this.customInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Login {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    deviceIp: ").append(this.toIndentedString(this.deviceIp)).append("\n");
        sb.append("    originTimestamp: ").append(this.toIndentedString(this.originTimestamp)).append("\n");
        sb.append("    loginStatus: ").append(this.toIndentedString(this.loginStatus)).append("\n");
        sb.append("    customInfo: ").append(this.toIndentedString(this.customInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

