/*
 * Decompiled with CFR 0.152.
 */
package ai.thirdwatch.model;

import ai.thirdwatch.model.CustomInfo;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class OrderStatus {
    @SerializedName(value="_userId")
    private String userId = null;
    @SerializedName(value="_sessionId")
    private String sessionId = null;
    @SerializedName(value="_orderId")
    private String orderId = null;
    @SerializedName(value="_orderStatus")
    private String orderStatus = null;
    @SerializedName(value="_reason")
    private String reason = null;
    @SerializedName(value="_shippingCost")
    private String shippingCost = null;
    @SerializedName(value="_trackingNumber")
    private String trackingNumber = null;
    @SerializedName(value="_trackingMethod")
    private String trackingMethod = null;
    @SerializedName(value="_source")
    private String source = null;
    @SerializedName(value="_analyst")
    private String analyst = null;
    @SerializedName(value="_description")
    private String description = null;
    @SerializedName(value="_customInfo")
    private CustomInfo customInfo = null;

    public OrderStatus userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(value="The user's account ID according to your systems. Note that user IDs are case sensitive.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public OrderStatus sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(value="The user's current session ID, used to tie a user's action before and after login or account creation. Required if no user_id values is provided.")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public OrderStatus orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @ApiModelProperty(value="The ID for the order that this chargeback is filed against. This field is not required if this chargeback was filed against a transaction with no _orderId.")
    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public OrderStatus orderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
        return this;
    }

    @ApiModelProperty(value="Indicates the high-level state of the order. e.g. _approved, _canceled, _held, _fulfilled, _returned, _rto")
    public String getOrderStatus() {
        return this.orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public OrderStatus reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="The reason for a cancellation. e.g. _paymentRisk, _abuse, _policy, _other")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public OrderStatus shippingCost(String shippingCost) {
        this.shippingCost = shippingCost;
        return this;
    }

    @ApiModelProperty(value="if _approved or _fulfilled than pass the shipping cost. e.g. \"50\"")
    public String getShippingCost() {
        return this.shippingCost;
    }

    public void setShippingCost(String shippingCost) {
        this.shippingCost = shippingCost;
    }

    public OrderStatus trackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        return this;
    }

    @ApiModelProperty(value="if _approved or _fulfilled than pass the tracking number. e.g. \"55327470\"")
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public OrderStatus trackingMethod(String trackingMethod) {
        this.trackingMethod = trackingMethod;
        return this;
    }

    @ApiModelProperty(value="if _approved or _fulfilled than pass the tracking url. e.g. \"http://fedex.com/track?q=abc123\"")
    public String getTrackingMethod() {
        return this.trackingMethod;
    }

    public void setTrackingMethod(String trackingMethod) {
        this.trackingMethod = trackingMethod;
    }

    public OrderStatus source(String source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(value="The source of a decision. e.g. _automated, _manualReview\"")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public OrderStatus analyst(String analyst) {
        this.analyst = analyst;
        return this;
    }

    @ApiModelProperty(value="The analyst who made the decision, if manual.")
    public String getAnalyst() {
        return this.analyst;
    }

    public void setAnalyst(String analyst) {
        this.analyst = analyst;
    }

    public OrderStatus description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Any additional information about this order status change.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OrderStatus customInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public CustomInfo getCustomInfo() {
        return this.customInfo;
    }

    public void setCustomInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderStatus orderStatus = (OrderStatus)o;
        return Objects.equals(this.userId, orderStatus.userId) && Objects.equals(this.sessionId, orderStatus.sessionId) && Objects.equals(this.orderId, orderStatus.orderId) && Objects.equals(this.orderStatus, orderStatus.orderStatus) && Objects.equals(this.reason, orderStatus.reason) && Objects.equals(this.shippingCost, orderStatus.shippingCost) && Objects.equals(this.trackingNumber, orderStatus.trackingNumber) && Objects.equals(this.trackingMethod, orderStatus.trackingMethod) && Objects.equals(this.source, orderStatus.source) && Objects.equals(this.analyst, orderStatus.analyst) && Objects.equals(this.description, orderStatus.description) && Objects.equals(this.customInfo, orderStatus.customInfo);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.sessionId, this.orderId, this.orderStatus, this.reason, this.shippingCost, this.trackingNumber, this.trackingMethod, this.source, this.analyst, this.description, this.customInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderStatus {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    orderStatus: ").append(this.toIndentedString(this.orderStatus)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    shippingCost: ").append(this.toIndentedString(this.shippingCost)).append("\n");
        sb.append("    trackingNumber: ").append(this.toIndentedString(this.trackingNumber)).append("\n");
        sb.append("    trackingMethod: ").append(this.toIndentedString(this.trackingMethod)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    analyst: ").append(this.toIndentedString(this.analyst)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    customInfo: ").append(this.toIndentedString(this.customInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

