/*
 * Decompiled with CFR 0.152.
 */
package ai.thirdwatch.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The payment_method field type represents information about the payment methods provided by the user. The value must be a nested object with the appropriate item subfields for the given payment method. Generally usedwith the create_order or transaction events. ")
public class PaymentMethod {
    @SerializedName(value="_paymentType")
    private String paymentType = null;
    @SerializedName(value="_amount")
    private String amount = null;
    @SerializedName(value="_currencyCode")
    private String currencyCode = null;
    @SerializedName(value="_paymentGateway")
    private String paymentGateway = null;
    @SerializedName(value="_accountName")
    private String accountName = null;
    @SerializedName(value="_cardBin")
    private String cardBin = null;
    @SerializedName(value="_avsResponseCode")
    private String avsResponseCode = null;
    @SerializedName(value="_cvvResponseCode")
    private String cvvResponseCode = null;
    @SerializedName(value="_cardLast4")
    private String cardLast4 = null;
    @SerializedName(value="_cardExpiryMonth")
    private String cardExpiryMonth = null;
    @SerializedName(value="_cardExpiryYear")
    private String cardExpiryYear = null;

    public PaymentMethod paymentType(String paymentType) {
        this.paymentType = paymentType;
        return this;
    }

    @ApiModelProperty(value="Values like - _cash, _check, _creditCard, _debitCard, _netBanking, _wallet, _cryptoCurrency, _electronicFundTransfer, _financing, _giftCard, _interac, _invoice, _moneyOrder, _masterPass, _points, _storeCredit, _thirdPartyProcessor, _voucher")
    public String getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public PaymentMethod amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="The item unit price in numbers, in the base unit of the currency_code.e.g. \"2500\". In case of multiple payment methods in order it's useful.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public PaymentMethod currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="The [ISO-4217](http://en.wikipedia.org/wiki/ISO_4217) currency code for the amount. e.g., USD, INR alternative currencies, like bitcoin or points systems. In case of multiple payment methods in order it's useful.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public PaymentMethod paymentGateway(String paymentGateway) {
        this.paymentGateway = paymentGateway;
        return this;
    }

    @ApiModelProperty(value="fill value like bank name, gateway name, wallet name etc, e.g. payu, paypal, icici, paytm")
    public String getPaymentGateway() {
        return this.paymentGateway;
    }

    public void setPaymentGateway(String paymentGateway) {
        this.paymentGateway = paymentGateway;
    }

    public PaymentMethod accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @ApiModelProperty(value="Account name oif the user for that payment method")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public PaymentMethod cardBin(String cardBin) {
        this.cardBin = cardBin;
        return this;
    }

    @ApiModelProperty(value="The first six digits of the credit card number. These numbers contain information about the card issuer, the geography and other card details.")
    public String getCardBin() {
        return this.cardBin;
    }

    public void setCardBin(String cardBin) {
        this.cardBin = cardBin;
    }

    public PaymentMethod avsResponseCode(String avsResponseCode) {
        this.avsResponseCode = avsResponseCode;
        return this;
    }

    @ApiModelProperty(value="Response code from the AVS address verification system. Used in payments involving credit cards.")
    public String getAvsResponseCode() {
        return this.avsResponseCode;
    }

    public void setAvsResponseCode(String avsResponseCode) {
        this.avsResponseCode = avsResponseCode;
    }

    public PaymentMethod cvvResponseCode(String cvvResponseCode) {
        this.cvvResponseCode = cvvResponseCode;
        return this;
    }

    @ApiModelProperty(value="Response code from the credit card company indicating if the CVV number entered matches the number on record. Used in payments involving credit cards.")
    public String getCvvResponseCode() {
        return this.cvvResponseCode;
    }

    public void setCvvResponseCode(String cvvResponseCode) {
        this.cvvResponseCode = cvvResponseCode;
    }

    public PaymentMethod cardLast4(String cardLast4) {
        this.cardLast4 = cardLast4;
        return this;
    }

    @ApiModelProperty(value="The last four digits of the credit card number.")
    public String getCardLast4() {
        return this.cardLast4;
    }

    public void setCardLast4(String cardLast4) {
        this.cardLast4 = cardLast4;
    }

    public PaymentMethod cardExpiryMonth(String cardExpiryMonth) {
        this.cardExpiryMonth = cardExpiryMonth;
        return this;
    }

    @ApiModelProperty(value="Expiry month of the card.")
    public String getCardExpiryMonth() {
        return this.cardExpiryMonth;
    }

    public void setCardExpiryMonth(String cardExpiryMonth) {
        this.cardExpiryMonth = cardExpiryMonth;
    }

    public PaymentMethod cardExpiryYear(String cardExpiryYear) {
        this.cardExpiryYear = cardExpiryYear;
        return this;
    }

    @ApiModelProperty(value="Expiry year of the card.")
    public String getCardExpiryYear() {
        return this.cardExpiryYear;
    }

    public void setCardExpiryYear(String cardExpiryYear) {
        this.cardExpiryYear = cardExpiryYear;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethod paymentMethod = (PaymentMethod)o;
        return Objects.equals(this.paymentType, paymentMethod.paymentType) && Objects.equals(this.amount, paymentMethod.amount) && Objects.equals(this.currencyCode, paymentMethod.currencyCode) && Objects.equals(this.paymentGateway, paymentMethod.paymentGateway) && Objects.equals(this.accountName, paymentMethod.accountName) && Objects.equals(this.cardBin, paymentMethod.cardBin) && Objects.equals(this.avsResponseCode, paymentMethod.avsResponseCode) && Objects.equals(this.cvvResponseCode, paymentMethod.cvvResponseCode) && Objects.equals(this.cardLast4, paymentMethod.cardLast4) && Objects.equals(this.cardExpiryMonth, paymentMethod.cardExpiryMonth) && Objects.equals(this.cardExpiryYear, paymentMethod.cardExpiryYear);
    }

    public int hashCode() {
        return Objects.hash(this.paymentType, this.amount, this.currencyCode, this.paymentGateway, this.accountName, this.cardBin, this.avsResponseCode, this.cvvResponseCode, this.cardLast4, this.cardExpiryMonth, this.cardExpiryYear);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethod {\n");
        sb.append("    paymentType: ").append(this.toIndentedString(this.paymentType)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    paymentGateway: ").append(this.toIndentedString(this.paymentGateway)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    cardBin: ").append(this.toIndentedString(this.cardBin)).append("\n");
        sb.append("    avsResponseCode: ").append(this.toIndentedString(this.avsResponseCode)).append("\n");
        sb.append("    cvvResponseCode: ").append(this.toIndentedString(this.cvvResponseCode)).append("\n");
        sb.append("    cardLast4: ").append(this.toIndentedString(this.cardLast4)).append("\n");
        sb.append("    cardExpiryMonth: ").append(this.toIndentedString(this.cardExpiryMonth)).append("\n");
        sb.append("    cardExpiryYear: ").append(this.toIndentedString(this.cardExpiryYear)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

