/*
 * Decompiled with CFR 0.152.
 */
package ai.thirdwatch.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The Promotion field type generically models different kinds of promotions such as referrals, coupons, free trials, etc. The value must be a nested JSON object which you populate with the appropriate information to describe the promotion. Not all sub-fields will likely apply to a given promotion. Populate only those that apply.  A promotion can be added when creating or updating an account, creating or updating an order, or on its own using the add_promotion event. The promotion object supports both monetary (e.g. 500 coupon on first order) and non-monetary (e.g. \"100 in points to refer a friend\"). ")
public class Promotion {
    @SerializedName(value="_promotionId")
    private String promotionId = null;
    @SerializedName(value="_status")
    private String status = null;
    @SerializedName(value="_description")
    private String description = null;
    @SerializedName(value="_amount")
    private String amount = null;
    @SerializedName(value="_minPurchaseAmount")
    private String minPurchaseAmount = null;
    @SerializedName(value="_referrerUserId")
    private String referrerUserId = null;
    @SerializedName(value="_failureReason")
    private String failureReason = null;
    @SerializedName(value="_percentageOff")
    private String percentageOff = null;
    @SerializedName(value="_currencyCode")
    private String currencyCode = null;
    @SerializedName(value="_type")
    private String type = null;

    public Promotion promotionId(String promotionId) {
        this.promotionId = promotionId;
        return this;
    }

    @ApiModelProperty(value="The ID/Coupon Code within your system that you use to represent this promotion. This ID is ideally unique to the promotion across users (e.g. \"Welcome\").")
    public String getPromotionId() {
        return this.promotionId;
    }

    public void setPromotionId(String promotionId) {
        this.promotionId = promotionId;
    }

    public Promotion status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the addition of promotion to an account. Best used with the add_promotion event. This way you can pass to Thirdwatch both successful and failed attempts when using a promotion. May be useful in spotting potential abuse. e.g. _success, _Failed")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Promotion description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Describe promotion here.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Promotion amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="The amount or credits the promotion is worth.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public Promotion minPurchaseAmount(String minPurchaseAmount) {
        this.minPurchaseAmount = minPurchaseAmount;
        return this;
    }

    @ApiModelProperty(value="The minimum amount someone must spend in order for the promotion to be applied.")
    public String getMinPurchaseAmount() {
        return this.minPurchaseAmount;
    }

    public void setMinPurchaseAmount(String minPurchaseAmount) {
        this.minPurchaseAmount = minPurchaseAmount;
    }

    public Promotion referrerUserId(String referrerUserId) {
        this.referrerUserId = referrerUserId;
        return this;
    }

    @ApiModelProperty(value="The unique user ID of the user who referred the user to this promotion.")
    public String getReferrerUserId() {
        return this.referrerUserId;
    }

    public void setReferrerUserId(String referrerUserId) {
        this.referrerUserId = referrerUserId;
    }

    public Promotion failureReason(String failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @ApiModelProperty(value="When adding a promotion fails, use this to describe why it failed.e.g. _alreadyUsed, _invalidCode, _notApplicable, _expired")
    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public Promotion percentageOff(String percentageOff) {
        this.percentageOff = percentageOff;
        return this;
    }

    @ApiModelProperty(value="The percentage discount. If the discount is 10% off, you would send \"10\".")
    public String getPercentageOff() {
        return this.percentageOff;
    }

    public void setPercentageOff(String percentageOff) {
        this.percentageOff = percentageOff;
    }

    public Promotion currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="The [ISO-4217](http://en.wikipedia.org/wiki/ISO_4217) currency code for the amount. e.g., USD, INR alternative currencies, like bitcoin or points systems.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Promotion type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Type of the promotion e.g., First Time, Refer, Diwali")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Promotion promotion = (Promotion)o;
        return Objects.equals(this.promotionId, promotion.promotionId) && Objects.equals(this.status, promotion.status) && Objects.equals(this.description, promotion.description) && Objects.equals(this.amount, promotion.amount) && Objects.equals(this.minPurchaseAmount, promotion.minPurchaseAmount) && Objects.equals(this.referrerUserId, promotion.referrerUserId) && Objects.equals(this.failureReason, promotion.failureReason) && Objects.equals(this.percentageOff, promotion.percentageOff) && Objects.equals(this.currencyCode, promotion.currencyCode) && Objects.equals(this.type, promotion.type);
    }

    public int hashCode() {
        return Objects.hash(this.promotionId, this.status, this.description, this.amount, this.minPurchaseAmount, this.referrerUserId, this.failureReason, this.percentageOff, this.currencyCode, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Promotion {\n");
        sb.append("    promotionId: ").append(this.toIndentedString(this.promotionId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    minPurchaseAmount: ").append(this.toIndentedString(this.minPurchaseAmount)).append("\n");
        sb.append("    referrerUserId: ").append(this.toIndentedString(this.referrerUserId)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    percentageOff: ").append(this.toIndentedString(this.percentageOff)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

