/*
 * Decompiled with CFR 0.152.
 */
package ai.thirdwatch.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The Seller field type represents information about the seller. The value must be a nested object with the appropriate item subfields for the given seller. Generally usedwith the order, item or transaction events. ")
public class Seller {
    @SerializedName(value="_sellerId")
    private String sellerId = null;
    @SerializedName(value="_name")
    private String name = null;
    @SerializedName(value="_email")
    private String email = null;
    @SerializedName(value="_phone")
    private String phone = null;
    @SerializedName(value="_createdDate")
    private String createdDate = null;
    @SerializedName(value="_lastUpdatedDate")
    private String lastUpdatedDate = null;
    @SerializedName(value="_onboardingIpAddress")
    private String onboardingIpAddress = null;

    public Seller sellerId(String sellerId) {
        this.sellerId = sellerId;
        return this;
    }

    @ApiModelProperty(value="The seller\u2019s internal account ID. This field is required on all events required seller info.")
    public String getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public Seller name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Provide the full name associated with the seller here. Concatenate first name and last name together if you collect them separately in your system.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Seller email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="Email of the seller. Note - If the seller's email is also their account ID in your system, set both the _sellerId and _email fields to their email address.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Seller phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(value="The primary phone number of the seller associated with this account. Provide the phone number as a string.")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Seller createdDate(String createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(value="Date when seller registered in system.")
    public String getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
    }

    public Seller lastUpdatedDate(String lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
        return this;
    }

    @ApiModelProperty(value="Date when seller profile uopdated last time.")
    public String getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(String lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
    }

    public Seller onboardingIpAddress(String onboardingIpAddress) {
        this.onboardingIpAddress = onboardingIpAddress;
        return this;
    }

    @ApiModelProperty(value="Ip address used by seller while registration.")
    public String getOnboardingIpAddress() {
        return this.onboardingIpAddress;
    }

    public void setOnboardingIpAddress(String onboardingIpAddress) {
        this.onboardingIpAddress = onboardingIpAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Seller seller = (Seller)o;
        return Objects.equals(this.sellerId, seller.sellerId) && Objects.equals(this.name, seller.name) && Objects.equals(this.email, seller.email) && Objects.equals(this.phone, seller.phone) && Objects.equals(this.createdDate, seller.createdDate) && Objects.equals(this.lastUpdatedDate, seller.lastUpdatedDate) && Objects.equals(this.onboardingIpAddress, seller.onboardingIpAddress);
    }

    public int hashCode() {
        return Objects.hash(this.sellerId, this.name, this.email, this.phone, this.createdDate, this.lastUpdatedDate, this.onboardingIpAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Seller {\n");
        sb.append("    sellerId: ").append(this.toIndentedString(this.sellerId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdatedDate: ").append(this.toIndentedString(this.lastUpdatedDate)).append("\n");
        sb.append("    onboardingIpAddress: ").append(this.toIndentedString(this.onboardingIpAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

