/*
 * Decompiled with CFR 0.152.
 */
package ai.thirdwatch.model;

import ai.thirdwatch.model.CustomInfo;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class SendMessage {
    @SerializedName(value="_userId")
    private String userId = null;
    @SerializedName(value="_sessionId")
    private String sessionId = null;
    @SerializedName(value="_deviceIp")
    private String deviceIp = null;
    @SerializedName(value="_originTimestamp")
    private String originTimestamp = null;
    @SerializedName(value="_recipientUserId")
    private String recipientUserId = null;
    @SerializedName(value="_subject")
    private String subject = null;
    @SerializedName(value="_content")
    private String content = null;
    @SerializedName(value="_customInfo")
    private CustomInfo customInfo = null;

    public SendMessage userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(value="The user's account ID according to your systems. Note that user IDs are case sensitive.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public SendMessage sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(value="The user's current session ID, used to tie a user's action before and after login or account creation. Required if no user_id values is provided.")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public SendMessage deviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
        return this;
    }

    @ApiModelProperty(value="IP address of the request made by the user. Recommended for historical backfills and customers with mobile apps.")
    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public SendMessage originTimestamp(String originTimestamp) {
        this.originTimestamp = originTimestamp;
        return this;
    }

    @ApiModelProperty(value="Represents the time the event occured in your system. Send as a UNIX timestamp in milliseconds in string.")
    public String getOriginTimestamp() {
        return this.originTimestamp;
    }

    public void setOriginTimestamp(String originTimestamp) {
        this.originTimestamp = originTimestamp;
    }

    public SendMessage recipientUserId(String recipientUserId) {
        this.recipientUserId = recipientUserId;
        return this;
    }

    @ApiModelProperty(value="_userID of the receiving user by default Store.")
    public String getRecipientUserId() {
        return this.recipientUserId;
    }

    public void setRecipientUserId(String recipientUserId) {
        this.recipientUserId = recipientUserId;
    }

    public SendMessage subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(value="The subject of the message.")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public SendMessage content(String content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(value="The text content of the message.")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public SendMessage customInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public CustomInfo getCustomInfo() {
        return this.customInfo;
    }

    public void setCustomInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendMessage sendMessage = (SendMessage)o;
        return Objects.equals(this.userId, sendMessage.userId) && Objects.equals(this.sessionId, sendMessage.sessionId) && Objects.equals(this.deviceIp, sendMessage.deviceIp) && Objects.equals(this.originTimestamp, sendMessage.originTimestamp) && Objects.equals(this.recipientUserId, sendMessage.recipientUserId) && Objects.equals(this.subject, sendMessage.subject) && Objects.equals(this.content, sendMessage.content) && Objects.equals(this.customInfo, sendMessage.customInfo);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.sessionId, this.deviceIp, this.originTimestamp, this.recipientUserId, this.subject, this.content, this.customInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SendMessage {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    deviceIp: ").append(this.toIndentedString(this.deviceIp)).append("\n");
        sb.append("    originTimestamp: ").append(this.toIndentedString(this.originTimestamp)).append("\n");
        sb.append("    recipientUserId: ").append(this.toIndentedString(this.recipientUserId)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    customInfo: ").append(this.toIndentedString(this.customInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

