/*
 * Decompiled with CFR 0.152.
 */
package ai.thirdwatch.model;

import ai.thirdwatch.model.CustomInfo;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class Tag {
    @SerializedName(value="_userId")
    private String userId = null;
    @SerializedName(value="_isBad")
    private Boolean isBad = null;
    @SerializedName(value="_abuseType")
    private String abuseType = null;
    @SerializedName(value="_description")
    private String description = null;
    @SerializedName(value="_source")
    private String source = null;
    @SerializedName(value="_analyst")
    private String analyst = null;
    @SerializedName(value="_customInfo")
    private CustomInfo customInfo = null;

    public Tag userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(value="The user's account ID according to your systems. Note that user IDs are case sensitive.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Tag isBad(Boolean isBad) {
        this.isBad = isBad;
        return this;
    }

    @ApiModelProperty(value="Indicates whether a user is engaging in behavior deemed harmful to your business. Set to true if the user is engaging in abusive activity. Set to false if the user is engaging in valid activity.")
    public Boolean getIsBad() {
        return this.isBad;
    }

    public void setIsBad(Boolean isBad) {
        this.isBad = isBad;
    }

    public Tag abuseType(String abuseType) {
        this.abuseType = abuseType;
        return this;
    }

    @ApiModelProperty(value="The type of abuse for which you want to send a tag. It's important to send a tag specific to the type of abuse the user is committing so that thirdwatch can learn about specific patterns of behavior. You'll end up with more accurate results this way. e.g. _paymentAbuse, _contentAbuse, _promotionAbuse, _accountAbuse")
    public String getAbuseType() {
        return this.abuseType;
    }

    public void setAbuseType(String abuseType) {
        this.abuseType = abuseType;
    }

    public Tag description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The text content of the tag.Useful as annotation on why the label was added.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Tag source(String source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(value="String describing the original source of the tag information (e.g. payment gateway, manual review, etc.).")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Tag analyst(String analyst) {
        this.analyst = analyst;
        return this;
    }

    @ApiModelProperty(value="Unique identifier (e.g. email address) of the analyst who applied the label. Useful for tracking purposes after the fact.")
    public String getAnalyst() {
        return this.analyst;
    }

    public void setAnalyst(String analyst) {
        this.analyst = analyst;
    }

    public Tag customInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public CustomInfo getCustomInfo() {
        return this.customInfo;
    }

    public void setCustomInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        return Objects.equals(this.userId, tag.userId) && Objects.equals(this.isBad, tag.isBad) && Objects.equals(this.abuseType, tag.abuseType) && Objects.equals(this.description, tag.description) && Objects.equals(this.source, tag.source) && Objects.equals(this.analyst, tag.analyst) && Objects.equals(this.customInfo, tag.customInfo);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.isBad, this.abuseType, this.description, this.source, this.analyst, this.customInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Tag {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    isBad: ").append(this.toIndentedString(this.isBad)).append("\n");
        sb.append("    abuseType: ").append(this.toIndentedString(this.abuseType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    analyst: ").append(this.toIndentedString(this.analyst)).append("\n");
        sb.append("    customInfo: ").append(this.toIndentedString(this.customInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

