/*
 * Decompiled with CFR 0.152.
 */
package ai.thirdwatch.model;

import ai.thirdwatch.model.BillingAddress;
import ai.thirdwatch.model.CustomInfo;
import ai.thirdwatch.model.PaymentMethod;
import ai.thirdwatch.model.ShippingAddress;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class Transaction {
    @SerializedName(value="_userId")
    private String userId = null;
    @SerializedName(value="_sessionId")
    private String sessionId = null;
    @SerializedName(value="_orderId")
    private String orderId = null;
    @SerializedName(value="_transactionId")
    private String transactionId = null;
    @SerializedName(value="_deviceIp")
    private String deviceIp = null;
    @SerializedName(value="_originTimestamp")
    private String originTimestamp = null;
    @SerializedName(value="_userEmail")
    private String userEmail = null;
    @SerializedName(value="_amount")
    private String amount = null;
    @SerializedName(value="_currencyCode")
    private String currencyCode = null;
    @SerializedName(value="_transactionType")
    private String transactionType = null;
    @SerializedName(value="_transactionStatus")
    private String transactionStatus = null;
    @SerializedName(value="_isFirstTimeBuyer")
    private Boolean isFirstTimeBuyer = null;
    @SerializedName(value="_billingAddress")
    private BillingAddress billingAddress = null;
    @SerializedName(value="_shippingAddress")
    private ShippingAddress shippingAddress = null;
    @SerializedName(value="_paymentMethod")
    private PaymentMethod paymentMethod = null;
    @SerializedName(value="_customInfo")
    private CustomInfo customInfo = null;

    public Transaction userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(value="The user's account ID according to your systems. Note that user IDs are case sensitive.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Transaction sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(value="The user's current session ID, used to tie a user's action before and after login or account creation. Required if no user_id values is provided.")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Transaction orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID for tracking this order in your system.")
    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Transaction transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(value="The ID for identifying this transaction. Important for tracking transactions, and linking different parts of the same transaction together, e.g., linking a refund to its original transaction.")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public Transaction deviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
        return this;
    }

    @ApiModelProperty(value="IP address of the request made by the user. Recommended for historical backfills and customers with mobile apps.")
    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public Transaction originTimestamp(String originTimestamp) {
        this.originTimestamp = originTimestamp;
        return this;
    }

    @ApiModelProperty(value="Represents the time the event occured in your system. Send as a UNIX timestamp in milliseconds in string.")
    public String getOriginTimestamp() {
        return this.originTimestamp;
    }

    public void setOriginTimestamp(String originTimestamp) {
        this.originTimestamp = originTimestamp;
    }

    public Transaction userEmail(String userEmail) {
        this.userEmail = userEmail;
        return this;
    }

    @ApiModelProperty(value="Email of the user creating this order. Note - If the user's email is also their account ID in your system, set both the userId and userEmail fields to their email address.")
    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public Transaction amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="The item unit price in numbers, in the base unit of the currency_code.e.g. \"2500\"")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public Transaction currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="The [ISO-4217](http://en.wikipedia.org/wiki/ISO_4217) currency code for the amount. e.g., USD, INR alternative currencies, like bitcoin or points systems.")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Transaction transactionType(String transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @ApiModelProperty(value="The type of transaction being recorded. e.g. _sale, _authorize, _capture, _void, _refund, _deposit, _withdrawal, _transfer")
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public Transaction transactionStatus(String transactionStatus) {
        this.transactionStatus = transactionStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="Use _transactionStatus to indicate the status of the transaction. The value can be \"_success\" (default value), \"_failure\" or \"_pending\". For instance, If the transaction was rejected by the payment gateway, set the value to \"_failure\".")
    public String getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(String transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public Transaction isFirstTimeBuyer(Boolean isFirstTimeBuyer) {
        this.isFirstTimeBuyer = isFirstTimeBuyer;
        return this;
    }

    @ApiModelProperty(value="Is user first time buyer.")
    public Boolean getIsFirstTimeBuyer() {
        return this.isFirstTimeBuyer;
    }

    public void setIsFirstTimeBuyer(Boolean isFirstTimeBuyer) {
        this.isFirstTimeBuyer = isFirstTimeBuyer;
    }

    public Transaction billingAddress(BillingAddress billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public BillingAddress getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(BillingAddress billingAddress) {
        this.billingAddress = billingAddress;
    }

    public Transaction shippingAddress(ShippingAddress shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public ShippingAddress getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(ShippingAddress shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public Transaction paymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(value="")
    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public Transaction customInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public CustomInfo getCustomInfo() {
        return this.customInfo;
    }

    public void setCustomInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction transaction = (Transaction)o;
        return Objects.equals(this.userId, transaction.userId) && Objects.equals(this.sessionId, transaction.sessionId) && Objects.equals(this.orderId, transaction.orderId) && Objects.equals(this.transactionId, transaction.transactionId) && Objects.equals(this.deviceIp, transaction.deviceIp) && Objects.equals(this.originTimestamp, transaction.originTimestamp) && Objects.equals(this.userEmail, transaction.userEmail) && Objects.equals(this.amount, transaction.amount) && Objects.equals(this.currencyCode, transaction.currencyCode) && Objects.equals(this.transactionType, transaction.transactionType) && Objects.equals(this.transactionStatus, transaction.transactionStatus) && Objects.equals(this.isFirstTimeBuyer, transaction.isFirstTimeBuyer) && Objects.equals(this.billingAddress, transaction.billingAddress) && Objects.equals(this.shippingAddress, transaction.shippingAddress) && Objects.equals(this.paymentMethod, transaction.paymentMethod) && Objects.equals(this.customInfo, transaction.customInfo);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.sessionId, this.orderId, this.transactionId, this.deviceIp, this.originTimestamp, this.userEmail, this.amount, this.currencyCode, this.transactionType, this.transactionStatus, this.isFirstTimeBuyer, this.billingAddress, this.shippingAddress, this.paymentMethod, this.customInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transaction {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    deviceIp: ").append(this.toIndentedString(this.deviceIp)).append("\n");
        sb.append("    originTimestamp: ").append(this.toIndentedString(this.originTimestamp)).append("\n");
        sb.append("    userEmail: ").append(this.toIndentedString(this.userEmail)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        sb.append("    transactionStatus: ").append(this.toIndentedString(this.transactionStatus)).append("\n");
        sb.append("    isFirstTimeBuyer: ").append(this.toIndentedString(this.isFirstTimeBuyer)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    shippingAddress: ").append(this.toIndentedString(this.shippingAddress)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    customInfo: ").append(this.toIndentedString(this.customInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

