/*
 * Decompiled with CFR 0.152.
 */
package ai.thirdwatch.model;

import ai.thirdwatch.model.BillingAddress;
import ai.thirdwatch.model.CustomInfo;
import ai.thirdwatch.model.PaymentMethod;
import ai.thirdwatch.model.Promotion;
import ai.thirdwatch.model.ShippingAddress;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateAccount {
    @SerializedName(value="_userId")
    private String userId = null;
    @SerializedName(value="_sessionId")
    private String sessionId = null;
    @SerializedName(value="_deviceIp")
    private String deviceIp = null;
    @SerializedName(value="_originTimestamp")
    private String originTimestamp = null;
    @SerializedName(value="_userEmail")
    private String userEmail = null;
    @SerializedName(value="_firstName")
    private String firstName = null;
    @SerializedName(value="_lastName")
    private String lastName = null;
    @SerializedName(value="_phone")
    private String phone = null;
    @SerializedName(value="_age")
    private String age = null;
    @SerializedName(value="_gender")
    private String gender = null;
    @SerializedName(value="_referralCode")
    private String referralCode = null;
    @SerializedName(value="_referrerUserId")
    private String referrerUserId = null;
    @SerializedName(value="_billingAddress")
    private BillingAddress billingAddress = null;
    @SerializedName(value="_shippingAddress")
    private ShippingAddress shippingAddress = null;
    @SerializedName(value="_paymentMethods")
    private List<PaymentMethod> paymentMethods = null;
    @SerializedName(value="_promotions")
    private List<Promotion> promotions = null;
    @SerializedName(value="_socialSignOnType")
    private String socialSignOnType = null;
    @SerializedName(value="_emailConfirmedStatus")
    private String emailConfirmedStatus = null;
    @SerializedName(value="_phoneConfirmedStatus")
    private String phoneConfirmedStatus = null;
    @SerializedName(value="_isNewsletterSubscribed")
    private Boolean isNewsletterSubscribed = null;
    @SerializedName(value="_accountStatus")
    private String accountStatus = null;
    @SerializedName(value="_facebookId")
    private String facebookId = null;
    @SerializedName(value="_googleId")
    private String googleId = null;
    @SerializedName(value="_twitterId")
    private String twitterId = null;
    @SerializedName(value="_customInfo")
    private CustomInfo customInfo = null;

    public UpdateAccount userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(value="The user's account ID according to your systems. Note that user IDs are case sensitive.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public UpdateAccount sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(value="The user's current session ID, used to tie a user's action before and after login or account creation. Required if no user_id values is provided.")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public UpdateAccount deviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
        return this;
    }

    @ApiModelProperty(value="IP address of the request made by the user. Recommended for historical backfills and customers with mobile apps.")
    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public UpdateAccount originTimestamp(String originTimestamp) {
        this.originTimestamp = originTimestamp;
        return this;
    }

    @ApiModelProperty(value="Represents the time the event occured in your system. Send as a UNIX timestamp in milliseconds in string.")
    public String getOriginTimestamp() {
        return this.originTimestamp;
    }

    public void setOriginTimestamp(String originTimestamp) {
        this.originTimestamp = originTimestamp;
    }

    public UpdateAccount userEmail(String userEmail) {
        this.userEmail = userEmail;
        return this;
    }

    @ApiModelProperty(value="Email of the user creating this order. Note - If the user's email is also their account ID in your system, set both the userId and userEmail fields to their email address.")
    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public UpdateAccount firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(value="Provide the first name associated with the user here.")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public UpdateAccount lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(value="Provide the last name associated with the user here.")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public UpdateAccount phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(value="The primary phone number of the user associated with this account. Provide the phone number as a string.")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public UpdateAccount age(String age) {
        this.age = age;
        return this;
    }

    @ApiModelProperty(value="Age of the user e.g. \"25\"")
    public String getAge() {
        return this.age;
    }

    public void setAge(String age) {
        this.age = age;
    }

    public UpdateAccount gender(String gender) {
        this.gender = gender;
        return this;
    }

    @ApiModelProperty(value="Gender of the user e.g. \"_male\", \"_female\" or \"_trans\"")
    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public UpdateAccount referralCode(String referralCode) {
        this.referralCode = referralCode;
        return this;
    }

    @ApiModelProperty(value="Code or promotion used by the user while creating account.")
    public String getReferralCode() {
        return this.referralCode;
    }

    public void setReferralCode(String referralCode) {
        this.referralCode = referralCode;
    }

    public UpdateAccount referrerUserId(String referrerUserId) {
        this.referrerUserId = referrerUserId;
        return this;
    }

    @ApiModelProperty(value="The ID of the user that referred the current user to your business. This field is required for detecting referral fraud.")
    public String getReferrerUserId() {
        return this.referrerUserId;
    }

    public void setReferrerUserId(String referrerUserId) {
        this.referrerUserId = referrerUserId;
    }

    public UpdateAccount billingAddress(BillingAddress billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public BillingAddress getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(BillingAddress billingAddress) {
        this.billingAddress = billingAddress;
    }

    public UpdateAccount shippingAddress(ShippingAddress shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public ShippingAddress getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(ShippingAddress shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public UpdateAccount paymentMethods(List<PaymentMethod> paymentMethods) {
        this.paymentMethods = paymentMethods;
        return this;
    }

    public UpdateAccount addPaymentMethodsItem(PaymentMethod paymentMethodsItem) {
        if (this.paymentMethods == null) {
            this.paymentMethods = new ArrayList<PaymentMethod>();
        }
        this.paymentMethods.add(paymentMethodsItem);
        return this;
    }

    @ApiModelProperty(value="The payment information associated with this account. Represented as an array of nested payment_method objects containing payment type, payment gateway, credit card bin, etc.")
    public List<PaymentMethod> getPaymentMethods() {
        return this.paymentMethods;
    }

    public void setPaymentMethods(List<PaymentMethod> paymentMethods) {
        this.paymentMethods = paymentMethods;
    }

    public UpdateAccount promotions(List<Promotion> promotions) {
        this.promotions = promotions;
        return this;
    }

    public UpdateAccount addPromotionsItem(Promotion promotionsItem) {
        if (this.promotions == null) {
            this.promotions = new ArrayList<Promotion>();
        }
        this.promotions.add(promotionsItem);
        return this;
    }

    @ApiModelProperty(value="The list of promotions that apply to this account. You can add one or more promotions when creating or updating an order. Represented as a JSON array of promotion objects. You can also separately add promotions to the account via the addPromotion event.")
    public List<Promotion> getPromotions() {
        return this.promotions;
    }

    public void setPromotions(List<Promotion> promotions) {
        this.promotions = promotions;
    }

    public UpdateAccount socialSignOnType(String socialSignOnType) {
        this.socialSignOnType = socialSignOnType;
        return this;
    }

    @ApiModelProperty(value="If the user logged in with a social identify provider, give the name here. e.g. _google, _facebook, _twitter, _linkedin, _other")
    public String getSocialSignOnType() {
        return this.socialSignOnType;
    }

    public void setSocialSignOnType(String socialSignOnType) {
        this.socialSignOnType = socialSignOnType;
    }

    public UpdateAccount emailConfirmedStatus(String emailConfirmedStatus) {
        this.emailConfirmedStatus = emailConfirmedStatus;
        return this;
    }

    @ApiModelProperty(value="Status of email verification. e.g. _success, _failure, _pending")
    public String getEmailConfirmedStatus() {
        return this.emailConfirmedStatus;
    }

    public void setEmailConfirmedStatus(String emailConfirmedStatus) {
        this.emailConfirmedStatus = emailConfirmedStatus;
    }

    public UpdateAccount phoneConfirmedStatus(String phoneConfirmedStatus) {
        this.phoneConfirmedStatus = phoneConfirmedStatus;
        return this;
    }

    @ApiModelProperty(value="Status of phone verification. e.g. _success, _failure, _pending")
    public String getPhoneConfirmedStatus() {
        return this.phoneConfirmedStatus;
    }

    public void setPhoneConfirmedStatus(String phoneConfirmedStatus) {
        this.phoneConfirmedStatus = phoneConfirmedStatus;
    }

    public UpdateAccount isNewsletterSubscribed(Boolean isNewsletterSubscribed) {
        this.isNewsletterSubscribed = isNewsletterSubscribed;
        return this;
    }

    @ApiModelProperty(value="Is user subscribed for newsletter. e.g. true, false")
    public Boolean getIsNewsletterSubscribed() {
        return this.isNewsletterSubscribed;
    }

    public void setIsNewsletterSubscribed(Boolean isNewsletterSubscribed) {
        this.isNewsletterSubscribed = isNewsletterSubscribed;
    }

    public UpdateAccount accountStatus(String accountStatus) {
        this.accountStatus = accountStatus;
        return this;
    }

    @ApiModelProperty(value="Current status of account, e.g. _active, _inactive")
    public String getAccountStatus() {
        return this.accountStatus;
    }

    public void setAccountStatus(String accountStatus) {
        this.accountStatus = accountStatus;
    }

    public UpdateAccount facebookId(String facebookId) {
        this.facebookId = facebookId;
        return this;
    }

    @ApiModelProperty(value="Facebook user id or token of the user. This can help to varify his social identity.")
    public String getFacebookId() {
        return this.facebookId;
    }

    public void setFacebookId(String facebookId) {
        this.facebookId = facebookId;
    }

    public UpdateAccount googleId(String googleId) {
        this.googleId = googleId;
        return this;
    }

    @ApiModelProperty(value="Google user id or token of the user. This can help to varify his social identity.")
    public String getGoogleId() {
        return this.googleId;
    }

    public void setGoogleId(String googleId) {
        this.googleId = googleId;
    }

    public UpdateAccount twitterId(String twitterId) {
        this.twitterId = twitterId;
        return this;
    }

    @ApiModelProperty(value="Twitter handle or token of the user. This can help to varify his social identity.")
    public String getTwitterId() {
        return this.twitterId;
    }

    public void setTwitterId(String twitterId) {
        this.twitterId = twitterId;
    }

    public UpdateAccount customInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public CustomInfo getCustomInfo() {
        return this.customInfo;
    }

    public void setCustomInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateAccount updateAccount = (UpdateAccount)o;
        return Objects.equals(this.userId, updateAccount.userId) && Objects.equals(this.sessionId, updateAccount.sessionId) && Objects.equals(this.deviceIp, updateAccount.deviceIp) && Objects.equals(this.originTimestamp, updateAccount.originTimestamp) && Objects.equals(this.userEmail, updateAccount.userEmail) && Objects.equals(this.firstName, updateAccount.firstName) && Objects.equals(this.lastName, updateAccount.lastName) && Objects.equals(this.phone, updateAccount.phone) && Objects.equals(this.age, updateAccount.age) && Objects.equals(this.gender, updateAccount.gender) && Objects.equals(this.referralCode, updateAccount.referralCode) && Objects.equals(this.referrerUserId, updateAccount.referrerUserId) && Objects.equals(this.billingAddress, updateAccount.billingAddress) && Objects.equals(this.shippingAddress, updateAccount.shippingAddress) && Objects.equals(this.paymentMethods, updateAccount.paymentMethods) && Objects.equals(this.promotions, updateAccount.promotions) && Objects.equals(this.socialSignOnType, updateAccount.socialSignOnType) && Objects.equals(this.emailConfirmedStatus, updateAccount.emailConfirmedStatus) && Objects.equals(this.phoneConfirmedStatus, updateAccount.phoneConfirmedStatus) && Objects.equals(this.isNewsletterSubscribed, updateAccount.isNewsletterSubscribed) && Objects.equals(this.accountStatus, updateAccount.accountStatus) && Objects.equals(this.facebookId, updateAccount.facebookId) && Objects.equals(this.googleId, updateAccount.googleId) && Objects.equals(this.twitterId, updateAccount.twitterId) && Objects.equals(this.customInfo, updateAccount.customInfo);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.sessionId, this.deviceIp, this.originTimestamp, this.userEmail, this.firstName, this.lastName, this.phone, this.age, this.gender, this.referralCode, this.referrerUserId, this.billingAddress, this.shippingAddress, this.paymentMethods, this.promotions, this.socialSignOnType, this.emailConfirmedStatus, this.phoneConfirmedStatus, this.isNewsletterSubscribed, this.accountStatus, this.facebookId, this.googleId, this.twitterId, this.customInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateAccount {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    deviceIp: ").append(this.toIndentedString(this.deviceIp)).append("\n");
        sb.append("    originTimestamp: ").append(this.toIndentedString(this.originTimestamp)).append("\n");
        sb.append("    userEmail: ").append(this.toIndentedString(this.userEmail)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    age: ").append(this.toIndentedString(this.age)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString(this.gender)).append("\n");
        sb.append("    referralCode: ").append(this.toIndentedString(this.referralCode)).append("\n");
        sb.append("    referrerUserId: ").append(this.toIndentedString(this.referrerUserId)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    shippingAddress: ").append(this.toIndentedString(this.shippingAddress)).append("\n");
        sb.append("    paymentMethods: ").append(this.toIndentedString(this.paymentMethods)).append("\n");
        sb.append("    promotions: ").append(this.toIndentedString(this.promotions)).append("\n");
        sb.append("    socialSignOnType: ").append(this.toIndentedString(this.socialSignOnType)).append("\n");
        sb.append("    emailConfirmedStatus: ").append(this.toIndentedString(this.emailConfirmedStatus)).append("\n");
        sb.append("    phoneConfirmedStatus: ").append(this.toIndentedString(this.phoneConfirmedStatus)).append("\n");
        sb.append("    isNewsletterSubscribed: ").append(this.toIndentedString(this.isNewsletterSubscribed)).append("\n");
        sb.append("    accountStatus: ").append(this.toIndentedString(this.accountStatus)).append("\n");
        sb.append("    facebookId: ").append(this.toIndentedString(this.facebookId)).append("\n");
        sb.append("    googleId: ").append(this.toIndentedString(this.googleId)).append("\n");
        sb.append("    twitterId: ").append(this.toIndentedString(this.twitterId)).append("\n");
        sb.append("    customInfo: ").append(this.toIndentedString(this.customInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

