/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public record AnnotationMetadata(Class<? extends Annotation> annotationType, Map<String, Object> annotationValueMap) {
    public void addAnnotationTo(ClassVisitor classVisitor) {
        this.visitAnnotation(classVisitor.visitAnnotation(Type.getDescriptor(this.annotationType), true));
    }

    public void addAnnotationTo(FieldVisitor fieldVisitor) {
        this.visitAnnotation(fieldVisitor.visitAnnotation(Type.getDescriptor(this.annotationType), true));
    }

    public void addAnnotationTo(MethodVisitor methodVisitor) {
        this.visitAnnotation(methodVisitor.visitAnnotation(Type.getDescriptor(this.annotationType), true));
    }

    public static List<AnnotationMetadata> getAnnotationListWithoutRepeatable(List<AnnotationMetadata> metadata) {
        ArrayList<AnnotationMetadata> out = new ArrayList<AnnotationMetadata>();
        LinkedHashMap<Class, List> repeatableAnnotationMap = new LinkedHashMap<Class, List>();
        for (AnnotationMetadata annotationMetadata : metadata) {
            Repeatable repeatable = annotationMetadata.annotationType().getAnnotation(Repeatable.class);
            if (repeatable == null) {
                out.add(annotationMetadata);
                continue;
            }
            Class<? extends Annotation> annotationContainer = repeatable.value();
            repeatableAnnotationMap.computeIfAbsent(annotationContainer, ignored -> new ArrayList()).add(annotationMetadata);
        }
        for (Map.Entry entry : repeatableAnnotationMap.entrySet()) {
            out.add(new AnnotationMetadata((Class)entry.getKey(), Map.of("value", ((List)entry.getValue()).toArray(AnnotationMetadata[]::new))));
        }
        return out;
    }

    public static Type getValueAsType(String className) {
        return Type.getType((String)("L" + className.replace('.', '/') + ";"));
    }

    private void visitAnnotation(AnnotationVisitor annotationVisitor) {
        for (Map.Entry<String, Object> entry : this.annotationValueMap.entrySet()) {
            String annotationAttributeName = entry.getKey();
            Object annotationAttributeValue = entry.getValue();
            this.visitAnnotationAttribute(annotationVisitor, annotationAttributeName, annotationAttributeValue);
        }
        annotationVisitor.visitEnd();
    }

    private void visitAnnotationAttribute(AnnotationVisitor annotationVisitor, String attributeName, Object attributeValue) {
        if (attributeValue instanceof Number || attributeValue instanceof Boolean || attributeValue instanceof Character || attributeValue instanceof String) {
            annotationVisitor.visit(attributeName, attributeValue);
            return;
        }
        if (attributeValue instanceof Type) {
            Type type = (Type)attributeValue;
            annotationVisitor.visit(attributeName, (Object)type);
            return;
        }
        if (attributeValue instanceof AnnotationMetadata) {
            AnnotationMetadata annotationMetadata = (AnnotationMetadata)attributeValue;
            annotationMetadata.visitAnnotation(annotationVisitor.visitAnnotation(attributeName, Type.getDescriptor(annotationMetadata.annotationType)));
            return;
        }
        if (attributeValue instanceof Enum) {
            Enum enumValue = (Enum)attributeValue;
            annotationVisitor.visitEnum(attributeName, Type.getDescriptor(enumValue.getClass()), enumValue.name());
            return;
        }
        if (attributeValue.getClass().isArray()) {
            AnnotationVisitor arrayAnnotationVisitor = annotationVisitor.visitArray(attributeName);
            int arrayLength = Array.getLength(attributeValue);
            for (int i = 0; i < arrayLength; ++i) {
                this.visitAnnotationAttribute(arrayAnnotationVisitor, attributeName, Array.get(attributeValue, i));
            }
            arrayAnnotationVisitor.visitEnd();
            return;
        }
        throw new IllegalArgumentException("Annotation of type %s has an illegal value %s for attribute %s.".formatted(this.annotationType, attributeValue, attributeName));
    }
}

