/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import ai.timefold.jpyinterpreter.AnnotationMetadata;
import ai.timefold.jpyinterpreter.BytecodeSwitchImplementor;
import ai.timefold.jpyinterpreter.CPythonBackedPythonInterpreter;
import ai.timefold.jpyinterpreter.FieldDescriptor;
import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.LocalVariableHelper;
import ai.timefold.jpyinterpreter.MethodDescriptor;
import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.PythonBytecodeToJavaBytecodeTranslator;
import ai.timefold.jpyinterpreter.PythonCompiledClass;
import ai.timefold.jpyinterpreter.PythonCompiledFunction;
import ai.timefold.jpyinterpreter.PythonFunctionSignature;
import ai.timefold.jpyinterpreter.PythonFunctionType;
import ai.timefold.jpyinterpreter.PythonInterpreter;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.TypeHint;
import ai.timefold.jpyinterpreter.dag.FlowGraph;
import ai.timefold.jpyinterpreter.implementors.DelegatingInterfaceImplementor;
import ai.timefold.jpyinterpreter.implementors.JavaComparableImplementor;
import ai.timefold.jpyinterpreter.implementors.JavaEqualsImplementor;
import ai.timefold.jpyinterpreter.implementors.JavaHashCodeImplementor;
import ai.timefold.jpyinterpreter.implementors.JavaInterfaceImplementor;
import ai.timefold.jpyinterpreter.implementors.JavaPythonTypeConversionImplementor;
import ai.timefold.jpyinterpreter.implementors.PythonConstantsImplementor;
import ai.timefold.jpyinterpreter.opcodes.AbstractOpcode;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.opcodes.SelfOpcodeWithoutSource;
import ai.timefold.jpyinterpreter.opcodes.controlflow.ReturnConstantValueOpcode;
import ai.timefold.jpyinterpreter.opcodes.controlflow.ReturnValueOpcode;
import ai.timefold.jpyinterpreter.opcodes.object.DeleteAttrOpcode;
import ai.timefold.jpyinterpreter.opcodes.object.LoadAttrOpcode;
import ai.timefold.jpyinterpreter.opcodes.object.StoreAttrOpcode;
import ai.timefold.jpyinterpreter.opcodes.variable.LoadFastOpcode;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.CPythonBackedPythonLikeObject;
import ai.timefold.jpyinterpreter.types.GeneratedFunctionMethodReference;
import ai.timefold.jpyinterpreter.types.PythonJavaTypeMapping;
import ai.timefold.jpyinterpreter.types.PythonLikeFunction;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonNone;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeDict;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.wrappers.JavaObjectWrapper;
import ai.timefold.jpyinterpreter.types.wrappers.OpaquePythonReference;
import ai.timefold.jpyinterpreter.util.JavaPythonClassWriter;
import ai.timefold.jpyinterpreter.util.arguments.ArgumentSpec;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;

public class PythonClassTranslator {
    static Map<FunctionSignature, InterfaceDeclaration> functionSignatureToInterfaceName = new HashMap<FunctionSignature, InterfaceDeclaration>();
    public static final String TYPE_FIELD_NAME = "$TYPE";
    public static final String CPYTHON_TYPE_FIELD_NAME = "$CPYTHON_TYPE";
    public static final String JAVA_METHOD_PREFIX = "$method$";
    public static final String JAVA_METHOD_HOLDER_PREFIX = "$methodholder$";
    public static final String PYTHON_JAVA_TYPE_MAPPING_PREFIX = "$pythonJavaTypeMapping";

    public static PreparedClassInfo getPreparedClassInfo(String pythonClassName, String module, String qualifiedName) {
        String maybeClassName = "org.jpyinterpreter.user." + PythonCompiledClass.getGeneratedClassBaseName(module, qualifiedName);
        int numberOfInstances = PythonBytecodeToJavaBytecodeTranslator.classNameToSharedInstanceCount.merge(maybeClassName, 1, Integer::sum);
        if (numberOfInstances > 1) {
            maybeClassName = maybeClassName + "$$" + numberOfInstances;
        }
        String className = maybeClassName;
        String internalClassName = className.replace('.', '/');
        return new PreparedClassInfo(PythonLikeType.getTypeForNewClass(pythonClassName, internalClassName), className, internalClassName);
    }

    public static PythonLikeType translatePythonClass(PythonCompiledClass pythonCompiledClass) {
        return PythonClassTranslator.translatePythonClass(pythonCompiledClass, PythonClassTranslator.getPreparedClassInfo(pythonCompiledClass.className, pythonCompiledClass.module, pythonCompiledClass.qualifiedName));
    }

    /*
     * WARNING - void declaration
     */
    public static PythonLikeType translatePythonClass(PythonCompiledClass pythonCompiledClass, PreparedClassInfo preparedClassInfo) {
        InterfaceDeclaration interfaceDeclaration;
        Class<?> generatedClass;
        void var16_46;
        Set<PythonLikeType> superTypeSet;
        String className = preparedClassInfo.className;
        String internalClassName = preparedClassInfo.classInternalName;
        HashMap<String, InterfaceDeclaration> instanceMethodNameToMethodDescriptor = new HashMap<String, InterfaceDeclaration>();
        HashSet<JavaInterfaceImplementor> javaInterfaceImplementorSet = new HashSet<JavaInterfaceImplementor>();
        for (Map.Entry<String, PythonCompiledFunction> entry : pythonCompiledClass.instanceFunctionNameToPythonBytecode.entrySet()) {
            switch (entry.getKey()) {
                case "__eq__": {
                    javaInterfaceImplementorSet.add(new JavaEqualsImplementor(internalClassName));
                    break;
                }
                case "__hash__": {
                    javaInterfaceImplementorSet.add(new JavaHashCodeImplementor(internalClassName));
                    break;
                }
                case "__lt__": 
                case "__le__": 
                case "__gt__": 
                case "__ge__": {
                    javaInterfaceImplementorSet.add(new JavaComparableImplementor(internalClassName, entry.getKey()));
                }
            }
        }
        for (Class clazz : pythonCompiledClass.javaInterfaces) {
            javaInterfaceImplementorSet.add(new DelegatingInterfaceImplementor(internalClassName, clazz, instanceMethodNameToMethodDescriptor));
        }
        if (pythonCompiledClass.superclassList.isEmpty()) {
            superTypeSet = Set.of(CPythonBackedPythonLikeObject.CPYTHON_BACKED_OBJECT_TYPE);
        } else {
            superTypeSet = new LinkedHashSet<PythonLikeType>(pythonCompiledClass.superclassList.size());
            for (int i = 0; i < pythonCompiledClass.superclassList.size(); ++i) {
                PythonLikeType pythonLikeType = pythonCompiledClass.superclassList.get(i);
                if (pythonLikeType == BuiltinTypes.BASE_TYPE || pythonLikeType == null) {
                    superTypeSet.add(CPythonBackedPythonLikeObject.CPYTHON_BACKED_OBJECT_TYPE);
                    continue;
                }
                superTypeSet.add(pythonLikeType);
            }
        }
        ArrayList<PythonLikeType> superTypeList = new ArrayList<PythonLikeType>(superTypeSet);
        PythonLikeType pythonLikeType = preparedClassInfo.type;
        pythonLikeType.initializeNewType(superTypeList);
        PythonLikeType superClassType = (PythonLikeType)superTypeList.get(0);
        HashSet<String> instanceAttributeSet = new HashSet<String>();
        pythonCompiledClass.instanceFunctionNameToPythonBytecode.values().forEach(instanceMethod -> {
            try {
                instanceAttributeSet.addAll(PythonClassTranslator.getReferencedSelfAttributes(instanceMethod));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("WARNING: Ignoring exception");
                System.out.println("Instructions:");
                System.out.println(instanceMethod.instructionList.stream().map(PythonBytecodeInstruction::toString).collect(Collectors.joining("\n")));
            }
        });
        List<JavaInterfaceImplementor> nonObjectInterfaceImplementors = javaInterfaceImplementorSet.stream().filter(implementor -> !Object.class.equals(implementor.getInterfaceClass())).toList();
        String[] interfaces = new String[nonObjectInterfaceImplementors.size()];
        for (int i = 0; i < nonObjectInterfaceImplementors.size(); ++i) {
            interfaces[i] = Type.getInternalName(nonObjectInterfaceImplementors.get(i).getInterfaceClass());
        }
        JavaPythonClassWriter classWriter = new JavaPythonClassWriter(3);
        classWriter.visit(55, 1, internalClassName, null, superClassType.getJavaTypeInternalName(), interfaces);
        classWriter.visitSource(pythonCompiledClass.moduleFilePath, null);
        for (AnnotationMetadata annotationMetadata : AnnotationMetadata.getAnnotationListWithoutRepeatable(pythonCompiledClass.annotations)) {
            annotationMetadata.addAnnotationTo((ClassVisitor)classWriter);
        }
        pythonCompiledClass.staticAttributeNameToObject.forEach(pythonLikeType::$setAttribute);
        classWriter.visitField(9, TYPE_FIELD_NAME, Type.getDescriptor(PythonLikeType.class), null, null);
        classWriter.visitField(9, CPYTHON_TYPE_FIELD_NAME, Type.getDescriptor(PythonLikeType.class), null, null);
        for (Map.Entry entry : pythonCompiledClass.staticAttributeNameToObject.entrySet()) {
            pythonLikeType.$setAttribute((String)entry.getKey(), (PythonLikeObject)entry.getValue());
        }
        for (String string : pythonCompiledClass.typeAnnotations.keySet()) {
            if (pythonLikeType.$getAttributeOrNull(string) != null) continue;
            instanceAttributeSet.add(string);
        }
        for (int i = 0; i < pythonCompiledClass.pythonJavaTypeMappings.size(); ++i) {
            classWriter.visitField(9, PYTHON_JAVA_TYPE_MAPPING_PREFIX + i, Type.getDescriptor(PythonJavaTypeMapping.class), null, null);
        }
        HashMap<String, PythonLikeType> attributeNameToTypeMap = new HashMap<String, PythonLikeType>();
        instanceAttributeSet.removeAll(pythonCompiledClass.staticAttributeDescriptorNames);
        try {
            void var15_32;
            Class<?> clazz = superClassType.getJavaClass();
            while (var15_32 != Object.class) {
                for (Field field : var15_32.getFields()) {
                    instanceAttributeSet.remove(field.getName());
                }
                Class clazz2 = var15_32.getSuperclass();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
        for (String string : instanceAttributeSet) {
            boolean isJavaType;
            FieldVisitor fieldVisitor;
            String getterTypeDescriptor;
            Object javaFieldTypeDescriptor;
            TypeHint typeHint = pythonCompiledClass.typeAnnotations.getOrDefault(string, TypeHint.withoutAnnotations(BuiltinTypes.BASE_TYPE));
            PythonLikeType type2 = typeHint.type();
            PythonLikeType javaGetterType = typeHint.javaGetterType();
            if (type2 == null) {
                type2 = BuiltinTypes.BASE_TYPE;
            }
            attributeNameToTypeMap.put(string, type2);
            String signature = null;
            if (type2.getJavaTypeInternalName().equals(Type.getInternalName(JavaObjectWrapper.class))) {
                javaFieldTypeDescriptor = Type.getDescriptor(type2.getJavaObjectWrapperType());
                getterTypeDescriptor = javaFieldTypeDescriptor;
                fieldVisitor = classWriter.visitField(1, PythonClassTranslator.getJavaFieldName(string), (String)javaFieldTypeDescriptor, null, null);
                isJavaType = true;
            } else {
                if (typeHint.genericArgs() != null) {
                    SignatureWriter signatureWriter = new SignatureWriter();
                    PythonClassTranslator.visitSignature(typeHint, (SignatureVisitor)signatureWriter);
                    signature = signatureWriter.toString();
                }
                javaFieldTypeDescriptor = "L" + type2.getJavaTypeInternalName() + ";";
                getterTypeDescriptor = javaGetterType.getJavaTypeDescriptor();
                fieldVisitor = classWriter.visitField(1, PythonClassTranslator.getJavaFieldName(string), (String)javaFieldTypeDescriptor, signature, null);
                isJavaType = false;
            }
            fieldVisitor.visitEnd();
            PythonClassTranslator.createJavaGetterSetter(classWriter, pythonCompiledClass, preparedClassInfo, string, Type.getType((String)javaFieldTypeDescriptor), Type.getType((String)getterTypeDescriptor), signature, typeHint);
            FieldDescriptor fieldDescriptor = new FieldDescriptor(string, PythonClassTranslator.getJavaFieldName(string), internalClassName, (String)javaFieldTypeDescriptor, type2, true, isJavaType);
            pythonLikeType.addInstanceField(fieldDescriptor);
        }
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        methodVisitor.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(178, Type.getInternalName(PythonInterpreter.class), "DEFAULT", Type.getDescriptor(PythonInterpreter.class));
        methodVisitor.visitFieldInsn(178, internalClassName, TYPE_FIELD_NAME, Type.getDescriptor(PythonLikeType.class));
        methodVisitor.visitMethodInsn(183, superClassType.getJavaTypeInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonInterpreter.class), Type.getType(PythonLikeType.class)}), false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
        MethodVisitor methodVisitor2 = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonInterpreter.class), Type.getType(PythonLikeType.class)}), null, null);
        methodVisitor2.visitParameter("subclassType", 0);
        methodVisitor2.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor2);
        methodVisitor2.visitVarInsn(25, 0);
        methodVisitor2.visitVarInsn(25, 1);
        methodVisitor2.visitVarInsn(25, 2);
        methodVisitor2.visitMethodInsn(183, superClassType.getJavaTypeInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonInterpreter.class), Type.getType(PythonLikeType.class)}), false);
        methodVisitor2.visitInsn(177);
        methodVisitor2.visitMaxs(-1, -1);
        methodVisitor2.visitEnd();
        PythonClassTranslator.createGetAttribute(classWriter, internalClassName, superClassType.getJavaTypeInternalName(), instanceAttributeSet, attributeNameToTypeMap);
        PythonClassTranslator.createSetAttribute(classWriter, internalClassName, superClassType.getJavaTypeInternalName(), instanceAttributeSet, attributeNameToTypeMap);
        PythonClassTranslator.createDeleteAttribute(classWriter, internalClassName, superClassType.getJavaTypeInternalName(), instanceAttributeSet, attributeNameToTypeMap);
        for (Map.Entry<String, PythonCompiledFunction> entry : pythonCompiledClass.instanceFunctionNameToPythonBytecode.entrySet()) {
            entry.getValue().methodKind = PythonMethodKind.VIRTUAL_METHOD;
            PythonClassTranslator.createInstanceMethod(pythonLikeType, classWriter, internalClassName, entry.getKey(), entry.getValue(), instanceMethodNameToMethodDescriptor);
        }
        for (Map.Entry<String, PythonCompiledFunction> entry : pythonCompiledClass.staticFunctionNameToPythonBytecode.entrySet()) {
            entry.getValue().methodKind = PythonMethodKind.STATIC_METHOD;
            PythonClassTranslator.createStaticMethod(pythonLikeType, classWriter, internalClassName, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, PythonCompiledFunction> entry : pythonCompiledClass.classFunctionNameToPythonBytecode.entrySet()) {
            entry.getValue().methodKind = PythonMethodKind.CLASS_METHOD;
            PythonClassTranslator.createClassMethod(pythonLikeType, classWriter, internalClassName, entry.getKey(), entry.getValue());
        }
        try {
            boolean bl = CPythonBackedPythonLikeObject.class.isAssignableFrom(superClassType.getJavaClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            boolean bl = false;
        }
        if (var16_46 != false) {
            PythonClassTranslator.createCPythonOperationMethods(classWriter, internalClassName, superClassType.getJavaTypeInternalName(), attributeNameToTypeMap);
        }
        javaInterfaceImplementorSet.forEach(implementor -> implementor.implement(classWriter, pythonCompiledClass));
        classWriter.visitEnd();
        PythonBytecodeToJavaBytecodeTranslator.writeClassOutput(BuiltinTypes.classNameToBytecode, className, classWriter.toByteArray());
        pythonLikeType.$setAttribute("__name__", PythonString.valueOf(pythonCompiledClass.className));
        pythonLikeType.$setAttribute("__qualname__", PythonString.valueOf(pythonCompiledClass.qualifiedName));
        pythonLikeType.$setAttribute("__module__", PythonString.valueOf(pythonCompiledClass.module));
        PythonLikeDict pythonLikeDict = new PythonLikeDict();
        pythonCompiledClass.typeAnnotations.forEach((name, type) -> annotations.put(PythonString.valueOf(name), type.type()));
        pythonLikeType.$setAttribute("__annotations__", pythonLikeDict);
        PythonLikeTuple<PythonLikeType> mro = new PythonLikeTuple<PythonLikeType>();
        mro.addAll((Collection<PythonLikeType>)superTypeList);
        pythonLikeType.$setAttribute("__mro__", mro);
        try {
            generatedClass = BuiltinTypes.asmClassLoader.loadClass(className);
            generatedClass.getField(TYPE_FIELD_NAME).set(null, pythonLikeType);
            generatedClass.getField(CPYTHON_TYPE_FIELD_NAME).set(null, pythonCompiledClass.binaryType);
            for (int i = 0; i < pythonCompiledClass.pythonJavaTypeMappings.size(); ++i) {
                generatedClass.getField(PYTHON_JAVA_TYPE_MAPPING_PREFIX + i).set(null, pythonCompiledClass.pythonJavaTypeMappings.get(i));
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Impossible State: Unable to load generated class (" + className + ") despite it being just generated.", e);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Impossible State: could not access type static field for generated class (" + className + ").", e);
        }
        Class<?> initFunctionClass = null;
        for (Map.Entry<String, PythonCompiledFunction> instanceMethodEntry : pythonCompiledClass.instanceFunctionNameToPythonBytecode.entrySet()) {
            interfaceDeclaration = PythonClassTranslator.getInterfaceForInstancePythonFunction(internalClassName, instanceMethodEntry.getValue());
            Class<?> createdFunctionClass = PythonClassTranslator.createBytecodeForMethodAndSetOnClass(className, pythonLikeType, pythonCompiledClass.binaryType, generatedClass, instanceMethodEntry, interfaceDeclaration, PythonMethodKind.VIRTUAL_METHOD);
            if (!instanceMethodEntry.getKey().equals("__init__")) continue;
            initFunctionClass = createdFunctionClass;
        }
        for (Map.Entry<String, PythonCompiledFunction> staticMethodEntry : pythonCompiledClass.staticFunctionNameToPythonBytecode.entrySet()) {
            interfaceDeclaration = PythonClassTranslator.getInterfaceForPythonFunction(staticMethodEntry.getValue());
            PythonClassTranslator.createBytecodeForMethodAndSetOnClass(className, pythonLikeType, pythonCompiledClass.binaryType, generatedClass, staticMethodEntry, interfaceDeclaration, PythonMethodKind.STATIC_METHOD);
        }
        for (Map.Entry<String, PythonCompiledFunction> classMethodEntry : pythonCompiledClass.classFunctionNameToPythonBytecode.entrySet()) {
            interfaceDeclaration = PythonClassTranslator.getInterfaceForClassPythonFunction(classMethodEntry.getValue());
            PythonClassTranslator.createBytecodeForMethodAndSetOnClass(className, pythonLikeType, pythonCompiledClass.binaryType, generatedClass, classMethodEntry, interfaceDeclaration, PythonMethodKind.CLASS_METHOD);
        }
        pythonLikeType.setConstructor(PythonClassTranslator.createConstructor(internalClassName, pythonCompiledClass.instanceFunctionNameToPythonBytecode.get("__init__"), generatedClass));
        PythonOverloadImplementor.createDispatchesFor(pythonLikeType);
        return pythonLikeType;
    }

    private static void visitSignature(TypeHint typeHint, SignatureVisitor signatureVisitor) {
        signatureVisitor.visitClassType(typeHint.type().getJavaTypeInternalName());
        if (typeHint.genericArgs() != null) {
            for (TypeHint genericArg : typeHint.genericArgs()) {
                PythonClassTranslator.visitSignature(genericArg, signatureVisitor.visitTypeArgument('='));
            }
        }
        signatureVisitor.visitEnd();
    }

    public static void setSelfStaticInstances(PythonCompiledClass pythonCompiledClass, Class<?> generatedClass, PythonLikeType pythonLikeType, Map<Number, PythonLikeObject> instanceMap) {
        if (!CPythonBackedPythonLikeObject.class.isAssignableFrom(generatedClass)) {
            return;
        }
        pythonCompiledClass.staticAttributeNameToClassInstance.forEach((attributeName, instancePointer) -> {
            try {
                CPythonBackedPythonLikeObject objectInstance = (CPythonBackedPythonLikeObject)generatedClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                Number pythonReferenceId = CPythonBackedPythonInterpreter.getPythonReferenceId(instancePointer);
                instanceMap.put(pythonReferenceId, objectInstance);
                objectInstance.$setCPythonReference((OpaquePythonReference)instancePointer);
                objectInstance.$setInstanceMap(instanceMap);
                objectInstance.$readFieldsFromCPythonReference();
                pythonLikeType.$setAttribute((String)attributeName, objectInstance);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Unable to construct instance of class (" + generatedClass + ")", e);
            }
        });
    }

    public static String getJavaFieldName(String pythonFieldName) {
        return pythonFieldName;
    }

    public static String getPythonFieldName(String javaFieldName) {
        return javaFieldName;
    }

    public static String getJavaMethodName(String pythonMethodName) {
        return JAVA_METHOD_PREFIX + pythonMethodName;
    }

    public static String getJavaMethodHolderName(String pythonMethodName) {
        return JAVA_METHOD_HOLDER_PREFIX + pythonMethodName;
    }

    public static String getPythonMethodName(String javaMethodName) {
        return javaMethodName.substring(JAVA_METHOD_PREFIX.length());
    }

    private static Class<?> createBytecodeForMethodAndSetOnClass(String className, PythonLikeType pythonLikeType, PythonLikeType cPythonType, Class<? extends PythonLikeObject> generatedClass, Map.Entry<String, PythonCompiledFunction> methodEntry, InterfaceDeclaration interfaceDeclaration, PythonMethodKind pythonMethodKind) {
        Class<?> functionClass;
        Object functionInstance;
        try {
            functionInstance = PythonBytecodeToJavaBytecodeTranslator.translatePythonBytecodeToInstance(methodEntry.getValue(), new MethodDescriptor(interfaceDeclaration.interfaceName, MethodDescriptor.MethodType.INTERFACE, "invoke", interfaceDeclaration.methodDescriptor), pythonMethodKind == PythonMethodKind.VIRTUAL_METHOD);
            functionClass = functionInstance.getClass();
            functionClass.getField("__class_cell__").set(null, pythonLikeType);
        }
        catch (Exception e) {
            functionClass = PythonClassTranslator.createPythonWrapperMethod(methodEntry.getKey(), methodEntry.getValue(), interfaceDeclaration, pythonMethodKind == PythonMethodKind.VIRTUAL_METHOD);
            try {
                functionInstance = functionClass.getConstructor(PythonLikeType.class).newInstance(cPythonType);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new IllegalStateException("Cannot create instance of Python native wrapper despite it being just generated", ex);
            }
        }
        try {
            GeneratedFunctionMethodReference translatedPythonMethodWrapper;
            PythonCompiledFunction function = methodEntry.getValue();
            pythonLikeType.clearMethod(methodEntry.getKey());
            String javaMethodDescriptor = Arrays.stream(generatedClass.getDeclaredMethods()).filter(method -> method.getName().equals(PythonClassTranslator.getJavaMethodName((String)methodEntry.getKey()))).map(Type::getMethodDescriptor).findFirst().orElseThrow();
            ArgumentSpec<PythonLikeObject> argumentSpec = function.getArgumentSpecMapper().apply(function.defaultPositionalArguments, function.defaultKeywordArguments);
            switch (pythonMethodKind) {
                case VIRTUAL_METHOD: {
                    translatedPythonMethodWrapper = new GeneratedFunctionMethodReference(functionInstance, functionClass.getMethods()[0], Map.of(), PythonLikeFunction.getFunctionType());
                    pythonLikeType.addMethod(methodEntry.getKey(), argumentSpec.asPythonFunctionSignature(className.replace('.', '/'), PythonClassTranslator.getJavaMethodName(methodEntry.getKey()), javaMethodDescriptor));
                    break;
                }
                case STATIC_METHOD: {
                    translatedPythonMethodWrapper = new GeneratedFunctionMethodReference(functionInstance, functionClass.getMethods()[0], Map.of(), PythonLikeFunction.getStaticFunctionType());
                    pythonLikeType.addMethod(methodEntry.getKey(), argumentSpec.asStaticPythonFunctionSignature(className.replace('.', '/'), PythonClassTranslator.getJavaMethodName(methodEntry.getKey()), javaMethodDescriptor));
                    break;
                }
                case CLASS_METHOD: {
                    translatedPythonMethodWrapper = new GeneratedFunctionMethodReference(functionInstance, functionClass.getMethods()[0], Map.of(), PythonLikeFunction.getClassFunctionType());
                    pythonLikeType.addMethod(methodEntry.getKey(), argumentSpec.asClassPythonFunctionSignature(className.replace('.', '/'), PythonClassTranslator.getJavaMethodName(methodEntry.getKey()), javaMethodDescriptor));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled case: " + pythonMethodKind);
                }
            }
            generatedClass.getField(PythonClassTranslator.getJavaMethodHolderName(methodEntry.getKey())).set(null, functionInstance);
            pythonLikeType.$setAttribute(methodEntry.getKey(), translatedPythonMethodWrapper);
            return functionClass;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Impossible State: could not access method (" + methodEntry.getKey() + ") static field for generated class (" + className + ").", e);
        }
    }

    private static Class<?> createPythonWrapperMethod(String methodName, PythonCompiledFunction pythonCompiledFunction, InterfaceDeclaration interfaceDeclaration, boolean isVirtual) {
        int i;
        String maybeClassName = "org.jpyinterpreter.synthetic." + pythonCompiledFunction.getGeneratedClassBaseName() + "$$Wrapper";
        int numberOfInstances = PythonBytecodeToJavaBytecodeTranslator.classNameToSharedInstanceCount.merge(maybeClassName, 1, Integer::sum);
        if (numberOfInstances > 1) {
            maybeClassName = maybeClassName + "$$" + numberOfInstances;
        }
        String className = maybeClassName;
        String internalClassName = className.replace('.', '/');
        JavaPythonClassWriter classWriter = new JavaPythonClassWriter(3);
        classWriter.visit(55, 1, internalClassName, null, Type.getInternalName(Object.class), new String[]{interfaceDeclaration.interfaceName});
        classWriter.visitSource("<generated signature>", null);
        classWriter.visitField(17, "$binaryType", Type.getDescriptor(PythonLikeType.class), null, null);
        classWriter.visitField(9, "__spec__", Type.getDescriptor(ArgumentSpec.class), null, null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonLikeType.class)}), null, null);
        methodVisitor.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, internalClassName, "$binaryType", Type.getDescriptor(PythonLikeType.class));
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "invoke", interfaceDeclaration.methodDescriptor, null, null);
        for (i = 0; i < pythonCompiledFunction.totalArgCount(); ++i) {
            methodVisitor.visitParameter("parameter" + i, 0);
        }
        methodVisitor.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, internalClassName, "$binaryType", Type.getDescriptor(PythonLikeType.class));
        methodVisitor.visitLdcInsn((Object)methodName);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrError", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonLikeFunction.class));
        methodVisitor.visitLdcInsn((Object)pythonCompiledFunction.totalArgCount());
        methodVisitor.visitTypeInsn(189, Type.getInternalName(Object.class));
        for (i = 0; i < pythonCompiledFunction.totalArgCount(); ++i) {
            methodVisitor.visitInsn(89);
            methodVisitor.visitLdcInsn((Object)i);
            methodVisitor.visitVarInsn(25, i + 1);
            methodVisitor.visitInsn(83);
        }
        methodVisitor.visitMethodInsn(184, Type.getInternalName(Arrays.class), "asList", Type.getMethodDescriptor((Type)Type.getType(List.class), (Type[])new Type[]{Type.getType(Object[].class)}), false);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptyMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), false);
        methodVisitor.visitInsn(1);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
        methodVisitor.visitTypeInsn(192, Type.getReturnType((String)interfaceDeclaration.methodDescriptor).getInternalName());
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        PythonBytecodeToJavaBytecodeTranslator.writeClassOutput(BuiltinTypes.classNameToBytecode, className, classWriter.toByteArray());
        try {
            return BuiltinTypes.asmClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot load class " + className + " despite it being just generated", e);
        }
    }

    private static PythonLikeFunction createConstructor(String classInternalName, PythonCompiledFunction initFunction, Class<?> typeGeneratedClass) {
        String maybeClassName = "org.jpyinterpreter.synthetic." + classInternalName.replace('/', '.') + "$$Constructor";
        int numberOfInstances = PythonBytecodeToJavaBytecodeTranslator.classNameToSharedInstanceCount.merge(maybeClassName, 1, Integer::sum);
        if (numberOfInstances > 1) {
            maybeClassName = maybeClassName + "$$" + numberOfInstances;
        }
        String constructorClassName = maybeClassName;
        String constructorInternalClassName = constructorClassName.replace('.', '/');
        JavaPythonClassWriter classWriter = new JavaPythonClassWriter(3);
        classWriter.visit(55, 1, constructorInternalClassName, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(PythonLikeFunction.class)});
        classWriter.visitSource(initFunction != null ? initFunction.moduleFilePath : "<unknown>", null);
        classWriter.visitField(9, "__spec__", Type.getDescriptor(ArgumentSpec.class), null, null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        methodVisitor.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
        Type generatedClassType = Type.getType((String)("L" + classInternalName + ";"));
        methodVisitor = classWriter.visitMethod(1, "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), null, null);
        methodVisitor.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
        methodVisitor.visitTypeInsn(187, classInternalName);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, classInternalName, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        if (initFunction != null) {
            Label start = new Label();
            methodVisitor.visitLabel(start);
            methodVisitor.visitLineNumber(initFunction.getFirstLine(), start);
            methodVisitor.visitInsn(89);
            methodVisitor.visitFieldInsn(178, constructorInternalClassName, "__spec__", Type.getDescriptor(ArgumentSpec.class));
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(182, Type.getInternalName(ArgumentSpec.class), "extractArgumentList", Type.getMethodDescriptor((Type)Type.getType(List.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class)}), false);
            List<PythonLikeType> initParameterTypes = initFunction.getParameterTypes();
            for (int i = 1; i < initParameterTypes.size(); ++i) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn((Object)(i - 1));
                methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.INT_TYPE}), true);
                methodVisitor.visitTypeInsn(192, initParameterTypes.get(i).getJavaTypeInternalName());
                methodVisitor.visitInsn(95);
            }
            methodVisitor.visitInsn(87);
            Type[] parameterTypes = new Type[initFunction.totalArgCount() - 1];
            List<PythonLikeType> parameterTypeAnnotations = initFunction.getParameterTypes();
            for (int i = 1; i < parameterTypeAnnotations.size(); ++i) {
                parameterTypes[i - 1] = Type.getType((String)("L" + parameterTypeAnnotations.get(i).getJavaTypeInternalName() + ";"));
            }
            Type returnType = PythonClassTranslator.getVirtualFunctionReturnType(initFunction);
            String initMethodDescriptor = Type.getMethodDescriptor((Type)returnType, (Type[])parameterTypes);
            methodVisitor.visitMethodInsn(182, classInternalName, PythonClassTranslator.getJavaMethodName("__init__"), initMethodDescriptor, false);
            methodVisitor.visitInsn(87);
        }
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        PythonBytecodeToJavaBytecodeTranslator.writeClassOutput(BuiltinTypes.classNameToBytecode, constructorClassName, classWriter.toByteArray());
        try {
            Class<?> generatedClass = BuiltinTypes.asmClassLoader.loadClass(constructorClassName);
            if (initFunction != null) {
                Object method = typeGeneratedClass.getField(PythonClassTranslator.getJavaMethodHolderName("__init__")).get(null);
                ArgumentSpec spec = (ArgumentSpec)method.getClass().getField("__spec__").get(method);
                generatedClass.getField("__spec__").set(null, spec);
            }
            return (PythonLikeFunction)generatedClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            throw new IllegalStateException("Impossible State: Unable to load generated class (" + constructorClassName + ") despite it being just generated.", e);
        }
    }

    private static void createJavaGetterSetter(ClassWriter classWriter, PythonCompiledClass pythonCompiledClass, PreparedClassInfo preparedClassInfo, String attributeName, Type attributeType, Type getterType, String signature, TypeHint typeHint) {
        MatchedMapping matchedMapping = null;
        for (int i = 0; i < pythonCompiledClass.pythonJavaTypeMappings.size(); ++i) {
            PythonJavaTypeMapping<?, ?> mapping = pythonCompiledClass.pythonJavaTypeMappings.get(i);
            if (!mapping.getPythonType().equals(typeHint.javaGetterType())) continue;
            matchedMapping = new MatchedMapping(i, mapping);
            getterType = Type.getType(mapping.getJavaType());
        }
        PythonClassTranslator.createJavaGetter(classWriter, preparedClassInfo, matchedMapping, attributeName, attributeType, getterType, signature, typeHint);
        PythonClassTranslator.createJavaSetter(classWriter, preparedClassInfo, matchedMapping, attributeName, attributeType, getterType, signature, typeHint);
    }

    private static void createJavaGetter(ClassWriter classWriter, PreparedClassInfo preparedClassInfo, MatchedMapping matchedMapping, String attributeName, Type attributeType, Type getterType, String signature, TypeHint typeHint) {
        String getterName = "get" + attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1);
        if (signature != null && Objects.equals(attributeType, getterType)) {
            signature = "()" + (String)signature;
        }
        MethodVisitor getterVisitor = classWriter.visitMethod(1, getterName, Type.getMethodDescriptor((Type)getterType, (Type[])new Type[0]), (String)signature, null);
        int maxStack = 1;
        for (AnnotationMetadata annotation : AnnotationMetadata.getAnnotationListWithoutRepeatable(typeHint.annotationList())) {
            annotation.addAnnotationTo(getterVisitor);
        }
        getterVisitor.visitCode();
        getterVisitor.visitVarInsn(25, 0);
        getterVisitor.visitFieldInsn(180, preparedClassInfo.classInternalName, attributeName, attributeType.getDescriptor());
        if (typeHint.type().isInstance(PythonNone.INSTANCE)) {
            maxStack = 3;
            getterVisitor.visitInsn(89);
            PythonConstantsImplementor.loadNone(getterVisitor);
            Label returnLabel = new Label();
            getterVisitor.visitJumpInsn(166, returnLabel);
            getterVisitor.visitInsn(87);
            getterVisitor.visitInsn(1);
            getterVisitor.visitLabel(returnLabel);
        }
        if (!Objects.equals(attributeType, getterType)) {
            if (matchedMapping != null) {
                getterVisitor.visitInsn(89);
                getterVisitor.visitInsn(1);
                Label skipMapping = new Label();
                getterVisitor.visitJumpInsn(165, skipMapping);
                getterVisitor.visitFieldInsn(178, preparedClassInfo.classInternalName, PYTHON_JAVA_TYPE_MAPPING_PREFIX + matchedMapping.index, Type.getDescriptor(PythonJavaTypeMapping.class));
                getterVisitor.visitInsn(95);
                getterVisitor.visitMethodInsn(185, Type.getInternalName(PythonJavaTypeMapping.class), "toJavaObject", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class)}), true);
                getterVisitor.visitLabel(skipMapping);
            }
            getterVisitor.visitTypeInsn(192, getterType.getInternalName());
        }
        getterVisitor.visitInsn(176);
        getterVisitor.visitMaxs(maxStack, 0);
        getterVisitor.visitEnd();
    }

    private static void createJavaSetter(ClassWriter classWriter, PreparedClassInfo preparedClassInfo, MatchedMapping matchedMapping, String attributeName, Type attributeType, Type setterType, String signature, TypeHint typeHint) {
        String setterName = "set" + attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1);
        if (signature != null && Objects.equals(attributeType, setterType)) {
            signature = "(" + (String)signature + ")V";
        }
        MethodVisitor setterVisitor = classWriter.visitMethod(1, setterName, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{setterType}), (String)signature, null);
        int maxStack = 2;
        setterVisitor.visitCode();
        setterVisitor.visitVarInsn(25, 0);
        setterVisitor.visitVarInsn(25, 1);
        if (typeHint.type().isInstance(PythonNone.INSTANCE)) {
            maxStack = 4;
            setterVisitor.visitInsn(89);
            setterVisitor.visitInsn(1);
            Label setFieldLabel = new Label();
            setterVisitor.visitJumpInsn(166, setFieldLabel);
            setterVisitor.visitInsn(87);
            PythonConstantsImplementor.loadNone(setterVisitor);
            setterVisitor.visitLabel(setFieldLabel);
        }
        if (!Objects.equals(attributeType, setterType)) {
            if (matchedMapping != null) {
                setterVisitor.visitVarInsn(25, 1);
                setterVisitor.visitInsn(1);
                Label skipMapping = new Label();
                setterVisitor.visitJumpInsn(165, skipMapping);
                setterVisitor.visitFieldInsn(178, preparedClassInfo.classInternalName, PYTHON_JAVA_TYPE_MAPPING_PREFIX + matchedMapping.index, Type.getDescriptor(PythonJavaTypeMapping.class));
                setterVisitor.visitInsn(95);
                setterVisitor.visitMethodInsn(185, Type.getInternalName(PythonJavaTypeMapping.class), "toPythonObject", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class)}), true);
                setterVisitor.visitLabel(skipMapping);
            }
            setterVisitor.visitTypeInsn(192, attributeType.getInternalName());
        }
        setterVisitor.visitFieldInsn(181, preparedClassInfo.classInternalName, attributeName, attributeType.getDescriptor());
        setterVisitor.visitInsn(177);
        setterVisitor.visitMaxs(maxStack, 0);
        setterVisitor.visitEnd();
    }

    private static void addAnnotationsToMethod(PythonCompiledFunction function, MethodVisitor methodVisitor) {
        TypeHint returnTypeHint = function.typeAnnotations.get("return");
        if (returnTypeHint != null) {
            for (AnnotationMetadata annotation : AnnotationMetadata.getAnnotationListWithoutRepeatable(returnTypeHint.annotationList())) {
                annotation.addAnnotationTo(methodVisitor);
            }
        }
    }

    private static void createInstanceMethod(PythonLikeType pythonLikeType, ClassWriter classWriter, String internalClassName, String methodName, PythonCompiledFunction function, Map<String, InterfaceDeclaration> instanceMethodNameToMethodDescriptor) {
        InterfaceDeclaration interfaceDeclaration = PythonClassTranslator.getInterfaceForInstancePythonFunction(internalClassName, function);
        String interfaceDescriptor = interfaceDeclaration.descriptor();
        String javaMethodName = PythonClassTranslator.getJavaMethodName(methodName);
        classWriter.visitField(9, PythonClassTranslator.getJavaMethodHolderName(methodName), interfaceDescriptor, null, null);
        instanceMethodNameToMethodDescriptor.put(methodName, interfaceDeclaration);
        Type returnType = PythonClassTranslator.getVirtualFunctionReturnType(function);
        List<PythonLikeType> parameterPythonTypeList = function.getParameterTypes();
        Type[] javaParameterTypes = new Type[Math.max(0, function.totalArgCount() - 1)];
        for (int i = 1; i < function.totalArgCount(); ++i) {
            javaParameterTypes[i - 1] = Type.getType((String)parameterPythonTypeList.get(i).getJavaTypeDescriptor());
        }
        String javaMethodDescriptor = Type.getMethodDescriptor((Type)returnType, (Type[])javaParameterTypes);
        String signature = PythonClassTranslator.getFunctionSignature(function, javaMethodDescriptor);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, javaMethodName, javaMethodDescriptor, signature, null);
        PythonClassTranslator.createInstanceOrStaticMethodBody(internalClassName, methodName, javaParameterTypes, interfaceDeclaration.methodDescriptor, function, interfaceDeclaration.interfaceName, interfaceDescriptor, methodVisitor);
        pythonLikeType.addMethod(methodName, new PythonFunctionSignature(new MethodDescriptor(internalClassName, MethodDescriptor.MethodType.VIRTUAL, javaMethodName, javaMethodDescriptor), function.getReturnType().orElse(BuiltinTypes.BASE_TYPE), function.totalArgCount() > 0 ? function.getParameterTypes().subList(1, function.getParameterTypes().size()) : Collections.emptyList()));
    }

    private static void createStaticMethod(PythonLikeType pythonLikeType, ClassWriter classWriter, String internalClassName, String methodName, PythonCompiledFunction function) {
        InterfaceDeclaration interfaceDeclaration = PythonClassTranslator.getInterfaceForPythonFunction(function);
        String interfaceDescriptor = "L" + interfaceDeclaration.interfaceName + ";";
        String javaMethodName = PythonClassTranslator.getJavaMethodName(methodName);
        String signature = PythonClassTranslator.getFunctionSignature(function, function.getAsmMethodDescriptorString());
        classWriter.visitField(9, PythonClassTranslator.getJavaMethodHolderName(methodName), interfaceDescriptor, null, null);
        MethodVisitor methodVisitor = classWriter.visitMethod(9, javaMethodName, function.getAsmMethodDescriptorString(), signature, null);
        List<PythonLikeType> parameterPythonTypeList = function.getParameterTypes();
        Type[] javaParameterTypes = new Type[function.totalArgCount()];
        for (int i = 0; i < function.totalArgCount(); ++i) {
            javaParameterTypes[i] = Type.getType((String)("L" + parameterPythonTypeList.get(i).getJavaTypeInternalName() + ";"));
        }
        PythonClassTranslator.createInstanceOrStaticMethodBody(internalClassName, methodName, javaParameterTypes, interfaceDeclaration.methodDescriptor, function, interfaceDeclaration.interfaceName, interfaceDescriptor, methodVisitor);
        pythonLikeType.addMethod(methodName, new PythonFunctionSignature(new MethodDescriptor(internalClassName, MethodDescriptor.MethodType.STATIC, javaMethodName, function.getAsmMethodDescriptorString()), function.getReturnType().orElse(BuiltinTypes.BASE_TYPE), function.getParameterTypes()));
    }

    private static void createClassMethod(PythonLikeType pythonLikeType, ClassWriter classWriter, String internalClassName, String methodName, PythonCompiledFunction function) {
        InterfaceDeclaration interfaceDeclaration = PythonClassTranslator.getInterfaceForClassPythonFunction(function);
        String interfaceDescriptor = "L" + interfaceDeclaration.interfaceName + ";";
        String javaMethodName = PythonClassTranslator.getJavaMethodName(methodName);
        classWriter.visitField(9, PythonClassTranslator.getJavaMethodHolderName(methodName), interfaceDescriptor, null, null);
        String javaMethodDescriptor = interfaceDeclaration.methodDescriptor;
        String signature = PythonClassTranslator.getFunctionSignature(function, javaMethodDescriptor);
        MethodVisitor methodVisitor = classWriter.visitMethod(9, javaMethodName, javaMethodDescriptor, signature, null);
        for (int i = 0; i < function.getParameterTypes().size(); ++i) {
            methodVisitor.visitParameter(function.co_varnames.get(i), 0);
        }
        PythonClassTranslator.addAnnotationsToMethod(function, methodVisitor);
        methodVisitor.visitCode();
        Label start = new Label();
        methodVisitor.visitLabel(start);
        methodVisitor.visitLineNumber(function.getFirstLine(), start);
        methodVisitor.visitFieldInsn(178, internalClassName, PythonClassTranslator.getJavaMethodHolderName(methodName), interfaceDescriptor);
        for (int i = 0; i < function.totalArgCount(); ++i) {
            methodVisitor.visitVarInsn(25, i);
        }
        methodVisitor.visitMethodInsn(185, interfaceDeclaration.interfaceName, "invoke", interfaceDeclaration.methodDescriptor, true);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
        ArrayList<PythonLikeType> parameterTypes = new ArrayList<PythonLikeType>(function.getParameterTypes().size());
        parameterTypes.add(BuiltinTypes.TYPE_TYPE);
        parameterTypes.addAll(function.getParameterTypes().subList(1, function.getParameterTypes().size()));
        pythonLikeType.addMethod(methodName, new PythonFunctionSignature(new MethodDescriptor(internalClassName, MethodDescriptor.MethodType.CLASS, javaMethodName, interfaceDeclaration.methodDescriptor), function.getReturnType().orElse(BuiltinTypes.BASE_TYPE), parameterTypes));
    }

    private static void createInstanceOrStaticMethodBody(String internalClassName, String methodName, Type[] javaParameterTypes, String methodDescriptorString, PythonCompiledFunction function, String interfaceInternalName, String interfaceDescriptor, MethodVisitor methodVisitor) {
        for (int i = 0; i < javaParameterTypes.length; ++i) {
            methodVisitor.visitParameter(function.co_varnames.get(i), 0);
        }
        PythonClassTranslator.addAnnotationsToMethod(function, methodVisitor);
        methodVisitor.visitCode();
        Label start = new Label();
        methodVisitor.visitLabel(start);
        methodVisitor.visitLineNumber(function.getFirstLine(), start);
        methodVisitor.visitFieldInsn(178, internalClassName, PythonClassTranslator.getJavaMethodHolderName(methodName), interfaceDescriptor);
        for (int i = 0; i < function.totalArgCount(); ++i) {
            methodVisitor.visitVarInsn(25, i);
        }
        methodVisitor.visitMethodInsn(185, interfaceInternalName, "invoke", methodDescriptorString, true);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
    }

    public static Type getVirtualFunctionReturnType(PythonCompiledFunction function) {
        return Type.getType((String)("L" + function.getReturnType().map(PythonLikeType::getJavaTypeInternalName).orElseGet(() -> PythonClassTranslator.getPythonReturnTypeOfFunction(function, true).getJavaTypeInternalName()) + ";"));
    }

    public static String getFunctionSignature(PythonCompiledFunction function, String asmMethodDescriptor) {
        Optional<TypeHint> maybeReturnTypeHint = function.getReturnTypeHint();
        if (maybeReturnTypeHint.isPresent()) {
            TypeHint returnTypeHint = maybeReturnTypeHint.get();
            SignatureWriter signatureWriter = new SignatureWriter();
            Type methodType = Type.getMethodType((String)asmMethodDescriptor);
            for (int i = 0; i < methodType.getArgumentCount(); ++i) {
                SignatureVisitor parameterVisitor = signatureWriter.visitParameterType();
                parameterVisitor.visitClassType(methodType.getArgumentTypes()[i].getInternalName());
                parameterVisitor.visitEnd();
            }
            PythonClassTranslator.visitSignature(returnTypeHint, signatureWriter.visitReturnType());
            signatureWriter.visitEnd();
            return signatureWriter.toString();
        }
        return null;
    }

    public static void createGetAttribute(ClassWriter classWriter, String classInternalName, String superInternalName, Collection<String> instanceAttributes, Map<String, PythonLikeType> fieldToType) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "$getAttributeOrNull", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), null, null);
        methodVisitor.visitParameter("attribute", 0);
        methodVisitor.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
        methodVisitor.visitVarInsn(25, 1);
        BytecodeSwitchImplementor.createStringSwitch(methodVisitor, instanceAttributes, 2, field -> {
            methodVisitor.visitVarInsn(25, 0);
            PythonLikeType type = (PythonLikeType)fieldToType.get(field);
            if (type.getJavaTypeInternalName().equals(Type.getInternalName(JavaObjectWrapper.class))) {
                methodVisitor.visitFieldInsn(180, classInternalName, PythonClassTranslator.getJavaFieldName(field), Type.getDescriptor(type.getJavaObjectWrapperType()));
                PythonClassTranslator.getWrappedJavaObject(methodVisitor);
            } else {
                methodVisitor.visitFieldInsn(180, classInternalName, PythonClassTranslator.getJavaFieldName(field), "L" + type.getJavaTypeInternalName() + ";");
            }
            methodVisitor.visitInsn(176);
        }, () -> {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(183, superInternalName, "$getAttributeOrNull", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), false);
            methodVisitor.visitInsn(176);
        }, true);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
    }

    private static void getWrappedJavaObject(MethodVisitor methodVisitor) {
        methodVisitor.visitTypeInsn(187, Type.getInternalName(JavaObjectWrapper.class));
        methodVisitor.visitInsn(90);
        methodVisitor.visitInsn(90);
        methodVisitor.visitInsn(87);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(JavaObjectWrapper.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), false);
    }

    public static void createSetAttribute(ClassWriter classWriter, String classInternalName, String superInternalName, Collection<String> instanceAttributes, Map<String, PythonLikeType> fieldToType) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "$setAttribute", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(PythonLikeObject.class)}), null, null);
        methodVisitor.visitParameter("attribute", 0);
        methodVisitor.visitParameter("value", 0);
        methodVisitor.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
        methodVisitor.visitVarInsn(25, 1);
        BytecodeSwitchImplementor.createStringSwitch(methodVisitor, instanceAttributes, 3, field -> {
            PythonLikeType type = (PythonLikeType)fieldToType.get(field);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 2);
            String typeDescriptor = type.getJavaTypeDescriptor();
            if (type.getJavaTypeInternalName().equals(Type.getInternalName(JavaObjectWrapper.class))) {
                PythonClassTranslator.getUnwrappedJavaObject(methodVisitor, type);
                typeDescriptor = Type.getDescriptor(type.getJavaObjectWrapperType());
            } else {
                methodVisitor.visitLdcInsn((Object)Type.getType((String)type.getJavaTypeDescriptor()));
                methodVisitor.visitMethodInsn(184, Type.getInternalName(JavaPythonTypeConversionImplementor.class), "coerceToType", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(PythonLikeObject.class), Type.getType(Class.class)}), false);
                methodVisitor.visitTypeInsn(192, type.getJavaTypeInternalName());
            }
            methodVisitor.visitFieldInsn(181, classInternalName, PythonClassTranslator.getJavaFieldName(field), typeDescriptor);
            methodVisitor.visitInsn(177);
        }, () -> {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(183, superInternalName, "$setAttribute", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(PythonLikeObject.class)}), false);
            methodVisitor.visitInsn(177);
        }, true);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
    }

    private static void getUnwrappedJavaObject(MethodVisitor methodVisitor, PythonLikeType type) {
        methodVisitor.visitTypeInsn(192, Type.getInternalName(JavaObjectWrapper.class));
        methodVisitor.visitMethodInsn(182, Type.getInternalName(JavaObjectWrapper.class), "getWrappedObject", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[0]), false);
        methodVisitor.visitTypeInsn(192, Type.getType(type.getJavaObjectWrapperType()).getInternalName());
    }

    public static void createDeleteAttribute(ClassWriter classWriter, String classInternalName, String superInternalName, Collection<String> instanceAttributes, Map<String, PythonLikeType> fieldToType) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "$deleteAttribute", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)}), null, null);
        methodVisitor.visitParameter("attribute", 0);
        methodVisitor.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
        methodVisitor.visitVarInsn(25, 1);
        BytecodeSwitchImplementor.createStringSwitch(methodVisitor, instanceAttributes, 2, field -> {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitInsn(1);
            PythonLikeType fieldType = (PythonLikeType)fieldToType.get(field);
            if (fieldType.getJavaTypeInternalName().equals(Type.getInternalName(JavaObjectWrapper.class))) {
                methodVisitor.visitFieldInsn(181, classInternalName, PythonClassTranslator.getJavaFieldName(field), Type.getDescriptor(fieldType.getJavaObjectWrapperType()));
            } else {
                methodVisitor.visitFieldInsn(181, classInternalName, PythonClassTranslator.getJavaFieldName(field), fieldType.getJavaTypeDescriptor());
            }
            methodVisitor.visitInsn(177);
        }, () -> {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(183, superInternalName, "$deleteAttribute", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)}), false);
            methodVisitor.visitInsn(177);
        }, true);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
    }

    public static void createCPythonOperationMethods(ClassWriter classWriter, String internalClassName, String superClassInternalName, Map<String, PythonLikeType> attributeNameToType) {
        PythonClassTranslator.createReadFromCPythonReference(classWriter, internalClassName, superClassInternalName, attributeNameToType);
        PythonClassTranslator.createWriteToCPythonReference(classWriter, internalClassName, superClassInternalName, attributeNameToType);
    }

    public static void createReadFromCPythonReference(ClassWriter classWriter, String internalClassName, String superClassInternalName, Map<String, PythonLikeType> attributeNameToType) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "$readFieldsFromCPythonReference", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        methodVisitor.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, superClassInternalName, "$readFieldsFromCPythonReference", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(180, Type.getInternalName(CPythonBackedPythonLikeObject.class), "$cpythonReference", Type.getDescriptor(OpaquePythonReference.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(1);
        Label ifReferenceIsNotNull = new Label();
        methodVisitor.visitJumpInsn(166, ifReferenceIsNotNull);
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel(ifReferenceIsNotNull);
        for (String field : attributeNameToType.keySet()) {
            methodVisitor.visitInsn(92);
            methodVisitor.visitLdcInsn((Object)field);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, Type.getInternalName(CPythonBackedPythonLikeObject.class), "$instanceMap", Type.getDescriptor(Map.class));
            methodVisitor.visitMethodInsn(184, Type.getInternalName(CPythonBackedPythonInterpreter.class), "lookupAttributeOnPythonReference", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(OpaquePythonReference.class), Type.getType(String.class), Type.getType(Map.class)}), false);
            boolean isAssignableFromNone = false;
            try {
                isAssignableFromNone = attributeNameToType.get(field).getJavaClass().isAssignableFrom(PythonNone.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Label ifFieldIsNone = new Label();
            Label doneSettingField = new Label();
            if (!isAssignableFromNone) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitFieldInsn(178, Type.getInternalName(PythonNone.class), "INSTANCE", Type.getDescriptor(PythonNone.class));
                methodVisitor.visitJumpInsn(165, ifFieldIsNone);
            }
            PythonLikeType attributeType = attributeNameToType.get(field);
            methodVisitor.visitLdcInsn((Object)Type.getType((String)attributeType.getJavaTypeDescriptor()));
            methodVisitor.visitMethodInsn(184, Type.getInternalName(JavaPythonTypeConversionImplementor.class), "coerceToType", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(PythonLikeObject.class), Type.getType(Class.class)}), false);
            methodVisitor.visitTypeInsn(192, attributeNameToType.get(field).getJavaTypeInternalName());
            if (attributeType.getJavaTypeInternalName().equals(Type.getInternalName(JavaObjectWrapper.class))) {
                Class<?> wrappedJavaType = attributeType.getJavaObjectWrapperType();
                methodVisitor.visitMethodInsn(182, Type.getInternalName(JavaObjectWrapper.class), "getWrappedObject", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[0]), false);
                methodVisitor.visitTypeInsn(192, Type.getType(wrappedJavaType).getInternalName());
                methodVisitor.visitFieldInsn(181, internalClassName, PythonClassTranslator.getJavaFieldName(field), Type.getDescriptor(wrappedJavaType));
            } else {
                methodVisitor.visitFieldInsn(181, internalClassName, PythonClassTranslator.getJavaFieldName(field), attributeType.getJavaTypeDescriptor());
            }
            if (isAssignableFromNone) continue;
            methodVisitor.visitJumpInsn(167, doneSettingField);
            methodVisitor.visitLabel(ifFieldIsNone);
            methodVisitor.visitInsn(87);
            methodVisitor.visitInsn(1);
            if (attributeType.getJavaTypeInternalName().equals(Type.getInternalName(JavaObjectWrapper.class))) {
                methodVisitor.visitFieldInsn(181, internalClassName, PythonClassTranslator.getJavaFieldName(field), Type.getDescriptor(attributeType.getJavaObjectWrapperType()));
            } else {
                methodVisitor.visitFieldInsn(181, internalClassName, PythonClassTranslator.getJavaFieldName(field), attributeType.getJavaTypeDescriptor());
            }
            methodVisitor.visitLabel(doneSettingField);
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
    }

    public static void createWriteToCPythonReference(ClassWriter classWriter, String internalClassName, String superClassInternalName, Map<String, PythonLikeType> attributeNameToType) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "$writeFieldsToCPythonReference", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpaquePythonReference.class)}), null, null);
        methodVisitor.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(183, superClassInternalName, "$writeFieldsToCPythonReference", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpaquePythonReference.class)}), false);
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(180, Type.getInternalName(CPythonBackedPythonLikeObject.class), "$cpythonReference", Type.getDescriptor(OpaquePythonReference.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(1);
        Label ifReferenceIsNotNull = new Label();
        methodVisitor.visitJumpInsn(166, ifReferenceIsNotNull);
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel(ifReferenceIsNotNull);
        methodVisitor.visitInsn(95);
        for (String field : attributeNameToType.keySet()) {
            methodVisitor.visitInsn(92);
            PythonLikeType attributeType = attributeNameToType.get(field);
            if (attributeType.getJavaTypeInternalName().equals(Type.getInternalName(JavaObjectWrapper.class))) {
                Class<?> wrappedJavaType = attributeType.getJavaObjectWrapperType();
                methodVisitor.visitFieldInsn(180, internalClassName, PythonClassTranslator.getJavaFieldName(field), Type.getDescriptor(wrappedJavaType));
                methodVisitor.visitTypeInsn(187, Type.getInternalName(JavaObjectWrapper.class));
                methodVisitor.visitInsn(90);
                methodVisitor.visitInsn(90);
                methodVisitor.visitInsn(87);
                methodVisitor.visitMethodInsn(183, Type.getInternalName(JavaObjectWrapper.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), false);
            } else {
                methodVisitor.visitFieldInsn(180, internalClassName, PythonClassTranslator.getJavaFieldName(field), attributeType.getJavaTypeDescriptor());
            }
            methodVisitor.visitLdcInsn((Object)field);
            methodVisitor.visitInsn(95);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitInsn(91);
            methodVisitor.visitInsn(87);
            methodVisitor.visitMethodInsn(184, Type.getInternalName(CPythonBackedPythonInterpreter.class), "setAttributeOnPythonReference", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpaquePythonReference.class), Type.getType(OpaquePythonReference.class), Type.getType(String.class), Type.getType(Object.class)}), false);
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
    }

    public static InterfaceDeclaration getInterfaceForFunctionSignature(FunctionSignature functionSignature) {
        return functionSignatureToInterfaceName.computeIfAbsent(functionSignature, PythonClassTranslator::createInterfaceForFunctionSignature);
    }

    public static InterfaceDeclaration getInterfaceForPythonFunction(PythonCompiledFunction pythonCompiledFunction) {
        String[] parameterTypes = new String[pythonCompiledFunction.totalArgCount()];
        List<PythonLikeType> parameterTypeAnnotations = pythonCompiledFunction.getParameterTypes();
        for (int i = 0; i < parameterTypeAnnotations.size(); ++i) {
            parameterTypes[i] = "L" + parameterTypeAnnotations.get(i).getJavaTypeInternalName() + ";";
        }
        String returnType = "L" + pythonCompiledFunction.getReturnType().orElseGet(() -> PythonClassTranslator.getPythonReturnTypeOfFunction(pythonCompiledFunction, false)).getJavaTypeInternalName() + ";";
        FunctionSignature functionSignature = new FunctionSignature(returnType, parameterTypes);
        return functionSignatureToInterfaceName.computeIfAbsent(functionSignature, PythonClassTranslator::createInterfaceForFunctionSignature);
    }

    public static InterfaceDeclaration getInterfaceForPythonFunctionIgnoringReturn(PythonCompiledFunction pythonCompiledFunction) {
        String[] parameterTypes = new String[pythonCompiledFunction.totalArgCount()];
        List<PythonLikeType> parameterTypeAnnotations = pythonCompiledFunction.getParameterTypes();
        for (int i = 0; i < parameterTypeAnnotations.size(); ++i) {
            PythonLikeType parameterType = parameterTypeAnnotations.get(i);
            parameterTypes[i] = parameterType.getJavaTypeDescriptor();
        }
        String returnType = pythonCompiledFunction.getReturnType().orElse(BuiltinTypes.BASE_TYPE).getJavaTypeDescriptor();
        FunctionSignature functionSignature = new FunctionSignature(returnType, parameterTypes);
        return functionSignatureToInterfaceName.computeIfAbsent(functionSignature, PythonClassTranslator::createInterfaceForFunctionSignature);
    }

    public static InterfaceDeclaration getInterfaceForInstancePythonFunction(String instanceInternalClassName, PythonCompiledFunction pythonCompiledFunction) {
        List<PythonLikeType> parameterPythonTypeList = pythonCompiledFunction.getParameterTypes();
        String[] pythonParameterTypes = new String[pythonCompiledFunction.totalArgCount()];
        if (pythonParameterTypes.length > 0) {
            pythonParameterTypes[0] = "L" + instanceInternalClassName + ";";
        }
        for (int i = 1; i < pythonCompiledFunction.totalArgCount(); ++i) {
            pythonParameterTypes[i] = "L" + parameterPythonTypeList.get(i).getJavaTypeInternalName() + ";";
        }
        String returnType = "L" + pythonCompiledFunction.getReturnType().map(PythonLikeType::getJavaTypeInternalName).orElseGet(() -> PythonClassTranslator.getPythonReturnTypeOfFunction(pythonCompiledFunction, true).getJavaTypeInternalName()) + ";";
        FunctionSignature functionSignature = new FunctionSignature(returnType, pythonParameterTypes);
        return functionSignatureToInterfaceName.computeIfAbsent(functionSignature, PythonClassTranslator::createInterfaceForFunctionSignature);
    }

    public static InterfaceDeclaration getInterfaceForClassPythonFunction(PythonCompiledFunction pythonCompiledFunction) {
        List<PythonLikeType> parameterPythonTypeList = pythonCompiledFunction.getParameterTypes();
        String[] pythonParameterTypes = new String[pythonCompiledFunction.totalArgCount()];
        if (pythonParameterTypes.length > 0) {
            pythonParameterTypes[0] = Type.getDescriptor(PythonLikeType.class);
        }
        for (int i = 1; i < pythonCompiledFunction.totalArgCount(); ++i) {
            pythonParameterTypes[i] = "L" + parameterPythonTypeList.get(i).getJavaTypeInternalName() + ";";
        }
        String returnType = "L" + pythonCompiledFunction.getReturnType().map(PythonLikeType::getJavaTypeInternalName).orElseGet(() -> PythonClassTranslator.getPythonReturnTypeOfFunction(pythonCompiledFunction, true).getJavaTypeInternalName()) + ";";
        FunctionSignature functionSignature = new FunctionSignature(returnType, pythonParameterTypes);
        return functionSignatureToInterfaceName.computeIfAbsent(functionSignature, PythonClassTranslator::createInterfaceForFunctionSignature);
    }

    public static InterfaceDeclaration createInterfaceForFunctionSignature(FunctionSignature functionSignature) {
        Object maybeClassName = functionSignature.getClassName();
        int numberOfInstances = PythonBytecodeToJavaBytecodeTranslator.classNameToSharedInstanceCount.merge((String)maybeClassName, 1, Integer::sum);
        if (numberOfInstances > 1) {
            maybeClassName = (String)maybeClassName + "$$" + numberOfInstances;
        }
        String className = maybeClassName;
        String internalClassName = className.replace('.', '/');
        JavaPythonClassWriter classWriter = new JavaPythonClassWriter(3);
        classWriter.visit(55, 1537, internalClassName, null, Type.getInternalName(Object.class), null);
        classWriter.visitSource("<generated signature>", null);
        Type returnType = Type.getType((String)functionSignature.returnType);
        Type[] parameterTypes = new Type[functionSignature.parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = Type.getType((String)functionSignature.parameterTypes[i]);
        }
        classWriter.visitMethod(1025, "invoke", Type.getMethodDescriptor((Type)returnType, (Type[])parameterTypes), null, null);
        classWriter.visitEnd();
        PythonBytecodeToJavaBytecodeTranslator.writeClassOutput(BuiltinTypes.classNameToBytecode, className, classWriter.toByteArray());
        return new InterfaceDeclaration(internalClassName, Type.getMethodDescriptor((Type)returnType, (Type[])parameterTypes));
    }

    public static Class<?> getInterfaceClassForDeclaration(InterfaceDeclaration interfaceDeclaration) {
        try {
            return BuiltinTypes.asmClassLoader.loadClass(interfaceDeclaration.interfaceName.replaceAll("/", "."));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot load " + interfaceDeclaration.interfaceName + " from the classloader; maybe it was not created?", e);
        }
    }

    private static FlowGraph createFlowGraph(PythonCompiledFunction pythonCompiledFunction, boolean isVirtual) {
        InterfaceDeclaration interfaceDeclaration = PythonClassTranslator.getInterfaceForPythonFunctionIgnoringReturn(pythonCompiledFunction);
        MethodDescriptor methodDescriptor = new MethodDescriptor(interfaceDeclaration.interfaceName.replace('.', '/'), MethodDescriptor.MethodType.INTERFACE, "invoke", interfaceDeclaration.methodDescriptor);
        LocalVariableHelper localVariableHelper = new LocalVariableHelper(methodDescriptor.getParameterTypes(), pythonCompiledFunction);
        List<Opcode> opcodeList = PythonBytecodeToJavaBytecodeTranslator.getOpcodeList(pythonCompiledFunction);
        StackMetadata initialStackMetadata = PythonBytecodeToJavaBytecodeTranslator.getInitialStackMetadata(localVariableHelper, methodDescriptor, isVirtual);
        FunctionMetadata functionMetadata = new FunctionMetadata();
        functionMetadata.functionType = PythonBytecodeToJavaBytecodeTranslator.getFunctionType(pythonCompiledFunction);
        functionMetadata.bytecodeCounterToLabelMap = new HashMap<Integer, Label>();
        functionMetadata.bytecodeCounterToCodeArgumenterList = new HashMap<Integer, List<Runnable>>();
        functionMetadata.method = methodDescriptor;
        functionMetadata.pythonCompiledFunction = pythonCompiledFunction;
        functionMetadata.className = "";
        functionMetadata.methodVisitor = null;
        return FlowGraph.createFlowGraph(functionMetadata, initialStackMetadata, opcodeList);
    }

    public static Set<String> getReferencedSelfAttributes(PythonCompiledFunction pythonCompiledFunction) {
        FlowGraph flowGraph = PythonClassTranslator.createFlowGraph(pythonCompiledFunction, true);
        HashSet<String> referencedSelfAttributeSet = new HashSet<String>();
        BiConsumer<AbstractOpcode, StackMetadata> attributeVisitor = (attributeOpcode, stackMetadata) -> {
            Set<Opcode> possibleSourceOpcodeSet = stackMetadata.getTOSValueSource().getPossibleSourceOpcodeSet();
            if (possibleSourceOpcodeSet.stream().anyMatch(opcode -> {
                if (opcode instanceof LoadFastOpcode || opcode instanceof StoreAttrOpcode || opcode instanceof DeleteAttrOpcode) {
                    AbstractOpcode instructionOpcode = (AbstractOpcode)opcode;
                    return instructionOpcode.getInstruction().arg() == 0;
                }
                return opcode instanceof SelfOpcodeWithoutSource;
            })) {
                referencedSelfAttributeSet.add(pythonCompiledFunction.co_names.get(attributeOpcode.getInstruction().arg()));
            }
        };
        flowGraph.visitOperations(LoadAttrOpcode.class, attributeVisitor);
        flowGraph.visitOperations(StoreAttrOpcode.class, attributeVisitor);
        flowGraph.visitOperations(DeleteAttrOpcode.class, attributeVisitor);
        return referencedSelfAttributeSet;
    }

    public static PythonLikeType getPythonReturnTypeOfFunction(PythonCompiledFunction pythonCompiledFunction, boolean isVirtual) {
        try {
            if (PythonBytecodeToJavaBytecodeTranslator.getFunctionType(pythonCompiledFunction) == PythonFunctionType.GENERATOR) {
                return BuiltinTypes.GENERATOR_TYPE;
            }
            FlowGraph flowGraph = PythonClassTranslator.createFlowGraph(pythonCompiledFunction, isVirtual);
            ArrayList possibleReturnTypeList = new ArrayList();
            flowGraph.visitOperations(ReturnValueOpcode.class, (opcode, stackMetadata) -> possibleReturnTypeList.add(stackMetadata.getTOSType()));
            flowGraph.visitOperations(ReturnConstantValueOpcode.class, (opcode, stackMetadata) -> possibleReturnTypeList.add(opcode.getConstant(pythonCompiledFunction).$getGenericType()));
            return possibleReturnTypeList.stream().reduce(PythonLikeType::unifyWith).orElse(BuiltinTypes.NONE_TYPE);
        }
        catch (UnsupportedOperationException e) {
            return BuiltinTypes.BASE_TYPE;
        }
        catch (Exception e) {
            System.out.println("WARNING: Ignoring exception");
            System.out.println("Instructions:");
            System.out.println(pythonCompiledFunction.instructionList.stream().map(PythonBytecodeInstruction::toString).collect(Collectors.joining("\n")));
            e.printStackTrace();
            return BuiltinTypes.BASE_TYPE;
        }
    }

    public record PreparedClassInfo(PythonLikeType type, String className, String classInternalName) {
    }

    public static enum PythonMethodKind {
        VIRTUAL_METHOD,
        STATIC_METHOD,
        CLASS_METHOD;

    }

    public record InterfaceDeclaration(String interfaceName, String methodDescriptor) {
        public String descriptor() {
            return "L" + this.interfaceName + ";";
        }

        public Type methodType() {
            return Type.getMethodType((String)this.methodDescriptor);
        }
    }

    private record MatchedMapping(int index, PythonJavaTypeMapping<?, ?> pythonJavaTypeMapping) {
    }

    public static class FunctionSignature {
        final String returnType;
        final String[] parameterTypes;

        public FunctionSignature(String returnType, String ... parameterTypes) {
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
        }

        public String getClassName() {
            return "org.jpyinterpreter.synthetic.signature.InterfaceSignature";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionSignature that = (FunctionSignature)o;
            return this.returnType.equals(that.returnType) && Arrays.equals(this.parameterTypes, that.parameterTypes);
        }

        public int hashCode() {
            int result = Objects.hash(this.returnType);
            result = 31 * result + Arrays.hashCode(this.parameterTypes);
            return result;
        }
    }
}

