/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import ai.timefold.jpyinterpreter.AnnotationMetadata;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public record TypeHint(PythonLikeType type, List<AnnotationMetadata> annotationList, TypeHint[] genericArgs, PythonLikeType javaGetterType) {
    public TypeHint {
        annotationList = Collections.unmodifiableList(annotationList);
    }

    public TypeHint(PythonLikeType type, List<AnnotationMetadata> annotationList) {
        this(type, annotationList, null, type);
    }

    public TypeHint(PythonLikeType type, List<AnnotationMetadata> annotationList, PythonLikeType javaGetterType) {
        this(type, annotationList, null, javaGetterType);
    }

    public TypeHint addAnnotations(List<AnnotationMetadata> addedAnnotations) {
        ArrayList<AnnotationMetadata> combinedAnnotations = new ArrayList<AnnotationMetadata>(this.annotationList.size() + addedAnnotations.size());
        combinedAnnotations.addAll(this.annotationList);
        combinedAnnotations.addAll(addedAnnotations);
        return new TypeHint(this.type, combinedAnnotations, this.genericArgs, this.javaGetterType);
    }

    public static TypeHint withoutAnnotations(PythonLikeType type) {
        return new TypeHint(type, Collections.emptyList());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeHint)) {
            return false;
        }
        TypeHint typeHint = (TypeHint)o;
        return Objects.equals(this.type, typeHint.type) && Objects.deepEquals(this.genericArgs, typeHint.genericArgs) && Objects.equals(this.javaGetterType, typeHint.javaGetterType) && Objects.equals(this.annotationList, typeHint.annotationList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.annotationList, Arrays.hashCode(this.genericArgs), this.javaGetterType);
    }

    @Override
    public String toString() {
        return "TypeHint{type=" + this.type + ", annotationList=" + this.annotationList + ", genericArgs=" + Arrays.toString(this.genericArgs) + ", javaGetterType=" + this.javaGetterType + "}";
    }
}

