/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.implementors;

import ai.timefold.jpyinterpreter.PythonClassTranslator;
import ai.timefold.jpyinterpreter.PythonCompiledClass;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.implementors.JavaInterfaceImplementor;
import ai.timefold.jpyinterpreter.implementors.JavaPythonTypeConversionImplementor;
import ai.timefold.jpyinterpreter.types.errors.TypeError;
import ai.timefold.jpyinterpreter.util.MethodVisitorAdapters;
import ai.timefold.jpyinterpreter.util.arguments.ArgumentSpec;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class DelegatingInterfaceImplementor
extends JavaInterfaceImplementor {
    final String internalClassName;
    final Class<?> interfaceClass;
    final Map<String, PythonClassTranslator.InterfaceDeclaration> methodNameToFieldDescriptor;

    public DelegatingInterfaceImplementor(String internalClassName, Class<?> interfaceClass, Map<String, PythonClassTranslator.InterfaceDeclaration> methodNameToFieldDescriptor) {
        this.internalClassName = internalClassName;
        this.interfaceClass = interfaceClass;
        this.methodNameToFieldDescriptor = methodNameToFieldDescriptor;
    }

    @Override
    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    @Override
    public void implement(ClassWriter classWriter, PythonCompiledClass compiledClass) {
        for (Method method : this.interfaceClass.getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !method.getDeclaringClass().isInterface()) continue;
            this.implementMethod(classWriter, compiledClass, method);
        }
    }

    private void implementMethod(ClassWriter classWriter, PythonCompiledClass compiledClass, Method interfaceMethod) {
        if (!this.methodNameToFieldDescriptor.containsKey(interfaceMethod.getName())) {
            if (interfaceMethod.isDefault()) {
                return;
            }
            throw new TypeError("Class %s cannot implement interface %s because it does not implement method %s.".formatted(compiledClass.className, interfaceMethod.getDeclaringClass().getName(), interfaceMethod.getName()));
        }
        String interfaceMethodDescriptor = Type.getMethodDescriptor((Method)interfaceMethod);
        MethodVisitor interfaceMethodVisitor = classWriter.visitMethod(1, interfaceMethod.getName(), interfaceMethodDescriptor, null, null);
        interfaceMethodVisitor = MethodVisitorAdapters.adapt(interfaceMethodVisitor, interfaceMethod.getName(), interfaceMethodDescriptor);
        for (Parameter parameter : interfaceMethod.getParameters()) {
            interfaceMethodVisitor.visitParameter(parameter.getName(), 0);
        }
        interfaceMethodVisitor.visitCode();
        interfaceMethodVisitor.visitVarInsn(25, 0);
        interfaceMethodVisitor.visitTypeInsn(187, Type.getInternalName(IdentityHashMap.class));
        interfaceMethodVisitor.visitInsn(89);
        interfaceMethodVisitor.visitMethodInsn(183, Type.getInternalName(IdentityHashMap.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        interfaceMethodVisitor.visitVarInsn(58, interfaceMethod.getParameterCount() + 1);
        PythonClassTranslator.InterfaceDeclaration functionInterfaceDeclaration = this.methodNameToFieldDescriptor.get(interfaceMethod.getName());
        interfaceMethodVisitor.visitVarInsn(25, 0);
        interfaceMethodVisitor.visitFieldInsn(178, this.internalClassName, PythonClassTranslator.getJavaMethodHolderName(interfaceMethod.getName()), functionInterfaceDeclaration.descriptor());
        interfaceMethodVisitor.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[0]), false);
        interfaceMethodVisitor.visitLdcInsn((Object)"__spec__");
        interfaceMethodVisitor.visitMethodInsn(182, Type.getInternalName(Class.class), "getField", Type.getMethodDescriptor((Type)Type.getType(Field.class), (Type[])new Type[]{Type.getType(String.class)}), false);
        interfaceMethodVisitor.visitFieldInsn(178, this.internalClassName, PythonClassTranslator.getJavaMethodHolderName(interfaceMethod.getName()), functionInterfaceDeclaration.descriptor());
        interfaceMethodVisitor.visitMethodInsn(182, Type.getInternalName(Field.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class)}), false);
        interfaceMethodVisitor.visitTypeInsn(192, Type.getInternalName(ArgumentSpec.class));
        Type methodType = functionInterfaceDeclaration.methodType();
        int argumentCount = methodType.getArgumentCount();
        DelegatingInterfaceImplementor.prepareParametersForMethodCallFromArgumentSpec(interfaceMethod, interfaceMethodVisitor, argumentCount, methodType, true);
        Type[] javaParameterTypes = new Type[Math.max(0, argumentCount - 1)];
        for (int i = 1; i < argumentCount; ++i) {
            javaParameterTypes[i - 1] = methodType.getArgumentTypes()[i];
        }
        String javaMethodDescriptor = Type.getMethodDescriptor((Type)methodType.getReturnType(), (Type[])javaParameterTypes);
        interfaceMethodVisitor.visitMethodInsn(182, this.internalClassName, PythonClassTranslator.getJavaMethodName(interfaceMethod.getName()), javaMethodDescriptor, false);
        Class<?> returnType = interfaceMethod.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            interfaceMethodVisitor.visitInsn(177);
        } else {
            if (returnType.isPrimitive()) {
                DelegatingInterfaceImplementor.loadBoxedPrimitiveTypeClass(returnType, interfaceMethodVisitor);
            } else {
                interfaceMethodVisitor.visitLdcInsn((Object)Type.getType(returnType));
            }
            interfaceMethodVisitor.visitInsn(95);
            interfaceMethodVisitor.visitMethodInsn(184, Type.getInternalName(JavaPythonTypeConversionImplementor.class), "convertPythonObjectToJavaType", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Class.class), Type.getType(PythonLikeObject.class)}), false);
            if (returnType.isPrimitive()) {
                DelegatingInterfaceImplementor.unboxBoxedPrimitiveType(returnType, interfaceMethodVisitor);
                interfaceMethodVisitor.visitInsn(Type.getType(returnType).getOpcode(172));
            } else {
                interfaceMethodVisitor.visitTypeInsn(192, Type.getInternalName(returnType));
                interfaceMethodVisitor.visitInsn(176);
            }
        }
        interfaceMethodVisitor.visitMaxs(interfaceMethod.getParameterCount() + 2, 1);
        interfaceMethodVisitor.visitEnd();
    }

    public static void prepareParametersForMethodCallFromArgumentSpec(Method interfaceMethod, MethodVisitor interfaceMethodVisitor, int argumentCount, Type methodType, boolean skipSelf) {
        int i;
        int parameterStart = skipSelf ? 1 : 0;
        interfaceMethodVisitor.visitLdcInsn((Object)interfaceMethod.getParameterCount());
        interfaceMethodVisitor.visitTypeInsn(189, Type.getInternalName(PythonLikeObject.class));
        interfaceMethodVisitor.visitVarInsn(58, interfaceMethod.getParameterCount() + 2);
        for (i = 0; i < interfaceMethod.getParameterCount(); ++i) {
            Class<?> parameterType = interfaceMethod.getParameterTypes()[i];
            interfaceMethodVisitor.visitVarInsn(25, interfaceMethod.getParameterCount() + 2);
            interfaceMethodVisitor.visitLdcInsn((Object)i);
            interfaceMethodVisitor.visitVarInsn(Type.getType(parameterType).getOpcode(21), i + 1);
            if (parameterType.isPrimitive()) {
                DelegatingInterfaceImplementor.convertPrimitiveToObjectType(parameterType, interfaceMethodVisitor);
            }
            interfaceMethodVisitor.visitVarInsn(25, interfaceMethod.getParameterCount() + 1);
            interfaceMethodVisitor.visitMethodInsn(184, Type.getInternalName(JavaPythonTypeConversionImplementor.class), "wrapJavaObject", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Map.class)}), false);
            interfaceMethodVisitor.visitInsn(83);
        }
        interfaceMethodVisitor.visitVarInsn(25, interfaceMethod.getParameterCount() + 2);
        interfaceMethodVisitor.visitMethodInsn(184, Type.getInternalName(List.class), "of", Type.getMethodDescriptor((Type)Type.getType(List.class), (Type[])new Type[]{Type.getType(Object[].class)}), true);
        interfaceMethodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptyMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), false);
        interfaceMethodVisitor.visitMethodInsn(182, Type.getInternalName(ArgumentSpec.class), "extractArgumentList", Type.getMethodDescriptor((Type)Type.getType(List.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class)}), false);
        for (i = 0; i < argumentCount - parameterStart; ++i) {
            interfaceMethodVisitor.visitInsn(89);
            interfaceMethodVisitor.visitLdcInsn((Object)i);
            interfaceMethodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.INT_TYPE}), true);
            interfaceMethodVisitor.visitTypeInsn(192, methodType.getArgumentTypes()[i + parameterStart].getInternalName());
            interfaceMethodVisitor.visitInsn(95);
        }
        interfaceMethodVisitor.visitInsn(87);
    }

    public static void convertPrimitiveToObjectType(Class<?> primitiveType, MethodVisitor methodVisitor) {
        if (primitiveType.equals(Boolean.TYPE)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Boolean.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Boolean.class), (Type[])new Type[]{Type.BOOLEAN_TYPE}), false);
        } else if (primitiveType.equals(Byte.TYPE)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Byte.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Byte.class), (Type[])new Type[]{Type.BYTE_TYPE}), false);
        } else if (primitiveType.equals(Character.TYPE)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Character.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Character.class), (Type[])new Type[]{Type.CHAR_TYPE}), false);
        } else if (primitiveType.equals(Short.TYPE)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Short.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Short.class), (Type[])new Type[]{Type.SHORT_TYPE}), false);
        } else if (primitiveType.equals(Integer.TYPE)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Integer.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Integer.class), (Type[])new Type[]{Type.INT_TYPE}), false);
        } else if (primitiveType.equals(Long.TYPE)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Long.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Long.class), (Type[])new Type[]{Type.LONG_TYPE}), false);
        } else if (primitiveType.equals(Float.TYPE)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Float.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Float.class), (Type[])new Type[]{Type.FLOAT_TYPE}), false);
        } else if (primitiveType.equals(Double.TYPE)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Double.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Double.class), (Type[])new Type[]{Type.DOUBLE_TYPE}), false);
        } else {
            throw new IllegalStateException("Unknown primitive type %s.".formatted(primitiveType));
        }
    }

    public static void loadBoxedPrimitiveTypeClass(Class<?> primitiveType, MethodVisitor methodVisitor) {
        if (primitiveType.equals(Boolean.TYPE)) {
            methodVisitor.visitLdcInsn((Object)Type.getType(Boolean.class));
        } else if (primitiveType.equals(Byte.TYPE)) {
            methodVisitor.visitLdcInsn((Object)Type.getType(Byte.class));
        } else if (primitiveType.equals(Character.TYPE)) {
            methodVisitor.visitLdcInsn((Object)Type.getType(Character.class));
        } else if (primitiveType.equals(Short.TYPE)) {
            methodVisitor.visitLdcInsn((Object)Type.getType(Short.class));
        } else if (primitiveType.equals(Integer.TYPE)) {
            methodVisitor.visitLdcInsn((Object)Type.getType(Integer.class));
        } else if (primitiveType.equals(Long.TYPE)) {
            methodVisitor.visitLdcInsn((Object)Type.getType(Long.class));
        } else if (primitiveType.equals(Float.TYPE)) {
            methodVisitor.visitLdcInsn((Object)Type.getType(Float.class));
        } else if (primitiveType.equals(Double.TYPE)) {
            methodVisitor.visitLdcInsn((Object)Type.getType(Double.class));
        } else {
            throw new IllegalStateException("Unknown primitive type %s.".formatted(primitiveType));
        }
    }

    public static void unboxBoxedPrimitiveType(Class<?> primitiveType, MethodVisitor methodVisitor) {
        if (primitiveType.equals(Boolean.TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Boolean.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]), false);
        } else if (primitiveType.equals(Byte.TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Byte.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Byte.class), "byteValue", Type.getMethodDescriptor((Type)Type.BYTE_TYPE, (Type[])new Type[0]), false);
        } else if (primitiveType.equals(Character.TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Character.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Character.class), "charValue", Type.getMethodDescriptor((Type)Type.CHAR_TYPE, (Type[])new Type[0]), false);
        } else if (primitiveType.equals(Short.TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Short.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Short.class), "shortValue", Type.getMethodDescriptor((Type)Type.SHORT_TYPE, (Type[])new Type[0]), false);
        } else if (primitiveType.equals(Integer.TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Integer.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Integer.class), "intValue", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), false);
        } else if (primitiveType.equals(Long.TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Long.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Long.class), "longValue", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
        } else if (primitiveType.equals(Float.TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Float.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Float.class), "floatValue", Type.getMethodDescriptor((Type)Type.FLOAT_TYPE, (Type[])new Type[0]), false);
        } else if (primitiveType.equals(Double.TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Double.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Double.class), "doubleValue", Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[0]), false);
        } else {
            throw new IllegalStateException("Unknown primitive type %s.".formatted(primitiveType));
        }
    }
}

