/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.opcodes.descriptor;

import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.PythonVersion;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.opcodes.descriptor.OpcodeDescriptor;
import ai.timefold.jpyinterpreter.opcodes.descriptor.VersionMapping;
import ai.timefold.jpyinterpreter.opcodes.exceptions.BeforeWithOpcode;
import ai.timefold.jpyinterpreter.opcodes.exceptions.CheckExcMatchOpcode;
import ai.timefold.jpyinterpreter.opcodes.exceptions.CleanupThrowOpcode;
import ai.timefold.jpyinterpreter.opcodes.exceptions.LoadAssertionErrorOpcode;
import ai.timefold.jpyinterpreter.opcodes.exceptions.PopBlockOpcode;
import ai.timefold.jpyinterpreter.opcodes.exceptions.PopExceptOpcode;
import ai.timefold.jpyinterpreter.opcodes.exceptions.PushExcInfoOpcode;
import ai.timefold.jpyinterpreter.opcodes.exceptions.RaiseVarargsOpcode;
import ai.timefold.jpyinterpreter.opcodes.exceptions.ReraiseOpcode;
import ai.timefold.jpyinterpreter.opcodes.exceptions.SetupFinallyOpcode;
import ai.timefold.jpyinterpreter.opcodes.exceptions.SetupWithOpcode;
import ai.timefold.jpyinterpreter.opcodes.exceptions.WithExceptStartOpcode;
import ai.timefold.jpyinterpreter.util.JumpUtils;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;

public enum ExceptionOpDescriptor implements OpcodeDescriptor
{
    LOAD_ASSERTION_ERROR(LoadAssertionErrorOpcode::new),
    POP_BLOCK(PopBlockOpcode::new),
    POP_EXCEPT(PopExceptOpcode::new),
    RERAISE(ReraiseOpcode::new),
    CHECK_EXC_MATCH(CheckExcMatchOpcode::new),
    PUSH_EXC_INFO(PushExcInfoOpcode::new),
    RAISE_VARARGS(RaiseVarargsOpcode::new),
    WITH_EXCEPT_START(WithExceptStartOpcode::new),
    SETUP_FINALLY(SetupFinallyOpcode::new, JumpUtils::getRelativeTarget),
    BEFORE_WITH(BeforeWithOpcode::new),
    SETUP_WITH(SetupWithOpcode::new, JumpUtils::getRelativeTarget),
    CLEANUP_THROW(CleanupThrowOpcode::new);

    final VersionMapping versionLookup;

    private ExceptionOpDescriptor(Function<PythonBytecodeInstruction, Opcode> opcodeFunction) {
        this.versionLookup = VersionMapping.constantMapping(opcodeFunction);
    }

    private ExceptionOpDescriptor(BiFunction<PythonBytecodeInstruction, Integer, Opcode> opcodeFunction, ToIntBiFunction<PythonBytecodeInstruction, PythonVersion> jumpFunction) {
        this.versionLookup = VersionMapping.constantMapping((instruction, pythonVersion) -> (Opcode)opcodeFunction.apply((PythonBytecodeInstruction)instruction, jumpFunction.applyAsInt((PythonBytecodeInstruction)instruction, (PythonVersion)pythonVersion)));
    }

    @Override
    public VersionMapping getVersionMapping() {
        return this.versionLookup;
    }
}

