/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.builtins.UnaryDunderBuiltin;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonBytesLikeObject;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonNone;
import ai.timefold.jpyinterpreter.types.PythonSlice;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.DelegatePythonIterator;
import ai.timefold.jpyinterpreter.types.collections.PythonIterator;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeDict;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeList;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.errors.TypeError;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import ai.timefold.jpyinterpreter.types.errors.lookup.IndexError;
import ai.timefold.jpyinterpreter.types.errors.unicode.UnicodeDecodeError;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.jpyinterpreter.util.ByteCharSequence;
import ai.timefold.jpyinterpreter.util.StringFormatter;
import ai.timefold.solver.core.impl.domain.solution.cloner.PlanningImmutable;
import java.io.ByteArrayOutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.BitSet;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PythonBytes
extends AbstractPythonLikeObject
implements PythonBytesLikeObject,
PlanningImmutable {
    public static final PythonBytes EMPTY = new PythonBytes(new byte[0]);
    private static final PythonBytes ASCII_SPACE = new PythonBytes(new byte[]{32});
    private static final BitSet ASCII_WHITESPACE_BITSET = PythonBytes.asBitSet(new PythonBytes(new byte[]{32, 9, 10, 13, 11, 12}));
    public static final PythonInteger[] BYTE_TO_INT = new PythonInteger[]{PythonInteger.valueOf(0), PythonInteger.valueOf(1), PythonInteger.valueOf(2), PythonInteger.valueOf(3), PythonInteger.valueOf(4), PythonInteger.valueOf(5), PythonInteger.valueOf(6), PythonInteger.valueOf(7), PythonInteger.valueOf(8), PythonInteger.valueOf(9), PythonInteger.valueOf(10), PythonInteger.valueOf(11), PythonInteger.valueOf(12), PythonInteger.valueOf(13), PythonInteger.valueOf(14), PythonInteger.valueOf(15), PythonInteger.valueOf(16), PythonInteger.valueOf(17), PythonInteger.valueOf(18), PythonInteger.valueOf(19), PythonInteger.valueOf(20), PythonInteger.valueOf(21), PythonInteger.valueOf(22), PythonInteger.valueOf(23), PythonInteger.valueOf(24), PythonInteger.valueOf(25), PythonInteger.valueOf(26), PythonInteger.valueOf(27), PythonInteger.valueOf(28), PythonInteger.valueOf(29), PythonInteger.valueOf(30), PythonInteger.valueOf(31), PythonInteger.valueOf(32), PythonInteger.valueOf(33), PythonInteger.valueOf(34), PythonInteger.valueOf(35), PythonInteger.valueOf(36), PythonInteger.valueOf(37), PythonInteger.valueOf(38), PythonInteger.valueOf(39), PythonInteger.valueOf(40), PythonInteger.valueOf(41), PythonInteger.valueOf(42), PythonInteger.valueOf(43), PythonInteger.valueOf(44), PythonInteger.valueOf(45), PythonInteger.valueOf(46), PythonInteger.valueOf(47), PythonInteger.valueOf(48), PythonInteger.valueOf(49), PythonInteger.valueOf(50), PythonInteger.valueOf(51), PythonInteger.valueOf(52), PythonInteger.valueOf(53), PythonInteger.valueOf(54), PythonInteger.valueOf(55), PythonInteger.valueOf(56), PythonInteger.valueOf(57), PythonInteger.valueOf(58), PythonInteger.valueOf(59), PythonInteger.valueOf(60), PythonInteger.valueOf(61), PythonInteger.valueOf(62), PythonInteger.valueOf(63), PythonInteger.valueOf(64), PythonInteger.valueOf(65), PythonInteger.valueOf(66), PythonInteger.valueOf(67), PythonInteger.valueOf(68), PythonInteger.valueOf(69), PythonInteger.valueOf(70), PythonInteger.valueOf(71), PythonInteger.valueOf(72), PythonInteger.valueOf(73), PythonInteger.valueOf(74), PythonInteger.valueOf(75), PythonInteger.valueOf(76), PythonInteger.valueOf(77), PythonInteger.valueOf(78), PythonInteger.valueOf(79), PythonInteger.valueOf(80), PythonInteger.valueOf(81), PythonInteger.valueOf(82), PythonInteger.valueOf(83), PythonInteger.valueOf(84), PythonInteger.valueOf(85), PythonInteger.valueOf(86), PythonInteger.valueOf(87), PythonInteger.valueOf(88), PythonInteger.valueOf(89), PythonInteger.valueOf(90), PythonInteger.valueOf(91), PythonInteger.valueOf(92), PythonInteger.valueOf(93), PythonInteger.valueOf(94), PythonInteger.valueOf(95), PythonInteger.valueOf(96), PythonInteger.valueOf(97), PythonInteger.valueOf(98), PythonInteger.valueOf(99), PythonInteger.valueOf(100), PythonInteger.valueOf(101), PythonInteger.valueOf(102), PythonInteger.valueOf(103), PythonInteger.valueOf(104), PythonInteger.valueOf(105), PythonInteger.valueOf(106), PythonInteger.valueOf(107), PythonInteger.valueOf(108), PythonInteger.valueOf(109), PythonInteger.valueOf(110), PythonInteger.valueOf(111), PythonInteger.valueOf(112), PythonInteger.valueOf(113), PythonInteger.valueOf(114), PythonInteger.valueOf(115), PythonInteger.valueOf(116), PythonInteger.valueOf(117), PythonInteger.valueOf(118), PythonInteger.valueOf(119), PythonInteger.valueOf(120), PythonInteger.valueOf(121), PythonInteger.valueOf(122), PythonInteger.valueOf(123), PythonInteger.valueOf(124), PythonInteger.valueOf(125), PythonInteger.valueOf(126), PythonInteger.valueOf(127), PythonInteger.valueOf(128), PythonInteger.valueOf(129), PythonInteger.valueOf(130), PythonInteger.valueOf(131), PythonInteger.valueOf(132), PythonInteger.valueOf(133), PythonInteger.valueOf(134), PythonInteger.valueOf(135), PythonInteger.valueOf(136), PythonInteger.valueOf(137), PythonInteger.valueOf(138), PythonInteger.valueOf(139), PythonInteger.valueOf(140), PythonInteger.valueOf(141), PythonInteger.valueOf(142), PythonInteger.valueOf(143), PythonInteger.valueOf(144), PythonInteger.valueOf(145), PythonInteger.valueOf(146), PythonInteger.valueOf(147), PythonInteger.valueOf(148), PythonInteger.valueOf(149), PythonInteger.valueOf(150), PythonInteger.valueOf(151), PythonInteger.valueOf(152), PythonInteger.valueOf(153), PythonInteger.valueOf(154), PythonInteger.valueOf(155), PythonInteger.valueOf(156), PythonInteger.valueOf(157), PythonInteger.valueOf(158), PythonInteger.valueOf(159), PythonInteger.valueOf(160), PythonInteger.valueOf(161), PythonInteger.valueOf(162), PythonInteger.valueOf(163), PythonInteger.valueOf(164), PythonInteger.valueOf(165), PythonInteger.valueOf(166), PythonInteger.valueOf(167), PythonInteger.valueOf(168), PythonInteger.valueOf(169), PythonInteger.valueOf(170), PythonInteger.valueOf(171), PythonInteger.valueOf(172), PythonInteger.valueOf(173), PythonInteger.valueOf(174), PythonInteger.valueOf(175), PythonInteger.valueOf(176), PythonInteger.valueOf(177), PythonInteger.valueOf(178), PythonInteger.valueOf(179), PythonInteger.valueOf(180), PythonInteger.valueOf(181), PythonInteger.valueOf(182), PythonInteger.valueOf(183), PythonInteger.valueOf(184), PythonInteger.valueOf(185), PythonInteger.valueOf(186), PythonInteger.valueOf(187), PythonInteger.valueOf(188), PythonInteger.valueOf(189), PythonInteger.valueOf(190), PythonInteger.valueOf(191), PythonInteger.valueOf(192), PythonInteger.valueOf(193), PythonInteger.valueOf(194), PythonInteger.valueOf(195), PythonInteger.valueOf(196), PythonInteger.valueOf(197), PythonInteger.valueOf(198), PythonInteger.valueOf(199), PythonInteger.valueOf(200), PythonInteger.valueOf(201), PythonInteger.valueOf(202), PythonInteger.valueOf(203), PythonInteger.valueOf(204), PythonInteger.valueOf(205), PythonInteger.valueOf(206), PythonInteger.valueOf(207), PythonInteger.valueOf(208), PythonInteger.valueOf(209), PythonInteger.valueOf(210), PythonInteger.valueOf(211), PythonInteger.valueOf(212), PythonInteger.valueOf(213), PythonInteger.valueOf(214), PythonInteger.valueOf(215), PythonInteger.valueOf(216), PythonInteger.valueOf(217), PythonInteger.valueOf(218), PythonInteger.valueOf(219), PythonInteger.valueOf(220), PythonInteger.valueOf(221), PythonInteger.valueOf(222), PythonInteger.valueOf(223), PythonInteger.valueOf(224), PythonInteger.valueOf(225), PythonInteger.valueOf(226), PythonInteger.valueOf(227), PythonInteger.valueOf(228), PythonInteger.valueOf(229), PythonInteger.valueOf(230), PythonInteger.valueOf(231), PythonInteger.valueOf(232), PythonInteger.valueOf(233), PythonInteger.valueOf(234), PythonInteger.valueOf(235), PythonInteger.valueOf(236), PythonInteger.valueOf(237), PythonInteger.valueOf(238), PythonInteger.valueOf(239), PythonInteger.valueOf(240), PythonInteger.valueOf(241), PythonInteger.valueOf(242), PythonInteger.valueOf(243), PythonInteger.valueOf(244), PythonInteger.valueOf(245), PythonInteger.valueOf(246), PythonInteger.valueOf(247), PythonInteger.valueOf(248), PythonInteger.valueOf(249), PythonInteger.valueOf(250), PythonInteger.valueOf(251), PythonInteger.valueOf(252), PythonInteger.valueOf(253), PythonInteger.valueOf(254), PythonInteger.valueOf(255)};
    public final byte[] value;

    private static PythonLikeType registerMethods() throws NoSuchMethodException {
        BuiltinTypes.BYTES_TYPE.setConstructor((positionalArguments, namedArguments, callerInstance) -> {
            if (positionalArguments.isEmpty()) {
                return new PythonBytes(new byte[0]);
            }
            if (positionalArguments.size() == 1) {
                PythonLikeObject arg = (PythonLikeObject)positionalArguments.get(0);
                if (arg instanceof PythonInteger) {
                    return new PythonBytes(new byte[((PythonInteger)arg).value.intValueExact()]);
                }
                PythonIterator iterator = (PythonIterator)UnaryDunderBuiltin.ITERATOR.invoke(arg);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] toWrite = new byte[1];
                while (iterator.hasNext()) {
                    PythonLikeObject item = iterator.nextPythonItem();
                    if (!(item instanceof PythonInteger)) {
                        throw new ValueError("bytearray argument 1 must be an int or an iterable of int");
                    }
                    toWrite[0] = ((PythonInteger)item).asByte();
                    out.writeBytes(toWrite);
                }
                return new PythonBytes(out.toByteArray());
            }
            throw new ValueError("bytearray takes 0 or 1 arguments, not " + positionalArguments.size());
        });
        BuiltinTypes.BYTES_TYPE.addUnaryMethod(PythonUnaryOperator.REPRESENTATION, PythonBytes.class.getMethod("repr", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addUnaryMethod(PythonUnaryOperator.AS_STRING, PythonBytes.class.getMethod("asString", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addUnaryMethod(PythonUnaryOperator.ITERATOR, PythonBytes.class.getMethod("getIterator", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addUnaryMethod(PythonUnaryOperator.LENGTH, PythonBytes.class.getMethod("getLength", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addBinaryMethod(PythonBinaryOperator.GET_ITEM, PythonBytes.class.getMethod("getCharAt", PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addBinaryMethod(PythonBinaryOperator.GET_ITEM, PythonBytes.class.getMethod("getSubsequence", PythonSlice.class));
        BuiltinTypes.BYTES_TYPE.addBinaryMethod(PythonBinaryOperator.CONTAINS, PythonBytes.class.getMethod("containsSubsequence", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addBinaryMethod(PythonBinaryOperator.ADD, PythonBytes.class.getMethod("concat", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addBinaryMethod(PythonBinaryOperator.MULTIPLY, PythonBytes.class.getMethod("repeat", PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addBinaryMethod(PythonBinaryOperator.MODULO, PythonBytes.class.getMethod("interpolate", PythonLikeObject.class));
        BuiltinTypes.BYTES_TYPE.addBinaryMethod(PythonBinaryOperator.MODULO, PythonBytes.class.getMethod("interpolate", PythonLikeTuple.class));
        BuiltinTypes.BYTES_TYPE.addBinaryMethod(PythonBinaryOperator.MODULO, PythonBytes.class.getMethod("interpolate", PythonLikeDict.class));
        BuiltinTypes.BYTES_TYPE.addMethod("capitalize", PythonBytes.class.getMethod("capitalize", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("center", PythonBytes.class.getMethod("center", PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("center", PythonBytes.class.getMethod("center", PythonInteger.class, PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("count", PythonBytes.class.getMethod("count", PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("count", PythonBytes.class.getMethod("count", PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("count", PythonBytes.class.getMethod("count", PythonInteger.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("count", PythonBytes.class.getMethod("count", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("count", PythonBytes.class.getMethod("count", PythonBytes.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("count", PythonBytes.class.getMethod("count", PythonBytes.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("endswith", PythonBytes.class.getMethod("endsWith", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("endswith", PythonBytes.class.getMethod("endsWith", PythonLikeTuple.class));
        BuiltinTypes.BYTES_TYPE.addMethod("endswith", PythonBytes.class.getMethod("endsWith", PythonBytes.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("endswith", PythonBytes.class.getMethod("endsWith", PythonLikeTuple.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("endswith", PythonBytes.class.getMethod("endsWith", PythonBytes.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("endswith", PythonBytes.class.getMethod("endsWith", PythonLikeTuple.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("expandtabs", PythonBytes.class.getMethod("expandTabs", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("expandtabs", PythonBytes.class.getMethod("expandTabs", PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("find", PythonBytes.class.getMethod("find", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("find", PythonBytes.class.getMethod("find", PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("find", PythonBytes.class.getMethod("find", PythonBytes.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("find", PythonBytes.class.getMethod("find", PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("find", PythonBytes.class.getMethod("find", PythonBytes.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("find", PythonBytes.class.getMethod("find", PythonInteger.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("index", PythonBytes.class.getMethod("index", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("index", PythonBytes.class.getMethod("index", PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("index", PythonBytes.class.getMethod("index", PythonBytes.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("index", PythonBytes.class.getMethod("index", PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("index", PythonBytes.class.getMethod("index", PythonBytes.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("index", PythonBytes.class.getMethod("index", PythonInteger.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("isalnum", PythonBytes.class.getMethod("isAlphaNumeric", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("isalpha", PythonBytes.class.getMethod("isAlpha", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("isascii", PythonBytes.class.getMethod("isAscii", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("isdigit", PythonBytes.class.getMethod("isDigit", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("islower", PythonBytes.class.getMethod("isLower", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("isspace", PythonBytes.class.getMethod("isSpace", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("istitle", PythonBytes.class.getMethod("isTitle", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("isupper", PythonBytes.class.getMethod("isUpper", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("join", PythonBytes.class.getMethod("join", PythonLikeObject.class));
        BuiltinTypes.BYTES_TYPE.addMethod("ljust", PythonBytes.class.getMethod("leftJustify", PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("ljust", PythonBytes.class.getMethod("leftJustify", PythonInteger.class, PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("lower", PythonBytes.class.getMethod("lower", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("lstrip", PythonBytes.class.getMethod("leftStrip", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("lstrip", PythonBytes.class.getMethod("leftStrip", PythonNone.class));
        BuiltinTypes.BYTES_TYPE.addMethod("lstrip", PythonBytes.class.getMethod("leftStrip", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("partition", PythonBytes.class.getMethod("partition", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("removeprefix", PythonBytes.class.getMethod("removePrefix", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("removesuffix", PythonBytes.class.getMethod("removeSuffix", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("replace", PythonBytes.class.getMethod("replace", PythonBytes.class, PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("replace", PythonBytes.class.getMethod("replace", PythonBytes.class, PythonBytes.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rfind", PythonBytes.class.getMethod("rightFind", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rfind", PythonBytes.class.getMethod("rightFind", PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rfind", PythonBytes.class.getMethod("rightFind", PythonBytes.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rfind", PythonBytes.class.getMethod("rightFind", PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rfind", PythonBytes.class.getMethod("rightFind", PythonBytes.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rfind", PythonBytes.class.getMethod("rightFind", PythonInteger.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rindex", PythonBytes.class.getMethod("rightIndex", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rindex", PythonBytes.class.getMethod("rightIndex", PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rindex", PythonBytes.class.getMethod("rightIndex", PythonBytes.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rindex", PythonBytes.class.getMethod("rightIndex", PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rindex", PythonBytes.class.getMethod("rightIndex", PythonBytes.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rindex", PythonBytes.class.getMethod("rightIndex", PythonInteger.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rjust", PythonBytes.class.getMethod("rightJustify", PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rjust", PythonBytes.class.getMethod("rightJustify", PythonInteger.class, PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rpartition", PythonBytes.class.getMethod("rightPartition", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rsplit", PythonBytes.class.getMethod("rightSplit", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("rsplit", PythonBytes.class.getMethod("rightSplit", PythonNone.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rsplit", PythonBytes.class.getMethod("rightSplit", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rsplit", PythonBytes.class.getMethod("rightSplit", PythonNone.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rsplit", PythonBytes.class.getMethod("rightSplit", PythonBytes.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rstrip", PythonBytes.class.getMethod("rightStrip", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("rstrip", PythonBytes.class.getMethod("rightStrip", PythonNone.class));
        BuiltinTypes.BYTES_TYPE.addMethod("rstrip", PythonBytes.class.getMethod("rightStrip", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("split", PythonBytes.class.getMethod("split", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("split", PythonBytes.class.getMethod("split", PythonNone.class));
        BuiltinTypes.BYTES_TYPE.addMethod("split", PythonBytes.class.getMethod("split", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("split", PythonBytes.class.getMethod("split", PythonNone.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("split", PythonBytes.class.getMethod("split", PythonBytes.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("splitlines", PythonBytes.class.getMethod("splitLines", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("splitlines", PythonBytes.class.getMethod("splitLines", PythonBoolean.class));
        BuiltinTypes.BYTES_TYPE.addMethod("startswith", PythonBytes.class.getMethod("startsWith", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("startswith", PythonBytes.class.getMethod("startsWith", PythonLikeTuple.class));
        BuiltinTypes.BYTES_TYPE.addMethod("startswith", PythonBytes.class.getMethod("startsWith", PythonBytes.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("startswith", PythonBytes.class.getMethod("startsWith", PythonLikeTuple.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("startswith", PythonBytes.class.getMethod("startsWith", PythonBytes.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("startswith", PythonBytes.class.getMethod("startsWith", PythonLikeTuple.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.BYTES_TYPE.addMethod("strip", PythonBytes.class.getMethod("strip", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("strip", PythonBytes.class.getMethod("strip", PythonNone.class));
        BuiltinTypes.BYTES_TYPE.addMethod("strip", PythonBytes.class.getMethod("strip", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("swapcase", PythonBytes.class.getMethod("swapCase", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("title", PythonBytes.class.getMethod("title", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("translate", PythonBytes.class.getMethod("translate", PythonBytes.class));
        BuiltinTypes.BYTES_TYPE.addMethod("upper", PythonBytes.class.getMethod("upper", new Class[0]));
        BuiltinTypes.BYTES_TYPE.addMethod("zfill", PythonBytes.class.getMethod("zfill", PythonInteger.class));
        return BuiltinTypes.BYTES_TYPE;
    }

    public PythonBytes(byte[] value) {
        super(BuiltinTypes.BYTES_TYPE);
        this.value = value;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.value).asReadOnlyBuffer();
    }

    public final ByteCharSequence asCharSequence() {
        return new ByteCharSequence(this.value);
    }

    public final PythonString asAsciiString() {
        return PythonString.valueOf(this.asCharSequence().toString());
    }

    public static PythonBytes fromIntTuple(PythonLikeTuple tuple) {
        byte[] out = new byte[tuple.size()];
        IntStream.range(0, tuple.size()).forEach(index -> {
            out[index] = ((PythonInteger)tuple.get(index)).asByte();
        });
        return new PythonBytes(out);
    }

    public final PythonLikeTuple asIntTuple() {
        return IntStream.range(0, this.value.length).mapToObj(index -> BYTE_TO_INT[Byte.toUnsignedInt(this.value[index])]).collect(Collectors.toCollection(PythonLikeTuple::new));
    }

    private static BitSet asBitSet(PythonBytes bytesInBitSet) {
        BitSet out = new BitSet();
        for (byte item : bytesInBitSet.value) {
            out.set(item & 0xFF);
        }
        return out;
    }

    public PythonInteger getLength() {
        return PythonInteger.valueOf(this.value.length);
    }

    public PythonInteger getCharAt(PythonInteger position) {
        int index = PythonSlice.asIntIndexForLength(position, this.value.length);
        if (index >= this.value.length) {
            throw new IndexError("position " + position + " larger than bytes length " + this.value.length);
        }
        if (index < 0) {
            throw new IndexError("position " + position + " is less than 0");
        }
        return BYTE_TO_INT[Byte.toUnsignedInt(this.value[index])];
    }

    public PythonBytes getSubsequence(PythonSlice slice) {
        int length = this.value.length;
        int start = slice.getStartIndex(length);
        int stop = slice.getStopIndex(length);
        int step = slice.getStrideLength();
        if (step == 1) {
            if (stop <= start) {
                return EMPTY;
            }
            return new PythonBytes(Arrays.copyOfRange(this.value, start, stop));
        }
        byte[] out = new byte[slice.getSliceSize(length)];
        slice.iterate(length, (index, iteration) -> {
            out[iteration] = this.value[index];
        });
        return new PythonBytes(out);
    }

    public PythonBoolean containsSubsequence(PythonBytes subsequence) {
        if (subsequence.value.length == 0) {
            return PythonBoolean.TRUE;
        }
        if (subsequence.value.length > this.value.length) {
            return PythonBoolean.FALSE;
        }
        for (int i = 0; i <= this.value.length - subsequence.value.length; ++i) {
            if (!Arrays.equals(this.value, i, i + subsequence.value.length, subsequence.value, 0, subsequence.value.length)) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonBytes concat(PythonBytes other) {
        if (this.value.length == 0) {
            return other;
        }
        if (other.value.length == 0) {
            return this;
        }
        byte[] out = new byte[this.value.length + other.value.length];
        System.arraycopy(this.value, 0, out, 0, this.value.length);
        System.arraycopy(other.value, 0, out, this.value.length, other.value.length);
        return new PythonBytes(out);
    }

    public PythonBytes repeat(PythonInteger times) {
        int timesAsInt = times.value.intValueExact();
        if (timesAsInt <= 0) {
            return EMPTY;
        }
        if (timesAsInt == 1 || this.value.length == 0) {
            return this;
        }
        byte[] out = new byte[this.value.length * timesAsInt];
        for (int i = 0; i < timesAsInt; ++i) {
            System.arraycopy(this.value, 0, out, i * this.value.length, this.value.length);
        }
        return new PythonBytes(out);
    }

    public DelegatePythonIterator<PythonInteger> getIterator() {
        return new DelegatePythonIterator<PythonInteger>(IntStream.range(0, this.value.length).mapToObj(index -> BYTE_TO_INT[Byte.toUnsignedInt(this.value[index])]).iterator());
    }

    public PythonInteger countByte(byte query, int start, int end) {
        int count = 0;
        for (int i = start; i < end; ++i) {
            if (this.value[i] != query) continue;
            ++count;
        }
        return PythonInteger.valueOf(count);
    }

    public PythonInteger count(PythonInteger byteAsInt) {
        byte query = byteAsInt.asByte();
        return this.countByte(query, 0, this.value.length);
    }

    public PythonInteger count(PythonInteger byteAsInt, PythonInteger start) {
        byte query = byteAsInt.asByte();
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        return this.countByte(query, startAsInt, this.value.length);
    }

    public PythonInteger count(PythonInteger byteAsInt, PythonInteger start, PythonInteger end) {
        byte query = byteAsInt.asByte();
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.value.length);
        return this.countByte(query, startAsInt, endAsInt);
    }

    private PythonInteger countSubsequence(byte[] query, int from, int to) {
        int count = 0;
        if (to - from == 0 || query.length > to - from) {
            return PythonInteger.ZERO;
        }
        if (query.length == 0) {
            return PythonInteger.valueOf(to - from + 1);
        }
        for (int i = from; i <= to - query.length; ++i) {
            if (!Arrays.equals(this.value, i, i + query.length, query, 0, query.length)) continue;
            ++count;
            i += query.length - 1;
        }
        return PythonInteger.valueOf(count);
    }

    public PythonInteger count(PythonBytes bytes) {
        return this.countSubsequence(bytes.value, 0, this.value.length);
    }

    public PythonInteger count(PythonBytes bytes, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        return this.countSubsequence(bytes.value, startAsInt, this.value.length);
    }

    public PythonInteger count(PythonBytes bytes, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.value.length);
        return this.countSubsequence(bytes.value, startAsInt, endAsInt);
    }

    public boolean hasPrefix(byte[] prefixBytes, int start, int end) {
        if (prefixBytes.length > end - start) {
            return false;
        }
        for (int i = 0; i < prefixBytes.length; ++i) {
            if (prefixBytes[i] == this.value[i + start]) continue;
            return false;
        }
        return true;
    }

    public boolean hasSuffix(byte[] suffixBytes, int start, int end) {
        if (suffixBytes.length > end - start) {
            return false;
        }
        for (int i = 1; i <= suffixBytes.length; ++i) {
            if (suffixBytes[suffixBytes.length - i] == this.value[end - i]) continue;
            return false;
        }
        return true;
    }

    public PythonBytes removePrefix(PythonBytes prefix) {
        byte[] prefixBytes = prefix.value;
        return this.hasPrefix(prefixBytes, 0, this.value.length) ? new PythonBytes(Arrays.copyOfRange(this.value, prefixBytes.length, this.value.length)) : this;
    }

    public PythonBytes removeSuffix(PythonBytes suffix) {
        byte[] suffixBytes = suffix.value;
        return this.hasSuffix(suffixBytes, 0, this.value.length) ? new PythonBytes(Arrays.copyOfRange(this.value, 0, this.value.length - suffixBytes.length)) : this;
    }

    public PythonString decode() {
        try {
            return PythonString.valueOf(StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(this.value)).toString());
        }
        catch (CharacterCodingException e) {
            throw new UnicodeDecodeError(e.getMessage());
        }
    }

    public PythonString decode(PythonString charset) {
        try {
            return PythonString.valueOf(Charset.forName(charset.value).newDecoder().onMalformedInput(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(this.value)).toString());
        }
        catch (CharacterCodingException e) {
            throw new UnicodeDecodeError(e.getMessage());
        }
    }

    public PythonString decode(PythonString charset, PythonString errorActionString) {
        CodingErrorAction errorAction = switch (errorActionString.value) {
            case "strict" -> CodingErrorAction.REPORT;
            case "ignore" -> CodingErrorAction.IGNORE;
            case "replace" -> CodingErrorAction.REPLACE;
            default -> throw new ValueError(errorActionString.repr() + " is not a valid value for errors. Possible values are: \"strict\", \"ignore\", \"replace\".");
        };
        try {
            return PythonString.valueOf(Charset.forName(charset.value).newDecoder().onMalformedInput(errorAction).decode(ByteBuffer.wrap(this.value)).toString());
        }
        catch (CharacterCodingException e) {
            throw new UnicodeDecodeError(e.getMessage());
        }
    }

    public PythonBoolean endsWith(PythonBytes suffix) {
        return PythonBoolean.valueOf(this.hasSuffix(suffix.value, 0, this.value.length));
    }

    public PythonBoolean endsWith(PythonBytes suffix, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        return PythonBoolean.valueOf(this.hasSuffix(suffix.value, startAsInt, this.value.length));
    }

    public PythonBoolean endsWith(PythonBytes suffix, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.value.length);
        return PythonBoolean.valueOf(this.hasSuffix(suffix.value, startAsInt, endAsInt));
    }

    public PythonBoolean endsWith(PythonLikeTuple<PythonBytes> suffixes) {
        for (PythonBytes suffix : suffixes) {
            if (!this.hasSuffix(suffix.value, 0, this.value.length)) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonBoolean endsWith(PythonLikeTuple<PythonBytes> suffixes, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        for (PythonBytes suffix : suffixes) {
            if (!this.hasSuffix(suffix.value, startAsInt, this.value.length)) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonBoolean endsWith(PythonLikeTuple<PythonBytes> suffixes, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.value.length);
        for (PythonBytes suffix : suffixes) {
            if (!this.hasSuffix(suffix.value, startAsInt, endAsInt)) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    private PythonInteger find(PythonInteger query, int start, int end) {
        byte queryByte = query.asByte();
        for (int i = start; i < end; ++i) {
            if (this.value[i] != queryByte) continue;
            return PythonInteger.valueOf(i);
        }
        return PythonInteger.valueOf(-1);
    }

    private PythonInteger index(PythonInteger query, int start, int end) {
        byte queryByte = query.asByte();
        for (int i = start; i < end; ++i) {
            if (this.value[i] != queryByte) continue;
            return PythonInteger.valueOf(i);
        }
        throw new ValueError("Subsequence not found");
    }

    public PythonInteger find(PythonInteger query) {
        return this.find(query, 0, this.value.length);
    }

    public PythonInteger find(PythonInteger query, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        return this.find(query, startAsInt, this.value.length);
    }

    public PythonInteger find(PythonInteger query, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.value.length);
        return this.find(query, startAsInt, endAsInt);
    }

    public PythonInteger index(PythonInteger query) {
        return this.index(query, 0, this.value.length);
    }

    public PythonInteger index(PythonInteger query, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        return this.index(query, startAsInt, this.value.length);
    }

    public PythonInteger index(PythonInteger query, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.value.length);
        return this.index(query, startAsInt, endAsInt);
    }

    private PythonInteger find(PythonBytesLikeObject query, int start, int end) {
        byte[] queryBytes = query.asByteArray();
        if (queryBytes.length == 0) {
            return this.value.length > 0 ? PythonInteger.ZERO : PythonInteger.valueOf(-1);
        }
        for (int i = start; i <= end - queryBytes.length; ++i) {
            if (!Arrays.equals(this.value, i, i + queryBytes.length, queryBytes, 0, queryBytes.length)) continue;
            return PythonInteger.valueOf(i);
        }
        return PythonInteger.valueOf(-1);
    }

    private PythonInteger index(PythonBytesLikeObject query, int start, int end) {
        byte[] queryBytes = query.asByteArray();
        if (queryBytes.length == 0) {
            if (this.value.length > 0) {
                return PythonInteger.ZERO;
            }
            throw new ValueError("Subsequence not found");
        }
        for (int i = start; i <= end - queryBytes.length; ++i) {
            if (!Arrays.equals(this.value, i, i + queryBytes.length, queryBytes, 0, queryBytes.length)) continue;
            return PythonInteger.valueOf(i);
        }
        throw new ValueError("Subsequence not found");
    }

    public PythonInteger find(PythonBytes query) {
        return this.find((PythonBytesLikeObject)query, 0, this.value.length);
    }

    public PythonInteger find(PythonBytes query, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        return this.find((PythonBytesLikeObject)query, startAsInt, this.value.length);
    }

    public PythonInteger find(PythonBytes query, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.value.length);
        return this.find((PythonBytesLikeObject)query, startAsInt, endAsInt);
    }

    public PythonInteger index(PythonBytes query) {
        return this.index((PythonBytesLikeObject)query, 0, this.value.length);
    }

    public PythonInteger index(PythonBytes query, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        return this.index((PythonBytesLikeObject)query, startAsInt, this.value.length);
    }

    public PythonInteger index(PythonBytes query, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.value.length);
        return this.index((PythonBytesLikeObject)query, startAsInt, endAsInt);
    }

    public PythonBytes interpolate(PythonLikeObject object) {
        if (object instanceof PythonLikeTuple) {
            return this.interpolate((PythonLikeTuple)object);
        }
        if (object instanceof PythonLikeDict) {
            return this.interpolate((PythonLikeDict)object);
        }
        return this.interpolate(PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{object}));
    }

    public PythonBytes interpolate(PythonLikeTuple tuple) {
        return PythonString.valueOf(StringFormatter.printfInterpolate((CharSequence)this.asCharSequence(), tuple, StringFormatter.PrintfStringType.BYTES)).asAsciiBytes();
    }

    public PythonBytes interpolate(PythonLikeDict dict) {
        return PythonString.valueOf(StringFormatter.printfInterpolate((CharSequence)this.asCharSequence(), dict, StringFormatter.PrintfStringType.BYTES)).asAsciiBytes();
    }

    public PythonBytes join(PythonLikeObject iterable) {
        PythonIterator iterator = (PythonIterator)UnaryDunderBuiltin.ITERATOR.invoke(iterable);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while (iterator.hasNext()) {
            PythonLikeObject item = iterator.nextPythonItem();
            if (!(item instanceof PythonBytesLikeObject)) {
                throw new TypeError("type " + item.$getType() + " is not a bytes-like type");
            }
            outputStream.writeBytes(((PythonBytesLikeObject)item).asByteArray());
            if (!iterator.hasNext()) continue;
            outputStream.writeBytes(this.value);
        }
        return new PythonBytes(outputStream.toByteArray());
    }

    private PythonLikeTuple partition(PythonBytesLikeObject sep, int start, int end) {
        byte[] sepBytes = sep.asByteArray();
        for (int i = start; i < end - sepBytes.length; ++i) {
            int j;
            for (j = 0; j < sepBytes.length && this.value[i + j] == sepBytes[j]; ++j) {
            }
            if (j != sepBytes.length) continue;
            return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonBytesLikeObject[]{new PythonBytes(Arrays.copyOfRange(this.value, 0, i)), sep, new PythonBytes(Arrays.copyOfRange(this.value, i + sepBytes.length, this.value.length))});
        }
        return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonBytes[]{this, EMPTY, EMPTY});
    }

    public PythonLikeTuple partition(PythonBytes sep) {
        return this.partition((PythonBytesLikeObject)sep, 0, this.value.length);
    }

    public PythonLikeTuple partition(PythonBytes sep, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        return this.partition((PythonBytesLikeObject)sep, startAsInt, this.value.length);
    }

    public PythonLikeTuple partition(PythonBytes sep, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        int endAsInt = PythonSlice.asValidStartIntIndexForLength(end, this.value.length);
        return this.partition((PythonBytesLikeObject)sep, startAsInt, endAsInt);
    }

    public PythonBytes replace(PythonBytesLikeObject old, PythonBytesLikeObject replacement) {
        byte[] oldBytes = old.asByteArray();
        byte[] replacementBytes = replacement.asByteArray();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int lastReplacementEnd = 0;
        for (int i = 0; i < this.value.length - oldBytes.length; ++i) {
            if (!Arrays.equals(this.value, i, i + oldBytes.length, oldBytes, 0, oldBytes.length)) continue;
            outputStream.write(this.value, lastReplacementEnd, i - lastReplacementEnd);
            outputStream.writeBytes(replacementBytes);
            lastReplacementEnd = i += oldBytes.length;
        }
        outputStream.write(this.value, lastReplacementEnd, this.value.length - lastReplacementEnd);
        return new PythonBytes(outputStream.toByteArray());
    }

    public PythonBytes replace(PythonBytesLikeObject old, PythonBytesLikeObject replacement, BigInteger count) {
        byte[] oldBytes = old.asByteArray();
        byte[] replacementBytes = replacement.asByteArray();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int lastReplacementEnd = 0;
        for (int i = 0; i < this.value.length - oldBytes.length && count.compareTo(BigInteger.ZERO) != 0; ++i) {
            if (!Arrays.equals(this.value, i, i + oldBytes.length, oldBytes, 0, oldBytes.length)) continue;
            outputStream.write(this.value, lastReplacementEnd, i - lastReplacementEnd);
            outputStream.writeBytes(replacementBytes);
            lastReplacementEnd = i += oldBytes.length;
            count = count.subtract(BigInteger.ONE);
        }
        outputStream.write(this.value, lastReplacementEnd, this.value.length - lastReplacementEnd);
        return new PythonBytes(outputStream.toByteArray());
    }

    public PythonBytes replace(PythonBytes old, PythonBytes replacement) {
        return this.replace((PythonBytesLikeObject)old, (PythonBytesLikeObject)replacement);
    }

    public PythonBytes replace(PythonBytes old, PythonBytes replacement, PythonInteger count) {
        return this.replace((PythonBytesLikeObject)old, (PythonBytesLikeObject)replacement, count.value);
    }

    private PythonInteger rightFind(PythonInteger query, int start, int end) {
        byte queryByte = query.asByte();
        for (int i = end - 1; i >= start; --i) {
            if (this.value[i] != queryByte) continue;
            return PythonInteger.valueOf(i);
        }
        return PythonInteger.valueOf(-1);
    }

    private PythonInteger rightIndex(PythonInteger query, int start, int end) {
        byte queryByte = query.asByte();
        for (int i = end - 1; i >= start; --i) {
            if (this.value[i] != queryByte) continue;
            return PythonInteger.valueOf(i);
        }
        throw new ValueError("Subsequence not found");
    }

    public PythonInteger rightFind(PythonInteger query) {
        return this.rightFind(query, 0, this.value.length);
    }

    public PythonInteger rightFind(PythonInteger query, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        return this.rightFind(query, startAsInt, this.value.length);
    }

    public PythonInteger rightFind(PythonInteger query, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.value.length);
        return this.rightFind(query, startAsInt, endAsInt);
    }

    public PythonInteger rightIndex(PythonInteger query) {
        return this.rightIndex(query, 0, this.value.length);
    }

    public PythonInteger rightIndex(PythonInteger query, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        return this.rightIndex(query, startAsInt, this.value.length);
    }

    public PythonInteger rightIndex(PythonInteger query, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.value.length);
        return this.rightIndex(query, startAsInt, endAsInt);
    }

    private PythonInteger rightFind(PythonBytesLikeObject query, int start, int end) {
        byte[] queryBytes = query.asByteArray();
        for (int i = end - queryBytes.length; i >= start; --i) {
            int j;
            for (j = 0; j < queryBytes.length && this.value[i + j] == queryBytes[j]; ++j) {
            }
            if (j != queryBytes.length) continue;
            return PythonInteger.valueOf(i);
        }
        return PythonInteger.valueOf(-1);
    }

    private PythonInteger rightIndex(PythonBytesLikeObject query, int start, int end) {
        byte[] queryBytes = query.asByteArray();
        for (int i = end - queryBytes.length; i >= start; --i) {
            int j;
            for (j = 0; j < queryBytes.length && this.value[i + j] == queryBytes[j]; ++j) {
            }
            if (j != queryBytes.length) continue;
            return PythonInteger.valueOf(i);
        }
        throw new ValueError("Subsequence not found");
    }

    public PythonInteger rightFind(PythonBytes query) {
        return this.rightFind((PythonBytesLikeObject)query, 0, this.value.length);
    }

    public PythonInteger rightFind(PythonBytes query, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        return this.rightFind((PythonBytesLikeObject)query, startAsInt, this.value.length);
    }

    public PythonInteger rightFind(PythonBytes query, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.value.length);
        return this.rightFind((PythonBytesLikeObject)query, startAsInt, endAsInt);
    }

    public PythonInteger rightIndex(PythonBytes query) {
        return this.rightIndex((PythonBytesLikeObject)query, 0, this.value.length);
    }

    public PythonInteger rightIndex(PythonBytes query, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        return this.rightIndex((PythonBytesLikeObject)query, startAsInt, this.value.length);
    }

    public PythonInteger rightIndex(PythonBytes query, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.value.length);
        return this.rightIndex((PythonBytesLikeObject)query, startAsInt, endAsInt);
    }

    private PythonLikeTuple rightPartition(PythonBytesLikeObject sep, int start, int end) {
        byte[] sepBytes = sep.asByteArray();
        for (int i = end - sepBytes.length; i >= start; --i) {
            if (!Arrays.equals(this.value, i, i + sepBytes.length, sepBytes, 0, sepBytes.length)) continue;
            return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonBytesLikeObject[]{new PythonBytes(Arrays.copyOfRange(this.value, 0, i)), sep, new PythonBytes(Arrays.copyOfRange(this.value, i + sepBytes.length, this.value.length))});
        }
        return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonBytes[]{EMPTY, EMPTY, this});
    }

    public PythonLikeTuple rightPartition(PythonBytes sep) {
        return this.rightPartition(sep, 0, this.value.length);
    }

    public PythonBoolean startsWith(PythonBytes prefix) {
        return PythonBoolean.valueOf(this.hasPrefix(prefix.value, 0, this.value.length));
    }

    public PythonBoolean startsWith(PythonBytes prefix, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        return PythonBoolean.valueOf(this.hasPrefix(prefix.value, startAsInt, this.value.length));
    }

    public PythonBoolean startsWith(PythonBytes prefix, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.value.length);
        return PythonBoolean.valueOf(this.hasPrefix(prefix.value, startAsInt, endAsInt));
    }

    public PythonBoolean startsWith(PythonLikeTuple<PythonBytes> prefixes) {
        for (PythonBytes prefix : prefixes) {
            if (!this.hasPrefix(prefix.value, 0, this.value.length)) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonBoolean startsWith(PythonLikeTuple<PythonBytes> prefixes, PythonInteger start) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        for (PythonBytes prefix : prefixes) {
            if (!this.hasPrefix(prefix.value, startAsInt, this.value.length)) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonBoolean startsWith(PythonLikeTuple<PythonBytes> prefixes, PythonInteger start, PythonInteger end) {
        int startAsInt = PythonSlice.asValidStartIntIndexForLength(start, this.value.length);
        int endAsInt = PythonSlice.asValidEndIntIndexForLength(end, this.value.length);
        for (PythonBytes prefix : prefixes) {
            if (!this.hasPrefix(prefix.value, startAsInt, endAsInt)) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public PythonBytes translate(PythonBytes table) {
        byte[] tableBytes = table.value;
        if (tableBytes.length != 256) {
            throw new ValueError("translate table must be a bytes object of length 256");
        }
        byte[] out = new byte[this.value.length];
        for (int i = 0; i < this.value.length; ++i) {
            out[i] = tableBytes[this.value[i] & 0xFF];
        }
        return new PythonBytes(out);
    }

    public PythonBytes translate(PythonNone table) {
        return this;
    }

    public PythonBytes translate(PythonBytes table, PythonBytes delete) {
        byte[] tableBytes = table.value;
        if (tableBytes.length != 256) {
            throw new ValueError("translate table must be a bytes object of length 256");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.value.length);
        BitSet removedSet = PythonBytes.asBitSet(delete);
        for (byte b : this.value) {
            if (removedSet.get(b & 0xFF)) continue;
            out.write(tableBytes, b & 0xFF, 1);
        }
        return new PythonBytes(out.toByteArray());
    }

    public PythonBytes translate(PythonNone table, PythonBytes delete) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.value.length);
        BitSet removedSet = PythonBytes.asBitSet(delete);
        for (int i = 0; i < this.value.length; ++i) {
            if (removedSet.get(this.value[i] & 0xFF)) continue;
            out.write(this.value, i, 1);
        }
        return new PythonBytes(out.toByteArray());
    }

    public PythonBytes center(PythonInteger fillWidth) {
        return this.center(fillWidth, ASCII_SPACE);
    }

    public PythonBytes center(PythonInteger fillWidth, PythonBytes fillCharacter) {
        if (fillCharacter.value.length != 1) {
            throw new TypeError("center() argument 2 must be a byte string of length 1");
        }
        int widthAsInt = fillWidth.value.intValueExact();
        if (widthAsInt <= this.value.length) {
            return this;
        }
        int extraWidth = widthAsInt - this.value.length;
        int rightPadding = extraWidth / 2;
        int leftPadding = rightPadding + (extraWidth & 1);
        byte[] out = new byte[widthAsInt];
        Arrays.fill(out, 0, leftPadding, fillCharacter.value[0]);
        System.arraycopy(this.value, 0, out, leftPadding, this.value.length);
        Arrays.fill(out, leftPadding + this.value.length, widthAsInt, fillCharacter.value[0]);
        return new PythonBytes(out);
    }

    public PythonBytes leftJustify(PythonInteger fillWidth) {
        return this.leftJustify(fillWidth, ASCII_SPACE);
    }

    public PythonBytes leftJustify(PythonInteger fillWidth, PythonBytes fillCharacter) {
        if (fillCharacter.value.length != 1) {
            throw new TypeError("ljust() argument 2 must be a byte string of length 1");
        }
        int widthAsInt = fillWidth.value.intValueExact();
        if (widthAsInt <= this.value.length) {
            return this;
        }
        byte[] out = new byte[widthAsInt];
        System.arraycopy(this.value, 0, out, 0, this.value.length);
        Arrays.fill(out, this.value.length, widthAsInt, fillCharacter.value[0]);
        return new PythonBytes(out);
    }

    public PythonBytes rightJustify(PythonInteger fillWidth) {
        return this.rightJustify(fillWidth, ASCII_SPACE);
    }

    public PythonBytes rightJustify(PythonInteger fillWidth, PythonBytes fillCharacter) {
        if (fillCharacter.value.length != 1) {
            throw new TypeError("rjust() argument 2 must be a byte string of length 1");
        }
        int widthAsInt = fillWidth.value.intValueExact();
        if (widthAsInt <= this.value.length) {
            return this;
        }
        int extraWidth = widthAsInt - this.value.length;
        byte[] out = new byte[widthAsInt];
        Arrays.fill(out, 0, extraWidth, fillCharacter.value[0]);
        System.arraycopy(this.value, 0, out, extraWidth, this.value.length);
        return new PythonBytes(out);
    }

    public PythonBytes strip() {
        return this.strip(ASCII_SPACE);
    }

    public PythonBytes strip(PythonNone ignored) {
        return this.strip();
    }

    public PythonBytes strip(PythonBytes bytesToStrip) {
        int start;
        BitSet toStrip = PythonBytes.asBitSet(bytesToStrip);
        int end = this.value.length - 1;
        for (start = 0; start < this.value.length && toStrip.get(this.value[start] & 0xFF); ++start) {
        }
        while (end >= start && toStrip.get(this.value[end] & 0xFF)) {
            --end;
        }
        if (end < start) {
            return new PythonBytes(new byte[0]);
        }
        return new PythonBytes(Arrays.copyOfRange(this.value, start, end + 1));
    }

    public PythonBytes leftStrip() {
        return this.leftStrip(ASCII_SPACE);
    }

    public PythonBytes leftStrip(PythonNone ignored) {
        return this.leftStrip();
    }

    public PythonBytes leftStrip(PythonBytes bytesToStrip) {
        int start;
        BitSet toStrip = PythonBytes.asBitSet(bytesToStrip);
        for (start = 0; start < this.value.length && toStrip.get(this.value[start] & 0xFF); ++start) {
        }
        if (start == this.value.length) {
            return new PythonBytes(new byte[0]);
        }
        return new PythonBytes(Arrays.copyOfRange(this.value, start, this.value.length));
    }

    public PythonBytes rightStrip() {
        return this.rightStrip(ASCII_SPACE);
    }

    public PythonBytes rightStrip(PythonNone ignored) {
        return this.rightStrip();
    }

    public PythonBytes rightStrip(PythonBytes bytesToStrip) {
        int end;
        BitSet toStrip = PythonBytes.asBitSet(bytesToStrip);
        for (end = this.value.length - 1; end >= 0 && toStrip.get(this.value[end] & 0xFF); --end) {
        }
        if (end < 0) {
            return new PythonBytes(new byte[0]);
        }
        return new PythonBytes(Arrays.copyOfRange(this.value, 0, end + 1));
    }

    public PythonLikeList<PythonBytes> split() {
        int end;
        PythonLikeList<PythonBytes> out = new PythonLikeList<PythonBytes>();
        int start = 0;
        for (end = this.value.length; end > 0 && ASCII_WHITESPACE_BITSET.get(this.value[end - 1] & 0xFF); --end) {
        }
        while (start < end && ASCII_WHITESPACE_BITSET.get(this.value[start] & 0xFF)) {
            ++start;
        }
        if (start == end) {
            return out;
        }
        int lastEnd = start;
        while (start < end - 1) {
            while (start < end - 1 && !ASCII_WHITESPACE_BITSET.get(this.value[start] & 0xFF)) {
                ++start;
            }
            if (start == end - 1) continue;
            out.add(new PythonBytes(Arrays.copyOfRange(this.value, lastEnd, start)));
            start = lastEnd = start + 1;
        }
        if (lastEnd != end) {
            out.add(new PythonBytes(Arrays.copyOfRange(this.value, lastEnd, end)));
        }
        return out;
    }

    public PythonLikeList<PythonBytes> split(PythonNone ignored) {
        return this.split();
    }

    public PythonLikeList<PythonBytes> split(PythonBytes seperator) {
        PythonLikeList<PythonBytes> out = new PythonLikeList<PythonBytes>();
        int start = 0;
        int end = this.value.length;
        int lastEnd = start;
        while (start < end - seperator.value.length) {
            while (start < end - seperator.value.length && !Arrays.equals(this.value, start, start + seperator.value.length, seperator.value, 0, seperator.value.length)) {
                ++start;
            }
            if (start == end - seperator.value.length) continue;
            out.add(new PythonBytes(Arrays.copyOfRange(this.value, lastEnd, start)));
            start = lastEnd = start + seperator.value.length;
        }
        if (Arrays.equals(this.value, start, start + seperator.value.length, seperator.value, 0, seperator.value.length)) {
            out.add(new PythonBytes(Arrays.copyOfRange(this.value, lastEnd, start)));
            lastEnd = start + seperator.value.length;
        }
        out.add(new PythonBytes(Arrays.copyOfRange(this.value, lastEnd, end)));
        return out;
    }

    public PythonLikeList<PythonBytes> split(PythonBytes seperator, PythonInteger maxSplits) {
        if (maxSplits.equals(new PythonInteger(-1L))) {
            return this.split(seperator);
        }
        PythonLikeList<PythonBytes> out = new PythonLikeList<PythonBytes>();
        int start = 0;
        int end = this.value.length;
        int lastEnd = start;
        while (start < end - seperator.value.length && maxSplits.compareTo(PythonInteger.ONE) >= 0) {
            while (start < end - seperator.value.length && !Arrays.equals(this.value, start, start + seperator.value.length, seperator.value, 0, seperator.value.length)) {
                ++start;
            }
            if (start == end - seperator.value.length) continue;
            out.add(new PythonBytes(Arrays.copyOfRange(this.value, lastEnd, start)));
            start = lastEnd = start + seperator.value.length;
            maxSplits = maxSplits.subtract(PythonInteger.ONE);
        }
        if (maxSplits.compareTo(PythonInteger.ONE) >= 0 && Arrays.equals(this.value, start, start + seperator.value.length, seperator.value, 0, seperator.value.length)) {
            out.add(new PythonBytes(Arrays.copyOfRange(this.value, lastEnd, start)));
            lastEnd = start + seperator.value.length;
        }
        out.add(new PythonBytes(Arrays.copyOfRange(this.value, lastEnd, end)));
        return out;
    }

    public PythonLikeList<PythonBytes> split(PythonNone seperator, PythonInteger maxSplits) {
        int end;
        if (maxSplits.equals(new PythonInteger(-1L))) {
            return this.split(seperator);
        }
        PythonLikeList<PythonBytes> out = new PythonLikeList<PythonBytes>();
        int start = 0;
        for (end = this.value.length; end > 0 && ASCII_WHITESPACE_BITSET.get(this.value[end - 1] & 0xFF); --end) {
        }
        while (start < end && ASCII_WHITESPACE_BITSET.get(this.value[start] & 0xFF)) {
            ++start;
        }
        if (start == end) {
            return out;
        }
        int lastEnd = start;
        while (start < end - 1 && maxSplits.compareTo(PythonInteger.ONE) >= 0) {
            while (start < end - 1 && !ASCII_WHITESPACE_BITSET.get(this.value[start] & 0xFF)) {
                ++start;
            }
            if (start == end - 1) continue;
            out.add(new PythonBytes(Arrays.copyOfRange(this.value, lastEnd, start)));
            start = lastEnd = start + 1;
            maxSplits = maxSplits.subtract(PythonInteger.ONE);
        }
        if (lastEnd != end) {
            out.add(new PythonBytes(Arrays.copyOfRange(this.value, lastEnd, end)));
        }
        return out;
    }

    public PythonLikeList<PythonBytes> rightSplit() {
        return this.split();
    }

    public PythonLikeList<PythonBytes> rightSplit(PythonNone ignored) {
        return this.rightSplit();
    }

    public PythonLikeList<PythonBytes> rightSplit(PythonBytes seperator) {
        return this.split(seperator);
    }

    private static byte[] reverseInplace(byte[] array) {
        for (int i = 0; i < array.length >> 1; ++i) {
            byte temp = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = temp;
        }
        return array;
    }

    public PythonLikeList<PythonBytes> rightSplit(PythonBytes seperator, PythonInteger maxSplits) {
        if (maxSplits.equals(new PythonInteger(-1L))) {
            return this.split(seperator);
        }
        PythonLikeList<PythonBytes> out = new PythonLikeList<PythonBytes>();
        byte[] reversedValue = PythonBytes.reverseInplace((byte[])this.value.clone());
        byte[] reversedSep = PythonBytes.reverseInplace((byte[])seperator.value.clone());
        int start = 0;
        int end = reversedValue.length;
        int lastEnd = start;
        while (start < end - reversedSep.length && maxSplits.compareTo(PythonInteger.ONE) >= 0) {
            while (start < end - reversedSep.length && !Arrays.equals(reversedValue, start, start + reversedSep.length, reversedSep, 0, reversedSep.length)) {
                ++start;
            }
            if (start == end - reversedSep.length) continue;
            out.add(new PythonBytes(PythonBytes.reverseInplace(Arrays.copyOfRange(reversedValue, lastEnd, start))));
            start = lastEnd = start + reversedSep.length;
            maxSplits = maxSplits.subtract(PythonInteger.ONE);
        }
        if (maxSplits.compareTo(PythonInteger.ONE) >= 0 && Arrays.equals(reversedValue, start, start + reversedSep.length, reversedSep, 0, reversedSep.length)) {
            out.add(new PythonBytes(PythonBytes.reverseInplace(Arrays.copyOfRange(reversedValue, lastEnd, start))));
            lastEnd = start + seperator.value.length;
        }
        out.add(new PythonBytes(PythonBytes.reverseInplace(Arrays.copyOfRange(reversedValue, lastEnd, end))));
        out.reverse();
        return out;
    }

    public PythonLikeList<PythonBytes> rightSplit(PythonNone seperator, PythonInteger maxSplits) {
        int end;
        if (maxSplits.equals(new PythonInteger(-1L))) {
            return this.split(seperator);
        }
        PythonLikeList<PythonBytes> out = new PythonLikeList<PythonBytes>();
        byte[] reversedValue = PythonBytes.reverseInplace((byte[])this.value.clone());
        int start = 0;
        for (end = this.value.length; end > 0 && ASCII_WHITESPACE_BITSET.get(this.value[end - 1] & 0xFF); --end) {
        }
        while (start < end && ASCII_WHITESPACE_BITSET.get(this.value[start] & 0xFF)) {
            ++start;
        }
        if (start == end) {
            return out;
        }
        int lastEnd = start;
        while (start < end - 1 && maxSplits.compareTo(PythonInteger.ONE) >= 0) {
            while (start < end - 1 && !ASCII_WHITESPACE_BITSET.get(reversedValue[start] & 0xFF)) {
                ++start;
            }
            if (start == end - 1) continue;
            out.add(new PythonBytes(PythonBytes.reverseInplace(Arrays.copyOfRange(reversedValue, lastEnd, start))));
            start = lastEnd = start + 1;
            maxSplits = maxSplits.subtract(PythonInteger.ONE);
        }
        if (lastEnd != end) {
            out.add(new PythonBytes(PythonBytes.reverseInplace(Arrays.copyOfRange(reversedValue, lastEnd, end))));
        }
        out.reverse();
        return out;
    }

    public PythonBytes capitalize() {
        PythonString asString = this.asAsciiString();
        if (asString.value.isEmpty()) {
            return this;
        }
        String tail = PythonString.valueOf((String)asString.value.substring((int)1)).withModifiedCodepoints((IntUnaryOperator)(IntUnaryOperator)LambdaMetafactory.metafactory(null, null, null, (I)I, lambda$capitalize$5(int ), (I)I)()).value;
        char head = asString.value.charAt(0);
        if (head < '\u0080') {
            head = Character.toTitleCase(head);
        }
        return PythonString.valueOf(head + tail).asAsciiBytes();
    }

    public PythonBytes expandTabs() {
        return this.asAsciiString().expandTabs().asAsciiBytes();
    }

    public PythonBytes expandTabs(PythonInteger tabSize) {
        return this.asAsciiString().expandTabs(tabSize).asAsciiBytes();
    }

    public PythonBoolean isAlphaNumeric() {
        return this.asAsciiString().isAlphaNumeric();
    }

    public PythonBoolean isAlpha() {
        return this.asAsciiString().isAlpha();
    }

    public PythonBoolean isAscii() {
        for (byte b : this.value) {
            if ((b & 0xFF) <= 127) continue;
            return PythonBoolean.FALSE;
        }
        return PythonBoolean.TRUE;
    }

    public PythonBoolean isDigit() {
        return this.asAsciiString().isDigit();
    }

    public PythonBoolean isLower() {
        return this.asAsciiString().isLower();
    }

    public PythonBoolean isSpace() {
        return this.asAsciiString().isSpace();
    }

    public PythonBoolean isTitle() {
        return this.asAsciiString().isTitle();
    }

    public PythonBoolean isUpper() {
        return this.asAsciiString().isUpper();
    }

    public PythonBytes lower() {
        return this.asAsciiString().withModifiedCodepoints(cp -> cp < 128 ? Character.toLowerCase(cp) : cp).asAsciiBytes();
    }

    public PythonLikeList<PythonBytes> splitLines() {
        return this.asAsciiString().splitLines().stream().map(PythonString::asAsciiBytes).collect(Collectors.toCollection(PythonLikeList::new));
    }

    public PythonLikeList<PythonBytes> splitLines(PythonBoolean keepEnds) {
        return this.asAsciiString().splitLines(keepEnds).stream().map(PythonString::asAsciiBytes).collect(Collectors.toCollection(PythonLikeList::new));
    }

    public PythonBytes swapCase() {
        return this.asAsciiString().withModifiedCodepoints(cp -> cp < 128 ? PythonString.CharacterCase.swapCase(cp) : cp).asAsciiBytes();
    }

    public PythonBytes title() {
        return this.asAsciiString().title(cp -> cp < 128).asAsciiBytes();
    }

    public PythonBytes upper() {
        return this.asAsciiString().withModifiedCodepoints(cp -> cp < 128 ? Character.toUpperCase(cp) : cp).asAsciiBytes();
    }

    public PythonBytes zfill(PythonInteger width) {
        return this.asAsciiString().zfill(width).asAsciiBytes();
    }

    public PythonString asString() {
        return PythonString.valueOf(this.toString());
    }

    public PythonString repr() {
        return this.asString();
    }

    @Override
    public PythonString $method$__str__() {
        return PythonString.valueOf(this.toString());
    }

    @Override
    public String toString() {
        boolean hasSingleQuotes = false;
        boolean hasDoubleQuotes = false;
        block11: for (byte b : this.value) {
            switch (b) {
                case 39: {
                    hasSingleQuotes = true;
                    continue block11;
                }
                case 34: {
                    hasDoubleQuotes = true;
                }
            }
        }
        StringBuilder out = new StringBuilder(this.value.length);
        out.append("b");
        if (!hasSingleQuotes || hasDoubleQuotes) {
            out.append('\'');
        } else {
            out.append('\"');
        }
        boolean escapeSingleQuotes = hasSingleQuotes && hasDoubleQuotes;
        block12: for (byte b : this.value) {
            switch (b) {
                case 39: {
                    if (escapeSingleQuotes) {
                        out.append("\\'");
                        continue block12;
                    }
                    out.append('\'');
                    continue block12;
                }
                case 92: {
                    out.append("\\\\");
                    continue block12;
                }
                case 9: {
                    out.append("\\t");
                    continue block12;
                }
                case 10: {
                    out.append("\\n");
                    continue block12;
                }
                case 13: {
                    out.append("\\r");
                    continue block12;
                }
                default: {
                    out.append((char)(b & 0xFF));
                }
            }
        }
        if (!hasSingleQuotes || hasDoubleQuotes) {
            out.append('\'');
        } else {
            out.append('\"');
        }
        return out.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PythonBytes that = (PythonBytes)o;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public PythonInteger $method$__hash__() {
        return PythonInteger.valueOf(this.hashCode());
    }

    private static /* synthetic */ int lambda$capitalize$5(int cp) {
        return cp < 128 ? Character.toLowerCase(cp) : cp;
    }

    static {
        PythonOverloadImplementor.deferDispatchesFor(PythonBytes::registerMethods);
    }
}

