/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.collections;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonTernaryOperator;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.builtins.UnaryDunderBuiltin;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonNone;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.DelegatePythonIterator;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.collections.view.DictItemView;
import ai.timefold.jpyinterpreter.types.collections.view.DictKeyView;
import ai.timefold.jpyinterpreter.types.collections.view.DictValueView;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import ai.timefold.jpyinterpreter.types.errors.lookup.KeyError;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.jpyinterpreter.util.JavaStringMapMirror;
import ai.timefold.solver.core.impl.domain.solution.cloner.PlanningCloneable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.collections4.map.LinkedMap;

public class PythonLikeDict<K extends PythonLikeObject, V extends PythonLikeObject>
extends AbstractPythonLikeObject
implements Map<K, V>,
PlanningCloneable<PythonLikeDict<K, V>>,
Iterable<PythonLikeObject> {
    public final OrderedMap delegate;

    private static PythonLikeType registerMethods() throws NoSuchMethodException {
        BuiltinTypes.DICT_TYPE.setConstructor((positionalArguments, namedArguments, callerInstance) -> {
            PythonLikeDict out = new PythonLikeDict();
            if (positionalArguments.isEmpty()) {
                out.putAll(namedArguments);
                return out;
            }
            if (positionalArguments.size() == 1) {
                PythonLikeObject from = (PythonLikeObject)positionalArguments.get(0);
                if (from instanceof Map) {
                    out.putAll((Map)((Object)from));
                } else {
                    Iterator iterator = (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(from));
                    while (iterator.hasNext()) {
                        List item = (List)iterator.next();
                        out.put((PythonLikeObject)item.get(0), (PythonLikeObject)item.get(1));
                    }
                }
                out.putAll(namedArguments);
                return out;
            }
            throw new ValueError("dict takes 0 or 1 positional arguments, got " + positionalArguments.size());
        });
        BuiltinTypes.DICT_TYPE.addUnaryMethod(PythonUnaryOperator.ITERATOR, PythonLikeDict.class.getMethod("getKeyIterator", new Class[0]));
        BuiltinTypes.DICT_TYPE.addUnaryMethod(PythonUnaryOperator.LENGTH, PythonLikeDict.class.getMethod("getSize", new Class[0]));
        BuiltinTypes.DICT_TYPE.addUnaryMethod(PythonUnaryOperator.REVERSED, PythonLikeDict.class.getMethod("reversed", new Class[0]));
        BuiltinTypes.DICT_TYPE.addBinaryMethod(PythonBinaryOperator.GET_ITEM, PythonLikeDict.class.getMethod("getItemOrError", PythonLikeObject.class));
        BuiltinTypes.DICT_TYPE.addBinaryMethod(PythonBinaryOperator.DELETE_ITEM, PythonLikeDict.class.getMethod("removeItemOrError", PythonLikeObject.class));
        BuiltinTypes.DICT_TYPE.addBinaryMethod(PythonBinaryOperator.CONTAINS, PythonLikeDict.class.getMethod("isKeyInDict", PythonLikeObject.class));
        BuiltinTypes.DICT_TYPE.addBinaryMethod(PythonBinaryOperator.OR, PythonLikeDict.class.getMethod("binaryOr", PythonLikeDict.class));
        BuiltinTypes.DICT_TYPE.addBinaryMethod(PythonBinaryOperator.INPLACE_OR, PythonLikeDict.class.getMethod("binaryInplaceOr", PythonLikeDict.class));
        BuiltinTypes.DICT_TYPE.addTernaryMethod(PythonTernaryOperator.SET_ITEM, PythonLikeDict.class.getMethod("setItem", PythonLikeObject.class, PythonLikeObject.class));
        BuiltinTypes.DICT_TYPE.addMethod("clear", PythonLikeDict.class.getMethod("clearDict", new Class[0]));
        BuiltinTypes.DICT_TYPE.addMethod("copy", PythonLikeDict.class.getMethod("copy", new Class[0]));
        BuiltinTypes.DICT_TYPE.addMethod("get", PythonLikeDict.class.getMethod("getItemOrNone", PythonLikeObject.class));
        BuiltinTypes.DICT_TYPE.addMethod("get", PythonLikeDict.class.getMethod("getItemOrDefault", PythonLikeObject.class, PythonLikeObject.class));
        BuiltinTypes.DICT_TYPE.addMethod("items", PythonLikeDict.class.getMethod("getItems", new Class[0]));
        BuiltinTypes.DICT_TYPE.addMethod("keys", PythonLikeDict.class.getMethod("getKeyView", new Class[0]));
        BuiltinTypes.DICT_TYPE.addMethod("pop", PythonLikeDict.class.getMethod("popItemOrError", PythonLikeObject.class));
        BuiltinTypes.DICT_TYPE.addMethod("pop", PythonLikeDict.class.getMethod("popItemOrDefault", PythonLikeObject.class, PythonLikeObject.class));
        BuiltinTypes.DICT_TYPE.addMethod("popitem", PythonLikeDict.class.getMethod("popLast", new Class[0]));
        BuiltinTypes.DICT_TYPE.addMethod("setdefault", PythonLikeDict.class.getMethod("setIfAbsent", PythonLikeObject.class));
        BuiltinTypes.DICT_TYPE.addMethod("setdefault", PythonLikeDict.class.getMethod("setIfAbsent", PythonLikeObject.class, PythonLikeObject.class));
        BuiltinTypes.DICT_TYPE.addMethod("update", PythonLikeDict.class.getMethod("update", PythonLikeDict.class));
        BuiltinTypes.DICT_TYPE.addMethod("update", PythonLikeDict.class.getMethod("update", PythonLikeObject.class));
        BuiltinTypes.DICT_TYPE.addMethod("values", PythonLikeDict.class.getMethod("getValueView", new Class[0]));
        return BuiltinTypes.DICT_TYPE;
    }

    public PythonLikeDict() {
        super(BuiltinTypes.DICT_TYPE);
        this.delegate = new LinkedMap();
    }

    public PythonLikeDict(int size) {
        super(BuiltinTypes.DICT_TYPE);
        this.delegate = new LinkedMap(size);
    }

    public PythonLikeDict(OrderedMap<PythonLikeObject, PythonLikeObject> source) {
        super(BuiltinTypes.DICT_TYPE);
        this.delegate = source;
    }

    public PythonLikeDict<K, V> createNewInstance() {
        return new PythonLikeDict<K, V>();
    }

    public static PythonLikeDict<PythonString, PythonLikeObject> mirror(Map<String, PythonLikeObject> globals) {
        return new PythonLikeDict<PythonString, PythonLikeObject>(new JavaStringMapMirror(globals));
    }

    public PythonLikeTuple toFlattenKeyValueTuple() {
        return PythonLikeTuple.fromItems((PythonLikeObject[])((PythonLikeObject[])this.delegate.entrySet().stream().flatMap(entry -> {
            Map.Entry mapEntry = (Map.Entry)entry;
            return Stream.of((PythonLikeObject)mapEntry.getKey(), (PythonLikeObject)mapEntry.getValue());
        }).toArray(PythonLikeObject[]::new)));
    }

    public PythonLikeDict<K, V> copy() {
        return new PythonLikeDict<K, V>((OrderedMap<PythonLikeObject, PythonLikeObject>)new LinkedMap((Map)this.delegate));
    }

    public PythonLikeDict concatToNew(PythonLikeDict other) {
        PythonLikeDict<K, V> result = new PythonLikeDict<K, V>();
        result.putAll((Map<K, V>)this.delegate);
        result.putAll(other);
        return result;
    }

    public PythonLikeDict concatToSelf(PythonLikeDict other) {
        this.putAll(other);
        return this;
    }

    public PythonInteger getSize() {
        return PythonInteger.valueOf(this.delegate.size());
    }

    public DelegatePythonIterator<PythonLikeObject> getKeyIterator() {
        return new DelegatePythonIterator<PythonLikeObject>(this.delegate.keySet().iterator());
    }

    public PythonLikeObject getItemOrError(PythonLikeObject key) {
        PythonLikeObject out = (PythonLikeObject)this.delegate.get((Object)key);
        if (out == null) {
            throw new KeyError(key.toString());
        }
        return out;
    }

    public PythonLikeObject getItemOrNone(PythonLikeObject key) {
        PythonLikeObject out = (PythonLikeObject)this.delegate.get((Object)key);
        if (out == null) {
            return PythonNone.INSTANCE;
        }
        return out;
    }

    public PythonLikeObject getItemOrDefault(PythonLikeObject key, PythonLikeObject defaultValue) {
        PythonLikeObject out = (PythonLikeObject)this.delegate.get((Object)key);
        if (out == null) {
            return defaultValue;
        }
        return out;
    }

    public DictItemView getItems() {
        return new DictItemView(this);
    }

    public DictKeyView getKeyView() {
        return new DictKeyView(this);
    }

    public PythonNone setItem(PythonLikeObject key, PythonLikeObject value) {
        this.delegate.put((Object)key, (Object)value);
        return PythonNone.INSTANCE;
    }

    public PythonNone removeItemOrError(PythonLikeObject key) {
        if (this.delegate.remove((Object)key) == null) {
            throw new KeyError(key.toString());
        }
        return PythonNone.INSTANCE;
    }

    public PythonBoolean isKeyInDict(PythonLikeObject key) {
        return PythonBoolean.valueOf(this.delegate.containsKey((Object)key));
    }

    public PythonNone clearDict() {
        this.delegate.clear();
        return PythonNone.INSTANCE;
    }

    public PythonLikeObject popItemOrError(PythonLikeObject key) {
        PythonLikeObject out = (PythonLikeObject)this.delegate.remove((Object)key);
        if (out == null) {
            throw new KeyError(key.toString());
        }
        return out;
    }

    public PythonLikeObject popItemOrDefault(PythonLikeObject key, PythonLikeObject defaultValue) {
        PythonLikeObject out = (PythonLikeObject)this.delegate.remove((Object)key);
        if (out == null) {
            return defaultValue;
        }
        return out;
    }

    public PythonLikeObject popLast() {
        if (this.delegate.isEmpty()) {
            throw new KeyError("popitem(): dictionary is empty");
        }
        PythonLikeObject lastKey = (PythonLikeObject)this.delegate.lastKey();
        return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{lastKey, (PythonLikeObject)this.delegate.remove((Object)lastKey)});
    }

    public DelegatePythonIterator<PythonLikeObject> reversed() {
        if (this.delegate.isEmpty()) {
            return new DelegatePythonIterator<PythonLikeObject>(Collections.emptyIterator());
        }
        final PythonLikeObject lastKey = (PythonLikeObject)this.delegate.lastKey();
        return new DelegatePythonIterator<PythonLikeObject>(new Iterator<PythonLikeObject>(){
            PythonLikeObject current;
            {
                this.current = lastKey;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public PythonLikeObject next() {
                PythonLikeObject out = this.current;
                this.current = (PythonLikeObject)PythonLikeDict.this.delegate.previousKey((Object)this.current);
                return out;
            }
        });
    }

    public PythonLikeObject setIfAbsent(PythonLikeObject key) {
        PythonLikeObject value = (PythonLikeObject)this.delegate.get((Object)key);
        if (value != null) {
            return value;
        }
        this.delegate.put((Object)key, (Object)PythonNone.INSTANCE);
        return PythonNone.INSTANCE;
    }

    public PythonLikeObject setIfAbsent(PythonLikeObject key, PythonLikeObject defaultValue) {
        PythonLikeObject value = (PythonLikeObject)this.delegate.get((Object)key);
        if (value != null) {
            return value;
        }
        this.delegate.put((Object)key, (Object)defaultValue);
        return defaultValue;
    }

    public PythonNone update(PythonLikeDict other) {
        this.delegate.putAll((Map)other.delegate);
        return PythonNone.INSTANCE;
    }

    public PythonNone update(PythonLikeObject iterable) {
        Iterator iterator = (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(iterable));
        while (iterator.hasNext()) {
            List keyValuePair = (List)iterator.next();
            this.delegate.put(keyValuePair.get(0), keyValuePair.get(1));
        }
        return PythonNone.INSTANCE;
    }

    public DictValueView getValueView() {
        return new DictValueView(this);
    }

    public PythonLikeDict<K, V> binaryOr(PythonLikeDict<K, V> other) {
        PythonLikeDict<K, V> out = new PythonLikeDict<K, V>();
        out.delegate.putAll((Map)this.delegate);
        out.delegate.putAll((Map)other.delegate);
        return out;
    }

    public PythonLikeDict<K, V> binaryInplaceOr(PythonLikeDict<K, V> other) {
        this.delegate.putAll((Map)other.delegate);
        return this;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return (V)((PythonLikeObject)this.delegate.get(key));
    }

    @Override
    public PythonLikeObject put(PythonLikeObject key, PythonLikeObject value) {
        return (PythonLikeObject)this.delegate.put((Object)key, (Object)value);
    }

    @Override
    public V remove(Object o) {
        return (V)((PythonLikeObject)this.delegate.remove(o));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.delegate.putAll(map);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public Iterator<PythonLikeObject> iterator() {
        return this.delegate.keySet().iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Map) {
            Map other = (Map)o;
            if (other.size() != this.size()) {
                return false;
            }
            return this.entrySet().containsAll(other.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    @Override
    public PythonString $method$__str__() {
        return PythonString.valueOf(this.toString());
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    static {
        PythonOverloadImplementor.deferDispatchesFor(PythonLikeDict::registerMethods);
    }
}

