/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.numeric;

import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.types.PythonLikeComparable;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import java.math.BigDecimal;
import java.math.BigInteger;

public interface PythonNumber
extends PythonLikeComparable<PythonNumber>,
PythonLikeObject {
    public static final PythonLikeType NUMBER_TYPE = new PythonLikeType("number", PythonNumber.class);
    public static final PythonInteger MODULUS = PythonInteger.valueOf(0x1FFFFFFFFFFFFFFFL);
    public static final PythonInteger INFINITY_HASH_VALUE = PythonInteger.valueOf(314159);

    public Number getValue();

    @Override
    default public int compareTo(PythonNumber pythonNumber) {
        Number self;
        Number value = this.getValue();
        Number otherValue = pythonNumber.getValue();
        if (value instanceof BigInteger) {
            self = (BigInteger)value;
            if (otherValue instanceof BigInteger) {
                BigInteger other = (BigInteger)otherValue;
                return ((BigInteger)self).compareTo(other);
            }
            if (otherValue instanceof BigDecimal) {
                BigDecimal other = (BigDecimal)otherValue;
                return new BigDecimal((BigInteger)self).compareTo(other);
            }
        }
        if (value instanceof BigDecimal) {
            self = (BigDecimal)value;
            if (otherValue instanceof BigDecimal) {
                BigDecimal other = (BigDecimal)otherValue;
                return ((BigDecimal)self).compareTo(other);
            }
            if (otherValue instanceof BigInteger) {
                BigInteger other = (BigInteger)otherValue;
                return ((BigDecimal)self).compareTo(new BigDecimal(other));
            }
        }
        return Double.compare(value.doubleValue(), otherValue.doubleValue());
    }

    public static PythonInteger computeHash(PythonInteger numerator, PythonInteger denominator) {
        PythonInteger P = MODULUS;
        while (numerator.modulo(P).equals(PythonInteger.ZERO) && denominator.modulo(P).equals(PythonInteger.ZERO)) {
            numerator = numerator.floorDivide(P);
            denominator = denominator.floorDivide(P);
        }
        PythonInteger hash_value = denominator.modulo(P).equals(PythonInteger.ZERO) ? INFINITY_HASH_VALUE : numerator.abs().modulo(P).multiply(denominator.power(P.subtract(PythonInteger.TWO), P)).modulo(P);
        if (numerator.lessThan(PythonInteger.ZERO).getBooleanValue()) {
            hash_value = hash_value.negative();
        }
        if (hash_value.equals(PythonInteger.valueOf(-1))) {
            hash_value = PythonInteger.valueOf(-2);
        }
        return hash_value;
    }
}

