/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.util;

import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.builtins.BinaryDunderBuiltin;
import ai.timefold.jpyinterpreter.builtins.GlobalBuiltins;
import ai.timefold.jpyinterpreter.builtins.UnaryDunderBuiltin;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.PythonByteArray;
import ai.timefold.jpyinterpreter.types.PythonBytes;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeDict;
import ai.timefold.jpyinterpreter.types.errors.TypeError;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import ai.timefold.jpyinterpreter.types.errors.lookup.KeyError;
import ai.timefold.jpyinterpreter.types.numeric.PythonFloat;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.jpyinterpreter.util.DefaultFormatSpec;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringFormatter {
    static final String IDENTIFIER = "(?:(?:\\p{javaUnicodeIdentifierStart}|_)\\p{javaUnicodeIdentifierPart}*)";
    static final String ARG_NAME = "(?<argName>(?:(?:\\p{javaUnicodeIdentifierStart}|_)\\p{javaUnicodeIdentifierPart}*)|\\d+)?";
    static final String ATTRIBUTE_NAME = "(?:(?:\\p{javaUnicodeIdentifierStart}|_)\\p{javaUnicodeIdentifierPart}*)";
    static final String ELEMENT_INDEX = "[^]]+";
    static final String ITEM_NAME = "(?:(?:\\.(?:(?:\\p{javaUnicodeIdentifierStart}|_)\\p{javaUnicodeIdentifierPart}*))|(?:\\[[^]]+\\]))";
    static final String FIELD_NAME = "(?<fieldName>(?<argName>(?:(?:\\p{javaUnicodeIdentifierStart}|_)\\p{javaUnicodeIdentifierPart}*)|\\d+)?((?:(?:\\.(?:(?:\\p{javaUnicodeIdentifierStart}|_)\\p{javaUnicodeIdentifierPart}*))|(?:\\[[^]]+\\])))*)?";
    static final String CONVERSION = "(?:!(?<conversion>[rsa]))?";
    static final String FORMAT_SPEC = "(?::(?<formatSpec>[^{}]*))?";
    static final Pattern REPLACEMENT_FIELD_PATTERN = Pattern.compile("\\{(?<fieldName>(?<argName>(?:(?:\\p{javaUnicodeIdentifierStart}|_)\\p{javaUnicodeIdentifierPart}*)|\\d+)?((?:(?:\\.(?:(?:\\p{javaUnicodeIdentifierStart}|_)\\p{javaUnicodeIdentifierPart}*))|(?:\\[[^]]+\\])))*)?(?:!(?<conversion>[rsa]))?(?::(?<formatSpec>[^{}]*))?}|(?<literal>\\{\\{|}})");
    static final Pattern INDEX_CHAIN_PART_PATTERN = Pattern.compile("(?:(?:\\.(?:(?:\\p{javaUnicodeIdentifierStart}|_)\\p{javaUnicodeIdentifierPart}*))|(?:\\[[^]]+\\]))");
    private static final Pattern PRINTF_FORMAT_REGEX = Pattern.compile("%(?:(?<key>\\([^()]+\\))?(?<flags>[#0\\-+ ]*)?(?<minWidth>\\*|\\d+)?(?<precision>\\.(?:\\*|\\d+))?[hlL]?(?<type>[diouxXeEfFgGcrsa%])|.*)");

    public static String printfInterpolate(CharSequence value, List<PythonLikeObject> tuple, PrintfStringType stringType) {
        Matcher matcher = PRINTF_FORMAT_REGEX.matcher(value);
        StringBuilder out = new StringBuilder();
        int start = 0;
        int currentElement = 0;
        while (matcher.find()) {
            out.append(value, start, matcher.start());
            start = matcher.end();
            String key = matcher.group("key");
            if (key != null) {
                throw new TypeError("format requires a mapping");
            }
            String flags = matcher.group("flags");
            String minWidth = matcher.group("minWidth");
            String precisionString = matcher.group("precision");
            PrintfConversionType conversionType = PrintfConversionType.getConversionType(matcher);
            if (conversionType != PrintfConversionType.LITERAL_PERCENT) {
                if (tuple.size() <= currentElement) {
                    throw new TypeError("not enough arguments for format string");
                }
                PythonLikeObject toConvert = tuple.get(currentElement);
                ++currentElement;
                if ("*".equals(minWidth)) {
                    if (tuple.size() <= currentElement) {
                        throw new TypeError("not enough arguments for format string");
                    }
                    minWidth = ((PythonString)UnaryDunderBuiltin.STR.invoke((PythonLikeObject)tuple.get((int)currentElement))).value;
                    ++currentElement;
                }
                if ("*".equals(precisionString)) {
                    if (tuple.size() <= currentElement) {
                        throw new TypeError("not enough arguments for format string");
                    }
                    precisionString = ((PythonString)UnaryDunderBuiltin.STR.invoke((PythonLikeObject)tuple.get((int)currentElement))).value;
                    ++currentElement;
                }
                Optional<Integer> maybePrecision = precisionString != null ? Optional.of(Integer.parseInt(precisionString.substring(1))) : Optional.empty();
                Optional<Integer> maybeWidth = minWidth != null ? Optional.of(Integer.parseInt(minWidth)) : Optional.empty();
                out.append(StringFormatter.performInterpolateConversion(flags, maybeWidth, maybePrecision, conversionType, toConvert, stringType));
                continue;
            }
            out.append("%");
        }
        out.append(value.subSequence(start, value.length()));
        return out.toString();
    }

    public static String printfInterpolate(CharSequence value, PythonLikeDict dict, PrintfStringType stringType) {
        Matcher matcher = PRINTF_FORMAT_REGEX.matcher(value);
        StringBuilder out = new StringBuilder();
        int start = 0;
        while (matcher.find()) {
            out.append(value, start, matcher.start());
            start = matcher.end();
            PrintfConversionType conversionType = PrintfConversionType.getConversionType(matcher);
            if (conversionType != PrintfConversionType.LITERAL_PERCENT) {
                String key = matcher.group("key");
                if (key == null) {
                    throw new ValueError("When a dict is used for the interpolation operator, all conversions must have parenthesised keys");
                }
                key = key.substring(1, key.length() - 1);
                String flags = matcher.group("flags");
                String minWidth = matcher.group("minWidth");
                String precisionString = matcher.group("precision");
                if ("*".equals(minWidth)) {
                    throw new ValueError("* cannot be used for minimum field width when a dict is used for the interpolation operator");
                }
                if ("*".equals(precisionString)) {
                    throw new ValueError("* cannot be used for precision when a dict is used for the interpolation operator");
                }
                PythonLikeObject toConvert = stringType == PrintfStringType.STRING ? dict.getItemOrError(PythonString.valueOf(key)) : dict.getItemOrError(PythonString.valueOf(key).asAsciiBytes());
                Optional<Integer> maybePrecision = precisionString != null ? Optional.of(Integer.parseInt(precisionString.substring(1))) : Optional.empty();
                Optional<Integer> maybeWidth = minWidth != null ? Optional.of(Integer.parseInt(minWidth)) : Optional.empty();
                out.append(StringFormatter.performInterpolateConversion(flags, maybeWidth, maybePrecision, conversionType, toConvert, stringType));
                continue;
            }
            out.append("%");
        }
        out.append(value.subSequence(start, value.length()));
        return out.toString();
    }

    private static BigDecimal getBigDecimalWithPrecision(BigDecimal number, Optional<Integer> precision) {
        int currentScale = number.scale();
        int currentPrecision = number.precision();
        int precisionDelta = precision.orElse(6) - currentPrecision;
        return number.setScale(currentScale + precisionDelta, RoundingMode.HALF_EVEN);
    }

    private static String getUppercaseEngineeringString(BigDecimal number, Optional<Integer> precision) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(out);
        printStream.printf("%1." + (precision.orElse(6) - 1) + "E", number);
        return out.toString();
    }

    private static String performInterpolateConversion(String flags, Optional<Integer> maybeWidth, Optional<Integer> maybePrecision, PrintfConversionType conversionType, PythonLikeObject toConvert, PrintfStringType stringType) {
        Object result;
        boolean useAlternateForm = flags.contains("#");
        boolean isZeroPadded = flags.contains("0");
        boolean isLeftAdjusted = flags.contains("-");
        if (isLeftAdjusted) {
            isZeroPadded = false;
        }
        boolean putSpaceBeforePositiveNumber = flags.contains(" ");
        boolean putSignBeforeConversion = flags.contains("+");
        if (putSignBeforeConversion) {
            putSpaceBeforePositiveNumber = false;
        }
        switch (conversionType) {
            case SIGNED_INTEGER_DECIMAL: {
                if (toConvert instanceof PythonFloat) {
                    toConvert = ((PythonFloat)toConvert).asInteger();
                }
                if (!(toConvert instanceof PythonInteger)) {
                    throw new TypeError("%d format: a real number is required, not " + toConvert.$getType().getTypeName());
                }
                result = ((PythonInteger)toConvert).value.toString(10);
                break;
            }
            case SIGNED_INTEGER_OCTAL: {
                if (toConvert instanceof PythonFloat) {
                    toConvert = ((PythonFloat)toConvert).asInteger();
                }
                if (!(toConvert instanceof PythonInteger)) {
                    throw new TypeError("%o format: a real number is required, not " + toConvert.$getType().getTypeName());
                }
                result = ((PythonInteger)toConvert).value.toString(8);
                if (!useAlternateForm) break;
                result = ((String)result).startsWith("-") ? "-0o" + ((String)result).substring(1) : "0o" + (String)result;
                break;
            }
            case SIGNED_HEXADECIMAL_LOWERCASE: {
                if (toConvert instanceof PythonFloat) {
                    toConvert = ((PythonFloat)toConvert).asInteger();
                }
                if (!(toConvert instanceof PythonInteger)) {
                    throw new TypeError("%x format: a real number is required, not " + toConvert.$getType().getTypeName());
                }
                result = ((PythonInteger)toConvert).value.toString(16);
                if (!useAlternateForm) break;
                result = ((String)result).startsWith("-") ? "-0x" + ((String)result).substring(1) : "0x" + (String)result;
                break;
            }
            case SIGNED_HEXADECIMAL_UPPERCASE: {
                if (toConvert instanceof PythonFloat) {
                    toConvert = ((PythonFloat)toConvert).asInteger();
                }
                if (!(toConvert instanceof PythonInteger)) {
                    throw new TypeError("%X format: a real number is required, not " + toConvert.$getType().getTypeName());
                }
                result = ((PythonInteger)toConvert).value.toString(16).toUpperCase();
                if (!useAlternateForm) break;
                result = ((String)result).startsWith("-") ? "-0X" + ((String)result).substring(1) : "0X" + (String)result;
                break;
            }
            case FLOATING_POINT_EXPONENTIAL_LOWERCASE: {
                if (toConvert instanceof PythonInteger) {
                    toConvert = ((PythonInteger)toConvert).asFloat();
                }
                if (!(toConvert instanceof PythonFloat)) {
                    throw new TypeError("%e format: a real number is required, not " + toConvert.$getType().getTypeName());
                }
                BigDecimal value = BigDecimal.valueOf(((PythonFloat)toConvert).value);
                result = StringFormatter.getUppercaseEngineeringString(value, maybePrecision.map(precision -> precision + 1).or(() -> Optional.of(7))).toLowerCase();
                if (!useAlternateForm || ((String)result).contains(".")) break;
                result = (String)result + ".0";
                break;
            }
            case FLOATING_POINT_EXPONENTIAL_UPPERCASE: {
                if (toConvert instanceof PythonInteger) {
                    toConvert = ((PythonInteger)toConvert).asFloat();
                }
                if (!(toConvert instanceof PythonFloat)) {
                    throw new TypeError("%E format: a real number is required, not " + toConvert.$getType().getTypeName());
                }
                BigDecimal value = BigDecimal.valueOf(((PythonFloat)toConvert).value);
                result = StringFormatter.getUppercaseEngineeringString(value, maybePrecision.map(precision -> precision + 1).or(() -> Optional.of(7)));
                if (!useAlternateForm || ((String)result).contains(".")) break;
                result = (String)result + ".0";
                break;
            }
            case FLOATING_POINT_DECIMAL: {
                if (toConvert instanceof PythonInteger) {
                    toConvert = ((PythonInteger)toConvert).asFloat();
                }
                if (!(toConvert instanceof PythonFloat)) {
                    throw new TypeError("%f format: a real number is required, not " + toConvert.$getType().getTypeName());
                }
                BigDecimal value = BigDecimal.valueOf(((PythonFloat)toConvert).value);
                BigDecimal valueWithPrecision = value.setScale((int)maybePrecision.orElse(6), RoundingMode.HALF_EVEN);
                result = valueWithPrecision.toPlainString();
                if (!useAlternateForm || ((String)result).contains(".")) break;
                result = (String)result + ".0";
                break;
            }
            case FLOATING_POINT_DECIMAL_OR_EXPONENTIAL_LOWERCASE: {
                if (toConvert instanceof PythonInteger) {
                    toConvert = ((PythonInteger)toConvert).asFloat();
                }
                if (!(toConvert instanceof PythonFloat)) {
                    throw new TypeError("%g format: a real number is required, not " + toConvert.$getType().getTypeName());
                }
                BigDecimal value = BigDecimal.valueOf(((PythonFloat)toConvert).value);
                if (value.scale() > 4 || value.precision() >= maybePrecision.orElse(6)) {
                    BigDecimal valueWithPrecision = StringFormatter.getBigDecimalWithPrecision(value, maybePrecision);
                    result = StringFormatter.getUppercaseEngineeringString(valueWithPrecision, maybePrecision).toLowerCase();
                } else {
                    BigDecimal valueWithPrecision = value.setScale((int)maybePrecision.orElse(6), RoundingMode.HALF_EVEN);
                    result = valueWithPrecision.toPlainString();
                }
                if (((String)result).length() < 3 || ((String)result).charAt(((String)result).length() - 3) != 'e') break;
                result = ((String)result).substring(0, ((String)result).length() - 1) + "0" + ((String)result).charAt(((String)result).length() - 1);
                break;
            }
            case FLOATING_POINT_DECIMAL_OR_EXPONENTIAL_UPPERCASE: {
                if (toConvert instanceof PythonInteger) {
                    toConvert = ((PythonInteger)toConvert).asFloat();
                }
                if (!(toConvert instanceof PythonFloat)) {
                    throw new TypeError("%G format: a real number is required, not " + toConvert.$getType().getTypeName());
                }
                BigDecimal value = BigDecimal.valueOf(((PythonFloat)toConvert).value);
                if (value.scale() > 4 || value.precision() >= maybePrecision.orElse(6)) {
                    BigDecimal valueWithPrecision = StringFormatter.getBigDecimalWithPrecision(value, maybePrecision);
                    result = StringFormatter.getUppercaseEngineeringString(valueWithPrecision, maybePrecision);
                    break;
                }
                BigDecimal valueWithPrecision = value.setScale((int)maybePrecision.orElse(6), RoundingMode.HALF_EVEN);
                result = valueWithPrecision.toPlainString();
                break;
            }
            case SINGLE_CHARACTER: {
                AbstractPythonLikeObject convertedCharacter;
                if (stringType == PrintfStringType.STRING) {
                    if (toConvert instanceof PythonString) {
                        convertedCharacter = (PythonString)toConvert;
                        if (((PythonString)convertedCharacter).value.length() != 1) {
                            throw new ValueError("c specifier can only take an integer or single character string");
                        }
                        result = ((PythonString)convertedCharacter).value;
                        break;
                    }
                    result = Character.toString(((PythonInteger)toConvert).value.intValueExact());
                    break;
                }
                if (toConvert instanceof PythonBytes) {
                    convertedCharacter = (PythonBytes)toConvert;
                    if (((PythonBytes)convertedCharacter).value.length != 1) {
                        throw new ValueError("c specifier can only take an integer or single character string");
                    }
                    result = ((PythonBytes)convertedCharacter).asCharSequence().toString();
                    break;
                }
                if (toConvert instanceof PythonByteArray) {
                    convertedCharacter = (PythonByteArray)toConvert;
                    if (((PythonByteArray)convertedCharacter).valueBuffer.limit() != 1) {
                        throw new ValueError("c specifier can only take an integer or single character string");
                    }
                    result = ((PythonByteArray)convertedCharacter).asCharSequence().toString();
                    break;
                }
                result = Character.toString(((PythonInteger)toConvert).value.intValueExact());
                break;
            }
            case REPR_STRING: {
                result = ((PythonString)UnaryDunderBuiltin.REPRESENTATION.invoke((PythonLikeObject)toConvert)).value;
                break;
            }
            case STR_STRING: {
                if (stringType == PrintfStringType.STRING) {
                    result = ((PythonString)UnaryDunderBuiltin.STR.invoke((PythonLikeObject)toConvert)).value;
                    break;
                }
                if (toConvert instanceof PythonBytes) {
                    result = ((PythonBytes)toConvert).asCharSequence().toString();
                    break;
                }
                if (toConvert instanceof PythonByteArray) {
                    result = ((PythonByteArray)toConvert).asCharSequence().toString();
                    break;
                }
                result = ((PythonString)UnaryDunderBuiltin.STR.invoke((PythonLikeObject)toConvert)).value;
                break;
            }
            case ASCII_STRING: {
                result = GlobalBuiltins.ascii(List.of(toConvert), Map.of(), null).value;
                break;
            }
            case LITERAL_PERCENT: {
                result = "%";
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled case: " + conversionType);
            }
        }
        if (putSignBeforeConversion && !((String)result).startsWith("+") && !((String)result).startsWith("-")) {
            result = "+" + (String)result;
        }
        if (putSpaceBeforePositiveNumber && !((String)result).startsWith("-")) {
            result = " " + (String)result;
        }
        if (maybeWidth.isPresent() && maybeWidth.get() > ((String)result).length()) {
            int padding = maybeWidth.get() - ((String)result).length();
            if (isZeroPadded) {
                result = ((String)result).startsWith("+") || ((String)result).startsWith("-") ? ((String)result).charAt(0) + "0".repeat(padding) + ((String)result).substring(1) : "0".repeat(padding) + (String)result;
            } else if (isLeftAdjusted) {
                result = (String)result + " ".repeat(padding);
            }
        }
        return result;
    }

    public static String format(String text, List<PythonLikeObject> positionalArguments, Map<? extends PythonLikeObject, PythonLikeObject> namedArguments) {
        Matcher matcher = REPLACEMENT_FIELD_PATTERN.matcher(text);
        StringBuilder out = new StringBuilder();
        int start = 0;
        int implicitField = 0;
        block20: while (matcher.find()) {
            PythonLikeObject toConvert;
            out.append(text, start, matcher.start());
            start = matcher.end();
            String literal = matcher.group("literal");
            if (literal != null) {
                switch (literal) {
                    case "{{": {
                        out.append("{");
                        continue block20;
                    }
                    case "}}": {
                        out.append("}");
                        continue block20;
                    }
                }
                throw new IllegalStateException("Unhandled literal: " + literal);
            }
            String argName = matcher.group("argName");
            if (positionalArguments != null) {
                if (argName == null) {
                    if (implicitField >= positionalArguments.size()) {
                        throw new ValueError("(" + implicitField + ") is larger than sequence length (" + positionalArguments.size() + ")");
                    }
                    toConvert = positionalArguments.get(implicitField);
                    ++implicitField;
                } else {
                    try {
                        int argumentIndex = Integer.parseInt(argName);
                        if (argumentIndex >= positionalArguments.size()) {
                            throw new ValueError("(" + implicitField + ") is larger than sequence length (" + positionalArguments.size() + ")");
                        }
                        toConvert = positionalArguments.get(argumentIndex);
                    }
                    catch (NumberFormatException e) {
                        if (namedArguments == null) {
                            throw new ValueError("(" + argName + ") cannot be used to index a sequence");
                        }
                        toConvert = namedArguments.get(PythonString.valueOf(argName));
                    }
                }
            } else {
                toConvert = namedArguments.get(PythonString.valueOf(argName));
            }
            if (toConvert == null) {
                throw new KeyError(argName);
            }
            toConvert = StringFormatter.getFinalObjectInChain(toConvert, matcher.group("fieldName"));
            String conversion = matcher.group("conversion");
            if (conversion != null) {
                switch (conversion) {
                    case "s": {
                        toConvert = UnaryDunderBuiltin.STR.invoke(toConvert);
                        break;
                    }
                    case "r": {
                        toConvert = UnaryDunderBuiltin.REPRESENTATION.invoke(toConvert);
                        break;
                    }
                    case "a": {
                        toConvert = GlobalBuiltins.ascii(List.of(toConvert), Map.of(), null);
                    }
                }
            }
            String formatSpec = Objects.requireNonNullElse(matcher.group("formatSpec"), "");
            out.append(BinaryDunderBuiltin.FORMAT.invoke(toConvert, PythonString.valueOf(formatSpec)));
        }
        out.append(text.substring(start));
        return out.toString();
    }

    private static PythonLikeObject getFinalObjectInChain(PythonLikeObject chainStart, String chain) {
        if (chain == null) {
            return chainStart;
        }
        PythonLikeObject current = chainStart;
        Matcher matcher = INDEX_CHAIN_PART_PATTERN.matcher(chain);
        while (matcher.find()) {
            String result = matcher.group();
            if (result.startsWith(".")) {
                String attributeName = result.substring(1);
                current = BinaryDunderBuiltin.GET_ATTRIBUTE.invoke(current, PythonString.valueOf(attributeName));
                continue;
            }
            String index = result.substring(1, result.length() - 1);
            try {
                int intIndex = Integer.parseInt(index);
                current = BinaryDunderBuiltin.GET_ITEM.invoke(current, PythonInteger.valueOf(intIndex));
            }
            catch (NumberFormatException e) {
                current = BinaryDunderBuiltin.GET_ITEM.invoke(current, PythonString.valueOf(index));
            }
        }
        return current;
    }

    public static void addGroupings(StringBuilder out, DefaultFormatSpec formatSpec, int groupSize) {
        if (formatSpec.groupingOption.isEmpty()) {
            return;
        }
        if (groupSize <= 0) {
            throw new ValueError("Invalid format spec: grouping option now allowed for conversion type " + formatSpec.conversionType);
        }
        int decimalSeperator = out.indexOf(".");
        char seperator = switch (formatSpec.groupingOption.get()) {
            case DefaultFormatSpec.GroupingOption.COMMA -> ',';
            case DefaultFormatSpec.GroupingOption.UNDERSCORE -> '_';
            default -> throw new IllegalStateException("Unhandled case: " + (Object)((Object)formatSpec.groupingOption.get()));
        };
        int groupIndex = 0;
        for (int index = decimalSeperator != -1 ? decimalSeperator - 1 : out.length() - 1; index >= 0 && out.charAt(index) != '-'; --index) {
            if (++groupIndex != groupSize) continue;
            out.insert(index, seperator);
            groupIndex = 0;
        }
    }

    public static void align(StringBuilder out, DefaultFormatSpec formatSpec, DefaultFormatSpec.AlignmentOption defaultAlignment) {
        if (formatSpec.width.isPresent()) {
            switch (formatSpec.alignment.orElse(defaultAlignment)) {
                case LEFT_ALIGN: {
                    StringFormatter.leftAlign(out, formatSpec.fillCharacter, formatSpec.width.get());
                    break;
                }
                case RIGHT_ALIGN: {
                    StringFormatter.rightAlign(out, formatSpec.fillCharacter, formatSpec.width.get());
                    break;
                }
                case RESPECT_SIGN_RIGHT_ALIGN: {
                    StringFormatter.respectSignRightAlign(out, formatSpec.fillCharacter, formatSpec.width.get());
                    break;
                }
                case CENTER_ALIGN: {
                    StringFormatter.center(out, formatSpec.fillCharacter, formatSpec.width.get());
                }
            }
        }
    }

    public static void alignWithPrefixRespectingSign(StringBuilder out, String prefix, DefaultFormatSpec formatSpec, DefaultFormatSpec.AlignmentOption defaultAlignment) {
        int insertPosition;
        int n = insertPosition = out.charAt(0) == '+' || out.charAt(0) == '-' || out.charAt(0) == ' ' ? 1 : 0;
        if (formatSpec.width.isPresent()) {
            switch (formatSpec.alignment.orElse(defaultAlignment)) {
                case LEFT_ALIGN: {
                    out.insert(insertPosition, prefix);
                    StringFormatter.leftAlign(out, formatSpec.fillCharacter, formatSpec.width.get());
                    break;
                }
                case RIGHT_ALIGN: {
                    out.insert(insertPosition, prefix);
                    StringFormatter.rightAlign(out, formatSpec.fillCharacter, formatSpec.width.get());
                    break;
                }
                case RESPECT_SIGN_RIGHT_ALIGN: {
                    StringFormatter.respectSignRightAlign(out, formatSpec.fillCharacter, formatSpec.width.get());
                    out.insert(insertPosition, prefix);
                    break;
                }
                case CENTER_ALIGN: {
                    out.insert(insertPosition, prefix);
                    StringFormatter.center(out, formatSpec.fillCharacter, formatSpec.width.get());
                }
            }
        } else {
            out.insert(insertPosition, prefix);
        }
    }

    public static void leftAlign(StringBuilder builder, String fillCharAsString, int width) {
        if (width <= builder.length()) {
            return;
        }
        int rightPadding = width - builder.length();
        builder.append(fillCharAsString.repeat(rightPadding));
    }

    public static void rightAlign(StringBuilder builder, String fillCharAsString, int width) {
        if (width <= builder.length()) {
            return;
        }
        int leftPadding = width - builder.length();
        builder.insert(0, fillCharAsString.repeat(leftPadding));
    }

    public static void respectSignRightAlign(StringBuilder builder, String fillCharAsString, int width) {
        if (width <= builder.length()) {
            return;
        }
        int leftPadding = width - builder.length();
        if (builder.length() >= 1 && (builder.charAt(0) == '+' || builder.charAt(0) == '-' || builder.charAt(0) == ' ')) {
            builder.insert(1, fillCharAsString.repeat(leftPadding));
        } else {
            builder.insert(0, fillCharAsString.repeat(leftPadding));
        }
    }

    public static void center(StringBuilder builder, String fillCharAsString, int width) {
        if (width <= builder.length()) {
            return;
        }
        int extraWidth = width - builder.length();
        int rightPadding = extraWidth / 2;
        int leftPadding = rightPadding + (extraWidth & 1);
        builder.insert(0, fillCharAsString.repeat(leftPadding)).append(fillCharAsString.repeat(rightPadding));
    }

    private static enum PrintfConversionType {
        SIGNED_INTEGER_DECIMAL("d", "i", "u"),
        SIGNED_INTEGER_OCTAL("o"),
        SIGNED_HEXADECIMAL_LOWERCASE("x"),
        SIGNED_HEXADECIMAL_UPPERCASE("X"),
        FLOATING_POINT_EXPONENTIAL_LOWERCASE("e"),
        FLOATING_POINT_EXPONENTIAL_UPPERCASE("E"),
        FLOATING_POINT_DECIMAL("f", "F"),
        FLOATING_POINT_DECIMAL_OR_EXPONENTIAL_LOWERCASE("g"),
        FLOATING_POINT_DECIMAL_OR_EXPONENTIAL_UPPERCASE("G"),
        SINGLE_CHARACTER("c"),
        REPR_STRING("r"),
        STR_STRING("s"),
        ASCII_STRING("a"),
        LITERAL_PERCENT("%");

        final String[] matchedCharacters;

        private PrintfConversionType(String ... matchedCharacters) {
            this.matchedCharacters = matchedCharacters;
        }

        public static PrintfConversionType getConversionType(Matcher matcher) {
            String conversion = matcher.group("type");
            if (conversion == null) {
                throw new ValueError("Invalid specifier at position " + matcher.start() + " in string ");
            }
            for (PrintfConversionType conversionType : PrintfConversionType.values()) {
                for (String matchedCharacter : conversionType.matchedCharacters) {
                    if (!matchedCharacter.equals(conversion)) continue;
                    return conversionType;
                }
            }
            throw new IllegalStateException("Conversion (" + conversion + ") does not match any defined conversions");
        }
    }

    public static enum PrintfStringType {
        STRING,
        BYTES;

    }
}

