/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter;

import ai.timefold.jpyinterpreter.CPythonBackedPythonInterpreter;
import ai.timefold.jpyinterpreter.ExceptionBlock;
import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.InterpreterStartupOptions;
import ai.timefold.jpyinterpreter.LocalVariableHelper;
import ai.timefold.jpyinterpreter.MethodDescriptor;
import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.PythonCompiledFunction;
import ai.timefold.jpyinterpreter.PythonFunctionType;
import ai.timefold.jpyinterpreter.PythonGeneratorTranslator;
import ai.timefold.jpyinterpreter.PythonInterpreter;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.TypeHint;
import ai.timefold.jpyinterpreter.ValueSourceInfo;
import ai.timefold.jpyinterpreter.dag.FlowGraph;
import ai.timefold.jpyinterpreter.implementors.CollectionImplementor;
import ai.timefold.jpyinterpreter.implementors.ExceptionImplementor;
import ai.timefold.jpyinterpreter.implementors.FunctionImplementor;
import ai.timefold.jpyinterpreter.implementors.JavaPythonTypeConversionImplementor;
import ai.timefold.jpyinterpreter.implementors.StackManipulationImplementor;
import ai.timefold.jpyinterpreter.implementors.VariableImplementor;
import ai.timefold.jpyinterpreter.opcodes.AbstractOpcode;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.opcodes.OpcodeWithoutSource;
import ai.timefold.jpyinterpreter.opcodes.SelfOpcodeWithoutSource;
import ai.timefold.jpyinterpreter.opcodes.descriptor.GeneratorOpDescriptor;
import ai.timefold.jpyinterpreter.opcodes.descriptor.OpcodeDescriptor;
import ai.timefold.jpyinterpreter.opcodes.variable.LoadFastAndClearOpcode;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeFunction;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeDict;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.errors.PythonBaseException;
import ai.timefold.jpyinterpreter.types.wrappers.OpaquePythonReference;
import ai.timefold.jpyinterpreter.types.wrappers.PythonObjectWrapper;
import ai.timefold.jpyinterpreter.util.JavaPythonClassWriter;
import ai.timefold.jpyinterpreter.util.MethodVisitorAdapters;
import ai.timefold.jpyinterpreter.util.arguments.ArgumentSpec;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonBytecodeToJavaBytecodeTranslator {
    public static final String USER_PACKAGE_BASE = "org.jpyinterpreter.user.";
    public static final String GENERATED_PACKAGE_BASE = "org.jpyinterpreter.synthetic.";
    public static final String CONSTANTS_STATIC_FIELD_NAME = "co_consts";
    public static final String NAMES_STATIC_FIELD_NAME = "co_names";
    public static final String VARIABLE_NAMES_STATIC_FIELD_NAME = "co_varnames";
    public static final String GLOBALS_MAP_STATIC_FIELD_NAME = "__globals__";
    public static final String CLASS_CELL_STATIC_FIELD_NAME = "__class_cell__";
    public static final String ARGUMENT_SPEC_GETTER_STATIC_FIELD_NAME = "__spec_getter__";
    public static final String PYTHON_WRAPPER_CODE_STATIC_FIELD_NAME = "__code__";
    public static final String DEFAULT_POSITIONAL_ARGS_INSTANCE_FIELD_NAME = "__defaults__";
    public static final String DEFAULT_KEYWORD_ARGS_INSTANCE_FIELD_NAME = "__kwdefaults__";
    public static final String ANNOTATION_DIRECTORY_INSTANCE_FIELD_NAME = "__annotations__";
    public static final String CELLS_INSTANCE_FIELD_NAME = "__closure__";
    public static final String QUALIFIED_NAME_INSTANCE_FIELD_NAME = "__qualname__";
    public static final String ARGUMENT_SPEC_INSTANCE_FIELD_NAME = "__spec__";
    public static final String INTERPRETER_INSTANCE_FIELD_NAME = "__interpreter__";
    public static final String PYTHON_WRAPPER_FUNCTION_INSTANCE_FIELD_NAME = "__function__";
    public static final Map<String, Integer> classNameToSharedInstanceCount = new HashMap<String, Integer>();
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonBytecodeToJavaBytecodeTranslator.class);
    public static Path classOutputRootPath = InterpreterStartupOptions.classOutputRootPath;

    public static void writeClassOutput(Map<String, byte[]> classNameToBytecode, String className, byte[] classByteCode) {
        classNameToBytecode.put(className, classByteCode);
        if (classOutputRootPath == null) {
            return;
        }
        String[] parts = (className.replace('.', '/') + ".class").split("/");
        Path classFileLocation = classOutputRootPath.resolve(Path.of(".", parts));
        try {
            Files.createDirectories(classFileLocation.getParent(), new FileAttribute[0]);
            Files.write(classFileLocation, classByteCode, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getFunctionalInterfaceMethod(Class<?> interfaceClass) {
        ArrayList<Method> candidateList = new ArrayList<Method>();
        for (Method method : interfaceClass.getMethods()) {
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            candidateList.add(method);
        }
        if (candidateList.isEmpty()) {
            throw new IllegalArgumentException("Class (" + interfaceClass.getName() + ") is not a functional interface: it has no abstract methods.");
        }
        if (candidateList.size() > 1) {
            throw new IllegalArgumentException("Class (" + interfaceClass.getName() + ") is not a functional interface: it has multiple abstract methods (" + candidateList + ").");
        }
        return (Method)candidateList.get(0);
    }

    public static <T> T createInstance(Class<T> functionClass, PythonInterpreter pythonInterpreter) {
        return FunctionImplementor.createInstance(new PythonLikeTuple(), new PythonLikeDict(), new PythonLikeTuple(), new PythonLikeTuple(), PythonString.valueOf(functionClass.getName()), functionClass, pythonInterpreter);
    }

    public static <T> T translatePythonBytecode(PythonCompiledFunction pythonCompiledFunction, Class<T> javaFunctionalInterfaceType) {
        Class<T> compiledClass = PythonBytecodeToJavaBytecodeTranslator.translatePythonBytecodeToClass(pythonCompiledFunction, javaFunctionalInterfaceType);
        PythonLikeTuple annotationTuple = pythonCompiledFunction.typeAnnotations.entrySet().stream().map(entry -> PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{PythonString.valueOf((String)entry.getKey()), entry.getValue() != null ? ((TypeHint)entry.getValue()).type() : BuiltinTypes.BASE_TYPE})).collect(Collectors.toCollection(PythonLikeTuple::new));
        return FunctionImplementor.createInstance(pythonCompiledFunction.defaultPositionalArguments, pythonCompiledFunction.defaultKeywordArguments, annotationTuple, pythonCompiledFunction.closure, PythonString.valueOf(compiledClass.getName()), compiledClass, PythonInterpreter.DEFAULT);
    }

    public static <T> T translatePythonBytecode(PythonCompiledFunction pythonCompiledFunction, Class<T> javaFunctionalInterfaceType, List<Class<?>> genericTypeArgumentList) {
        Class<T> compiledClass = PythonBytecodeToJavaBytecodeTranslator.translatePythonBytecodeToClass(pythonCompiledFunction, javaFunctionalInterfaceType, genericTypeArgumentList);
        PythonLikeTuple annotationTuple = pythonCompiledFunction.typeAnnotations.entrySet().stream().map(entry -> PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{PythonString.valueOf((String)entry.getKey()), ((TypeHint)entry.getValue()).type()})).collect(Collectors.toCollection(PythonLikeTuple::new));
        return FunctionImplementor.createInstance(pythonCompiledFunction.defaultPositionalArguments, pythonCompiledFunction.defaultKeywordArguments, annotationTuple, pythonCompiledFunction.closure, PythonString.valueOf(compiledClass.getName()), compiledClass, PythonInterpreter.DEFAULT);
    }

    public static <T> T forceTranslatePythonBytecodeToGenerator(PythonCompiledFunction pythonCompiledFunction, Class<T> javaFunctionalInterfaceType) {
        Method methodWithoutGenerics = PythonBytecodeToJavaBytecodeTranslator.getFunctionalInterfaceMethod(javaFunctionalInterfaceType);
        MethodDescriptor methodDescriptor = new MethodDescriptor(javaFunctionalInterfaceType, methodWithoutGenerics, Collections.emptyList());
        Class<T> compiledClass = PythonBytecodeToJavaBytecodeTranslator.forceTranslatePythonBytecodeToGeneratorClass(pythonCompiledFunction, methodDescriptor, methodWithoutGenerics, false);
        return FunctionImplementor.createInstance(new PythonLikeTuple(), new PythonLikeDict(), new PythonLikeTuple(), pythonCompiledFunction.closure, PythonString.valueOf(compiledClass.getName()), compiledClass, PythonInterpreter.DEFAULT);
    }

    public static <T> Class<T> translatePythonBytecodeToClass(PythonCompiledFunction pythonCompiledFunction, Class<T> javaFunctionalInterfaceType) {
        MethodDescriptor methodDescriptor = new MethodDescriptor(PythonBytecodeToJavaBytecodeTranslator.getFunctionalInterfaceMethod(javaFunctionalInterfaceType));
        return PythonBytecodeToJavaBytecodeTranslator.translatePythonBytecodeToClass(pythonCompiledFunction, methodDescriptor);
    }

    public static <T> Class<T> translatePythonBytecodeToClass(PythonCompiledFunction pythonCompiledFunction, Class<T> javaFunctionalInterfaceType, List<Class<?>> genericTypeArgumentList) {
        Method methodWithoutGenerics = PythonBytecodeToJavaBytecodeTranslator.getFunctionalInterfaceMethod(javaFunctionalInterfaceType);
        MethodDescriptor methodDescriptor = new MethodDescriptor(javaFunctionalInterfaceType, methodWithoutGenerics, genericTypeArgumentList);
        return PythonBytecodeToJavaBytecodeTranslator.translatePythonBytecodeToClass(pythonCompiledFunction, methodDescriptor, methodWithoutGenerics, false);
    }

    public static <T> Class<T> translatePythonBytecodeToClass(PythonCompiledFunction pythonCompiledFunction, MethodDescriptor methodDescriptor) {
        return PythonBytecodeToJavaBytecodeTranslator.translatePythonBytecodeToClass(pythonCompiledFunction, methodDescriptor, false);
    }

    public static <T> T translatePythonBytecodeToInstance(PythonCompiledFunction pythonCompiledFunction, MethodDescriptor methodDescriptor) {
        return PythonBytecodeToJavaBytecodeTranslator.translatePythonBytecodeToInstance(pythonCompiledFunction, methodDescriptor, false);
    }

    public static <T> T translatePythonBytecodeToInstance(PythonCompiledFunction pythonCompiledFunction, MethodDescriptor methodDescriptor, boolean isVirtual) {
        Class<T> compiledClass = PythonBytecodeToJavaBytecodeTranslator.translatePythonBytecodeToClass(pythonCompiledFunction, methodDescriptor, isVirtual);
        PythonLikeTuple annotationTuple = pythonCompiledFunction.typeAnnotations.entrySet().stream().map(entry -> PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{PythonString.valueOf((String)entry.getKey()), ((TypeHint)entry.getValue()).type()})).collect(Collectors.toCollection(PythonLikeTuple::new));
        return FunctionImplementor.createInstance(pythonCompiledFunction.defaultPositionalArguments, pythonCompiledFunction.defaultKeywordArguments, annotationTuple, pythonCompiledFunction.closure, PythonString.valueOf(compiledClass.getName()), compiledClass, PythonInterpreter.DEFAULT);
    }

    public static <T> Class<T> translatePythonBytecodeToClass(PythonCompiledFunction pythonCompiledFunction, MethodDescriptor methodDescriptor, boolean isVirtual) {
        String maybeClassName = USER_PACKAGE_BASE + pythonCompiledFunction.getGeneratedClassBaseName();
        int numberOfInstances = classNameToSharedInstanceCount.merge(maybeClassName, 1, Integer::sum);
        if (numberOfInstances > 1) {
            maybeClassName = maybeClassName + "$$" + numberOfInstances;
        }
        String className = maybeClassName;
        String internalClassName = className.replace('.', '/');
        JavaPythonClassWriter classWriter = new JavaPythonClassWriter(3);
        classWriter.visit(55, 1, internalClassName, null, Type.getInternalName(Object.class), new String[]{methodDescriptor.getDeclaringClassInternalName()});
        boolean isPythonLikeFunction = methodDescriptor.getDeclaringClassInternalName().equals(Type.getInternalName(PythonLikeFunction.class));
        classWriter.visitSource(pythonCompiledFunction.moduleFilePath, null);
        PythonBytecodeToJavaBytecodeTranslator.createFields(classWriter);
        PythonBytecodeToJavaBytecodeTranslator.createConstructor(classWriter, internalClassName);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, methodDescriptor.getMethodName(), methodDescriptor.getMethodDescriptor(), null, null);
        PythonBytecodeToJavaBytecodeTranslator.translatePythonBytecodeToMethod(methodDescriptor, internalClassName, methodVisitor, pythonCompiledFunction, isPythonLikeFunction, isVirtual);
        classWriter.visitEnd();
        PythonBytecodeToJavaBytecodeTranslator.writeClassOutput(BuiltinTypes.classNameToBytecode, className, classWriter.toByteArray());
        try {
            Class<?> compiledClass = BuiltinTypes.asmClassLoader.loadClass(className);
            PythonBytecodeToJavaBytecodeTranslator.setStaticFields(compiledClass, pythonCompiledFunction);
            return compiledClass;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Impossible State: Unable to load generated class (" + className + ") despite it being just generated.", e);
        }
    }

    public static <T> Class<T> translatePythonBytecodeToClass(PythonCompiledFunction pythonCompiledFunction, MethodDescriptor methodDescriptor, Method methodWithoutGenerics, boolean isVirtual) {
        String maybeClassName = USER_PACKAGE_BASE + pythonCompiledFunction.getGeneratedClassBaseName();
        int numberOfInstances = classNameToSharedInstanceCount.merge(maybeClassName, 1, Integer::sum);
        if (numberOfInstances > 1) {
            maybeClassName = maybeClassName + "$$" + numberOfInstances;
        }
        String className = maybeClassName;
        String internalClassName = className.replace('.', '/');
        JavaPythonClassWriter classWriter = new JavaPythonClassWriter(3);
        classWriter.visit(55, 1, internalClassName, null, Type.getInternalName(Object.class), new String[]{methodDescriptor.getDeclaringClassInternalName()});
        boolean isPythonLikeFunction = methodDescriptor.getDeclaringClassInternalName().equals(Type.getInternalName(PythonLikeFunction.class));
        classWriter.visitSource(pythonCompiledFunction.moduleFilePath, null);
        PythonBytecodeToJavaBytecodeTranslator.createFields(classWriter);
        PythonBytecodeToJavaBytecodeTranslator.createConstructor(classWriter, internalClassName);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, methodDescriptor.getMethodName(), methodDescriptor.getMethodDescriptor(), null, null);
        PythonBytecodeToJavaBytecodeTranslator.translatePythonBytecodeToMethod(methodDescriptor, internalClassName, methodVisitor, pythonCompiledFunction, isPythonLikeFunction, isVirtual);
        String withoutGenericsSignature = Type.getMethodDescriptor((Method)methodWithoutGenerics);
        if (!withoutGenericsSignature.equals(methodDescriptor.getMethodDescriptor())) {
            methodVisitor = classWriter.visitMethod(1, methodDescriptor.getMethodName(), withoutGenericsSignature, null, null);
            methodVisitor.visitCode();
            PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
            methodVisitor.visitVarInsn(25, 0);
            for (int i = 0; i < methodWithoutGenerics.getParameterCount(); ++i) {
                Type parameterType = Type.getType(methodWithoutGenerics.getParameterTypes()[i]);
                methodVisitor.visitVarInsn(parameterType.getOpcode(21), i + 1);
                methodVisitor.visitTypeInsn(192, methodDescriptor.getParameterTypes()[i].getInternalName());
            }
            methodVisitor.visitMethodInsn(182, internalClassName, methodDescriptor.getMethodName(), methodDescriptor.getMethodDescriptor(), false);
            methodVisitor.visitInsn(methodDescriptor.getReturnType().getOpcode(172));
            methodVisitor.visitMaxs(-1, -1);
            methodVisitor.visitEnd();
        }
        classWriter.visitEnd();
        PythonBytecodeToJavaBytecodeTranslator.writeClassOutput(BuiltinTypes.classNameToBytecode, className, classWriter.toByteArray());
        try {
            Class<?> compiledClass = BuiltinTypes.asmClassLoader.loadClass(className);
            PythonBytecodeToJavaBytecodeTranslator.setStaticFields(compiledClass, pythonCompiledFunction);
            return compiledClass;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Impossible State: Unable to load generated class (" + className + ") despite it being just generated.", e);
        }
    }

    public static <T> Class<T> translatePythonBytecodeToPythonWrapperClass(PythonCompiledFunction pythonCompiledFunction, OpaquePythonReference codeReference) {
        String maybeClassName = USER_PACKAGE_BASE + pythonCompiledFunction.getGeneratedClassBaseName();
        int numberOfInstances = classNameToSharedInstanceCount.merge(maybeClassName, 1, Integer::sum);
        if (numberOfInstances > 1) {
            maybeClassName = maybeClassName + "$$" + numberOfInstances;
        }
        String className = maybeClassName;
        String internalClassName = className.replace('.', '/');
        JavaPythonClassWriter classWriter = new JavaPythonClassWriter(3);
        classWriter.visit(55, 1, internalClassName, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(PythonLikeFunction.class)});
        classWriter.visitSource(pythonCompiledFunction.moduleFilePath, null);
        PythonBytecodeToJavaBytecodeTranslator.createFields(classWriter);
        classWriter.visitField(9, PYTHON_WRAPPER_CODE_STATIC_FIELD_NAME, Type.getDescriptor(OpaquePythonReference.class), null, null);
        classWriter.visitField(17, PYTHON_WRAPPER_FUNCTION_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonObjectWrapper.class), null, null);
        PythonBytecodeToJavaBytecodeTranslator.createPythonWrapperConstructor(classWriter, internalClassName);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), null, null);
        methodVisitor.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, internalClassName, PYTHON_WRAPPER_FUNCTION_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonObjectWrapper.class));
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(PythonObjectWrapper.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        PythonBytecodeToJavaBytecodeTranslator.writeClassOutput(BuiltinTypes.classNameToBytecode, className, classWriter.toByteArray());
        try {
            Class<?> compiledClass = BuiltinTypes.asmClassLoader.loadClass(className);
            PythonBytecodeToJavaBytecodeTranslator.setStaticFields(compiledClass, pythonCompiledFunction);
            compiledClass.getField(PYTHON_WRAPPER_CODE_STATIC_FIELD_NAME).set(null, codeReference);
            return compiledClass;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Impossible State: Unable to load generated class (" + className + ") despite it being just generated.", e);
        }
    }

    public static <T> Class<T> forceTranslatePythonBytecodeToGeneratorClass(PythonCompiledFunction pythonCompiledFunction, MethodDescriptor methodDescriptor, Method methodWithoutGenerics, boolean isVirtual) {
        int i;
        String maybeClassName = USER_PACKAGE_BASE + pythonCompiledFunction.getGeneratedClassBaseName();
        int numberOfInstances = classNameToSharedInstanceCount.merge(maybeClassName, 1, Integer::sum);
        if (numberOfInstances > 1) {
            maybeClassName = maybeClassName + "$$" + numberOfInstances;
        }
        String className = maybeClassName;
        String internalClassName = className.replace('.', '/');
        JavaPythonClassWriter classWriter = new JavaPythonClassWriter(3);
        classWriter.visit(55, 1, internalClassName, null, Type.getInternalName(Object.class), new String[]{methodDescriptor.getDeclaringClassInternalName()});
        classWriter.visitSource(pythonCompiledFunction.moduleFilePath, null);
        boolean isPythonLikeFunction = methodDescriptor.getDeclaringClassInternalName().equals(Type.getInternalName(PythonLikeFunction.class));
        PythonBytecodeToJavaBytecodeTranslator.createFields(classWriter);
        PythonBytecodeToJavaBytecodeTranslator.createConstructor(classWriter, internalClassName);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, methodDescriptor.getMethodName(), methodDescriptor.getMethodDescriptor(), null, null);
        LocalVariableHelper localVariableHelper = new LocalVariableHelper(methodDescriptor.getParameterTypes(), pythonCompiledFunction);
        if (!isPythonLikeFunction) {
            for (i = 0; i < localVariableHelper.parameters.length; ++i) {
                JavaPythonTypeConversionImplementor.copyParameter(methodVisitor, localVariableHelper, i);
            }
        } else {
            PythonBytecodeToJavaBytecodeTranslator.movePythonParametersToSlots(methodVisitor, internalClassName, pythonCompiledFunction, localVariableHelper);
        }
        for (i = 0; i < localVariableHelper.getNumberOfBoundCells(); ++i) {
            VariableImplementor.createCell(methodVisitor, localVariableHelper, i);
        }
        for (i = 0; i < localVariableHelper.getNumberOfFreeCells(); ++i) {
            VariableImplementor.setupFreeVariableCell(methodVisitor, internalClassName, localVariableHelper, i);
        }
        PythonBytecodeToJavaBytecodeTranslator.translateGeneratorBytecode(methodVisitor, methodDescriptor, internalClassName, localVariableHelper, pythonCompiledFunction);
        String withoutGenericsSignature = Type.getMethodDescriptor((Method)methodWithoutGenerics);
        if (!withoutGenericsSignature.equals(methodDescriptor.getMethodDescriptor())) {
            methodVisitor = classWriter.visitMethod(1, methodDescriptor.getMethodName(), withoutGenericsSignature, null, null);
            methodVisitor.visitCode();
            PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
            methodVisitor.visitVarInsn(25, 0);
            for (int i2 = 0; i2 < methodWithoutGenerics.getParameterCount(); ++i2) {
                Type parameterType = Type.getType(methodWithoutGenerics.getParameterTypes()[i2]);
                methodVisitor.visitVarInsn(parameterType.getOpcode(21), i2 + 1);
                methodVisitor.visitTypeInsn(192, methodDescriptor.getParameterTypes()[i2].getInternalName());
            }
            methodVisitor.visitMethodInsn(182, internalClassName, methodDescriptor.getMethodName(), methodDescriptor.getMethodDescriptor(), false);
            methodVisitor.visitInsn(methodDescriptor.getReturnType().getOpcode(172));
            methodVisitor.visitMaxs(-1, -1);
            methodVisitor.visitEnd();
        }
        classWriter.visitEnd();
        PythonBytecodeToJavaBytecodeTranslator.writeClassOutput(BuiltinTypes.classNameToBytecode, className, classWriter.toByteArray());
        try {
            Class<?> compiledClass = BuiltinTypes.asmClassLoader.loadClass(className);
            PythonBytecodeToJavaBytecodeTranslator.setStaticFields(compiledClass, pythonCompiledFunction);
            return compiledClass;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Impossible State: Unable to load generated class (" + className + ") despite it being just generated.", e);
        }
    }

    private static void createConstructor(ClassWriter classWriter, String className) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        methodVisitor.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        methodVisitor.visitInsn(89);
        CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, 0);
        methodVisitor.visitFieldInsn(181, className, DEFAULT_POSITIONAL_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitInsn(89);
        CollectionImplementor.buildMap(PythonLikeDict.class, methodVisitor, 0);
        methodVisitor.visitFieldInsn(181, className, DEFAULT_KEYWORD_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeDict.class));
        methodVisitor.visitInsn(89);
        CollectionImplementor.buildMap(PythonLikeDict.class, methodVisitor, 0);
        methodVisitor.visitFieldInsn(181, className, ANNOTATION_DIRECTORY_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeDict.class));
        methodVisitor.visitInsn(89);
        CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, 0);
        methodVisitor.visitFieldInsn(181, className, CELLS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)className.replace('/', '.'));
        methodVisitor.visitMethodInsn(184, Type.getInternalName(PythonString.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(PythonString.class), (Type[])new Type[]{Type.getType(String.class)}), false);
        methodVisitor.visitFieldInsn(181, className, QUALIFIED_NAME_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonString.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(178, className, ARGUMENT_SPEC_GETTER_STATIC_FIELD_NAME, Type.getDescriptor(BiFunction.class));
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, className, DEFAULT_POSITIONAL_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, className, DEFAULT_KEYWORD_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeDict.class));
        methodVisitor.visitMethodInsn(185, Type.getInternalName(BiFunction.class), "apply", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), true);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(ArgumentSpec.class));
        methodVisitor.visitFieldInsn(181, className, ARGUMENT_SPEC_INSTANCE_FIELD_NAME, Type.getDescriptor(ArgumentSpec.class));
        methodVisitor.visitFieldInsn(178, Type.getInternalName(PythonInterpreter.class), "DEFAULT", Type.getDescriptor(PythonInterpreter.class));
        methodVisitor.visitFieldInsn(181, className, INTERPRETER_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonInterpreter.class));
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonLikeTuple.class), Type.getType(PythonLikeDict.class), Type.getType(PythonLikeDict.class), Type.getType(PythonLikeTuple.class), Type.getType(PythonString.class), Type.getType(PythonInterpreter.class)}), null, null);
        methodVisitor.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, className, DEFAULT_POSITIONAL_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitFieldInsn(181, className, DEFAULT_KEYWORD_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeDict.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitFieldInsn(181, className, ANNOTATION_DIRECTORY_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeDict.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitFieldInsn(181, className, CELLS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 5);
        methodVisitor.visitFieldInsn(181, className, QUALIFIED_NAME_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonString.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(178, className, ARGUMENT_SPEC_GETTER_STATIC_FIELD_NAME, Type.getDescriptor(BiFunction.class));
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, className, DEFAULT_POSITIONAL_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, className, DEFAULT_KEYWORD_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeDict.class));
        methodVisitor.visitMethodInsn(185, Type.getInternalName(BiFunction.class), "apply", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), true);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(ArgumentSpec.class));
        methodVisitor.visitFieldInsn(181, className, ARGUMENT_SPEC_INSTANCE_FIELD_NAME, Type.getDescriptor(ArgumentSpec.class));
        methodVisitor.visitVarInsn(25, 6);
        methodVisitor.visitFieldInsn(181, className, INTERPRETER_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonInterpreter.class));
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
    }

    private static void createPythonWrapperConstructor(ClassWriter classWriter, String className) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        methodVisitor.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        methodVisitor.visitInsn(89);
        CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, 0);
        methodVisitor.visitFieldInsn(181, className, DEFAULT_POSITIONAL_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitInsn(89);
        CollectionImplementor.buildMap(PythonLikeDict.class, methodVisitor, 0);
        methodVisitor.visitFieldInsn(181, className, DEFAULT_KEYWORD_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeDict.class));
        methodVisitor.visitInsn(89);
        CollectionImplementor.buildMap(PythonLikeDict.class, methodVisitor, 0);
        methodVisitor.visitFieldInsn(181, className, ANNOTATION_DIRECTORY_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeDict.class));
        methodVisitor.visitInsn(89);
        CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, 0);
        methodVisitor.visitFieldInsn(181, className, CELLS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)className.replace('/', '.'));
        methodVisitor.visitMethodInsn(184, Type.getInternalName(PythonString.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(PythonString.class), (Type[])new Type[]{Type.getType(String.class)}), false);
        methodVisitor.visitFieldInsn(181, className, QUALIFIED_NAME_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonString.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(178, className, ARGUMENT_SPEC_GETTER_STATIC_FIELD_NAME, Type.getDescriptor(BiFunction.class));
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, className, DEFAULT_POSITIONAL_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, className, DEFAULT_KEYWORD_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeDict.class));
        methodVisitor.visitMethodInsn(185, Type.getInternalName(BiFunction.class), "apply", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), true);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(ArgumentSpec.class));
        methodVisitor.visitFieldInsn(181, className, ARGUMENT_SPEC_INSTANCE_FIELD_NAME, Type.getDescriptor(ArgumentSpec.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(178, Type.getInternalName(PythonInterpreter.class), "DEFAULT", Type.getDescriptor(PythonInterpreter.class));
        methodVisitor.visitFieldInsn(181, className, INTERPRETER_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonInterpreter.class));
        methodVisitor.visitFieldInsn(178, className, PYTHON_WRAPPER_CODE_STATIC_FIELD_NAME, Type.getDescriptor(OpaquePythonReference.class));
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(90);
        methodVisitor.visitFieldInsn(178, className, GLOBALS_MAP_STATIC_FIELD_NAME, Type.getDescriptor(Map.class));
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(180, className, CELLS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitInsn(95);
        methodVisitor.visitFieldInsn(180, className, QUALIFIED_NAME_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonString.class));
        methodVisitor.visitMethodInsn(184, Type.getInternalName(CPythonBackedPythonInterpreter.class), "createPythonFunctionWrapper", Type.getMethodDescriptor((Type)Type.getType(PythonObjectWrapper.class), (Type[])new Type[]{Type.getType(OpaquePythonReference.class), Type.getType(Map.class), Type.getType(PythonLikeTuple.class), Type.getType(PythonString.class)}), false);
        methodVisitor.visitFieldInsn(181, className, PYTHON_WRAPPER_FUNCTION_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonObjectWrapper.class));
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonLikeTuple.class), Type.getType(PythonLikeDict.class), Type.getType(PythonLikeDict.class), Type.getType(PythonLikeTuple.class), Type.getType(PythonString.class), Type.getType(PythonInterpreter.class)}), null, null);
        methodVisitor.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, className, DEFAULT_POSITIONAL_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitFieldInsn(181, className, DEFAULT_KEYWORD_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeDict.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitFieldInsn(181, className, ANNOTATION_DIRECTORY_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeDict.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitFieldInsn(181, className, CELLS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 5);
        methodVisitor.visitFieldInsn(181, className, QUALIFIED_NAME_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonString.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(178, className, ARGUMENT_SPEC_GETTER_STATIC_FIELD_NAME, Type.getDescriptor(BiFunction.class));
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, className, DEFAULT_POSITIONAL_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, className, DEFAULT_KEYWORD_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeDict.class));
        methodVisitor.visitMethodInsn(185, Type.getInternalName(BiFunction.class), "apply", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), true);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(ArgumentSpec.class));
        methodVisitor.visitFieldInsn(181, className, ARGUMENT_SPEC_INSTANCE_FIELD_NAME, Type.getDescriptor(ArgumentSpec.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 6);
        methodVisitor.visitFieldInsn(181, className, INTERPRETER_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonInterpreter.class));
        methodVisitor.visitFieldInsn(178, className, PYTHON_WRAPPER_CODE_STATIC_FIELD_NAME, Type.getDescriptor(OpaquePythonReference.class));
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(90);
        methodVisitor.visitFieldInsn(178, className, GLOBALS_MAP_STATIC_FIELD_NAME, Type.getDescriptor(Map.class));
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(180, className, CELLS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitInsn(95);
        methodVisitor.visitFieldInsn(180, className, QUALIFIED_NAME_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonString.class));
        methodVisitor.visitMethodInsn(184, Type.getInternalName(CPythonBackedPythonInterpreter.class), "createPythonFunctionWrapper", Type.getMethodDescriptor((Type)Type.getType(PythonObjectWrapper.class), (Type[])new Type[]{Type.getType(OpaquePythonReference.class), Type.getType(Map.class), Type.getType(PythonLikeTuple.class), Type.getType(PythonString.class)}), false);
        methodVisitor.visitFieldInsn(181, className, PYTHON_WRAPPER_FUNCTION_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonObjectWrapper.class));
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(-1, -1);
        methodVisitor.visitEnd();
    }

    public static void createFields(ClassWriter classWriter) {
        classWriter.visitField(9, CONSTANTS_STATIC_FIELD_NAME, Type.getDescriptor(List.class), null, null);
        classWriter.visitField(9, NAMES_STATIC_FIELD_NAME, Type.getDescriptor(List.class), null, null);
        classWriter.visitField(9, VARIABLE_NAMES_STATIC_FIELD_NAME, Type.getDescriptor(List.class), null, null);
        classWriter.visitField(9, GLOBALS_MAP_STATIC_FIELD_NAME, Type.getDescriptor(Map.class), null, null);
        classWriter.visitField(9, CLASS_CELL_STATIC_FIELD_NAME, Type.getDescriptor(PythonLikeType.class), null, null);
        classWriter.visitField(9, ARGUMENT_SPEC_GETTER_STATIC_FIELD_NAME, Type.getDescriptor(BiFunction.class), null, null);
        classWriter.visitField(18, INTERPRETER_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonInterpreter.class), null, null);
        classWriter.visitField(18, DEFAULT_POSITIONAL_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class), null, null);
        classWriter.visitField(18, DEFAULT_KEYWORD_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeDict.class), null, null);
        classWriter.visitField(18, ANNOTATION_DIRECTORY_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeDict.class), null, null);
        classWriter.visitField(18, QUALIFIED_NAME_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonString.class), null, null);
        classWriter.visitField(18, CELLS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class), null, null);
        classWriter.visitField(17, ARGUMENT_SPEC_INSTANCE_FIELD_NAME, Type.getDescriptor(ArgumentSpec.class), null, null);
    }

    static void setStaticFields(Class<?> compiledClass, PythonCompiledFunction pythonCompiledFunction) {
        try {
            compiledClass.getField(CONSTANTS_STATIC_FIELD_NAME).set(null, pythonCompiledFunction.co_constants);
            compiledClass.getField(GLOBALS_MAP_STATIC_FIELD_NAME).set(null, pythonCompiledFunction.globalsMap);
            compiledClass.getField(ARGUMENT_SPEC_GETTER_STATIC_FIELD_NAME).set(null, pythonCompiledFunction.getArgumentSpecMapper());
            ArrayList<PythonString> pythonNameList = new ArrayList<PythonString>(pythonCompiledFunction.co_names.size());
            for (String name : pythonCompiledFunction.co_names) {
                pythonNameList.add(PythonString.valueOf(name));
            }
            compiledClass.getField(NAMES_STATIC_FIELD_NAME).set(null, pythonNameList);
            ArrayList<PythonString> pythonVariableNameList = new ArrayList<PythonString>(pythonCompiledFunction.co_varnames.size());
            for (String name : pythonCompiledFunction.co_varnames) {
                pythonVariableNameList.add(PythonString.valueOf(name));
            }
            compiledClass.getField(VARIABLE_NAMES_STATIC_FIELD_NAME).set(null, pythonVariableNameList);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Impossible state: generated class (" + compiledClass + ") does not have static field \"co_consts\"", e);
        }
    }

    public static List<Opcode> getOpcodeList(PythonCompiledFunction pythonCompiledFunction) {
        ArrayList<Opcode> opcodeList = new ArrayList<Opcode>(pythonCompiledFunction.instructionList.size());
        for (PythonBytecodeInstruction instruction : pythonCompiledFunction.instructionList) {
            opcodeList.add(Opcode.lookupOpcodeForInstruction(instruction, pythonCompiledFunction.pythonVersion));
        }
        return opcodeList;
    }

    public static StackMetadata getInitialStackMetadata(LocalVariableHelper localVariableHelper, MethodDescriptor method, boolean isVirtual) {
        StackMetadata initialStackMetadata = new StackMetadata(localVariableHelper);
        if (Type.getInternalName(PythonLikeFunction.class).equals(method.getDeclaringClassInternalName())) {
            return PythonBytecodeToJavaBytecodeTranslator.getPythonLikeFunctionInitialStackMetadata(localVariableHelper, initialStackMetadata);
        }
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Type type = method.getParameterTypes()[i];
            try {
                Class<?> typeClass = Class.forName(type.getClassName(), false, BuiltinTypes.asmClassLoader);
                initialStackMetadata = initialStackMetadata.setLocalVariableValueSource(i, ValueSourceInfo.of((Opcode)new OpcodeWithoutSource(), JavaPythonTypeConversionImplementor.getPythonLikeType(typeClass), new ValueSourceInfo[0]));
                continue;
            }
            catch (ClassNotFoundException e) {
                initialStackMetadata = initialStackMetadata.setLocalVariableValueSource(i, ValueSourceInfo.of((Opcode)new OpcodeWithoutSource(), BuiltinTypes.BASE_TYPE, new ValueSourceInfo[0]));
            }
        }
        if (isVirtual && method.getParameterTypes().length > 0) {
            try {
                Class<?> typeClass = Class.forName(method.getParameterTypes()[0].getClassName(), false, BuiltinTypes.asmClassLoader);
                initialStackMetadata = initialStackMetadata.setLocalVariableValueSource(0, ValueSourceInfo.of((Opcode)new SelfOpcodeWithoutSource(), JavaPythonTypeConversionImplementor.getPythonLikeType(typeClass), new ValueSourceInfo[0]));
            }
            catch (ClassNotFoundException e) {
                initialStackMetadata = initialStackMetadata.setLocalVariableValueSource(0, ValueSourceInfo.of((Opcode)new SelfOpcodeWithoutSource(), BuiltinTypes.BASE_TYPE, new ValueSourceInfo[0]));
            }
        }
        return initialStackMetadata;
    }

    private static StackMetadata getPythonLikeFunctionInitialStackMetadata(LocalVariableHelper localVariableHelper, StackMetadata initialStackMetadata) {
        int i;
        for (i = 0; i < localVariableHelper.getNumberOfLocalVariables(); ++i) {
            initialStackMetadata = initialStackMetadata.setLocalVariableValueSource(i, ValueSourceInfo.of((Opcode)new OpcodeWithoutSource(), BuiltinTypes.BASE_TYPE, new ValueSourceInfo[0]));
        }
        for (i = 0; i < localVariableHelper.getNumberOfCells(); ++i) {
            initialStackMetadata = initialStackMetadata.setCellVariableValueSource(i, ValueSourceInfo.of((Opcode)new OpcodeWithoutSource(), BuiltinTypes.BASE_TYPE, new ValueSourceInfo[0]));
        }
        return initialStackMetadata;
    }

    public static PythonFunctionType getFunctionType(PythonCompiledFunction pythonCompiledFunction) {
        for (PythonBytecodeInstruction instruction : pythonCompiledFunction.instructionList) {
            OpcodeDescriptor opcode = AbstractOpcode.lookupInstruction(instruction.opname());
            if (!(opcode instanceof GeneratorOpDescriptor)) continue;
            GeneratorOpDescriptor generatorInstruction = (GeneratorOpDescriptor)opcode;
            switch (generatorInstruction) {
                case GEN_START: 
                case RETURN_GENERATOR: 
                case YIELD_VALUE: 
                case YIELD_FROM: {
                    return PythonFunctionType.GENERATOR;
                }
            }
        }
        return PythonFunctionType.FUNCTION;
    }

    private static void translatePythonBytecodeToMethod(MethodDescriptor method, String className, MethodVisitor methodVisitor, PythonCompiledFunction pythonCompiledFunction, boolean isPythonLikeFunction, boolean isVirtual) {
        int i;
        methodVisitor = MethodVisitorAdapters.adapt(methodVisitor, method);
        for (int i2 = 0; i2 < method.getParameterTypes().length; ++i2) {
            if (!isPythonLikeFunction) {
                methodVisitor.visitParameter(pythonCompiledFunction.co_varnames.get(i2), 0);
                continue;
            }
            methodVisitor.visitParameter(null, 0);
        }
        methodVisitor.visitCode();
        PythonBytecodeToJavaBytecodeTranslator.visitGeneratedLineNumber(methodVisitor);
        Label start = new Label();
        Label end = new Label();
        methodVisitor.visitLabel(start);
        HashMap<Integer, Label> bytecodeCounterToLabelMap = new HashMap<Integer, Label>();
        LocalVariableHelper localVariableHelper = new LocalVariableHelper(method.getParameterTypes(), pythonCompiledFunction);
        localVariableHelper.resetCallKeywords(methodVisitor);
        localVariableHelper.setupInitialStoredExceptionStacks(methodVisitor);
        if (!isPythonLikeFunction) {
            for (i = 0; i < localVariableHelper.parameters.length; ++i) {
                JavaPythonTypeConversionImplementor.copyParameter(methodVisitor, localVariableHelper, i);
            }
        } else {
            PythonBytecodeToJavaBytecodeTranslator.movePythonParametersToSlots(methodVisitor, className, pythonCompiledFunction, localVariableHelper);
        }
        for (i = 0; i < localVariableHelper.getNumberOfBoundCells(); ++i) {
            VariableImplementor.createCell(methodVisitor, localVariableHelper, i);
        }
        for (i = 0; i < localVariableHelper.getNumberOfFreeCells(); ++i) {
            VariableImplementor.setupFreeVariableCell(methodVisitor, className, localVariableHelper, i);
        }
        HashMap<Integer, List<Runnable>> bytecodeIndexToArgumentorsMap = new HashMap<Integer, List<Runnable>>();
        FunctionMetadata functionMetadata = new FunctionMetadata();
        functionMetadata.functionType = PythonBytecodeToJavaBytecodeTranslator.getFunctionType(pythonCompiledFunction);
        functionMetadata.method = method;
        functionMetadata.bytecodeCounterToCodeArgumenterList = bytecodeIndexToArgumentorsMap;
        functionMetadata.bytecodeCounterToLabelMap = bytecodeCounterToLabelMap;
        functionMetadata.methodVisitor = methodVisitor;
        functionMetadata.pythonCompiledFunction = pythonCompiledFunction;
        functionMetadata.className = className;
        if (functionMetadata.functionType == PythonFunctionType.GENERATOR) {
            PythonBytecodeToJavaBytecodeTranslator.translateGeneratorBytecode(methodVisitor, method, className, localVariableHelper, pythonCompiledFunction);
            return;
        }
        StackMetadata initialStackMetadata = PythonBytecodeToJavaBytecodeTranslator.getInitialStackMetadata(localVariableHelper, method, isVirtual);
        List<Opcode> opcodeList = PythonBytecodeToJavaBytecodeTranslator.getOpcodeList(pythonCompiledFunction);
        FlowGraph flowGraph = FlowGraph.createFlowGraph(functionMetadata, initialStackMetadata, opcodeList);
        List<StackMetadata> stackMetadataForOpcodeIndex = flowGraph.getStackMetadataForOperations();
        PythonBytecodeToJavaBytecodeTranslator.writeInstructionsForOpcodes(functionMetadata, stackMetadataForOpcodeIndex, opcodeList);
        methodVisitor.visitLabel(end);
        for (int i3 = method.getParameterTypes().length; i3 < localVariableHelper.getNumberOfLocalVariables(); ++i3) {
            methodVisitor.visitLocalVariable(pythonCompiledFunction.co_varnames.get(i3), Type.getDescriptor(PythonLikeObject.class), null, start, end, localVariableHelper.getPythonLocalVariableSlot(i3));
        }
        try {
            methodVisitor.visitMaxs(0, 0);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid Java bytecode generated (this is a bug):\n" + pythonCompiledFunction.instructionList.stream().map(PythonBytecodeInstruction::toString).collect(Collectors.joining("\n")), e);
        }
        methodVisitor.visitEnd();
    }

    public static void writeInstructionsForOpcodes(FunctionMetadata functionMetadata, List<StackMetadata> stackMetadataForOpcodeIndex, List<Opcode> opcodeList) {
        PythonBytecodeToJavaBytecodeTranslator.writeInstructionsForOpcodes(functionMetadata, stackMetadataForOpcodeIndex, opcodeList, ignored -> {});
    }

    /*
     * WARNING - void declaration
     */
    public static void writeInstructionsForOpcodes(FunctionMetadata functionMetadata, List<StackMetadata> stackMetadataForOpcodeIndex, List<Opcode> opcodeList, Consumer<PythonBytecodeInstruction> runAfterLabelAndBeforeArgumentors) {
        void var13_19;
        StackMetadata stackMetadata;
        PythonCompiledFunction pythonCompiledFunction = functionMetadata.pythonCompiledFunction;
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        Map<Integer, Label> bytecodeCounterToLabelMap = functionMetadata.bytecodeCounterToLabelMap;
        Map<Integer, List<Runnable>> bytecodeIndexToArgumentorsMap = functionMetadata.bytecodeCounterToCodeArgumenterList;
        HashMap exceptionTableTryBlockMap = new HashMap();
        HashMap exceptionTableStartLabelMap = new HashMap();
        HashMap exceptionTableTargetLabelMap = new HashMap();
        HashSet<Integer> tryBlockStartInstructionSet = new HashSet<Integer>();
        for (ExceptionBlock exceptionBlock2 : pythonCompiledFunction.co_exceptiontable.getEntries()) {
            if (exceptionBlock2.blockStartInstructionInclusive == exceptionBlock2.blockEndInstructionExclusive) continue;
            tryBlockStartInstructionSet.add(exceptionBlock2.blockStartInstructionInclusive);
            stackMetadata = stackMetadataForOpcodeIndex.get(exceptionBlock2.blockStartInstructionInclusive);
            exceptionTableTryBlockMap.computeIfAbsent(exceptionBlock2.blockStartInstructionInclusive, index -> new ArrayList()).add(() -> {
                Label startLabel = exceptionTableStartLabelMap.computeIfAbsent(exceptionBlock.blockStartInstructionInclusive, offset -> new Label());
                Label endLabel = bytecodeCounterToLabelMap.computeIfAbsent(exceptionBlock.blockEndInstructionExclusive, offset -> new Label());
                Label targetLabel = exceptionTableTargetLabelMap.computeIfAbsent(exceptionBlock.targetInstruction, offset -> new Label());
                if (exceptionBlock.blockStartInstructionInclusive > exceptionBlock.targetInstruction) {
                    return;
                }
                functionMetadata.methodVisitor.visitTryCatchBlock(startLabel, endLabel, targetLabel, Type.getInternalName(PythonBaseException.class));
            });
            bytecodeIndexToArgumentorsMap.computeIfAbsent(exceptionBlock2.targetInstruction, index -> new ArrayList()).add(() -> ExceptionImplementor.startExceptBlock(functionMetadata, stackMetadata, exceptionBlock2));
        }
        for (Integer n : tryBlockStartInstructionSet) {
            stackMetadata = stackMetadataForOpcodeIndex.get(n);
            pythonCompiledFunction.co_exceptiontable.getEntries().stream().filter(block -> block.blockStartInstructionInclusive == tryBlockStart).forEach(exceptionBlock -> bytecodeIndexToArgumentorsMap.computeIfAbsent((Integer)((Object)tryBlockStart), index -> new ArrayList()).add(() -> StackManipulationImplementor.storeExceptionTableStack(functionMetadata, stackMetadata, exceptionBlock)));
        }
        TreeSet<Integer> requiredNullVariableSet = new TreeSet<Integer>();
        for (Opcode opcode : opcodeList) {
            if (!(opcode instanceof LoadFastAndClearOpcode)) continue;
            LoadFastAndClearOpcode loadAndClearOpcode = (LoadFastAndClearOpcode)opcode;
            requiredNullVariableSet.add(loadAndClearOpcode.getInstruction().arg());
        }
        for (Integer requiredNullVariable : requiredNullVariableSet) {
            methodVisitor.visitInsn(1);
            methodVisitor.visitVarInsn(58, stackMetadataForOpcodeIndex.get((int)0).localVariableHelper.getPythonLocalVariableSlot(requiredNullVariable));
        }
        boolean bl = false;
        while (var13_19 < opcodeList.size()) {
            Label label;
            stackMetadata = stackMetadataForOpcodeIndex.get((int)var13_19);
            PythonBytecodeInstruction instruction = pythonCompiledFunction.instructionList.get((int)var13_19);
            if (exceptionTableTargetLabelMap.containsKey(instruction.offset())) {
                label = (Label)exceptionTableTargetLabelMap.get(instruction.offset());
                methodVisitor.visitLabel(label);
            }
            exceptionTableTryBlockMap.getOrDefault(instruction.offset(), Collections.emptyList()).forEach(Runnable::run);
            if (instruction.isJumpTarget() || bytecodeCounterToLabelMap.containsKey(instruction.offset())) {
                label = bytecodeCounterToLabelMap.computeIfAbsent(instruction.offset(), offset -> new Label());
                methodVisitor.visitLabel(label);
            }
            if (instruction.startsLine().isPresent()) {
                label = new Label();
                methodVisitor.visitLabel(label);
                methodVisitor.visitLineNumber(instruction.startsLine().getAsInt(), label);
            }
            runAfterLabelAndBeforeArgumentors.accept(instruction);
            bytecodeIndexToArgumentorsMap.getOrDefault(instruction.offset(), Collections.emptyList()).forEach(Runnable::run);
            if (exceptionTableStartLabelMap.containsKey(instruction.offset())) {
                label = (Label)exceptionTableStartLabelMap.get(instruction.offset());
                methodVisitor.visitLabel(label);
            }
            if (!stackMetadata.isDeadCode()) {
                opcodeList.get((int)var13_19).implement(functionMetadata, stackMetadata);
            }
            ++var13_19;
        }
    }

    private static void translateGeneratorBytecode(MethodVisitor methodVisitor, MethodDescriptor method, String internalClassName, LocalVariableHelper localVariableHelper, PythonCompiledFunction pythonCompiledFunction) {
        Class<?> generatorClass = PythonGeneratorTranslator.translateGeneratorFunction(pythonCompiledFunction);
        methodVisitor.visitTypeInsn(187, Type.getInternalName(generatorClass));
        methodVisitor.visitInsn(89);
        Type[] javaParameterTypes = (Type[])Stream.concat(Stream.of(Type.getType(PythonLikeTuple.class), Type.getType(PythonLikeDict.class), Type.getType(PythonLikeDict.class), Type.getType(PythonLikeTuple.class), Type.getType(PythonString.class), Type.getType(PythonInterpreter.class)), pythonCompiledFunction.getParameterTypes().stream().map(type -> Type.getType((String)type.getJavaTypeDescriptor()))).toArray(Type[]::new);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(180, internalClassName, DEFAULT_POSITIONAL_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(180, internalClassName, DEFAULT_KEYWORD_ARGS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeDict.class));
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(180, internalClassName, ANNOTATION_DIRECTORY_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeDict.class));
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(180, internalClassName, CELLS_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonLikeTuple.class));
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(180, internalClassName, QUALIFIED_NAME_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonString.class));
        methodVisitor.visitInsn(95);
        methodVisitor.visitFieldInsn(180, internalClassName, INTERPRETER_INSTANCE_FIELD_NAME, Type.getDescriptor(PythonInterpreter.class));
        for (int i = 0; i < pythonCompiledFunction.totalArgCount(); ++i) {
            localVariableHelper.readLocal(methodVisitor, i);
            methodVisitor.visitTypeInsn(192, javaParameterTypes[i + 6].getInternalName());
        }
        methodVisitor.visitMethodInsn(183, Type.getInternalName(generatorClass), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])javaParameterTypes), false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static void movePythonParametersToSlots(MethodVisitor methodVisitor, String internalClassName, PythonCompiledFunction pythonCompiledFunction, LocalVariableHelper localVariableHelper) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, internalClassName, ARGUMENT_SPEC_INSTANCE_FIELD_NAME, Type.getDescriptor(ArgumentSpec.class));
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(ArgumentSpec.class), "extractArgumentList", Type.getMethodDescriptor((Type)Type.getType(List.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class)}), false);
        for (int i = 0; i < pythonCompiledFunction.totalArgCount(); ++i) {
            methodVisitor.visitInsn(89);
            methodVisitor.visitLdcInsn((Object)i);
            methodVisitor.visitMethodInsn(185, Type.getInternalName(List.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.INT_TYPE}), true);
            methodVisitor.visitVarInsn(58, localVariableHelper.getPythonLocalVariableSlot(i));
        }
        methodVisitor.visitInsn(87);
    }

    private static void trace(MethodVisitor methodVisitor, PythonBytecodeInstruction instruction) {
        methodVisitor.visitFieldInsn(178, Type.getInternalName(System.class), "out", Type.getDescriptor(PrintStream.class));
        methodVisitor.visitLdcInsn((Object)instruction.toString());
        methodVisitor.visitMethodInsn(182, Type.getInternalName(PrintStream.class), "println", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), false);
    }

    public static void print(MethodVisitor methodVisitor) {
        methodVisitor.visitInsn(89);
        methodVisitor.visitFieldInsn(178, Type.getInternalName(System.class), "out", Type.getDescriptor(PrintStream.class));
        methodVisitor.visitInsn(95);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(PrintStream.class), "println", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), false);
    }

    public static void printStack(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        int i;
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        LocalVariableHelper localVariableHelper = stackMetadata.localVariableHelper;
        int[] stackLocals = new int[stackMetadata.getStackSize()];
        for (i = stackLocals.length - 1; i >= 0; --i) {
            stackLocals[i] = localVariableHelper.newLocal();
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), stackLocals[i]);
        }
        methodVisitor.visitLdcInsn((Object)stackLocals.length);
        methodVisitor.visitTypeInsn(189, Type.getInternalName(PythonLikeObject.class));
        for (i = 0; i < stackLocals.length; ++i) {
            methodVisitor.visitInsn(89);
            methodVisitor.visitLdcInsn((Object)i);
            localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), stackLocals[i]);
            methodVisitor.visitInsn(83);
        }
        methodVisitor.visitMethodInsn(184, Type.getInternalName(Arrays.class), "toString", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[]{Type.getType(Object[].class)}), false);
        PythonBytecodeToJavaBytecodeTranslator.print(methodVisitor);
        methodVisitor.visitInsn(87);
        for (i = 0; i < stackLocals.length; ++i) {
            localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), stackLocals[i]);
        }
        for (i = 0; i < stackLocals.length; ++i) {
            localVariableHelper.freeLocal();
        }
    }

    public static String getPythonBytecodeListing(PythonCompiledFunction pythonCompiledFunction) {
        StringBuilder out = new StringBuilder();
        out.append("qualified_name = ").append(pythonCompiledFunction.qualifiedName).append("\n");
        out.append("co_varnames = ").append(pythonCompiledFunction.co_varnames).append("\n");
        out.append("co_cellvars = ").append(pythonCompiledFunction.co_cellvars).append("\n");
        out.append("co_freevars = ").append(pythonCompiledFunction.co_freevars).append("\n");
        out.append(pythonCompiledFunction.instructionList.stream().map(PythonBytecodeInstruction::toString).collect(Collectors.joining("\n")));
        out.append("\nco_exceptiontable = ").append(pythonCompiledFunction.co_exceptiontable).append("\n");
        return out.toString();
    }

    public static void visitGeneratedLineNumber(MethodVisitor methodVisitor) {
        Label label = new Label();
        methodVisitor.visitLabel(label);
        methodVisitor.visitLineNumber(0, label);
    }

    static {
        BuiltinTypes.load();
    }
}

