/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.builtins;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonInterpreter;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.builtins.BinaryDunderBuiltin;
import ai.timefold.jpyinterpreter.builtins.TernaryDunderBuiltin;
import ai.timefold.jpyinterpreter.builtins.UnaryDunderBuiltin;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.CPythonBackedPythonLikeObject;
import ai.timefold.jpyinterpreter.types.Ellipsis;
import ai.timefold.jpyinterpreter.types.NotImplemented;
import ai.timefold.jpyinterpreter.types.PythonLikeFunction;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonNone;
import ai.timefold.jpyinterpreter.types.PythonSlice;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.PythonSuperObject;
import ai.timefold.jpyinterpreter.types.collections.DelegatePythonIterator;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeDict;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeList;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.errors.AttributeError;
import ai.timefold.jpyinterpreter.types.errors.BufferError;
import ai.timefold.jpyinterpreter.types.errors.GeneratorExit;
import ai.timefold.jpyinterpreter.types.errors.ImportError;
import ai.timefold.jpyinterpreter.types.errors.ModuleNotFoundError;
import ai.timefold.jpyinterpreter.types.errors.NameError;
import ai.timefold.jpyinterpreter.types.errors.NotImplementedError;
import ai.timefold.jpyinterpreter.types.errors.PythonAssertionError;
import ai.timefold.jpyinterpreter.types.errors.PythonBaseException;
import ai.timefold.jpyinterpreter.types.errors.PythonException;
import ai.timefold.jpyinterpreter.types.errors.RecursionError;
import ai.timefold.jpyinterpreter.types.errors.ReferenceError;
import ai.timefold.jpyinterpreter.types.errors.RuntimeError;
import ai.timefold.jpyinterpreter.types.errors.StopAsyncIteration;
import ai.timefold.jpyinterpreter.types.errors.StopIteration;
import ai.timefold.jpyinterpreter.types.errors.TypeError;
import ai.timefold.jpyinterpreter.types.errors.UnboundLocalError;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import ai.timefold.jpyinterpreter.types.errors.arithmetic.ArithmeticError;
import ai.timefold.jpyinterpreter.types.errors.arithmetic.FloatingPointError;
import ai.timefold.jpyinterpreter.types.errors.arithmetic.OverflowError;
import ai.timefold.jpyinterpreter.types.errors.arithmetic.ZeroDivisionError;
import ai.timefold.jpyinterpreter.types.errors.io.BlockingIOError;
import ai.timefold.jpyinterpreter.types.errors.io.ChildProcessError;
import ai.timefold.jpyinterpreter.types.errors.io.EOFError;
import ai.timefold.jpyinterpreter.types.errors.io.FileExistsError;
import ai.timefold.jpyinterpreter.types.errors.io.FileNotFoundError;
import ai.timefold.jpyinterpreter.types.errors.io.InterruptedError;
import ai.timefold.jpyinterpreter.types.errors.io.IsADirectoryError;
import ai.timefold.jpyinterpreter.types.errors.io.KeyboardInterrupt;
import ai.timefold.jpyinterpreter.types.errors.io.MemoryError;
import ai.timefold.jpyinterpreter.types.errors.io.NotADirectoryError;
import ai.timefold.jpyinterpreter.types.errors.io.OSError;
import ai.timefold.jpyinterpreter.types.errors.io.PermissionError;
import ai.timefold.jpyinterpreter.types.errors.io.ProcessLookupError;
import ai.timefold.jpyinterpreter.types.errors.io.SystemError;
import ai.timefold.jpyinterpreter.types.errors.io.SystemExit;
import ai.timefold.jpyinterpreter.types.errors.io.TimeoutError;
import ai.timefold.jpyinterpreter.types.errors.io.connection.BrokenPipeError;
import ai.timefold.jpyinterpreter.types.errors.io.connection.ConnectionAbortedError;
import ai.timefold.jpyinterpreter.types.errors.io.connection.ConnectionError;
import ai.timefold.jpyinterpreter.types.errors.io.connection.ConnectionRefusedError;
import ai.timefold.jpyinterpreter.types.errors.io.connection.ConnectionResetError;
import ai.timefold.jpyinterpreter.types.errors.lookup.IndexError;
import ai.timefold.jpyinterpreter.types.errors.lookup.KeyError;
import ai.timefold.jpyinterpreter.types.errors.lookup.LookupError;
import ai.timefold.jpyinterpreter.types.errors.syntax.IndentationError;
import ai.timefold.jpyinterpreter.types.errors.syntax.SyntaxError;
import ai.timefold.jpyinterpreter.types.errors.syntax.TabError;
import ai.timefold.jpyinterpreter.types.errors.unicode.UnicodeDecodeError;
import ai.timefold.jpyinterpreter.types.errors.unicode.UnicodeEncodeError;
import ai.timefold.jpyinterpreter.types.errors.unicode.UnicodeError;
import ai.timefold.jpyinterpreter.types.errors.unicode.UnicodeTranslateError;
import ai.timefold.jpyinterpreter.types.errors.warning.BytesWarning;
import ai.timefold.jpyinterpreter.types.errors.warning.DeprecationWarning;
import ai.timefold.jpyinterpreter.types.errors.warning.EncodingWarning;
import ai.timefold.jpyinterpreter.types.errors.warning.FutureWarning;
import ai.timefold.jpyinterpreter.types.errors.warning.ImportWarning;
import ai.timefold.jpyinterpreter.types.errors.warning.PendingDeprecationWarning;
import ai.timefold.jpyinterpreter.types.errors.warning.ResourceWarning;
import ai.timefold.jpyinterpreter.types.errors.warning.RuntimeWarning;
import ai.timefold.jpyinterpreter.types.errors.warning.SyntaxWarning;
import ai.timefold.jpyinterpreter.types.errors.warning.UnicodeWarning;
import ai.timefold.jpyinterpreter.types.errors.warning.UserWarning;
import ai.timefold.jpyinterpreter.types.errors.warning.Warning;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public class GlobalBuiltins {
    private static final StackWalker stackWalker = GlobalBuiltins.getStackWalkerInstance();
    private static final Map<String, PythonLikeObject> builtinConstantMap = new HashMap<String, PythonLikeObject>();

    private static StackWalker getStackWalkerInstance() {
        return StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    }

    public static void addBuiltinType(PythonLikeType type) {
        GlobalBuiltins.addBuiltinConstant(type.getTypeName(), type);
    }

    public static void addBuiltinConstant(String builtinName, PythonLikeObject value) {
        builtinConstantMap.put(builtinName, value);
    }

    public static List<PythonLikeType> getBuiltinTypes() {
        ArrayList<PythonLikeType> out = new ArrayList<PythonLikeType>();
        for (PythonLikeObject constant : builtinConstantMap.values()) {
            if (!(constant instanceof PythonLikeType)) continue;
            out.add((PythonLikeType)constant);
        }
        return out;
    }

    public static void loadBuiltinConstants() {
        GlobalBuiltins.addBuiltinConstant("None", PythonNone.INSTANCE);
        GlobalBuiltins.addBuiltinConstant("Ellipsis", Ellipsis.INSTANCE);
        GlobalBuiltins.addBuiltinConstant("NotImplemented", NotImplemented.INSTANCE);
        GlobalBuiltins.addBuiltinConstant("True", PythonBoolean.TRUE);
        GlobalBuiltins.addBuiltinConstant("False", PythonBoolean.FALSE);
        GlobalBuiltins.addBuiltinType(BuiltinTypes.BOOLEAN_TYPE);
        GlobalBuiltins.addBuiltinType(BuiltinTypes.INT_TYPE);
        GlobalBuiltins.addBuiltinType(BuiltinTypes.FLOAT_TYPE);
        GlobalBuiltins.addBuiltinType(BuiltinTypes.COMPLEX_TYPE);
        GlobalBuiltins.addBuiltinType(BuiltinTypes.TUPLE_TYPE);
        GlobalBuiltins.addBuiltinType(BuiltinTypes.LIST_TYPE);
        GlobalBuiltins.addBuiltinType(BuiltinTypes.SET_TYPE);
        GlobalBuiltins.addBuiltinType(BuiltinTypes.FROZEN_SET_TYPE);
        GlobalBuiltins.addBuiltinType(BuiltinTypes.DICT_TYPE);
        GlobalBuiltins.addBuiltinType(BuiltinTypes.STRING_TYPE);
        GlobalBuiltins.addBuiltinType(BuiltinTypes.BYTES_TYPE);
        GlobalBuiltins.addBuiltinType(BuiltinTypes.BYTE_ARRAY_TYPE);
        GlobalBuiltins.addBuiltinType(BuiltinTypes.NONE_TYPE);
        GlobalBuiltins.addBuiltinType(BuiltinTypes.RANGE_TYPE);
        GlobalBuiltins.addBuiltinType(BuiltinTypes.SLICE_TYPE);
        GlobalBuiltins.addBuiltinType(ArithmeticError.ARITHMETIC_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(FloatingPointError.FLOATING_POINT_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(OverflowError.OVERFLOW_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(ZeroDivisionError.ZERO_DIVISION_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(BrokenPipeError.BROKEN_PIPE_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(ConnectionAbortedError.CONNECTION_ABORTED_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(ConnectionError.CONNECTION_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(ConnectionRefusedError.CONNECTION_REFUSED_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(ConnectionResetError.CONNECTION_RESET_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(BlockingIOError.BLOCKING_IO_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(ChildProcessError.CHILD_PROCESS_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(EOFError.EOF_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(FileExistsError.FILE_EXISTS_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(FileNotFoundError.FILE_NOT_FOUND_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(InterruptedError.INTERRUPTED_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(IsADirectoryError.IS_A_DIRECTORY_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(KeyboardInterrupt.KEYBOARD_INTERRUPT_TYPE);
        GlobalBuiltins.addBuiltinType(MemoryError.MEMORY_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(NotADirectoryError.NOT_A_DIRECTORY_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(OSError.OS_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(PermissionError.PERMISSION_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(ProcessLookupError.PROCESS_LOOKUP_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(SystemError.SYSTEM_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(SystemExit.SYSTEM_EXIT_TYPE);
        GlobalBuiltins.addBuiltinType(TimeoutError.TIMEOUT_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(IndexError.INDEX_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(KeyError.KEY_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(LookupError.LOOKUP_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(IndentationError.INDENTATION_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(SyntaxError.SYNTAX_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(TabError.TAB_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(UnicodeDecodeError.UNICODE_DECODE_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(UnicodeEncodeError.UNICODE_ENCODE_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(UnicodeError.UNICODE_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(UnicodeTranslateError.UNICODE_TRANSLATE_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(BytesWarning.BYTES_WARNING_TYPE);
        GlobalBuiltins.addBuiltinType(DeprecationWarning.DEPRECATION_WARNING_TYPE);
        GlobalBuiltins.addBuiltinType(EncodingWarning.ENCODING_WARNING_TYPE);
        GlobalBuiltins.addBuiltinType(FutureWarning.FUTURE_WARNING_TYPE);
        GlobalBuiltins.addBuiltinType(ImportWarning.IMPORT_WARNING_TYPE);
        GlobalBuiltins.addBuiltinType(PendingDeprecationWarning.PENDING_DEPRECATION_WARNING_TYPE);
        GlobalBuiltins.addBuiltinType(ResourceWarning.RESOURCE_WARNING_TYPE);
        GlobalBuiltins.addBuiltinType(RuntimeWarning.RUNTIME_WARNING_TYPE);
        GlobalBuiltins.addBuiltinType(SyntaxWarning.SYNTAX_WARNING_TYPE);
        GlobalBuiltins.addBuiltinType(UnicodeWarning.UNICODE_WARNING_TYPE);
        GlobalBuiltins.addBuiltinType(UserWarning.USER_WARNING_TYPE);
        GlobalBuiltins.addBuiltinType(Warning.WARNING_TYPE);
        GlobalBuiltins.addBuiltinType(AttributeError.ATTRIBUTE_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(BufferError.BUFFER_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(GeneratorExit.GENERATOR_EXIT_TYPE);
        GlobalBuiltins.addBuiltinType(ImportError.IMPORT_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(ModuleNotFoundError.MODULE_NOT_FOUND_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(NameError.NAME_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(NotImplementedError.NOT_IMPLEMENTED_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(PythonAssertionError.ASSERTION_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(PythonBaseException.BASE_EXCEPTION_TYPE);
        GlobalBuiltins.addBuiltinType(PythonException.EXCEPTION_TYPE);
        GlobalBuiltins.addBuiltinType(RecursionError.RECURSION_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(ReferenceError.REFERENCE_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(RuntimeError.RUNTIME_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(StopAsyncIteration.STOP_ASYNC_ITERATION_TYPE);
        GlobalBuiltins.addBuiltinType(StopIteration.STOP_ITERATION_TYPE);
        GlobalBuiltins.addBuiltinType(UnboundLocalError.UNBOUND_LOCAL_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(TypeError.TYPE_ERROR_TYPE);
        GlobalBuiltins.addBuiltinType(ValueError.VALUE_ERROR_TYPE);
        PythonOverloadImplementor.createDeferredDispatches();
    }

    public static PythonLikeObject lookup(PythonInterpreter interpreter, String builtinName) {
        switch (builtinName) {
            case "abs": {
                return UnaryDunderBuiltin.ABS;
            }
            case "all": {
                return GlobalBuiltins::all;
            }
            case "any": {
                return GlobalBuiltins::any;
            }
            case "ascii": {
                return GlobalBuiltins::ascii;
            }
            case "bin": {
                return GlobalBuiltins::bin;
            }
            case "bool": {
                return BuiltinTypes.BOOLEAN_TYPE;
            }
            case "bytes": {
                return BuiltinTypes.BYTES_TYPE;
            }
            case "bytearray": {
                return BuiltinTypes.BYTE_ARRAY_TYPE;
            }
            case "callable": {
                return GlobalBuiltins::callable;
            }
            case "chr": {
                return GlobalBuiltins::chr;
            }
            case "delattr": {
                return GlobalBuiltins::delattr;
            }
            case "divmod": {
                return GlobalBuiltins::divmod;
            }
            case "dict": {
                return BuiltinTypes.DICT_TYPE;
            }
            case "enumerate": {
                return GlobalBuiltins::enumerate;
            }
            case "filter": {
                return GlobalBuiltins::filter;
            }
            case "float": {
                return BuiltinTypes.FLOAT_TYPE;
            }
            case "format": {
                return GlobalBuiltins::format;
            }
            case "frozenset": {
                return BuiltinTypes.FROZEN_SET_TYPE;
            }
            case "getattr": {
                return GlobalBuiltins::getattr;
            }
            case "globals": {
                return GlobalBuiltins::globals;
            }
            case "hasattr": {
                return GlobalBuiltins::hasattr;
            }
            case "hash": {
                return UnaryDunderBuiltin.HASH;
            }
            case "hex": {
                return GlobalBuiltins::hex;
            }
            case "id": {
                return GlobalBuiltins::id;
            }
            case "input": {
                return GlobalBuiltins.input(interpreter);
            }
            case "int": {
                return BuiltinTypes.INT_TYPE;
            }
            case "isinstance": {
                return GlobalBuiltins::isinstance;
            }
            case "issubclass": {
                return GlobalBuiltins::issubclass;
            }
            case "iter": {
                return UnaryDunderBuiltin.ITERATOR;
            }
            case "len": {
                return UnaryDunderBuiltin.LENGTH;
            }
            case "list": {
                return BuiltinTypes.LIST_TYPE;
            }
            case "locals": {
                return GlobalBuiltins::locals;
            }
            case "map": {
                return GlobalBuiltins::map;
            }
            case "min": {
                return GlobalBuiltins::min;
            }
            case "max": {
                return GlobalBuiltins::max;
            }
            case "next": {
                return UnaryDunderBuiltin.NEXT;
            }
            case "object": {
                return BuiltinTypes.BASE_TYPE;
            }
            case "oct": {
                return GlobalBuiltins::oct;
            }
            case "ord": {
                return GlobalBuiltins::ord;
            }
            case "pow": {
                return GlobalBuiltins::pow;
            }
            case "print": {
                return GlobalBuiltins.print(interpreter);
            }
            case "range": {
                return BuiltinTypes.RANGE_TYPE;
            }
            case "repr": {
                return UnaryDunderBuiltin.REPRESENTATION;
            }
            case "reversed": {
                return GlobalBuiltins::reversed;
            }
            case "round": {
                return GlobalBuiltins::round;
            }
            case "set": {
                return BuiltinTypes.SET_TYPE;
            }
            case "setattr": {
                return GlobalBuiltins::setattr;
            }
            case "slice": {
                return PythonSlice.SLICE_TYPE;
            }
            case "sorted": {
                return GlobalBuiltins::sorted;
            }
            case "str": {
                return BuiltinTypes.STRING_TYPE;
            }
            case "sum": {
                return GlobalBuiltins::sum;
            }
            case "super": {
                return GlobalBuiltins::superOfCaller;
            }
            case "tuple": {
                return BuiltinTypes.TUPLE_TYPE;
            }
            case "type": {
                return BuiltinTypes.TYPE_TYPE;
            }
            case "vars": {
                return GlobalBuiltins::vars;
            }
            case "zip": {
                return GlobalBuiltins::zip;
            }
            case "__import__": {
                return GlobalBuiltins.importFunction(interpreter);
            }
        }
        return builtinConstantMap.get(builtinName);
    }

    public static PythonLikeObject lookupOrError(PythonInterpreter interpreter, String builtinName) {
        PythonLikeObject out = GlobalBuiltins.lookup(interpreter, builtinName);
        if (out == null) {
            throw new IllegalArgumentException(builtinName + " does not exist in global scope");
        }
        return out;
    }

    public static PythonBoolean all(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        Iterator iterator;
        if (positionalArgs.size() == 1 && keywordArgs.isEmpty()) {
            iterator = (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(positionalArgs.get(0)));
        } else if (positionalArgs.isEmpty() && keywordArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("iterable"))) {
            iterator = (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(keywordArgs.get(PythonString.valueOf("iterable"))));
        } else {
            throw new ValueError("all expects 1 argument, got " + positionalArgs.size());
        }
        while (iterator.hasNext()) {
            PythonLikeObject element = (PythonLikeObject)iterator.next();
            if (PythonBoolean.isTruthful(element)) continue;
            return PythonBoolean.FALSE;
        }
        return PythonBoolean.TRUE;
    }

    public static PythonBoolean any(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        Iterator iterator;
        if (positionalArgs.size() == 1 && keywordArgs.isEmpty()) {
            iterator = (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(positionalArgs.get(0)));
        } else if (positionalArgs.isEmpty() && keywordArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("iterable"))) {
            iterator = (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(keywordArgs.get(PythonString.valueOf("iterable"))));
        } else {
            throw new ValueError("any expects 1 argument, got " + positionalArgs.size());
        }
        while (iterator.hasNext()) {
            PythonLikeObject element = (PythonLikeObject)iterator.next();
            if (!PythonBoolean.isTruthful(element)) continue;
            return PythonBoolean.TRUE;
        }
        return PythonBoolean.FALSE;
    }

    public static PythonString ascii(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeObject object;
        if (positionalArgs.size() == 1 && keywordArgs.isEmpty()) {
            object = positionalArgs.get(0);
        } else if (positionalArgs.isEmpty() && keywordArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("object"))) {
            object = keywordArgs.get(PythonString.valueOf("object"));
        } else {
            throw new ValueError("ascii expects 1 argument, got " + positionalArgs.size());
        }
        PythonString reprString = (PythonString)UnaryDunderBuiltin.REPRESENTATION.invoke(object);
        String asciiString = reprString.value.codePoints().flatMap(character -> {
            if (character < 128) {
                return IntStream.of(character);
            }
            IntStream.Builder builder = IntStream.builder().add(92).add(85);
            String hexString = Integer.toHexString(character);
            for (int i = 8; i > hexString.length(); --i) {
                builder.add(48);
            }
            hexString.codePoints().forEach(builder);
            return builder.build();
        }).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        return PythonString.valueOf(asciiString);
    }

    public static PythonString bin(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeObject object;
        if (positionalArgs.size() == 1 && keywordArgs.isEmpty()) {
            object = positionalArgs.get(0);
        } else if (positionalArgs.isEmpty() && keywordArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("x"))) {
            object = keywordArgs.get(PythonString.valueOf("x"));
        } else {
            throw new ValueError("bin expects 1 argument, got " + positionalArgs.size());
        }
        PythonInteger integer = object instanceof PythonInteger ? (PythonInteger)object : (PythonInteger)UnaryDunderBuiltin.INDEX.invoke(object);
        String binaryString = integer.value.toString(2);
        if (binaryString.startsWith("-")) {
            return PythonString.valueOf("-0b" + binaryString.substring(1));
        }
        return PythonString.valueOf("0b" + binaryString);
    }

    public static PythonBoolean callable(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeObject object;
        if (positionalArgs.size() == 1 && keywordArgs.isEmpty()) {
            object = positionalArgs.get(0);
        } else if (positionalArgs.isEmpty() && keywordArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("object"))) {
            object = keywordArgs.get(PythonString.valueOf("object"));
        } else {
            throw new ValueError("callable expects 1 argument, got " + positionalArgs.size());
        }
        return PythonBoolean.valueOf(object instanceof PythonLikeFunction);
    }

    public static PythonString chr(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeObject object;
        if (positionalArgs.size() == 1 && keywordArgs.isEmpty()) {
            object = positionalArgs.get(0);
        } else if (positionalArgs.isEmpty() && keywordArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("i"))) {
            object = keywordArgs.get(PythonString.valueOf("i"));
        } else {
            throw new ValueError("chr expects 1 argument, got " + positionalArgs.size());
        }
        PythonInteger integer = (PythonInteger)object;
        if (integer.value.compareTo(BigInteger.valueOf(0x10FFFFL)) > 0 || integer.value.compareTo(BigInteger.ZERO) < 0) {
            throw new ValueError("Integer (" + integer + ") outside valid range for chr (0 through 1,114,111)");
        }
        return PythonString.valueOf(Character.toString(integer.value.intValueExact()));
    }

    public static PythonNone delattr(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonString name;
        PythonLikeObject object;
        if (positionalArgs.size() == 2) {
            object = positionalArgs.get(0);
            name = (PythonString)positionalArgs.get(1);
        } else if (positionalArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("name"))) {
            object = positionalArgs.get(0);
            name = (PythonString)keywordArgs.get(PythonString.valueOf("name"));
        } else if (positionalArgs.size() == 0 && keywordArgs.containsKey(PythonString.valueOf("object")) && keywordArgs.containsKey(PythonString.valueOf("name"))) {
            object = keywordArgs.get(PythonString.valueOf("object"));
            name = (PythonString)keywordArgs.get(PythonString.valueOf("name"));
        } else {
            throw new ValueError("delattr expects 2 argument, got " + positionalArgs.size());
        }
        object.$deleteAttribute(name.value);
        return PythonNone.INSTANCE;
    }

    public static PythonLikeObject divmod(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        if (positionalArgs.size() != 2) {
            throw new TypeError("divmod() expects 2 positional arguments");
        }
        PythonLikeObject left = positionalArgs.get(0);
        PythonLikeObject right = positionalArgs.get(1);
        PythonLikeObject maybeDivmod = left.$getType().$getAttributeOrNull("__divmod__");
        if (maybeDivmod != null) {
            PythonLikeObject result = ((PythonLikeFunction)maybeDivmod).$call(List.of(left, right), Map.of(), null);
            if (result != NotImplemented.INSTANCE) {
                return result;
            }
            maybeDivmod = right.$getType().$getAttributeOrNull("__rdivmod__");
            if (maybeDivmod != null) {
                result = ((PythonLikeFunction)maybeDivmod).$call(List.of(right, left), Map.of(), null);
                if (result != NotImplemented.INSTANCE) {
                    return result;
                }
                PythonLikeObject maybeDiv = left.$getType().$getAttributeOrNull("__floordiv__");
                PythonLikeObject maybeMod = left.$getType().$getAttributeOrNull("__mod__");
                if (maybeDiv != null && maybeMod != null) {
                    PythonLikeObject divResult = ((PythonLikeFunction)maybeDiv).$call(List.of(left, right), Map.of(), null);
                    PythonLikeObject modResult = ((PythonLikeFunction)maybeMod).$call(List.of(left, right), Map.of(), null);
                    if (divResult != NotImplemented.INSTANCE && modResult != NotImplemented.INSTANCE) {
                        return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{divResult, modResult});
                    }
                    maybeDiv = right.$getType().$getAttributeOrNull("__rfloordiv__");
                    maybeMod = right.$getType().$getAttributeOrNull("__rmod__");
                    if (maybeDiv != null && maybeMod != null) {
                        divResult = ((PythonLikeFunction)maybeDiv).$call(List.of(right, left), Map.of(), null);
                        modResult = ((PythonLikeFunction)maybeMod).$call(List.of(right, left), Map.of(), null);
                        if (divResult != NotImplemented.INSTANCE && modResult != NotImplemented.INSTANCE) {
                            return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{divResult, modResult});
                        }
                        throw new TypeError("Unsupported operands for divmod: " + left.$getType() + ", " + right.$getType());
                    }
                } else {
                    maybeDiv = right.$getType().$getAttributeOrNull("__rfloordiv__");
                    maybeMod = right.$getType().$getAttributeOrNull("__rmod__");
                    if (maybeDiv != null && maybeMod != null) {
                        PythonLikeObject divResult = ((PythonLikeFunction)maybeDiv).$call(List.of(right, left), Map.of(), null);
                        PythonLikeObject modResult = ((PythonLikeFunction)maybeMod).$call(List.of(right, left), Map.of(), null);
                        if (divResult != NotImplemented.INSTANCE && modResult != NotImplemented.INSTANCE) {
                            return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{divResult, modResult});
                        }
                        throw new TypeError("Unsupported operands for divmod: " + left.$getType() + ", " + right.$getType());
                    }
                }
            }
        } else {
            maybeDivmod = right.$getType().$getAttributeOrNull("__rdivmod__");
            if (maybeDivmod != null) {
                PythonLikeObject result = ((PythonLikeFunction)maybeDivmod).$call(List.of(right, left), Map.of(), null);
                if (result != NotImplemented.INSTANCE) {
                    return result;
                }
                PythonLikeObject maybeDiv = left.$getType().$getAttributeOrNull("__floordiv__");
                PythonLikeObject maybeMod = left.$getType().$getAttributeOrNull("__mod__");
                if (maybeDiv != null && maybeMod != null) {
                    PythonLikeObject divResult = ((PythonLikeFunction)maybeDiv).$call(List.of(left, right), Map.of(), null);
                    PythonLikeObject modResult = ((PythonLikeFunction)maybeMod).$call(List.of(left, right), Map.of(), null);
                    if (divResult != NotImplemented.INSTANCE && modResult != NotImplemented.INSTANCE) {
                        return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{divResult, modResult});
                    }
                    maybeDiv = right.$getType().$getAttributeOrNull("__rfloordiv__");
                    maybeMod = right.$getType().$getAttributeOrNull("__rmod__");
                    if (maybeDiv != null && maybeMod != null) {
                        divResult = ((PythonLikeFunction)maybeDiv).$call(List.of(right, left), Map.of(), null);
                        modResult = ((PythonLikeFunction)maybeMod).$call(List.of(right, left), Map.of(), null);
                        if (divResult != NotImplemented.INSTANCE && modResult != NotImplemented.INSTANCE) {
                            return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{divResult, modResult});
                        }
                        throw new TypeError("Unsupported operands for divmod: " + left.$getType() + ", " + right.$getType());
                    }
                } else {
                    maybeDiv = right.$getType().$getAttributeOrNull("__rfloordiv__");
                    maybeMod = right.$getType().$getAttributeOrNull("__rmod__");
                    if (maybeDiv != null && maybeMod != null) {
                        PythonLikeObject divResult = ((PythonLikeFunction)maybeDiv).$call(List.of(right, left), Map.of(), null);
                        PythonLikeObject modResult = ((PythonLikeFunction)maybeMod).$call(List.of(right, left), Map.of(), null);
                        if (divResult != NotImplemented.INSTANCE && modResult != NotImplemented.INSTANCE) {
                            return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{divResult, modResult});
                        }
                        throw new TypeError("Unsupported operands for divmod: " + left.$getType() + ", " + right.$getType());
                    }
                }
            } else {
                PythonLikeObject maybeDiv = left.$getType().$getAttributeOrNull("__floordiv__");
                PythonLikeObject maybeMod = left.$getType().$getAttributeOrNull("__mod__");
                if (maybeDiv != null && maybeMod != null) {
                    PythonLikeObject divResult = ((PythonLikeFunction)maybeDiv).$call(List.of(left, right), Map.of(), null);
                    PythonLikeObject modResult = ((PythonLikeFunction)maybeMod).$call(List.of(left, right), Map.of(), null);
                    if (divResult != NotImplemented.INSTANCE && modResult != NotImplemented.INSTANCE) {
                        return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{divResult, modResult});
                    }
                    maybeDiv = right.$getType().$getAttributeOrNull("__rfloordiv__");
                    maybeMod = right.$getType().$getAttributeOrNull("__rmod__");
                    if (maybeDiv != null && maybeMod != null) {
                        divResult = ((PythonLikeFunction)maybeDiv).$call(List.of(right, left), Map.of(), null);
                        modResult = ((PythonLikeFunction)maybeMod).$call(List.of(right, left), Map.of(), null);
                        if (divResult != NotImplemented.INSTANCE && modResult != NotImplemented.INSTANCE) {
                            return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{divResult, modResult});
                        }
                        throw new TypeError("Unsupported operands for divmod: " + left.$getType() + ", " + right.$getType());
                    }
                } else {
                    maybeDiv = right.$getType().$getAttributeOrNull("__rfloordiv__");
                    maybeMod = right.$getType().$getAttributeOrNull("__rmod__");
                    if (maybeDiv != null && maybeMod != null) {
                        PythonLikeObject divResult = ((PythonLikeFunction)maybeDiv).$call(List.of(right, left), Map.of(), null);
                        PythonLikeObject modResult = ((PythonLikeFunction)maybeMod).$call(List.of(right, left), Map.of(), null);
                        if (divResult != NotImplemented.INSTANCE && modResult != NotImplemented.INSTANCE) {
                            return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{divResult, modResult});
                        }
                        throw new TypeError("Unsupported operands for divmod: " + left.$getType() + ", " + right.$getType());
                    }
                }
            }
        }
        return PythonNone.INSTANCE;
    }

    public static PythonLikeObject enumerate(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeObject iterable;
        PythonLikeObject start = PythonInteger.valueOf(0);
        if (positionalArgs.size() == 2) {
            iterable = positionalArgs.get(0);
            start = positionalArgs.get(1);
        } else if (positionalArgs.size() == 1) {
            iterable = positionalArgs.get(0);
            if (keywordArgs.containsKey(PythonString.valueOf("start"))) {
                start = keywordArgs.get(PythonString.valueOf("start"));
            }
        } else if (positionalArgs.size() == 0 && keywordArgs.containsKey(PythonString.valueOf("iterable"))) {
            iterable = keywordArgs.get(PythonString.valueOf("iterable"));
            if (keywordArgs.containsKey(PythonString.valueOf("start"))) {
                start = keywordArgs.get(PythonString.valueOf("start"));
            }
        } else {
            throw new ValueError("enumerate expects 1 or 2 argument, got " + positionalArgs.size());
        }
        final PythonLikeObject iterator = UnaryDunderBuiltin.ITERATOR.invoke(iterable);
        final AtomicReference<Object> currentValue = new AtomicReference<Object>(null);
        final AtomicReference<PythonInteger> currentIndex = new AtomicReference<PythonInteger>((PythonInteger)start);
        final AtomicBoolean shouldCallNext = new AtomicBoolean(true);
        return new DelegatePythonIterator<PythonLikeObject>(new Iterator<PythonLikeObject>(){

            @Override
            public boolean hasNext() {
                if (shouldCallNext.get()) {
                    try {
                        currentValue.set(UnaryDunderBuiltin.NEXT.invoke(iterator));
                    }
                    catch (StopIteration e) {
                        currentValue.set(null);
                        shouldCallNext.set(false);
                        return false;
                    }
                    shouldCallNext.set(false);
                    return true;
                }
                return currentValue.get() != null;
            }

            @Override
            public PythonLikeObject next() {
                PythonLikeObject value;
                if (currentValue.get() != null) {
                    shouldCallNext.set(true);
                    value = (PythonLikeObject)currentValue.get();
                    currentValue.set(null);
                } else {
                    value = UnaryDunderBuiltin.NEXT.invoke(iterator);
                    shouldCallNext.set(true);
                }
                PythonLikeObject index = (PythonLikeObject)currentIndex.get();
                currentIndex.set(BinaryDunderBuiltin.ADD.invoke(index, PythonInteger.valueOf(1)));
                return PythonLikeTuple.fromItems((PythonLikeObject[])new PythonLikeObject[]{index, value});
            }
        });
    }

    public static DelegatePythonIterator filter(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeObject iterable;
        PythonLikeObject function;
        if (positionalArgs.size() == 2 && keywordArgs.isEmpty()) {
            function = positionalArgs.get(0);
            iterable = positionalArgs.get(1);
        } else if (positionalArgs.size() == 1) {
            function = positionalArgs.get(0);
            iterable = keywordArgs.get(PythonString.valueOf("iterable"));
            if (iterable == null) {
                throw new ValueError("iterable is None");
            }
        } else if (positionalArgs.size() == 0) {
            function = keywordArgs.get(PythonString.valueOf("function"));
            iterable = keywordArgs.get(PythonString.valueOf("iterable"));
            if (iterable == null) {
                throw new ValueError("iterable is None");
            }
            if (function == null) {
                function = PythonNone.INSTANCE;
            }
        } else {
            throw new ValueError("filter expects 2 argument, got " + positionalArgs.size());
        }
        Iterator iterator = iterable instanceof Collection ? ((Collection)((Object)iterable)).iterator() : (iterable instanceof Iterator ? (Iterator)((Object)iterable) : (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(iterable)));
        PythonLikeFunction predicate = function == PythonNone.INSTANCE ? (pos, keywords, callerInstance) -> (PythonLikeObject)pos.get(0) : (PythonLikeFunction)function;
        return new DelegatePythonIterator(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).filter(element -> PythonBoolean.isTruthful(predicate.$call(List.of((PythonLikeObject)element), Map.of(), null))).iterator());
    }

    public static PythonLikeObject format(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeObject toFormat;
        PythonLikeObject formatSpec = PythonString.valueOf("");
        if (positionalArgs.size() == 2 && keywordArgs.isEmpty()) {
            toFormat = positionalArgs.get(0);
            formatSpec = positionalArgs.get(1);
        } else if (positionalArgs.size() == 1) {
            toFormat = positionalArgs.get(0);
            if (keywordArgs.containsKey(PythonString.valueOf("format_spec"))) {
                formatSpec = keywordArgs.get(PythonString.valueOf("format_spec"));
            }
        } else if (positionalArgs.size() == 0 && keywordArgs.containsKey(PythonString.valueOf("value"))) {
            toFormat = keywordArgs.get(PythonString.valueOf("value"));
            if (keywordArgs.containsKey(PythonString.valueOf("format_spec"))) {
                formatSpec = keywordArgs.get(PythonString.valueOf("format_spec"));
            }
        } else {
            throw new ValueError("format expects 1 or 2 arguments, got " + positionalArgs.size());
        }
        return toFormat.$method$__format__(formatSpec);
    }

    public static PythonLikeObject getattr(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonString name;
        PythonLikeObject object;
        PythonLikeObject defaultValue = null;
        if (positionalArgs.size() == 3) {
            object = positionalArgs.get(0);
            name = (PythonString)positionalArgs.get(1);
            defaultValue = positionalArgs.get(2);
        } else if (positionalArgs.size() == 2) {
            object = positionalArgs.get(0);
            name = (PythonString)positionalArgs.get(1);
            defaultValue = keywordArgs.get(PythonString.valueOf("default"));
        } else if (positionalArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("name"))) {
            object = positionalArgs.get(0);
            name = (PythonString)keywordArgs.get(PythonString.valueOf("name"));
            defaultValue = keywordArgs.get(PythonString.valueOf("default"));
        } else if (positionalArgs.size() == 0 && keywordArgs.containsKey(PythonString.valueOf("object")) && keywordArgs.containsKey(PythonString.valueOf("name"))) {
            object = keywordArgs.get(PythonString.valueOf("object"));
            name = (PythonString)keywordArgs.get(PythonString.valueOf("name"));
            defaultValue = keywordArgs.get(PythonString.valueOf("default"));
        } else {
            throw new ValueError("getattr expects 2 or 3 arguments, got " + positionalArgs.size());
        }
        PythonLikeFunction getAttribute = (PythonLikeFunction)object.$getType().$getAttributeOrError("__getattribute__");
        try {
            return getAttribute.$call(List.of(object, name), Map.of(), null);
        }
        catch (AttributeError attributeError) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw attributeError;
        }
    }

    public static PythonLikeDict globals(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        if (!positionalArgs.isEmpty() && keywordArgs.isEmpty()) {
            throw new ValueError("globals expects 0 arguments, got " + positionalArgs.size());
        }
        Class<?> callerClass = stackWalker.getCallerClass();
        try {
            Map globalsMap = (Map)callerClass.getField("__globals__").get(null);
            return PythonLikeDict.mirror(globalsMap);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Caller (" + callerClass + ") is not a generated class", e);
        }
    }

    public static PythonBoolean hasattr(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        try {
            GlobalBuiltins.getattr(positionalArgs, keywordArgs, instance);
            return PythonBoolean.TRUE;
        }
        catch (AttributeError error) {
            return PythonBoolean.FALSE;
        }
    }

    public static PythonString hex(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeObject object;
        if (positionalArgs.size() == 1 && keywordArgs.isEmpty()) {
            object = positionalArgs.get(0);
        } else if (positionalArgs.isEmpty() && keywordArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("x"))) {
            object = keywordArgs.get(PythonString.valueOf("x"));
        } else {
            throw new ValueError("hex expects 1 argument, got " + positionalArgs.size());
        }
        PythonInteger integer = object instanceof PythonInteger ? (PythonInteger)object : (PythonInteger)UnaryDunderBuiltin.INDEX.invoke(object);
        String hexString = integer.value.toString(16);
        if (hexString.startsWith("-")) {
            return PythonString.valueOf("-0x" + hexString.substring(1));
        }
        return PythonString.valueOf("0x" + hexString);
    }

    public static PythonInteger id(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeObject object;
        if (positionalArgs.size() == 1 && keywordArgs.isEmpty()) {
            object = positionalArgs.get(0);
        } else if (positionalArgs.isEmpty() && keywordArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("object"))) {
            object = keywordArgs.get(PythonString.valueOf("object"));
        } else {
            throw new ValueError("id expects 1 argument, got " + positionalArgs.size());
        }
        if (object instanceof CPythonBackedPythonLikeObject) {
            CPythonBackedPythonLikeObject cPythonBackedPythonLikeObject = (CPythonBackedPythonLikeObject)object;
            if (cPythonBackedPythonLikeObject.$cpythonId != null) {
                return cPythonBackedPythonLikeObject.$cpythonId;
            }
        }
        return PythonInteger.valueOf(System.identityHashCode(object));
    }

    public static PythonLikeFunction input(PythonInterpreter interpreter) {
        return (positionalArguments, namedArguments, callerInstance) -> {
            PythonString prompt = null;
            if (positionalArguments.size() == 1) {
                prompt = (PythonString)positionalArguments.get(0);
            } else if (positionalArguments.size() == 0 && namedArguments.containsKey(PythonString.valueOf("prompt"))) {
                prompt = (PythonString)namedArguments.get(PythonString.valueOf("prompt"));
            } else {
                throw new ValueError("input expects 0 or 1 arguments, got " + positionalArguments.size());
            }
            if (prompt != null) {
                interpreter.write(prompt.value);
            }
            String line = interpreter.readLine();
            return PythonString.valueOf(line);
        };
    }

    public static PythonBoolean isinstance(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeObject classInfo;
        PythonLikeObject object;
        if (positionalArgs.size() == 2) {
            object = positionalArgs.get(0);
            classInfo = positionalArgs.get(1);
        } else if (positionalArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("classinfo"))) {
            object = positionalArgs.get(0);
            classInfo = keywordArgs.get(PythonString.valueOf("classinfo"));
        } else if (positionalArgs.size() == 0 && keywordArgs.containsKey(PythonString.valueOf("object")) && keywordArgs.containsKey(PythonString.valueOf("classinfo"))) {
            object = keywordArgs.get(PythonString.valueOf("object"));
            classInfo = keywordArgs.get(PythonString.valueOf("classinfo"));
        } else {
            throw new ValueError("isinstance expects 2 arguments, got " + positionalArgs.size());
        }
        if (classInfo instanceof PythonLikeType) {
            return PythonBoolean.valueOf(((PythonLikeType)classInfo).isInstance(object));
        }
        if (classInfo instanceof List) {
            for (PythonLikeObject possibleType : (List)((Object)classInfo)) {
                if (!GlobalBuiltins.isinstance(List.of(object, possibleType), null, instance).getBooleanValue()) continue;
                return PythonBoolean.TRUE;
            }
            return PythonBoolean.FALSE;
        }
        throw new ValueError("classInfo (" + classInfo + ") is not a tuple of types or a type");
    }

    public static PythonBoolean issubclass(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeObject classInfo;
        PythonLikeType type;
        if (positionalArgs.size() == 2) {
            if (!(positionalArgs.get(0) instanceof PythonLikeType)) {
                throw new TypeError("issubclass argument 0 must be a class, not " + positionalArgs.get(0).$getType());
            }
            type = (PythonLikeType)positionalArgs.get(0);
            classInfo = positionalArgs.get(1);
        } else if (positionalArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("classinfo"))) {
            if (!(positionalArgs.get(0) instanceof PythonLikeType)) {
                throw new TypeError("issubclass argument 0 must be a class, not " + positionalArgs.get(0).$getType());
            }
            type = (PythonLikeType)positionalArgs.get(0);
            classInfo = keywordArgs.get(PythonString.valueOf("classinfo"));
        } else if (positionalArgs.size() == 0 && keywordArgs.containsKey(PythonString.valueOf("class")) && keywordArgs.containsKey(PythonString.valueOf("classinfo"))) {
            if (!(keywordArgs.get(PythonString.valueOf("class")) instanceof PythonLikeType)) {
                throw new TypeError("issubclass argument 0 must be a class, not " + positionalArgs.get(0).$getType());
            }
            type = (PythonLikeType)keywordArgs.get(PythonString.valueOf("class"));
            classInfo = keywordArgs.get(PythonString.valueOf("classinfo"));
        } else {
            throw new ValueError("isinstance expects 2 arguments, got " + positionalArgs.size());
        }
        if (classInfo instanceof PythonLikeType) {
            return PythonBoolean.valueOf(type.isSubclassOf((PythonLikeType)classInfo));
        }
        if (classInfo instanceof List) {
            for (PythonLikeObject possibleType : (List)((Object)classInfo)) {
                if (!GlobalBuiltins.issubclass(List.of(type, possibleType), null, instance).getBooleanValue()) continue;
                return PythonBoolean.TRUE;
            }
            return PythonBoolean.FALSE;
        }
        throw new ValueError("classInfo (" + classInfo + ") is not a tuple of types or a type");
    }

    public static PythonLikeDict locals(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        throw new ValueError("builtin locals() is not supported when executed in Java bytecode");
    }

    public static DelegatePythonIterator map(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeFunction function;
        List<Object> iterableList = new ArrayList();
        if (positionalArgs.size() >= 2 && keywordArgs.isEmpty()) {
            function = (PythonLikeFunction)positionalArgs.get(0);
            iterableList = positionalArgs.subList(1, positionalArgs.size());
        } else if (positionalArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("iterable"))) {
            function = (PythonLikeFunction)positionalArgs.get(0);
            iterableList.add(keywordArgs.get(PythonString.valueOf("iterable")));
        } else if (positionalArgs.size() == 0 && keywordArgs.containsKey(PythonString.valueOf("function")) && keywordArgs.containsKey(PythonString.valueOf("iterable"))) {
            function = (PythonLikeFunction)keywordArgs.get(PythonString.valueOf("function"));
            iterableList.add(keywordArgs.get(PythonString.valueOf("iterable")));
        } else {
            throw new ValueError("map expects at least 2 argument, got " + positionalArgs.size());
        }
        final ArrayList<Iterator> iteratorList = new ArrayList<Iterator>(iterableList.size());
        for (PythonLikeObject pythonLikeObject : iterableList) {
            Iterator iterator = pythonLikeObject instanceof Collection ? ((Collection)((Object)pythonLikeObject)).iterator() : (pythonLikeObject instanceof Iterator ? (Iterator)((Object)pythonLikeObject) : (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(pythonLikeObject)));
            iteratorList.add(iterator);
        }
        Iterator<List<PythonLikeObject>> iteratorIterator = new Iterator<List<PythonLikeObject>>(){

            @Override
            public boolean hasNext() {
                return iteratorList.stream().allMatch(Iterator::hasNext);
            }

            @Override
            public List<PythonLikeObject> next() {
                ArrayList<PythonLikeObject> out = new ArrayList<PythonLikeObject>(iteratorList.size());
                for (Iterator iterator : iteratorList) {
                    out.add((PythonLikeObject)iterator.next());
                }
                return out;
            }
        };
        return new DelegatePythonIterator(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iteratorIterator, 16), false).map(element -> function.$call((List<PythonLikeObject>)element, Map.of(), null)).iterator());
    }

    public static PythonLikeObject min(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        if (positionalArgs.isEmpty()) {
            PythonLikeObject defaultValue = keywordArgs.get(PythonString.valueOf("default"));
            if (!keywordArgs.containsKey(PythonString.valueOf("default"))) {
                throw new ValueError("No arguments were passed to min, and no default was provided");
            }
            return defaultValue;
        }
        if (positionalArgs.size() == 1) {
            Iterator iterator = (Iterator)((Object)((PythonLikeFunction)positionalArgs.get(0).$getType().$getAttributeOrError("__iter__")).$call(List.of(positionalArgs.get(0)), Map.of(), null));
            Comparable min = null;
            Iterator it = iterator;
            while (it.hasNext()) {
                Comparable item = (Comparable)it.next();
                if (min == null) {
                    min = item;
                    continue;
                }
                if (item.compareTo(min) >= 0) continue;
                min = item;
            }
            if (min == null) {
                PythonLikeObject defaultValue = keywordArgs.get(PythonString.valueOf("default"));
                if (!keywordArgs.containsKey(PythonString.valueOf("default"))) {
                    throw new ValueError("Iterable is empty, and no default was provided");
                }
                return defaultValue;
            }
            return (PythonLikeObject)((Object)min);
        }
        Comparable min = (Comparable)((Object)positionalArgs.get(0));
        for (PythonLikeObject item : positionalArgs) {
            Comparable comparableItem = (Comparable)((Object)item);
            if (comparableItem.compareTo(min) >= 0) continue;
            min = comparableItem;
        }
        return (PythonLikeObject)((Object)min);
    }

    public static PythonLikeObject max(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        if (positionalArgs.isEmpty()) {
            PythonLikeObject defaultValue = keywordArgs.get(PythonString.valueOf("default"));
            if (!keywordArgs.containsKey(PythonString.valueOf("default"))) {
                throw new ValueError("No arguments were passed to max, and no default was provided");
            }
            return defaultValue;
        }
        if (positionalArgs.size() == 1) {
            Iterator iterator = (Iterator)((Object)((PythonLikeFunction)positionalArgs.get(0).$getType().$getAttributeOrError("__iter__")).$call(List.of(positionalArgs.get(0)), Map.of(), null));
            Comparable max = null;
            Iterator it = iterator;
            while (it.hasNext()) {
                Comparable item = (Comparable)it.next();
                if (max == null) {
                    max = item;
                    continue;
                }
                if (item.compareTo(max) <= 0) continue;
                max = item;
            }
            if (max == null) {
                PythonLikeObject defaultValue = keywordArgs.get(PythonString.valueOf("default"));
                if (!keywordArgs.containsKey(PythonString.valueOf("default"))) {
                    throw new ValueError("Iterable is empty, and no default was provided");
                }
                return defaultValue;
            }
            return (PythonLikeObject)((Object)max);
        }
        Comparable max = (Comparable)((Object)positionalArgs.get(0));
        for (PythonLikeObject item : positionalArgs) {
            Comparable comparableItem = (Comparable)((Object)item);
            if (comparableItem.compareTo(max) <= 0) continue;
            max = comparableItem;
        }
        return (PythonLikeObject)((Object)max);
    }

    public static PythonString oct(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeObject object;
        if (positionalArgs.size() == 1 && keywordArgs.isEmpty()) {
            object = positionalArgs.get(0);
        } else if (positionalArgs.isEmpty() && keywordArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("x"))) {
            object = keywordArgs.get(PythonString.valueOf("x"));
        } else {
            throw new ValueError("oct expects 1 argument, got " + positionalArgs.size());
        }
        PythonInteger integer = object instanceof PythonInteger ? (PythonInteger)object : (PythonInteger)UnaryDunderBuiltin.INDEX.invoke(object);
        String octString = integer.value.toString(8);
        if (octString.startsWith("-")) {
            return PythonString.valueOf("-0o" + octString.substring(1));
        }
        return PythonString.valueOf("0o" + octString);
    }

    public static PythonInteger ord(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonString character;
        if (positionalArgs.size() == 1 && keywordArgs.isEmpty()) {
            character = (PythonString)positionalArgs.get(0);
        } else if (positionalArgs.isEmpty() && keywordArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("c"))) {
            character = (PythonString)keywordArgs.get(PythonString.valueOf("c"));
        } else {
            throw new ValueError("ord expects 1 argument, got " + positionalArgs.size());
        }
        if (character.length() != 1) {
            throw new ValueError("String \"" + character + "\" does not represent a single character");
        }
        return PythonInteger.valueOf(character.value.charAt(0));
    }

    public static PythonLikeObject pow(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeObject exp;
        PythonLikeObject base;
        PythonLikeObject mod = null;
        if (positionalArgs.size() == 3 && keywordArgs.isEmpty()) {
            base = positionalArgs.get(0);
            exp = positionalArgs.get(1);
            mod = positionalArgs.get(2);
        } else if (positionalArgs.size() == 2) {
            base = positionalArgs.get(0);
            exp = positionalArgs.get(1);
            mod = keywordArgs.get(PythonString.valueOf("mod"));
        } else if (positionalArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("exp"))) {
            base = positionalArgs.get(0);
            exp = keywordArgs.get(PythonString.valueOf("exp"));
            mod = keywordArgs.get(PythonString.valueOf("mod"));
        } else if (positionalArgs.isEmpty() && keywordArgs.containsKey(PythonString.valueOf("base")) && keywordArgs.containsKey(PythonString.valueOf("exp"))) {
            base = keywordArgs.get(PythonString.valueOf("base"));
            exp = keywordArgs.get(PythonString.valueOf("exp"));
            mod = keywordArgs.get(PythonString.valueOf("mod"));
        } else {
            throw new ValueError("pow expects 2 or 3 arguments, got " + positionalArgs.size());
        }
        if (mod == null) {
            return BinaryDunderBuiltin.POWER.invoke(base, exp);
        }
        return TernaryDunderBuiltin.POWER.invoke(base, exp, mod);
    }

    public static PythonLikeFunction print(PythonInterpreter interpreter) {
        return (positionalArgs, keywordArgs, callerInstance) -> {
            List objects = positionalArgs;
            String sep = !keywordArgs.containsKey(PythonString.valueOf("sep")) || keywordArgs.get(PythonString.valueOf("sep")) == PythonNone.INSTANCE ? " " : ((PythonString)keywordArgs.get((Object)PythonString.valueOf((String)"sep"))).value;
            String end = !keywordArgs.containsKey(PythonString.valueOf("end")) || keywordArgs.get(PythonString.valueOf("end")) == PythonNone.INSTANCE ? "\n" : ((PythonString)keywordArgs.get((Object)PythonString.valueOf((String)"end"))).value;
            boolean flush = !keywordArgs.containsKey(PythonString.valueOf("flush")) || keywordArgs.get(PythonString.valueOf("flush")) == PythonNone.INSTANCE ? false : ((PythonBoolean)keywordArgs.get(PythonString.valueOf("flush"))).getBooleanValue();
            for (int i = 0; i < objects.size() - 1; ++i) {
                interpreter.write(UnaryDunderBuiltin.STR.invoke((PythonLikeObject)objects.get(i)).toString());
                interpreter.write(sep);
            }
            if (!objects.isEmpty()) {
                interpreter.write(UnaryDunderBuiltin.STR.invoke((PythonLikeObject)objects.get(objects.size() - 1)).toString());
            }
            interpreter.write(end);
            if (flush) {
                System.out.flush();
            }
            return PythonNone.INSTANCE;
        };
    }

    public static PythonLikeObject reversed(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        if (positionalArgs.size() != 1) {
            throw new ValueError("reversed() expects 1 argument, got " + positionalArgs.size());
        }
        final PythonLikeObject sequence = positionalArgs.get(0);
        PythonLikeType sequenceType = sequence.$getType();
        if (sequenceType.$getAttributeOrNull(PythonUnaryOperator.REVERSED.getDunderMethod()) != null) {
            return UnaryDunderBuiltin.REVERSED.invoke(sequence);
        }
        if (sequenceType.$getAttributeOrNull(PythonUnaryOperator.LENGTH.getDunderMethod()) != null && sequenceType.$getAttributeOrNull(PythonBinaryOperator.GET_ITEM.getDunderMethod()) != null) {
            final PythonInteger length = (PythonInteger)UnaryDunderBuiltin.LENGTH.invoke(sequence);
            Iterator<PythonLikeObject> reversedIterator = new Iterator<PythonLikeObject>(){
                PythonInteger current;
                {
                    this.current = length.subtract(PythonInteger.ONE);
                }

                @Override
                public boolean hasNext() {
                    return this.current.compareTo(PythonInteger.ZERO) >= 0;
                }

                @Override
                public PythonLikeObject next() {
                    PythonLikeObject out = BinaryDunderBuiltin.GET_ITEM.invoke(sequence, this.current);
                    this.current = this.current.subtract(PythonInteger.ONE);
                    return out;
                }
            };
            return new DelegatePythonIterator<PythonLikeObject>(reversedIterator);
        }
        throw new ValueError(sequenceType + " does not has a __reversed__ method and does not implement the Sequence protocol");
    }

    public static PythonLikeObject round(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        if (positionalArgs.size() != 1 && positionalArgs.size() != 2) {
            throw new ValueError("round() expects 1 or 2 arguments, got " + positionalArgs.size());
        }
        PythonLikeObject number = positionalArgs.get(0);
        PythonLikeType numberType = number.$getType();
        if (numberType.$getAttributeOrNull("__round__") != null) {
            return ((PythonLikeFunction)numberType.$getAttributeOrNull("__round__")).$call(positionalArgs, keywordArgs, null);
        }
        throw new ValueError(numberType + " does not has a __round__ method");
    }

    public static PythonLikeObject setattr(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeObject value;
        PythonString name;
        PythonLikeObject object;
        if (positionalArgs.size() == 3) {
            object = positionalArgs.get(0);
            name = (PythonString)positionalArgs.get(1);
            value = positionalArgs.get(2);
        } else if (positionalArgs.size() == 2 && keywordArgs.containsKey(PythonString.valueOf("value"))) {
            object = positionalArgs.get(0);
            name = (PythonString)positionalArgs.get(1);
            value = keywordArgs.get(PythonString.valueOf("value"));
        } else if (positionalArgs.size() == 1 && keywordArgs.containsKey(PythonString.valueOf("name")) && keywordArgs.containsKey(PythonString.valueOf("value"))) {
            object = positionalArgs.get(0);
            name = (PythonString)keywordArgs.get(PythonString.valueOf("name"));
            value = keywordArgs.get(PythonString.valueOf("value"));
        } else if (positionalArgs.size() == 0 && keywordArgs.containsKey(PythonString.valueOf("object")) && keywordArgs.containsKey(PythonString.valueOf("name")) && keywordArgs.containsKey(PythonString.valueOf("value"))) {
            object = keywordArgs.get(PythonString.valueOf("object"));
            name = (PythonString)keywordArgs.get(PythonString.valueOf("name"));
            value = keywordArgs.get(PythonString.valueOf("value"));
        } else {
            throw new ValueError("setattr expects 2 or 3 arguments, got " + positionalArgs.size());
        }
        return TernaryDunderBuiltin.SETATTR.invoke(object, name, value);
    }

    public static PythonLikeObject sorted(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeObject iterable = positionalArgs.get(0);
        boolean isReversed = false;
        if (keywordArgs.containsKey(PythonString.valueOf("reverse"))) {
            isReversed = ((PythonBoolean)keywordArgs.get(PythonString.valueOf("reverse"))).getBooleanValue();
        }
        PythonLikeList out = new PythonLikeList();
        if (iterable instanceof Collection) {
            out.addAll((Collection)((Object)iterable));
        } else {
            Iterator iterator = (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(iterable));
            iterator.forEachRemaining(out::add);
        }
        Comparator keyComparator = isReversed ? Comparator.reverseOrder() : Comparator.naturalOrder();
        ArrayList<KeyTuple> decoratedList = null;
        if (keywordArgs.containsKey(PythonString.valueOf("key"))) {
            PythonLikeObject key = keywordArgs.get(PythonString.valueOf("key"));
            if (key != PythonNone.INSTANCE) {
                PythonLikeFunction keyFunction = (PythonLikeFunction)key;
                Function<Object, Object> keyExtractor = item -> keyFunction.$call(List.of((PythonLikeObject)item), Map.of(), null);
                decoratedList = new ArrayList<KeyTuple>(out.size());
                for (int i = 0; i < out.size(); ++i) {
                    decoratedList.add(new KeyTuple((PythonLikeObject)keyExtractor.apply(out.get(i)), i, (PythonLikeObject)out.get(i)));
                }
            } else {
                keyComparator = isReversed ? Comparator.reverseOrder() : Comparator.naturalOrder();
            }
        } else {
            Comparator comparator = keyComparator = isReversed ? Comparator.reverseOrder() : Comparator.naturalOrder();
        }
        if (decoratedList != null) {
            Collections.sort(decoratedList, keyComparator);
            out.clear();
            for (KeyTuple keyTuple : decoratedList) {
                out.add(keyTuple.source);
            }
        } else {
            Collections.sort(out, keyComparator);
        }
        return out;
    }

    public static PythonLikeObject sum(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        PythonLikeObject start;
        PythonLikeObject iterable;
        if (positionalArgs.size() == 2) {
            iterable = positionalArgs.get(0);
            start = positionalArgs.get(1);
        } else if (positionalArgs.size() == 1) {
            iterable = positionalArgs.get(0);
            start = keywordArgs.getOrDefault(PythonString.valueOf("start"), PythonInteger.ZERO);
        } else if (positionalArgs.size() == 0) {
            iterable = keywordArgs.get(PythonString.valueOf("iterable"));
            start = keywordArgs.getOrDefault(PythonString.valueOf("start"), PythonInteger.ZERO);
        } else {
            throw new ValueError("sum() expects 1 or 2 arguments, got " + positionalArgs.size());
        }
        PythonLikeObject current = start;
        Iterator iterator = (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(iterable));
        while (iterator.hasNext()) {
            PythonLikeObject item = (PythonLikeObject)iterator.next();
            current = BinaryDunderBuiltin.ADD.invoke(current, item);
        }
        return current;
    }

    public static PythonSuperObject superOfCaller(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        if (positionalArgs.isEmpty()) {
            Class<?> callerClass = stackWalker.getCallerClass();
            try {
                PythonLikeType pythonClass = (PythonLikeType)callerClass.getField("__class_cell__").get(null);
                if (pythonClass == null) {
                    throw new RuntimeError("super(): no arguments");
                }
                if (instance != null) {
                    return new PythonSuperObject(pythonClass, instance);
                }
                return new PythonSuperObject(pythonClass);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeError("super(): no arguments");
            }
        }
        if (positionalArgs.size() == 1) {
            PythonLikeType pythonClass = (PythonLikeType)positionalArgs.get(0);
            return new PythonSuperObject(pythonClass);
        }
        if (positionalArgs.size() == 2) {
            PythonLikeType pythonClass = (PythonLikeType)positionalArgs.get(0);
            instance = positionalArgs.get(1);
            return new PythonSuperObject(pythonClass, instance);
        }
        throw new TypeError("super() takes 0 to 2 arguments, got " + positionalArgs.size());
    }

    public static PythonLikeObject vars(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        if (positionalArgs.isEmpty()) {
            throw new ValueError("0-argument version of vars is not supported when executed in Java bytecode");
        }
        return positionalArgs.get(0).$getAttributeOrError("__dict__");
    }

    public static DelegatePythonIterator zip(List<PythonLikeObject> positionalArgs, Map<PythonString, PythonLikeObject> keywordArgs, PythonLikeObject instance) {
        List<PythonLikeObject> iterableList = positionalArgs;
        boolean isStrict = false;
        if (keywordArgs.containsKey(PythonString.valueOf("strict"))) {
            isStrict = ((PythonBoolean)keywordArgs.get(PythonString.valueOf("strict"))).getBooleanValue();
        }
        final ArrayList<Iterator> iteratorList = new ArrayList<Iterator>(iterableList.size());
        for (PythonLikeObject iterable : iterableList) {
            Iterator iterator = iterable instanceof Collection ? ((Collection)((Object)iterable)).iterator() : (iterable instanceof Iterator ? (Iterator)((Object)iterable) : (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(iterable)));
            iteratorList.add(iterator);
        }
        final boolean isStrictFinal = isStrict;
        if (iteratorList.isEmpty()) {
            return new DelegatePythonIterator(iteratorList.iterator());
        }
        Iterator<List<PythonLikeObject>> iteratorIterator = new Iterator<List<PythonLikeObject>>(){

            @Override
            public boolean hasNext() {
                if (isStrictFinal) {
                    int firstWithoutNext = -1;
                    int firstWithNext = -1;
                    for (int i = 0; i < iteratorList.size(); ++i) {
                        if (((Iterator)iteratorList.get(i)).hasNext() && firstWithNext == -1) {
                            firstWithNext = i;
                        } else if (!((Iterator)iteratorList.get(i)).hasNext() && firstWithoutNext == -1) {
                            firstWithoutNext = i;
                        }
                        if (firstWithNext == -1 || firstWithoutNext == -1) continue;
                        throw new ValueError("zip() argument " + firstWithNext + " longer than argument " + firstWithoutNext);
                    }
                    return firstWithoutNext == -1;
                }
                return iteratorList.stream().allMatch(Iterator::hasNext);
            }

            @Override
            public List<PythonLikeObject> next() {
                PythonLikeTuple<PythonLikeObject> out = new PythonLikeTuple<PythonLikeObject>();
                for (Iterator iterator : iteratorList) {
                    out.add((PythonLikeObject)iterator.next());
                }
                return out;
            }
        };
        return new DelegatePythonIterator<List<PythonLikeObject>>(iteratorIterator);
    }

    public static PythonLikeFunction importFunction(PythonInterpreter pythonInterpreter) {
        return (positionalArguments, namedArguments, callerInstance) -> {
            PythonInteger level;
            PythonLikeTuple fromlist;
            PythonLikeDict locals;
            PythonLikeDict globals;
            PythonString name;
            if (positionalArguments.size() == 0) {
                name = (PythonString)namedArguments.get(PythonString.valueOf("name"));
                if (name == null) {
                    throw new ValueError("name is required for __import__()");
                }
                globals = namedArguments.getOrDefault(PythonString.valueOf("globals"), new PythonLikeDict());
                locals = namedArguments.getOrDefault(PythonString.valueOf("locals"), new PythonLikeDict());
                fromlist = namedArguments.getOrDefault(PythonString.valueOf("fromlist"), new PythonLikeTuple());
                level = namedArguments.getOrDefault(PythonString.valueOf("level"), PythonInteger.ZERO);
            } else if (positionalArguments.size() == 1) {
                name = (PythonString)positionalArguments.get(0);
                globals = namedArguments.getOrDefault(PythonString.valueOf("globals"), new PythonLikeDict());
                locals = namedArguments.getOrDefault(PythonString.valueOf("locals"), new PythonLikeDict());
                fromlist = namedArguments.getOrDefault(PythonString.valueOf("fromlist"), new PythonLikeTuple());
                level = namedArguments.getOrDefault(PythonString.valueOf("level"), PythonInteger.ZERO);
            } else if (positionalArguments.size() == 2) {
                name = (PythonString)positionalArguments.get(0);
                globals = (PythonLikeDict)positionalArguments.get(1);
                locals = namedArguments.getOrDefault(PythonString.valueOf("locals"), new PythonLikeDict());
                fromlist = namedArguments.getOrDefault(PythonString.valueOf("fromlist"), new PythonLikeTuple());
                level = namedArguments.getOrDefault(PythonString.valueOf("level"), PythonInteger.ZERO);
            } else if (positionalArguments.size() == 3) {
                name = (PythonString)positionalArguments.get(0);
                globals = (PythonLikeDict)positionalArguments.get(1);
                locals = (PythonLikeDict)positionalArguments.get(2);
                fromlist = namedArguments.getOrDefault(PythonString.valueOf("fromlist"), new PythonLikeTuple());
                level = namedArguments.getOrDefault(PythonString.valueOf("level"), PythonInteger.ZERO);
            } else if (positionalArguments.size() == 4) {
                name = (PythonString)positionalArguments.get(0);
                globals = (PythonLikeDict)positionalArguments.get(1);
                locals = (PythonLikeDict)positionalArguments.get(2);
                fromlist = (PythonLikeTuple)positionalArguments.get(3);
                level = namedArguments.getOrDefault(PythonString.valueOf("level"), PythonInteger.ZERO);
            } else if (positionalArguments.size() == 5) {
                name = (PythonString)positionalArguments.get(0);
                globals = (PythonLikeDict)positionalArguments.get(1);
                locals = (PythonLikeDict)positionalArguments.get(2);
                fromlist = (PythonLikeTuple)positionalArguments.get(3);
                level = (PythonInteger)positionalArguments.get(4);
            } else {
                throw new ValueError("__import__ expects 1 to 5 arguments, got " + positionalArguments.size());
            }
            HashMap<String, PythonLikeObject> stringGlobals = new HashMap<String, PythonLikeObject>();
            HashMap<String, PythonLikeObject> stringLocals = new HashMap<String, PythonLikeObject>();
            for (PythonLikeObject key : globals.keySet()) {
                stringGlobals.put(((PythonString)key).value, (PythonLikeObject)globals.get(key));
            }
            for (PythonLikeObject key : locals.keySet()) {
                stringLocals.put(((PythonString)key).value, (PythonLikeObject)globals.get(key));
            }
            return pythonInterpreter.importModule(level, fromlist, stringGlobals, stringLocals, name.value);
        };
    }

    static {
        GlobalBuiltins.loadBuiltinConstants();
    }

    private static final class KeyTuple
    implements Comparable<KeyTuple> {
        final PythonLikeObject key;
        final int index;
        final PythonLikeObject source;

        public KeyTuple(PythonLikeObject key, int index, PythonLikeObject source) {
            this.key = key;
            this.index = index;
            this.source = source;
        }

        @Override
        public int compareTo(KeyTuple other) {
            PythonBoolean result = (PythonBoolean)BinaryDunderBuiltin.LESS_THAN.invoke(this.key, other.key);
            if (result.getBooleanValue()) {
                return -1;
            }
            result = (PythonBoolean)BinaryDunderBuiltin.LESS_THAN.invoke(other.key, this.key);
            if (result.getBooleanValue()) {
                return 1;
            }
            return this.index - other.index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyTuple keyTuple = (KeyTuple)o;
            return this.index == keyTuple.index && this.key.equals(keyTuple.key);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.index);
        }
    }
}

