/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.dag;

import ai.timefold.jpyinterpreter.opcodes.Opcode;
import java.util.List;
import java.util.Objects;

public class BasicBlock {
    int startAtIndex;
    List<Opcode> blockOpcodeList;

    public BasicBlock(int startAtIndex, List<Opcode> blockOpcodeList) {
        this.startAtIndex = startAtIndex;
        this.blockOpcodeList = blockOpcodeList;
    }

    public int getStartInclusive() {
        return this.startAtIndex;
    }

    public int getEndExclusive() {
        return this.startAtIndex + this.blockOpcodeList.size();
    }

    public Opcode getLeader() {
        return this.blockOpcodeList.get(0);
    }

    public Opcode getFinalOpcode() {
        return this.blockOpcodeList.get(this.blockOpcodeList.size() - 1);
    }

    public boolean containsIndex(int index) {
        return this.getStartInclusive() <= index && index < this.getEndExclusive();
    }

    public List<Opcode> getBlockOpcodeList() {
        return this.blockOpcodeList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicBlock that = (BasicBlock)o;
        return this.startAtIndex == that.startAtIndex;
    }

    public int hashCode() {
        return Objects.hash(this.startAtIndex);
    }

    public String toString() {
        return "BasicBlock{startAtIndex=" + this.startAtIndex + ", blockOpcodeList=" + this.blockOpcodeList + "}";
    }
}

