/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.implementors;

import ai.timefold.jpyinterpreter.ExceptionBlock;
import ai.timefold.jpyinterpreter.FunctionMetadata;
import ai.timefold.jpyinterpreter.LocalVariableHelper;
import ai.timefold.jpyinterpreter.PythonBytecodeInstruction;
import ai.timefold.jpyinterpreter.PythonInterpreter;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.PythonVersion;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.ValueSourceInfo;
import ai.timefold.jpyinterpreter.implementors.CollectionImplementor;
import ai.timefold.jpyinterpreter.implementors.DunderOperatorImplementor;
import ai.timefold.jpyinterpreter.implementors.FunctionImplementor;
import ai.timefold.jpyinterpreter.implementors.PythonConstantsImplementor;
import ai.timefold.jpyinterpreter.implementors.StackManipulationImplementor;
import ai.timefold.jpyinterpreter.opcodes.Opcode;
import ai.timefold.jpyinterpreter.opcodes.OpcodeWithoutSource;
import ai.timefold.jpyinterpreter.types.BoundPythonLikeFunction;
import ai.timefold.jpyinterpreter.types.PythonLikeFunction;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.errors.PythonAssertionError;
import ai.timefold.jpyinterpreter.types.errors.PythonBaseException;
import ai.timefold.jpyinterpreter.types.errors.PythonTraceback;
import ai.timefold.jpyinterpreter.types.errors.StopIteration;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ExceptionImplementor {
    public static void createAssertionError(MethodVisitor methodVisitor) {
        methodVisitor.visitTypeInsn(187, Type.getInternalName(PythonAssertionError.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(PythonAssertionError.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
    }

    public static void reraiseLast(MethodVisitor methodVisitor, LocalVariableHelper localVariableHelper) {
        localVariableHelper.readCurrentException(methodVisitor);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(Throwable.class));
        methodVisitor.visitInsn(191);
    }

    public static void reraise(MethodVisitor methodVisitor) {
        methodVisitor.visitInsn(89);
        methodVisitor.visitTypeInsn(193, Type.getInternalName(Throwable.class));
        Label ifNotThrowable = new Label();
        methodVisitor.visitJumpInsn(153, ifNotThrowable);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(Throwable.class));
        methodVisitor.visitInsn(191);
        methodVisitor.visitLabel(ifNotThrowable);
        CollectionImplementor.buildCollection(PythonLikeTuple.class, methodVisitor, 0);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptyMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), false);
        methodVisitor.visitInsn(1);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(Throwable.class));
        methodVisitor.visitInsn(191);
    }

    public static void raiseWithCause(MethodVisitor methodVisitor) {
        StackManipulationImplementor.swap(methodVisitor);
        Label ifExceptionIsInstanceStart = new Label();
        methodVisitor.visitInsn(89);
        methodVisitor.visitTypeInsn(193, Type.getInternalName(PythonLikeType.class));
        methodVisitor.visitJumpInsn(153, ifExceptionIsInstanceStart);
        FunctionImplementor.callGenericFunction(methodVisitor, 0);
        methodVisitor.visitLabel(ifExceptionIsInstanceStart);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(Throwable.class));
        StackManipulationImplementor.swap(methodVisitor);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(Throwable.class));
        methodVisitor.visitMethodInsn(182, Type.getInternalName(Throwable.class), "initCause", Type.getMethodDescriptor((Type)Type.getType(Throwable.class), (Type[])new Type[]{Type.getType(Throwable.class)}), false);
        ExceptionImplementor.reraise(methodVisitor);
    }

    public static void raiseWithOptionalExceptionAndCause(MethodVisitor methodVisitor, PythonBytecodeInstruction instruction, LocalVariableHelper localVariableHelper) {
        switch (instruction.arg()) {
            case 0: {
                ExceptionImplementor.reraiseLast(methodVisitor, localVariableHelper);
                break;
            }
            case 1: {
                ExceptionImplementor.reraise(methodVisitor);
                break;
            }
            case 2: {
                ExceptionImplementor.raiseWithCause(methodVisitor);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible argc value (" + instruction.arg() + ") for RAISE_VARARGS.");
            }
        }
    }

    public static void createTryFinallyBlock(FunctionMetadata functionMetadata, StackMetadata stackMetadata, int handlerLocation, Map<Integer, Label> bytecodeCounterToLabelMap, BiConsumer<Integer, Runnable> bytecodeCounterCodeArgumentConsumer) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        String className = functionMetadata.className;
        int[] stackLocals = StackManipulationImplementor.storeStack(methodVisitor, stackMetadata);
        Label finallyStart = bytecodeCounterToLabelMap.computeIfAbsent(handlerLocation, key -> new Label());
        Label tryStart = new Label();
        methodVisitor.visitTryCatchBlock(tryStart, finallyStart, finallyStart, Type.getInternalName(PythonBaseException.class));
        methodVisitor.visitLabel(tryStart);
        bytecodeCounterCodeArgumentConsumer.accept(handlerLocation, () -> {
            stackMetadata.localVariableHelper.writeCurrentException(methodVisitor);
            StackManipulationImplementor.restoreStack(methodVisitor, stackMetadata, stackLocals);
            PythonConstantsImplementor.loadNone(methodVisitor);
            methodVisitor.visitLdcInsn((Object)stackMetadata.getStackSize());
            methodVisitor.visitMethodInsn(184, Type.getInternalName(PythonInteger.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(PythonInteger.class), (Type[])new Type[]{Type.INT_TYPE}), false);
            PythonConstantsImplementor.loadNone(methodVisitor);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitTypeInsn(192, className);
            methodVisitor.visitFieldInsn(180, className, "__interpreter__", Type.getDescriptor(PythonInterpreter.class));
            methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonInterpreter.class), "getTraceback", Type.getMethodDescriptor((Type)Type.getType(PythonTraceback.class), (Type[])new Type[0]), true);
            stackMetadata.localVariableHelper.readCurrentException(methodVisitor);
            methodVisitor.visitInsn(89);
        });
    }

    public static void startExceptOrFinally(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        LocalVariableHelper localVariableHelper = stackMetadata.localVariableHelper;
        methodVisitor.visitInsn(1);
        localVariableHelper.writeCurrentException(methodVisitor);
        if (functionMetadata.pythonCompiledFunction.pythonVersion.isAtLeast(PythonVersion.PYTHON_3_11)) {
            methodVisitor.visitInsn(87);
        } else {
            methodVisitor.visitInsn(87);
            methodVisitor.visitInsn(87);
            methodVisitor.visitInsn(87);
        }
    }

    public static void setupWith(int jumpTarget, FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
        methodVisitor.visitLdcInsn((Object)"__exit__");
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrError", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonLikeFunction.class));
        methodVisitor.visitTypeInsn(187, Type.getInternalName(BoundPythonLikeFunction.class));
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(87);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(BoundPythonLikeFunction.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonLikeObject.class), Type.getType(PythonLikeFunction.class)}), false);
        methodVisitor.visitInsn(95);
        DunderOperatorImplementor.unaryOperator(methodVisitor, stackMetadata, PythonUnaryOperator.ENTER);
        int enterResult = stackMetadata.localVariableHelper.newLocal();
        stackMetadata.localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), enterResult);
        StackMetadata currentStackMetadata = stackMetadata.pop().push(ValueSourceInfo.of((Opcode)new OpcodeWithoutSource(), PythonLikeFunction.getFunctionType(), stackMetadata.getTOSValueSource()));
        ExceptionImplementor.createTryFinallyBlock(functionMetadata, currentStackMetadata, jumpTarget, functionMetadata.bytecodeCounterToLabelMap, (bytecodeIndex, runnable) -> functionMetadata.bytecodeCounterToCodeArgumenterList.computeIfAbsent((Integer)bytecodeIndex, key -> new ArrayList()).add(runnable));
        stackMetadata.localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), enterResult);
    }

    public static void beforeWith(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
        methodVisitor.visitLdcInsn((Object)"__exit__");
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getAttributeOrError", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(String.class)}), true);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonLikeFunction.class));
        methodVisitor.visitTypeInsn(187, Type.getInternalName(BoundPythonLikeFunction.class));
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(91);
        methodVisitor.visitInsn(87);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(BoundPythonLikeFunction.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PythonLikeObject.class), Type.getType(PythonLikeFunction.class)}), false);
        methodVisitor.visitInsn(95);
        DunderOperatorImplementor.unaryOperator(methodVisitor, stackMetadata, PythonUnaryOperator.ENTER);
        int enterResult = stackMetadata.localVariableHelper.newLocal();
        stackMetadata.localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), enterResult);
        stackMetadata.localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), enterResult);
    }

    public static void startExceptBlock(FunctionMetadata functionMetadata, StackMetadata stackMetadata, ExceptionBlock exceptionBlock) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        stackMetadata.localVariableHelper.writeCurrentException(methodVisitor);
        StackManipulationImplementor.restoreExceptionTableStack(functionMetadata, stackMetadata, exceptionBlock);
        if (exceptionBlock.isPushLastIndex()) {
            methodVisitor.visitFieldInsn(178, Type.getInternalName(PythonInteger.class), "ZERO", Type.getDescriptor(PythonInteger.class));
        }
        stackMetadata.localVariableHelper.readCurrentException(methodVisitor);
    }

    public static void pushExcInfo(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        LocalVariableHelper localVariableHelper = stackMetadata.localVariableHelper;
        localVariableHelper.readCurrentException(methodVisitor);
        methodVisitor.visitInsn(95);
    }

    public static void checkExcMatch(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        methodVisitor.visitInsn(92);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonLikeType.class));
        methodVisitor.visitInsn(95);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(PythonLikeType.class), "isInstance", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(PythonLikeObject.class)}), false);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(PythonBoolean.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(PythonBoolean.class), (Type[])new Type[]{Type.BOOLEAN_TYPE}), false);
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(87);
    }

    public static void handleExceptionInWith(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        LocalVariableHelper localVariableHelper = stackMetadata.localVariableHelper;
        int exception = localVariableHelper.newLocal();
        int exceptionArgs = localVariableHelper.newLocal();
        int traceback = localVariableHelper.newLocal();
        int label = localVariableHelper.newLocal();
        int stackSize = localVariableHelper.newLocal();
        int instruction = localVariableHelper.newLocal();
        int exitFunction = localVariableHelper.newLocal();
        if (functionMetadata.pythonCompiledFunction.pythonVersion.isBefore(PythonVersion.PYTHON_3_11)) {
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), exception);
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), exceptionArgs);
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), traceback);
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), label);
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), stackSize);
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), instruction);
        } else {
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), exception);
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), exceptionArgs);
            localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), traceback);
        }
        localVariableHelper.writeTemp(methodVisitor, Type.getType(PythonLikeObject.class), exitFunction);
        localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), exitFunction);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonLikeFunction.class));
        methodVisitor.visitTypeInsn(187, Type.getInternalName(ArrayList.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)3);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(ArrayList.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE}), false);
        methodVisitor.visitInsn(89);
        localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), exception);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeObject.class), "$getType", Type.getMethodDescriptor((Type)Type.getType(PythonLikeType.class), (Type[])new Type[0]), true);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(Collection.class), "add", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), true);
        methodVisitor.visitInsn(87);
        methodVisitor.visitInsn(89);
        localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), exception);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(Collection.class), "add", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), true);
        methodVisitor.visitInsn(87);
        methodVisitor.visitInsn(89);
        localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), traceback);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(Collection.class), "add", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), true);
        methodVisitor.visitInsn(87);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptyMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), false);
        methodVisitor.visitInsn(1);
        methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonLikeFunction.class), "$call", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(List.class), Type.getType(Map.class), Type.getType(PythonLikeObject.class)}), true);
        localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), exitFunction);
        methodVisitor.visitInsn(95);
        if (functionMetadata.pythonCompiledFunction.pythonVersion.isBefore(PythonVersion.PYTHON_3_11)) {
            localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), instruction);
            methodVisitor.visitInsn(95);
            localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), stackSize);
            methodVisitor.visitInsn(95);
            localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), label);
            methodVisitor.visitInsn(95);
        }
        localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), traceback);
        methodVisitor.visitInsn(95);
        localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), exceptionArgs);
        methodVisitor.visitInsn(95);
        localVariableHelper.readTemp(methodVisitor, Type.getType(PythonLikeObject.class), exception);
        methodVisitor.visitInsn(95);
        localVariableHelper.freeLocal();
        localVariableHelper.freeLocal();
        localVariableHelper.freeLocal();
        localVariableHelper.freeLocal();
        localVariableHelper.freeLocal();
        localVariableHelper.freeLocal();
        localVariableHelper.freeLocal();
    }

    public static void getValueFromStopIterationOrReraise(FunctionMetadata functionMetadata, StackMetadata stackMetadata) {
        MethodVisitor methodVisitor = functionMetadata.methodVisitor;
        Label isStopIteration = new Label();
        methodVisitor.visitInsn(89);
        methodVisitor.visitTypeInsn(193, Type.getInternalName(StopIteration.class));
        methodVisitor.visitJumpInsn(154, isStopIteration);
        ExceptionImplementor.reraise(methodVisitor);
        methodVisitor.visitLabel(isStopIteration);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(StopIteration.class));
        methodVisitor.visitMethodInsn(182, Type.getInternalName(StopIteration.class), "getValue", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[0]), false);
    }
}

