/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.implementors;

import ai.timefold.jpyinterpreter.CompareOp;
import ai.timefold.jpyinterpreter.PythonClassTranslator;
import ai.timefold.jpyinterpreter.PythonCompiledClass;
import ai.timefold.jpyinterpreter.PythonCompiledFunction;
import ai.timefold.jpyinterpreter.implementors.JavaInterfaceImplementor;
import ai.timefold.jpyinterpreter.implementors.PythonConstantsImplementor;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.errors.NotImplementedError;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class JavaComparableImplementor
extends JavaInterfaceImplementor {
    final String internalClassName;
    final CompareOp compareOp;

    public JavaComparableImplementor(String internalClassName, String method) {
        this.internalClassName = internalClassName;
        this.compareOp = CompareOp.getOpForDunderMethod(method);
        switch (this.compareOp) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUALS: {
                break;
            }
            default: {
                throw new IllegalStateException("Cannot use " + method + " for comparisons");
            }
        }
    }

    @Override
    public Class<?> getInterfaceClass() {
        return Comparable.class;
    }

    private void typeCheck(MethodVisitor methodVisitor) {
        methodVisitor.visitInsn(89);
        methodVisitor.visitTypeInsn(193, this.internalClassName);
        Label isInstanceOfClass = new Label();
        methodVisitor.visitJumpInsn(154, isInstanceOfClass);
        methodVisitor.visitTypeInsn(187, Type.getInternalName(NotImplementedError.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn((Object)("compareTo arg 0 is not an instance of " + this.internalClassName));
        methodVisitor.visitMethodInsn(183, Type.getInternalName(NotImplementedError.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)}), false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitLabel(isInstanceOfClass);
        methodVisitor.visitTypeInsn(192, this.internalClassName);
    }

    @Override
    public void implement(ClassWriter classWriter, PythonCompiledClass compiledClass) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "compareTo", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(Object.class)}), null, null);
        methodVisitor.visitParameter("other", 0);
        methodVisitor.visitCode();
        switch (this.compareOp) {
            case LESS_THAN: {
                this.implementCompareToWithLessThan(methodVisitor, compiledClass);
                break;
            }
            case LESS_THAN_OR_EQUALS: {
                this.implementCompareToWithLessThanOrEqual(methodVisitor, compiledClass);
                break;
            }
            case GREATER_THAN: {
                this.implementCompareToWithGreaterThan(methodVisitor, compiledClass);
                break;
            }
            case GREATER_THAN_OR_EQUALS: {
                this.implementCompareToWithGreaterThanOrEqual(methodVisitor, compiledClass);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: " + this.compareOp + " is not a comparison operator");
            }
        }
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void implementCompareToWithLessThan(MethodVisitor methodVisitor, PythonCompiledClass pythonCompiledClass) {
        PythonCompiledFunction comparisonFunction = pythonCompiledClass.instanceFunctionNameToPythonBytecode.get("__lt__");
        String comparisonMethodName = PythonClassTranslator.getJavaMethodName("__lt__");
        this.implementCompareTo(methodVisitor, comparisonFunction, comparisonMethodName, false, true);
    }

    private void implementCompareToWithGreaterThan(MethodVisitor methodVisitor, PythonCompiledClass pythonCompiledClass) {
        PythonCompiledFunction comparisonFunction = pythonCompiledClass.instanceFunctionNameToPythonBytecode.get("__gt__");
        String comparisonMethodName = PythonClassTranslator.getJavaMethodName("__gt__");
        this.implementCompareTo(methodVisitor, comparisonFunction, comparisonMethodName, false, false);
    }

    private void implementCompareToWithLessThanOrEqual(MethodVisitor methodVisitor, PythonCompiledClass pythonCompiledClass) {
        PythonCompiledFunction comparisonFunction = pythonCompiledClass.instanceFunctionNameToPythonBytecode.get("__le__");
        String comparisonMethodName = PythonClassTranslator.getJavaMethodName("__le__");
        this.implementCompareTo(methodVisitor, comparisonFunction, comparisonMethodName, true, false);
    }

    private void implementCompareToWithGreaterThanOrEqual(MethodVisitor methodVisitor, PythonCompiledClass pythonCompiledClass) {
        PythonCompiledFunction comparisonFunction = pythonCompiledClass.instanceFunctionNameToPythonBytecode.get("__ge__");
        String comparisonMethodName = PythonClassTranslator.getJavaMethodName("__ge__");
        this.implementCompareTo(methodVisitor, comparisonFunction, comparisonMethodName, true, true);
    }

    private void implementCompareTo(MethodVisitor methodVisitor, PythonCompiledFunction comparisonFunction, String comparisonMethodName, boolean negateComparisionResult, boolean isLessThan) {
        PythonLikeType parameterType = comparisonFunction.getParameterTypes().get(1);
        Type returnType = PythonClassTranslator.getVirtualFunctionReturnType(comparisonFunction);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        this.typeCheck(methodVisitor);
        methodVisitor.visitInsn(92);
        methodVisitor.visitMethodInsn(182, this.internalClassName, comparisonMethodName, Type.getMethodDescriptor((Type)returnType, (Type[])new Type[]{Type.getType((String)parameterType.getJavaTypeDescriptor())}), false);
        Label ifSelfNotLessThanOther = new Label();
        if (negateComparisionResult) {
            PythonConstantsImplementor.loadFalse(methodVisitor);
        } else {
            PythonConstantsImplementor.loadTrue(methodVisitor);
        }
        methodVisitor.visitJumpInsn(166, ifSelfNotLessThanOther);
        methodVisitor.visitInsn(isLessThan ? 2 : 4);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(ifSelfNotLessThanOther);
        methodVisitor.visitInsn(95);
        methodVisitor.visitMethodInsn(182, this.internalClassName, comparisonMethodName, Type.getMethodDescriptor((Type)returnType, (Type[])new Type[]{Type.getType((String)parameterType.getJavaTypeDescriptor())}), false);
        Label ifOtherNotLessThanSelf = new Label();
        if (negateComparisionResult) {
            PythonConstantsImplementor.loadFalse(methodVisitor);
        } else {
            PythonConstantsImplementor.loadTrue(methodVisitor);
        }
        methodVisitor.visitJumpInsn(166, ifOtherNotLessThanSelf);
        methodVisitor.visitInsn(isLessThan ? 4 : 2);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(ifOtherNotLessThanSelf);
        methodVisitor.visitInsn(3);
        methodVisitor.visitInsn(172);
    }
}

