/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.implementors;

import ai.timefold.jpyinterpreter.LocalVariableHelper;
import ai.timefold.jpyinterpreter.MethodDescriptor;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.StackMetadata;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.Coercible;
import ai.timefold.jpyinterpreter.types.PythonByteArray;
import ai.timefold.jpyinterpreter.types.PythonBytes;
import ai.timefold.jpyinterpreter.types.PythonCode;
import ai.timefold.jpyinterpreter.types.PythonLikeFunction;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonNone;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.DelegatePythonIterator;
import ai.timefold.jpyinterpreter.types.collections.PythonIterator;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeDict;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeFrozenSet;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeList;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeSet;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeTuple;
import ai.timefold.jpyinterpreter.types.errors.TypeError;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonDecimal;
import ai.timefold.jpyinterpreter.types.numeric.PythonFloat;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.jpyinterpreter.types.numeric.PythonNumber;
import ai.timefold.jpyinterpreter.types.wrappers.JavaObjectWrapper;
import ai.timefold.jpyinterpreter.types.wrappers.OpaqueJavaReference;
import ai.timefold.jpyinterpreter.types.wrappers.OpaquePythonReference;
import ai.timefold.jpyinterpreter.types.wrappers.PythonObjectWrapper;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class JavaPythonTypeConversionImplementor {
    private static final Map<Type, ReturnValueOpDescriptor> numericReturnValueOpDescriptorMap = Map.of(Type.BYTE_TYPE, ReturnValueOpDescriptor.forNumeric("byteValue", Type.getMethodDescriptor((Type)Type.BYTE_TYPE, (Type[])new Type[0]), 172), Type.SHORT_TYPE, ReturnValueOpDescriptor.forNumeric("shortValue", Type.getMethodDescriptor((Type)Type.SHORT_TYPE, (Type[])new Type[0]), 172), Type.INT_TYPE, ReturnValueOpDescriptor.forNumeric("intValue", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), 172), Type.LONG_TYPE, ReturnValueOpDescriptor.forNumeric("longValue", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), 173), Type.FLOAT_TYPE, ReturnValueOpDescriptor.forNumeric("floatValue", Type.getMethodDescriptor((Type)Type.FLOAT_TYPE, (Type[])new Type[0]), 174), Type.DOUBLE_TYPE, ReturnValueOpDescriptor.forNumeric("doubleValue", Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[0]), 175), Type.getType(BigInteger.class), ReturnValueOpDescriptor.noConversion(), Type.getType(BigDecimal.class), ReturnValueOpDescriptor.noConversion());

    public static PythonLikeObject wrapJavaObject(Object object) {
        return JavaPythonTypeConversionImplementor.wrapJavaObject(object, new IdentityHashMap<Object, PythonLikeObject>());
    }

    public static PythonLikeObject wrapJavaObject(Object object, Map<Object, PythonLikeObject> createdObjectMap) {
        Class maybeFunctionClass;
        if (object == null) {
            return PythonNone.INSTANCE;
        }
        PythonLikeObject existingObject = createdObjectMap.get(object);
        if (existingObject != null) {
            return existingObject;
        }
        if (object instanceof OpaqueJavaReference) {
            OpaqueJavaReference opaqueJavaReference = (OpaqueJavaReference)object;
            return opaqueJavaReference.proxy();
        }
        if (object instanceof PythonLikeObject) {
            PythonLikeObject instance = (PythonLikeObject)object;
            return instance;
        }
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            return PythonInteger.valueOf(((Number)object).longValue());
        }
        if (object instanceof BigInteger) {
            BigInteger integer = (BigInteger)object;
            return PythonInteger.valueOf(integer);
        }
        if (object instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)object;
            return new PythonDecimal(decimal);
        }
        if (object instanceof Float || object instanceof Double) {
            return PythonFloat.valueOf(((Number)object).doubleValue());
        }
        if (object instanceof Boolean) {
            Boolean booleanValue = (Boolean)object;
            return PythonBoolean.valueOf(booleanValue);
        }
        if (object instanceof String) {
            String string = (String)object;
            return PythonString.valueOf(string);
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            return new DelegatePythonIterator(iterator);
        }
        if (object instanceof List) {
            List list = (List)object;
            PythonLikeList out = new PythonLikeList();
            createdObjectMap.put(object, out);
            for (Object item : list) {
                out.add(JavaPythonTypeConversionImplementor.wrapJavaObject(item));
            }
            return out;
        }
        if (object instanceof Set) {
            Set set = (Set)object;
            PythonLikeSet out = new PythonLikeSet();
            createdObjectMap.put(object, out);
            for (Object item : set) {
                out.add(JavaPythonTypeConversionImplementor.wrapJavaObject(item));
            }
            return out;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            PythonLikeDict out = new PythonLikeDict();
            createdObjectMap.put(object, out);
            Set entrySet = map.entrySet();
            for (Map.Entry entry : entrySet) {
                out.put(JavaPythonTypeConversionImplementor.wrapJavaObject(entry.getKey()), JavaPythonTypeConversionImplementor.wrapJavaObject(entry.getValue()));
            }
            return out;
        }
        if (object instanceof Class && Set.of((maybeFunctionClass = (Class)object).getInterfaces()).contains(PythonLikeFunction.class)) {
            return new PythonCode(maybeFunctionClass);
        }
        if (object instanceof OpaquePythonReference) {
            OpaquePythonReference opaquePythonReference = (OpaquePythonReference)object;
            return new PythonObjectWrapper(opaquePythonReference);
        }
        return new JavaObjectWrapper(object, createdObjectMap);
    }

    public static PythonLikeType getPythonLikeType(Class<?> javaClass) {
        if (PythonNone.class.equals(javaClass)) {
            return BuiltinTypes.NONE_TYPE;
        }
        if (PythonLikeObject.class.equals(javaClass)) {
            return BuiltinTypes.BASE_TYPE;
        }
        if (Byte.TYPE.equals(javaClass) || Short.TYPE.equals(javaClass) || Integer.TYPE.equals(javaClass) || Long.TYPE.equals(javaClass) || Byte.class.equals(javaClass) || Short.class.equals(javaClass) || Integer.class.equals(javaClass) || Long.class.equals(javaClass) || BigInteger.class.equals(javaClass) || PythonInteger.class.equals(javaClass)) {
            return BuiltinTypes.INT_TYPE;
        }
        if (BigDecimal.class.equals(javaClass) || PythonDecimal.class.equals(javaClass)) {
            return BuiltinTypes.DECIMAL_TYPE;
        }
        if (Float.TYPE.equals(javaClass) || Double.TYPE.equals(javaClass) || Float.class.equals(javaClass) || Double.class.equals(javaClass) || PythonFloat.class.equals(javaClass)) {
            return BuiltinTypes.FLOAT_TYPE;
        }
        if (PythonNumber.class.equals(javaClass)) {
            return BuiltinTypes.NUMBER_TYPE;
        }
        if (Boolean.TYPE.equals(javaClass) || Boolean.class.equals(javaClass) || PythonBoolean.class.equals(javaClass)) {
            return BuiltinTypes.BOOLEAN_TYPE;
        }
        if (String.class.equals(javaClass) || PythonString.class.equals(javaClass)) {
            return BuiltinTypes.STRING_TYPE;
        }
        if (PythonBytes.class.equals(javaClass)) {
            return BuiltinTypes.BYTES_TYPE;
        }
        if (PythonByteArray.class.equals(javaClass)) {
            return BuiltinTypes.BYTE_ARRAY_TYPE;
        }
        if (Iterator.class.equals(javaClass) || PythonIterator.class.equals(javaClass)) {
            return BuiltinTypes.ITERATOR_TYPE;
        }
        if (List.class.equals(javaClass) || PythonLikeList.class.equals(javaClass)) {
            return BuiltinTypes.LIST_TYPE;
        }
        if (PythonLikeTuple.class.equals(javaClass)) {
            return BuiltinTypes.TUPLE_TYPE;
        }
        if (Set.class.equals(javaClass) || PythonLikeSet.class.equals(javaClass)) {
            return BuiltinTypes.SET_TYPE;
        }
        if (PythonLikeFrozenSet.class.equals(javaClass)) {
            return BuiltinTypes.FROZEN_SET_TYPE;
        }
        if (Map.class.equals(javaClass) || PythonLikeDict.class.equals(javaClass)) {
            return BuiltinTypes.DICT_TYPE;
        }
        if (PythonLikeType.class.equals(javaClass)) {
            return BuiltinTypes.TYPE_TYPE;
        }
        try {
            Field typeField = javaClass.getField("$TYPE");
            Object maybeType = typeField.get(null);
            if (maybeType instanceof PythonLikeType) {
                return (PythonLikeType)maybeType;
            }
            if (PythonLikeFunction.class.isAssignableFrom(javaClass)) {
                return PythonLikeFunction.getFunctionType();
            }
            return JavaObjectWrapper.getPythonTypeForClass(javaClass);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            if (PythonLikeFunction.class.isAssignableFrom(javaClass)) {
                return PythonLikeFunction.getFunctionType();
            }
            return JavaObjectWrapper.getPythonTypeForClass(javaClass);
        }
    }

    public static <T> T convertPythonObjectToJavaType(Class<? extends T> type, PythonLikeObject object) {
        if (object == null || type.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        if (object instanceof PythonNone) {
            return null;
        }
        if (object instanceof JavaObjectWrapper) {
            JavaObjectWrapper wrappedObject = (JavaObjectWrapper)object;
            Object javaObject = wrappedObject.getWrappedObject();
            if (!type.isAssignableFrom(javaObject.getClass())) {
                throw new TypeError("Cannot convert from (" + JavaPythonTypeConversionImplementor.getPythonLikeType(javaObject.getClass()) + ") to (" + JavaPythonTypeConversionImplementor.getPythonLikeType(type) + ").");
            }
            return (T)javaObject;
        }
        if (type.equals(Byte.TYPE) || type.equals(Short.TYPE) || type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Float.TYPE) || type.equals(Double.TYPE) || Number.class.isAssignableFrom(type)) {
            if (!(object instanceof PythonNumber)) {
                throw new TypeError("Cannot convert from (" + JavaPythonTypeConversionImplementor.getPythonLikeType(object.getClass()) + ") to (" + JavaPythonTypeConversionImplementor.getPythonLikeType(type) + ").");
            }
            PythonNumber pythonNumber = (PythonNumber)object;
            Number value = pythonNumber.getValue();
            if (type.equals(BigInteger.class) || type.equals(BigDecimal.class)) {
                return (T)value;
            }
            if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                return (T)Byte.valueOf(value.byteValue());
            }
            if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                return (T)Short.valueOf(value.shortValue());
            }
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                return (T)Integer.valueOf(value.intValue());
            }
            if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                return (T)Long.valueOf(value.longValue());
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                return (T)Float.valueOf(value.floatValue());
            }
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                return (T)Double.valueOf(value.doubleValue());
            }
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            if (!(object instanceof PythonBoolean)) {
                throw new TypeError("Cannot convert from (" + JavaPythonTypeConversionImplementor.getPythonLikeType(object.getClass()) + ") to (" + JavaPythonTypeConversionImplementor.getPythonLikeType(type) + ").");
            }
            PythonBoolean pythonBoolean = (PythonBoolean)object;
            return (T)Boolean.valueOf(pythonBoolean.getBooleanValue());
        }
        if (type.equals(String.class)) {
            PythonString pythonString = (PythonString)object;
            return (T)pythonString.getValue();
        }
        throw new TypeError("Cannot convert from (" + JavaPythonTypeConversionImplementor.getPythonLikeType(object.getClass()) + ") to (" + JavaPythonTypeConversionImplementor.getPythonLikeType(type) + ").");
    }

    public static void loadName(MethodVisitor methodVisitor, String name) {
        methodVisitor.visitLdcInsn((Object)name);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(PythonString.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(PythonString.class), (Type[])new Type[]{Type.getType(PythonString.class)}), false);
    }

    public static void unboxBoxedPrimitiveType(Class<?> primitiveType, MethodVisitor methodVisitor) {
        JavaPythonTypeConversionImplementor.unboxBoxedPrimitiveType(Type.getType(primitiveType), methodVisitor);
    }

    public static void unboxBoxedPrimitiveType(Type primitiveType, MethodVisitor methodVisitor) {
        if (primitiveType.equals((Object)Type.BOOLEAN_TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Boolean.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]), false);
        } else if (primitiveType.equals((Object)Type.BYTE_TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Byte.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Byte.class), "byteValue", Type.getMethodDescriptor((Type)Type.BYTE_TYPE, (Type[])new Type[0]), false);
        } else if (primitiveType.equals((Object)Type.CHAR_TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Character.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Character.class), "charValue", Type.getMethodDescriptor((Type)Type.CHAR_TYPE, (Type[])new Type[0]), false);
        } else if (primitiveType.equals((Object)Type.SHORT_TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Short.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Short.class), "shortValue", Type.getMethodDescriptor((Type)Type.SHORT_TYPE, (Type[])new Type[0]), false);
        } else if (primitiveType.equals((Object)Type.INT_TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Integer.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Integer.class), "intValue", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), false);
        } else if (primitiveType.equals((Object)Type.LONG_TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Long.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Long.class), "longValue", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]), false);
        } else if (primitiveType.equals((Object)Type.FLOAT_TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Float.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Float.class), "floatValue", Type.getMethodDescriptor((Type)Type.FLOAT_TYPE, (Type[])new Type[0]), false);
        } else if (primitiveType.equals((Object)Type.DOUBLE_TYPE)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(Double.class));
            methodVisitor.visitMethodInsn(182, Type.getInternalName(Double.class), "doubleValue", Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[0]), false);
        } else {
            throw new IllegalStateException("Unknown primitive type %s.".formatted(primitiveType));
        }
    }

    public static void boxPrimitiveType(Class<?> primitiveType, MethodVisitor methodVisitor) {
        JavaPythonTypeConversionImplementor.boxPrimitiveType(Type.getType(primitiveType), methodVisitor);
    }

    public static void boxPrimitiveType(Type primitiveType, MethodVisitor methodVisitor) {
        if (primitiveType.equals((Object)Type.BOOLEAN_TYPE)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Boolean.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Boolean.class), (Type[])new Type[]{Type.BOOLEAN_TYPE}), false);
        } else if (primitiveType.equals((Object)Type.BYTE_TYPE)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Byte.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Byte.class), (Type[])new Type[]{Type.BYTE_TYPE}), false);
        } else if (primitiveType.equals((Object)Type.CHAR_TYPE)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Character.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Character.class), (Type[])new Type[]{Type.CHAR_TYPE}), false);
        } else if (primitiveType.equals((Object)Type.SHORT_TYPE)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Short.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Short.class), (Type[])new Type[]{Type.SHORT_TYPE}), false);
        } else if (primitiveType.equals((Object)Type.INT_TYPE)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Integer.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Integer.class), (Type[])new Type[]{Type.INT_TYPE}), false);
        } else if (primitiveType.equals((Object)Type.LONG_TYPE)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Long.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Long.class), (Type[])new Type[]{Type.LONG_TYPE}), false);
        } else if (primitiveType.equals((Object)Type.FLOAT_TYPE)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Float.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Float.class), (Type[])new Type[]{Type.FLOAT_TYPE}), false);
        } else if (primitiveType.equals((Object)Type.DOUBLE_TYPE)) {
            methodVisitor.visitMethodInsn(184, Type.getInternalName(Double.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(Double.class), (Type[])new Type[]{Type.DOUBLE_TYPE}), false);
        } else {
            throw new IllegalStateException("Unknown primitive type %s.".formatted(primitiveType));
        }
    }

    public static void loadTypeClass(Class<?> type, MethodVisitor methodVisitor) {
        JavaPythonTypeConversionImplementor.loadTypeClass(Type.getType(type), methodVisitor);
    }

    public static void loadTypeClass(Type type, MethodVisitor methodVisitor) {
        if (type.equals((Object)Type.BOOLEAN_TYPE)) {
            methodVisitor.visitLdcInsn((Object)Type.getType(Boolean.class));
        } else if (type.equals((Object)Type.BYTE_TYPE)) {
            methodVisitor.visitLdcInsn((Object)Type.getType(Byte.class));
        } else if (type.equals((Object)Type.CHAR_TYPE)) {
            methodVisitor.visitLdcInsn((Object)Type.getType(Character.class));
        } else if (type.equals((Object)Type.SHORT_TYPE)) {
            methodVisitor.visitLdcInsn((Object)Type.getType(Short.class));
        } else if (type.equals((Object)Type.INT_TYPE)) {
            methodVisitor.visitLdcInsn((Object)Type.getType(Integer.class));
        } else if (type.equals((Object)Type.LONG_TYPE)) {
            methodVisitor.visitLdcInsn((Object)Type.getType(Long.class));
        } else if (type.equals((Object)Type.FLOAT_TYPE)) {
            methodVisitor.visitLdcInsn((Object)Type.getType(Float.class));
        } else if (type.equals((Object)Type.DOUBLE_TYPE)) {
            methodVisitor.visitLdcInsn((Object)Type.getType(Double.class));
        } else {
            methodVisitor.visitLdcInsn((Object)type);
        }
    }

    public static void returnValue(MethodVisitor methodVisitor, MethodDescriptor method, StackMetadata stackMetadata) {
        Type returnAsmType = method.getReturnType();
        if (Type.CHAR_TYPE.equals((Object)returnAsmType)) {
            throw new IllegalStateException("Unhandled case for primitive type (char).");
        }
        if (Type.VOID_TYPE.equals((Object)returnAsmType)) {
            methodVisitor.visitInsn(177);
            return;
        }
        if (numericReturnValueOpDescriptorMap.containsKey(returnAsmType)) {
            ReturnValueOpDescriptor returnValueOpDescriptor = numericReturnValueOpDescriptorMap.get(returnAsmType);
            methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonNumber.class));
            methodVisitor.visitMethodInsn(185, Type.getInternalName(PythonNumber.class), "getValue", Type.getMethodDescriptor((Type)Type.getType(Number.class), (Type[])new Type[0]), true);
            if (returnValueOpDescriptor.noConversionNeeded) {
                methodVisitor.visitTypeInsn(192, returnAsmType.getInternalName());
                methodVisitor.visitInsn(176);
                return;
            }
            methodVisitor.visitMethodInsn(182, returnValueOpDescriptor.wrapperClassName, returnValueOpDescriptor.methodName, returnValueOpDescriptor.methodDescriptor, false);
            methodVisitor.visitInsn(returnValueOpDescriptor.opcode);
            return;
        }
        if (Type.BOOLEAN_TYPE.equals((Object)returnAsmType)) {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(PythonBoolean.class));
            String wrapperClassName = Type.getInternalName(PythonBoolean.class);
            String methodName = "getBooleanValue";
            String methodDescriptor = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]);
            int returnOpcode = 172;
            methodVisitor.visitMethodInsn(182, wrapperClassName, methodName, methodDescriptor, false);
            methodVisitor.visitInsn(returnOpcode);
            return;
        }
        try {
            Class<?> returnTypeClass = Class.forName(returnAsmType.getClassName(), true, BuiltinTypes.asmClassLoader);
            if (stackMetadata.getTOSType() == null) {
                throw new IllegalStateException("Cannot return a deleted or undefined value");
            }
            Class<?> tosTypeClass = stackMetadata.getTOSType().getJavaClass();
            if (returnTypeClass.isAssignableFrom(tosTypeClass)) {
                methodVisitor.visitTypeInsn(192, returnAsmType.getInternalName());
                methodVisitor.visitInsn(176);
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        methodVisitor.visitLdcInsn((Object)returnAsmType);
        methodVisitor.visitInsn(95);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(JavaPythonTypeConversionImplementor.class), "convertPythonObjectToJavaType", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Class.class), Type.getType(PythonLikeObject.class)}), false);
        methodVisitor.visitTypeInsn(192, returnAsmType.getInternalName());
        methodVisitor.visitInsn(176);
    }

    public static <T> T coerceToType(PythonLikeObject value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        if (value instanceof Coercible) {
            Coercible coercible = (Coercible)((Object)value);
            T out = coercible.coerce(type);
            if (out == null) {
                throw new TypeError("%s cannot be coerced to %s.".formatted(value.$getType(), type));
            }
            return out;
        }
        throw new TypeError("%s cannot be coerced to %s.".formatted(value.$getType(), type));
    }

    public static void copyParameter(MethodVisitor methodVisitor, LocalVariableHelper localVariableHelper, int parameterIndex) {
        Type parameterType = localVariableHelper.parameters[parameterIndex];
        if (parameterType.getSort() != 10 && parameterType.getSort() != 9) {
            String valueOfDescriptor;
            String valueOfOwner;
            int loadOpcode;
            if (Type.BOOLEAN_TYPE.equals((Object)parameterType)) {
                loadOpcode = 21;
                valueOfOwner = Type.getInternalName(PythonBoolean.class);
                valueOfDescriptor = Type.getMethodDescriptor((Type)Type.getType(PythonBoolean.class), (Type[])new Type[]{Type.getType(Boolean.TYPE)});
            } else {
                if (Type.CHAR_TYPE.equals((Object)parameterType)) {
                    int loadOpcode2 = 21;
                    throw new IllegalStateException("Unhandled case for primitive type (" + parameterType + ").");
                }
                if (Type.BYTE_TYPE.equals((Object)parameterType)) {
                    loadOpcode = 21;
                    valueOfOwner = Type.getInternalName(PythonInteger.class);
                    valueOfDescriptor = Type.getMethodDescriptor((Type)Type.getType(PythonInteger.class), (Type[])new Type[]{Type.getType(Byte.TYPE)});
                } else if (Type.SHORT_TYPE.equals((Object)parameterType)) {
                    loadOpcode = 21;
                    valueOfOwner = Type.getInternalName(PythonInteger.class);
                    valueOfDescriptor = Type.getMethodDescriptor((Type)Type.getType(PythonInteger.class), (Type[])new Type[]{Type.getType(Short.TYPE)});
                } else if (Type.INT_TYPE.equals((Object)parameterType)) {
                    loadOpcode = 21;
                    valueOfOwner = Type.getInternalName(PythonInteger.class);
                    valueOfDescriptor = Type.getMethodDescriptor((Type)Type.getType(PythonInteger.class), (Type[])new Type[]{Type.getType(Integer.TYPE)});
                } else if (Type.FLOAT_TYPE.equals((Object)parameterType)) {
                    loadOpcode = 23;
                    valueOfOwner = Type.getInternalName(PythonFloat.class);
                    valueOfDescriptor = Type.getMethodDescriptor((Type)Type.getType(PythonFloat.class), (Type[])new Type[]{Type.getType(Float.TYPE)});
                } else if (Type.LONG_TYPE.equals((Object)parameterType)) {
                    loadOpcode = 22;
                    valueOfOwner = Type.getInternalName(PythonInteger.class);
                    valueOfDescriptor = Type.getMethodDescriptor((Type)Type.getType(PythonInteger.class), (Type[])new Type[]{Type.getType(Long.TYPE)});
                } else if (Type.DOUBLE_TYPE.equals((Object)parameterType)) {
                    loadOpcode = 24;
                    valueOfOwner = Type.getInternalName(PythonFloat.class);
                    valueOfDescriptor = Type.getMethodDescriptor((Type)Type.getType(PythonFloat.class), (Type[])new Type[]{Type.getType(Double.TYPE)});
                } else {
                    throw new IllegalStateException("Unhandled case for primitive type (" + parameterType + ").");
                }
            }
            methodVisitor.visitVarInsn(loadOpcode, localVariableHelper.getParameterSlot(parameterIndex));
            methodVisitor.visitMethodInsn(184, valueOfOwner, "valueOf", valueOfDescriptor, false);
            localVariableHelper.writeLocal(methodVisitor, parameterIndex);
        } else {
            try {
                Class<?> typeClass = Class.forName(parameterType.getClassName(), false, BuiltinTypes.asmClassLoader);
                if (!PythonLikeObject.class.isAssignableFrom(typeClass)) {
                    methodVisitor.visitVarInsn(25, localVariableHelper.getParameterSlot(parameterIndex));
                    methodVisitor.visitMethodInsn(184, Type.getInternalName(JavaPythonTypeConversionImplementor.class), "wrapJavaObject", Type.getMethodDescriptor((Type)Type.getType(PythonLikeObject.class), (Type[])new Type[]{Type.getType(Object.class)}), false);
                    localVariableHelper.writeLocal(methodVisitor, parameterIndex);
                } else {
                    methodVisitor.visitVarInsn(25, localVariableHelper.getParameterSlot(parameterIndex));
                    localVariableHelper.writeLocal(methodVisitor, parameterIndex);
                }
            }
            catch (ClassNotFoundException e) {
                methodVisitor.visitVarInsn(25, localVariableHelper.getParameterSlot(parameterIndex));
                localVariableHelper.writeLocal(methodVisitor, parameterIndex);
            }
        }
    }

    private record ReturnValueOpDescriptor(String wrapperClassName, String methodName, String methodDescriptor, int opcode, boolean noConversionNeeded) {
        public static ReturnValueOpDescriptor noConversion() {
            return new ReturnValueOpDescriptor("", "", "", 176, true);
        }

        public static ReturnValueOpDescriptor forNumeric(String methodName, String methodDescriptor, int opcode) {
            return new ReturnValueOpDescriptor(Type.getInternalName(Number.class), methodName, methodDescriptor, opcode, false);
        }
    }
}

