/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.collections;

import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.collections.PythonIterator;
import ai.timefold.jpyinterpreter.types.errors.StopIteration;
import java.util.Iterator;

public class DelegatePythonIterator<T>
extends AbstractPythonLikeObject
implements PythonIterator<T> {
    private final Iterator<T> delegate;

    private static PythonLikeType registerMethods() throws NoSuchMethodException {
        BuiltinTypes.ITERATOR_TYPE.addUnaryMethod(PythonUnaryOperator.NEXT, PythonIterator.class.getMethod("nextPythonItem", new Class[0]));
        BuiltinTypes.ITERATOR_TYPE.addUnaryMethod(PythonUnaryOperator.ITERATOR, PythonIterator.class.getMethod("getIterator", new Class[0]));
        return BuiltinTypes.ITERATOR_TYPE;
    }

    public DelegatePythonIterator(Iterator<T> delegate) {
        super(BuiltinTypes.ITERATOR_TYPE);
        this.delegate = delegate;
    }

    public DelegatePythonIterator(PythonLikeType type) {
        super(type);
        this.delegate = this;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public T next() {
        if (!this.delegate.hasNext()) {
            throw new StopIteration();
        }
        return this.delegate.next();
    }

    @Override
    public PythonLikeObject nextPythonItem() {
        if (!this.delegate.hasNext()) {
            throw new StopIteration();
        }
        return (PythonLikeObject)this.delegate.next();
    }

    @Override
    public DelegatePythonIterator<T> getIterator() {
        return this;
    }

    static {
        PythonOverloadImplementor.deferDispatchesFor(DelegatePythonIterator::registerMethods);
    }
}

