/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.collections;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.builtins.UnaryDunderBuiltin;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonNone;
import ai.timefold.jpyinterpreter.types.collections.DelegatePythonIterator;
import ai.timefold.jpyinterpreter.types.collections.PythonLikeFrozenSet;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import ai.timefold.jpyinterpreter.types.errors.lookup.KeyError;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.solver.core.impl.domain.solution.cloner.PlanningCloneable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class PythonLikeSet<T extends PythonLikeObject>
extends AbstractPythonLikeObject
implements Set<T>,
PlanningCloneable<PythonLikeSet<T>> {
    public final Set delegate;

    private static PythonLikeType registerMethods() throws NoSuchMethodException {
        BuiltinTypes.SET_TYPE.setConstructor((positionalArguments, namedArguments, callerInstance) -> {
            if (positionalArguments.size() == 0) {
                return new PythonLikeSet();
            }
            if (positionalArguments.size() == 1) {
                PythonLikeSet out = new PythonLikeSet();
                out.update((PythonLikeObject)positionalArguments.get(0));
                return out;
            }
            throw new ValueError("set expects 0 or 1 arguments, got " + positionalArguments.size());
        });
        BuiltinTypes.SET_TYPE.addUnaryMethod(PythonUnaryOperator.LENGTH, PythonLikeSet.class.getMethod("getLength", new Class[0]));
        BuiltinTypes.SET_TYPE.addUnaryMethod(PythonUnaryOperator.ITERATOR, PythonLikeSet.class.getMethod("getIterator", new Class[0]));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.CONTAINS, PythonLikeSet.class.getMethod("containsItem", PythonLikeObject.class));
        BuiltinTypes.SET_TYPE.addMethod("isdisjoint", PythonLikeSet.class.getMethod("isDisjoint", PythonLikeSet.class));
        BuiltinTypes.SET_TYPE.addMethod("isdisjoint", PythonLikeSet.class.getMethod("isDisjoint", PythonLikeFrozenSet.class));
        BuiltinTypes.SET_TYPE.addMethod("issubset", PythonLikeSet.class.getMethod("isSubset", PythonLikeSet.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.LESS_THAN_OR_EQUAL, PythonLikeSet.class.getMethod("isSubset", PythonLikeSet.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.LESS_THAN, PythonLikeSet.class.getMethod("isStrictSubset", PythonLikeSet.class));
        BuiltinTypes.SET_TYPE.addMethod("issubset", PythonLikeSet.class.getMethod("isSubset", PythonLikeFrozenSet.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.LESS_THAN_OR_EQUAL, PythonLikeSet.class.getMethod("isSubset", PythonLikeFrozenSet.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.LESS_THAN, PythonLikeSet.class.getMethod("isStrictSubset", PythonLikeFrozenSet.class));
        BuiltinTypes.SET_TYPE.addMethod("issuperset", PythonLikeSet.class.getMethod("isSuperset", PythonLikeSet.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.GREATER_THAN_OR_EQUAL, PythonLikeSet.class.getMethod("isSuperset", PythonLikeSet.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.GREATER_THAN, PythonLikeSet.class.getMethod("isStrictSuperset", PythonLikeSet.class));
        BuiltinTypes.SET_TYPE.addMethod("issuperset", PythonLikeSet.class.getMethod("isSuperset", PythonLikeFrozenSet.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.GREATER_THAN_OR_EQUAL, PythonLikeSet.class.getMethod("isSuperset", PythonLikeFrozenSet.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.GREATER_THAN, PythonLikeSet.class.getMethod("isStrictSuperset", PythonLikeFrozenSet.class));
        BuiltinTypes.SET_TYPE.addMethod("union", PythonLikeSet.class.getMethod("union", PythonLikeSet.class));
        BuiltinTypes.SET_TYPE.addMethod("union", PythonLikeSet.class.getMethod("union", PythonLikeFrozenSet.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.OR, PythonLikeSet.class.getMethod("union", PythonLikeSet.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.OR, PythonLikeSet.class.getMethod("union", PythonLikeFrozenSet.class));
        BuiltinTypes.SET_TYPE.addMethod("intersection", PythonLikeSet.class.getMethod("intersection", PythonLikeSet.class));
        BuiltinTypes.SET_TYPE.addMethod("intersection", PythonLikeSet.class.getMethod("intersection", PythonLikeFrozenSet.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.AND, PythonLikeSet.class.getMethod("intersection", PythonLikeSet.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.AND, PythonLikeSet.class.getMethod("intersection", PythonLikeFrozenSet.class));
        BuiltinTypes.SET_TYPE.addMethod("difference", PythonLikeSet.class.getMethod("difference", PythonLikeSet.class));
        BuiltinTypes.SET_TYPE.addMethod("difference", PythonLikeSet.class.getMethod("difference", PythonLikeFrozenSet.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.SUBTRACT, PythonLikeSet.class.getMethod("difference", PythonLikeSet.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.SUBTRACT, PythonLikeSet.class.getMethod("difference", PythonLikeFrozenSet.class));
        BuiltinTypes.SET_TYPE.addMethod("symmetric_difference", PythonLikeSet.class.getMethod("symmetricDifference", PythonLikeSet.class));
        BuiltinTypes.SET_TYPE.addMethod("symmetric_difference", PythonLikeSet.class.getMethod("symmetricDifference", PythonLikeFrozenSet.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.XOR, PythonLikeSet.class.getMethod("symmetricDifference", PythonLikeSet.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.XOR, PythonLikeSet.class.getMethod("symmetricDifference", PythonLikeFrozenSet.class));
        BuiltinTypes.SET_TYPE.addMethod("update", PythonLikeSet.class.getMethod("update", PythonLikeObject.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.INPLACE_OR, PythonLikeSet.class.getMethod("updateWithResult", PythonLikeObject.class));
        BuiltinTypes.SET_TYPE.addMethod("intersection_update", PythonLikeSet.class.getMethod("intersectionUpdate", PythonLikeObject.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.INPLACE_AND, PythonLikeSet.class.getMethod("intersectionUpdateWithResult", PythonLikeObject.class));
        BuiltinTypes.SET_TYPE.addMethod("difference_update", PythonLikeSet.class.getMethod("differenceUpdate", PythonLikeObject.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.INPLACE_SUBTRACT, PythonLikeSet.class.getMethod("differenceUpdateWithResult", PythonLikeObject.class));
        BuiltinTypes.SET_TYPE.addMethod("symmetric_difference_update", PythonLikeSet.class.getMethod("symmetricDifferenceUpdate", PythonLikeObject.class));
        BuiltinTypes.SET_TYPE.addBinaryMethod(PythonBinaryOperator.INPLACE_XOR, PythonLikeSet.class.getMethod("symmetricDifferenceUpdateWithResult", PythonLikeObject.class));
        BuiltinTypes.SET_TYPE.addMethod("add", PythonLikeSet.class.getMethod("addItem", PythonLikeObject.class));
        BuiltinTypes.SET_TYPE.addMethod("remove", PythonLikeSet.class.getMethod("removeOrError", PythonLikeObject.class));
        BuiltinTypes.SET_TYPE.addMethod("discard", PythonLikeSet.class.getMethod("discard", PythonLikeObject.class));
        BuiltinTypes.SET_TYPE.addMethod("pop", PythonLikeSet.class.getMethod("pop", new Class[0]));
        BuiltinTypes.SET_TYPE.addMethod("clear", PythonLikeSet.class.getMethod("clearSet", new Class[0]));
        BuiltinTypes.SET_TYPE.addMethod("copy", PythonLikeSet.class.getMethod("copy", new Class[0]));
        return BuiltinTypes.SET_TYPE;
    }

    public PythonLikeSet() {
        super(BuiltinTypes.SET_TYPE);
        this.delegate = new HashSet();
    }

    public PythonLikeSet(int size) {
        super(BuiltinTypes.SET_TYPE);
        this.delegate = new HashSet(size);
    }

    public PythonLikeSet<T> createNewInstance() {
        return new PythonLikeSet<T>();
    }

    public void reverseAdd(T item) {
        this.delegate.add(item);
    }

    public PythonBoolean isDisjoint(PythonLikeSet other) {
        return PythonBoolean.valueOf(Collections.disjoint(this.delegate, other.delegate));
    }

    public PythonBoolean isDisjoint(PythonLikeFrozenSet other) {
        return PythonBoolean.valueOf(Collections.disjoint(this.delegate, other.delegate));
    }

    public PythonBoolean isSubset(PythonLikeSet other) {
        return PythonBoolean.valueOf(other.delegate.containsAll(this.delegate));
    }

    public PythonBoolean isSubset(PythonLikeFrozenSet other) {
        return PythonBoolean.valueOf(other.delegate.containsAll(this.delegate));
    }

    public PythonBoolean isStrictSubset(PythonLikeSet other) {
        return PythonBoolean.valueOf(other.delegate.containsAll(this.delegate) && !this.delegate.containsAll(other.delegate));
    }

    public PythonBoolean isStrictSubset(PythonLikeFrozenSet other) {
        return PythonBoolean.valueOf(other.delegate.containsAll(this.delegate) && !this.delegate.containsAll(other.delegate));
    }

    public PythonBoolean isSuperset(PythonLikeSet other) {
        return PythonBoolean.valueOf(this.delegate.containsAll(other.delegate));
    }

    public PythonBoolean isSuperset(PythonLikeFrozenSet other) {
        return PythonBoolean.valueOf(this.delegate.containsAll(other.delegate));
    }

    public PythonBoolean isStrictSuperset(PythonLikeSet other) {
        return PythonBoolean.valueOf(this.delegate.containsAll(other.delegate) && !other.delegate.containsAll(this.delegate));
    }

    public PythonBoolean isStrictSuperset(PythonLikeFrozenSet other) {
        return PythonBoolean.valueOf(this.delegate.containsAll(other.delegate) && !other.delegate.containsAll(this.delegate));
    }

    public PythonLikeSet<T> union(PythonLikeSet<T> other) {
        PythonLikeSet<T> out = new PythonLikeSet<T>();
        out.delegate.addAll(this.delegate);
        out.delegate.addAll(other.delegate);
        return out;
    }

    public PythonLikeSet<T> union(PythonLikeFrozenSet other) {
        PythonLikeSet<T> out = new PythonLikeSet<T>();
        out.delegate.addAll(this.delegate);
        out.delegate.addAll(other.delegate);
        return out;
    }

    public PythonLikeSet<T> intersection(PythonLikeSet<T> other) {
        PythonLikeSet<T> out = new PythonLikeSet<T>();
        out.delegate.addAll(this.delegate);
        out.delegate.retainAll(other.delegate);
        return out;
    }

    public PythonLikeSet<T> intersection(PythonLikeFrozenSet other) {
        PythonLikeSet<T> out = new PythonLikeSet<T>();
        out.delegate.addAll(this.delegate);
        out.delegate.retainAll(other.delegate);
        return out;
    }

    public PythonLikeSet difference(PythonLikeSet other) {
        PythonLikeSet<T> out = new PythonLikeSet<T>();
        out.delegate.addAll(this.delegate);
        out.delegate.removeAll(other.delegate);
        return out;
    }

    public PythonLikeSet difference(PythonLikeFrozenSet other) {
        PythonLikeSet<T> out = new PythonLikeSet<T>();
        out.delegate.addAll(this.delegate);
        out.delegate.removeAll(other.delegate);
        return out;
    }

    public PythonLikeSet symmetricDifference(PythonLikeSet other) {
        PythonLikeSet<T> out = new PythonLikeSet<T>();
        out.delegate.addAll(this.delegate);
        other.delegate.stream().filter(Predicate.not(out.delegate::add)).forEach(out.delegate::remove);
        return out;
    }

    public PythonLikeSet<T> symmetricDifference(PythonLikeFrozenSet other) {
        PythonLikeSet<T> out = new PythonLikeSet<T>();
        out.delegate.addAll(this.delegate);
        other.delegate.stream().filter(Predicate.not(item -> out.delegate.add(item))).forEach(out.delegate::remove);
        return out;
    }

    public PythonLikeSet<T> updateWithResult(PythonLikeObject collection) {
        if (collection instanceof Collection) {
            this.delegate.addAll((Collection)((Object)collection));
        } else {
            Iterator iterator = (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(collection));
            iterator.forEachRemaining(this.delegate::add);
        }
        return this;
    }

    public PythonNone update(PythonLikeObject collection) {
        this.updateWithResult(collection);
        return PythonNone.INSTANCE;
    }

    public PythonLikeSet intersectionUpdateWithResult(PythonLikeObject collection) {
        if (collection instanceof Collection) {
            this.delegate.retainAll((Collection)((Object)collection));
        } else {
            Iterator iterator = (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(collection));
            HashSet temp = new HashSet();
            iterator.forEachRemaining(temp::add);
            this.delegate.retainAll(temp);
        }
        return this;
    }

    public PythonNone intersectionUpdate(PythonLikeObject collection) {
        this.intersectionUpdateWithResult(collection);
        return PythonNone.INSTANCE;
    }

    public PythonLikeSet differenceUpdateWithResult(PythonLikeObject collection) {
        if (collection instanceof Collection) {
            this.delegate.removeAll((Collection)((Object)collection));
        } else {
            Iterator iterator = (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(collection));
            iterator.forEachRemaining(this.delegate::remove);
        }
        return this;
    }

    public PythonNone differenceUpdate(PythonLikeObject collection) {
        this.differenceUpdateWithResult(collection);
        return PythonNone.INSTANCE;
    }

    public PythonLikeSet symmetricDifferenceUpdateWithResult(PythonLikeObject collection) {
        if (collection instanceof Collection) {
            Collection otherSet = (Collection)((Object)collection);
            HashSet temp = new HashSet(this.delegate);
            temp.retainAll(otherSet);
            this.delegate.addAll(otherSet);
            this.delegate.removeAll(temp);
        } else {
            Iterator iterator = (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(collection));
            HashSet<PythonLikeObject> encountered = new HashSet<PythonLikeObject>(this.delegate);
            while (iterator.hasNext()) {
                PythonLikeObject item = (PythonLikeObject)iterator.next();
                if (encountered.contains(item)) continue;
                if (this.delegate.contains(item)) {
                    this.delegate.remove(item);
                } else {
                    this.delegate.add(item);
                }
                encountered.add(item);
            }
        }
        return this;
    }

    public PythonNone symmetricDifferenceUpdate(PythonLikeObject collection) {
        this.symmetricDifferenceUpdateWithResult(collection);
        return PythonNone.INSTANCE;
    }

    public PythonNone addItem(PythonLikeObject pythonLikeObject) {
        this.delegate.add(pythonLikeObject);
        return PythonNone.INSTANCE;
    }

    public PythonNone discard(PythonLikeObject object) {
        this.delegate.remove(object);
        return PythonNone.INSTANCE;
    }

    public PythonNone removeOrError(PythonLikeObject object) {
        if (!this.delegate.remove(object)) {
            throw new KeyError("set (" + this + ") does not contain the specified element (" + object + ").");
        }
        return PythonNone.INSTANCE;
    }

    public PythonLikeObject pop() {
        if (this.delegate.isEmpty()) {
            throw new KeyError("set (" + this + ") is empty.");
        }
        PythonLikeObject out = (PythonLikeObject)this.delegate.iterator().next();
        this.delegate.remove(out);
        return out;
    }

    public PythonLikeSet copy() {
        PythonLikeSet<T> copy = new PythonLikeSet<T>();
        copy.addAll(this.delegate);
        return copy;
    }

    public PythonNone clearSet() {
        this.delegate.clear();
        return PythonNone.INSTANCE;
    }

    public PythonInteger getLength() {
        return PythonInteger.valueOf(this.delegate.size());
    }

    public PythonBoolean containsItem(PythonLikeObject query) {
        return PythonBoolean.valueOf(this.delegate.contains(query));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    public DelegatePythonIterator getIterator() {
        return new DelegatePythonIterator(this.delegate.iterator());
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.delegate.toArray(ts);
    }

    @Override
    public boolean add(PythonLikeObject pythonLikeObject) {
        return this.delegate.add(pythonLikeObject);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.delegate.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        return this.delegate.addAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.delegate.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.delegate.retainAll(collection);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Set) {
            Set other = (Set)o;
            if (other.size() != this.size()) {
                return false;
            }
            return this.containsAll(other) && other.containsAll(this);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    static {
        PythonOverloadImplementor.deferDispatchesFor(PythonLikeSet::registerMethods);
    }
}

