/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.jpyinterpreter.types.collections;

import ai.timefold.jpyinterpreter.PythonBinaryOperator;
import ai.timefold.jpyinterpreter.PythonLikeObject;
import ai.timefold.jpyinterpreter.PythonOverloadImplementor;
import ai.timefold.jpyinterpreter.PythonUnaryOperator;
import ai.timefold.jpyinterpreter.builtins.UnaryDunderBuiltin;
import ai.timefold.jpyinterpreter.types.AbstractPythonLikeObject;
import ai.timefold.jpyinterpreter.types.BuiltinTypes;
import ai.timefold.jpyinterpreter.types.PythonLikeComparable;
import ai.timefold.jpyinterpreter.types.PythonLikeType;
import ai.timefold.jpyinterpreter.types.PythonSlice;
import ai.timefold.jpyinterpreter.types.PythonString;
import ai.timefold.jpyinterpreter.types.collections.DelegatePythonIterator;
import ai.timefold.jpyinterpreter.types.errors.TypeError;
import ai.timefold.jpyinterpreter.types.errors.ValueError;
import ai.timefold.jpyinterpreter.types.errors.lookup.IndexError;
import ai.timefold.jpyinterpreter.types.numeric.PythonBoolean;
import ai.timefold.jpyinterpreter.types.numeric.PythonInteger;
import ai.timefold.solver.core.impl.domain.solution.cloner.PlanningCloneable;
import ai.timefold.solver.core.impl.domain.solution.cloner.PlanningImmutable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;

public class PythonLikeTuple<T extends PythonLikeObject>
extends AbstractPythonLikeObject
implements List<T>,
PlanningCloneable<PythonLikeTuple<T>>,
PythonLikeComparable<PythonLikeTuple>,
PlanningImmutable,
RandomAccess {
    public static PythonLikeTuple EMPTY = PythonLikeTuple.fromList(Collections.emptyList());
    final List delegate;
    private int remainderToAdd;

    private static PythonLikeType registerMethods() throws NoSuchMethodException {
        BuiltinTypes.TUPLE_TYPE.setConstructor((positionalArguments, namedArguments, callerInstance) -> {
            if (positionalArguments.isEmpty()) {
                return new PythonLikeTuple();
            }
            if (positionalArguments.size() == 1) {
                PythonLikeTuple out = new PythonLikeTuple();
                PythonLikeObject iterable = (PythonLikeObject)positionalArguments.get(0);
                if (iterable instanceof Collection) {
                    out.delegate.addAll((Collection)((Object)iterable));
                } else {
                    Iterator iterator = (Iterator)((Object)UnaryDunderBuiltin.ITERATOR.invoke(iterable));
                    iterator.forEachRemaining(out.delegate::add);
                }
                return out;
            }
            throw new ValueError("tuple takes 0 or 1 arguments, got " + positionalArguments.size());
        });
        BuiltinTypes.TUPLE_TYPE.addUnaryMethod(PythonUnaryOperator.LENGTH, PythonLikeTuple.class.getMethod("getLength", new Class[0]));
        BuiltinTypes.TUPLE_TYPE.addUnaryMethod(PythonUnaryOperator.ITERATOR, PythonLikeTuple.class.getMethod("getIterator", new Class[0]));
        BuiltinTypes.TUPLE_TYPE.addBinaryMethod(PythonBinaryOperator.ADD, PythonLikeTuple.class.getMethod("concatToNew", PythonLikeTuple.class));
        BuiltinTypes.TUPLE_TYPE.addBinaryMethod(PythonBinaryOperator.MULTIPLY, PythonLikeTuple.class.getMethod("multiplyToNew", PythonInteger.class));
        BuiltinTypes.TUPLE_TYPE.addBinaryMethod(PythonBinaryOperator.GET_ITEM, PythonLikeTuple.class.getMethod("getItem", PythonInteger.class));
        BuiltinTypes.TUPLE_TYPE.addBinaryMethod(PythonBinaryOperator.GET_ITEM, PythonLikeTuple.class.getMethod("getSlice", PythonSlice.class));
        BuiltinTypes.TUPLE_TYPE.addBinaryMethod(PythonBinaryOperator.CONTAINS, PythonLikeTuple.class.getMethod("containsItem", PythonLikeObject.class));
        PythonLikeComparable.setup(BuiltinTypes.TUPLE_TYPE);
        BuiltinTypes.TUPLE_TYPE.addMethod("index", PythonLikeTuple.class.getMethod("index", PythonLikeObject.class));
        BuiltinTypes.TUPLE_TYPE.addMethod("index", PythonLikeTuple.class.getMethod("index", PythonLikeObject.class, PythonInteger.class));
        BuiltinTypes.TUPLE_TYPE.addMethod("index", PythonLikeTuple.class.getMethod("index", PythonLikeObject.class, PythonInteger.class, PythonInteger.class));
        BuiltinTypes.TUPLE_TYPE.addMethod("count", PythonLikeTuple.class.getMethod("count", PythonLikeObject.class));
        return BuiltinTypes.TUPLE_TYPE;
    }

    public PythonLikeTuple() {
        super(BuiltinTypes.TUPLE_TYPE);
        this.delegate = new ArrayList();
        this.remainderToAdd = 0;
    }

    public PythonLikeTuple(int size) {
        super(BuiltinTypes.TUPLE_TYPE);
        this.delegate = new ArrayList(size);
        this.remainderToAdd = size;
        for (int i = 0; i < size; ++i) {
            this.delegate.add(null);
        }
    }

    public PythonLikeTuple<T> createNewInstance() {
        return new PythonLikeTuple<T>();
    }

    public static <T extends PythonLikeObject> PythonLikeTuple<T> fromItems(T ... items) {
        PythonLikeTuple<T> result = new PythonLikeTuple<T>();
        Collections.addAll(result, items);
        return result;
    }

    public static <T extends PythonLikeObject> PythonLikeTuple<T> fromList(List<T> other) {
        PythonLikeTuple<T> result = new PythonLikeTuple<T>();
        result.addAll((Collection<T>)other);
        return result;
    }

    public PythonLikeTuple concatToNew(PythonLikeTuple other) {
        if (this.delegate.isEmpty()) {
            return other;
        }
        if (other.delegate.isEmpty()) {
            return this;
        }
        PythonLikeTuple<T> result = new PythonLikeTuple<T>();
        result.addAll(this.delegate);
        result.addAll(other);
        return result;
    }

    public PythonLikeTuple multiplyToNew(PythonInteger times) {
        if (times.value.compareTo(BigInteger.ZERO) <= 0) {
            if (this.delegate.isEmpty()) {
                return this;
            }
            return new PythonLikeTuple<T>();
        }
        if (times.value.equals(BigInteger.ONE)) {
            return this;
        }
        PythonLikeTuple<T> result = new PythonLikeTuple<T>();
        int timesAsInt = times.value.intValueExact();
        for (int i = 0; i < timesAsInt; ++i) {
            result.addAll(this.delegate);
        }
        return result;
    }

    public PythonInteger getLength() {
        return PythonInteger.valueOf(this.delegate.size());
    }

    public PythonBoolean containsItem(PythonLikeObject item) {
        return PythonBoolean.valueOf(this.delegate.contains(item));
    }

    public DelegatePythonIterator<T> getIterator() {
        return new DelegatePythonIterator(this.delegate.iterator());
    }

    public DelegatePythonIterator getReversedIterator() {
        final ListIterator listIterator = this.delegate.listIterator(this.delegate.size());
        return new DelegatePythonIterator<Object>(new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return listIterator.hasPrevious();
            }

            @Override
            public Object next() {
                return listIterator.previous();
            }
        });
    }

    public PythonLikeObject getItem(PythonInteger index) {
        int indexAsInt = index.value.intValueExact();
        if (indexAsInt < 0) {
            indexAsInt = this.delegate.size() + index.value.intValueExact();
        }
        if (indexAsInt < 0 || indexAsInt >= this.delegate.size()) {
            throw new IndexError("list index out of range");
        }
        return (PythonLikeObject)this.delegate.get(indexAsInt);
    }

    public PythonLikeTuple getSlice(PythonSlice slice) {
        int length = this.delegate.size();
        PythonLikeTuple<T> out = new PythonLikeTuple<T>();
        slice.iterate(length, (i, processed) -> out.add((PythonLikeObject)this.delegate.get(i)));
        return out;
    }

    public PythonInteger count(PythonLikeObject search) {
        long count = 0L;
        for (Object x : this.delegate) {
            if (!Objects.equals(search, x)) continue;
            ++count;
        }
        return new PythonInteger(count);
    }

    public PythonInteger index(PythonLikeObject item) {
        int result = this.delegate.indexOf(item);
        if (result != -1) {
            return PythonInteger.valueOf(result);
        }
        throw new ValueError(item + " is not in list");
    }

    public PythonInteger index(PythonLikeObject item, PythonInteger start) {
        List searchList;
        int result;
        int startAsInt = start.value.intValueExact();
        if (startAsInt < 0) {
            startAsInt = this.delegate.size() + startAsInt;
        }
        if ((result = (searchList = this.delegate.subList(startAsInt, this.delegate.size())).indexOf(item)) != -1) {
            return PythonInteger.valueOf(startAsInt + result);
        }
        throw new ValueError(item + " is not in list");
    }

    public PythonInteger index(PythonLikeObject item, PythonInteger start, PythonInteger end) {
        List searchList;
        int result;
        int startAsInt = start.value.intValueExact();
        int endAsInt = end.value.intValueExact();
        if (startAsInt < 0) {
            startAsInt = this.delegate.size() + startAsInt;
        }
        if (endAsInt < 0) {
            endAsInt = this.delegate.size() + endAsInt;
        }
        if ((result = (searchList = this.delegate.subList(startAsInt, endAsInt)).indexOf(item)) != -1) {
            return PythonInteger.valueOf(startAsInt + result);
        }
        throw new ValueError(item + " is not in list");
    }

    public void reverseAdd(PythonLikeObject object) {
        this.delegate.set(this.remainderToAdd - 1, object);
        --this.remainderToAdd;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.delegate.toArray(ts);
    }

    @Override
    public boolean add(PythonLikeObject pythonLikeObject) {
        return this.delegate.add(pythonLikeObject);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.delegate.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        return this.delegate.addAll(collection);
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> collection) {
        return this.delegate.addAll(i, collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.delegate.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.delegate.retainAll(collection);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public T get(int i) {
        return (T)((PythonLikeObject)this.delegate.get(i));
    }

    @Override
    public T set(int i, T pythonLikeObject) {
        return (T)((PythonLikeObject)this.delegate.set(i, pythonLikeObject));
    }

    @Override
    public void add(int i, PythonLikeObject pythonLikeObject) {
        this.delegate.add(i, pythonLikeObject);
    }

    @Override
    public T remove(int i) {
        return (T)((PythonLikeObject)this.delegate.remove(i));
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int i) {
        return this.delegate.listIterator(i);
    }

    @Override
    public List<T> subList(int i, int i1) {
        return this.delegate.subList(i, i1);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof List) {
            List other = (List)o;
            if (other.size() != this.size()) {
                return false;
            }
            int itemCount = this.size();
            for (int i = 0; i < itemCount; ++i) {
                if (Objects.equals(this.get(i), other.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(PythonLikeTuple other) {
        int ownLength = this.delegate.size();
        int otherLength = other.size();
        int commonLength = Math.min(ownLength, otherLength);
        for (int i = 0; i < commonLength; ++i) {
            Object ownItem = this.delegate.get(i);
            Object otherItem = other.delegate.get(i);
            if (ownItem instanceof Comparable) {
                Comparable ownComparable = (Comparable)ownItem;
                if (otherItem instanceof Comparable) {
                    Comparable otherComparable = (Comparable)otherItem;
                    int result = ownComparable.compareTo(otherComparable);
                    if (result == 0) continue;
                    return result;
                }
                throw new TypeError("Tuple %s does not support comparisons since item (%s) at index (%d) is not comparable.".formatted(other, otherItem, i));
            }
            throw new TypeError("Tuple %s does not support comparisons since item (%s) at index (%d) is not comparable.".formatted(this, ownItem, i));
        }
        return ownLength - otherLength;
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public PythonInteger $method$__hash__() {
        return PythonInteger.valueOf(this.hashCode());
    }

    @Override
    public PythonString $method$__str__() {
        return PythonString.valueOf(this.toString());
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    static {
        PythonOverloadImplementor.deferDispatchesFor(PythonLikeTuple::registerMethods);
    }
}

